/***********************************************************

Copyright (c) 1987  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.


Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifdef HAVE_DIX_CONFIG_H
#include <dix-config.h>
#endif

#include <X11/X.h>
#include "misc.h"
#include "afb.h"
#include "maskbits.h"
#include "miline.h"

/* Dashed bresenham line */

#define StepDash\
	if (!--dashRemaining) { \
		if (++ dashIndex == numInDashList) \
			dashIndex = 0; \
		dashRemaining = pDash[dashIndex]; \
		rop = fgrop; \
		if (dashIndex & 1) \
			rop = bgrop; \
	}

void
afbBresD(pdashIndex, pDash, numInDashList, pdashOffset, isDoubleDash,
		 addrlbase, nlwidth, sizeDst, depthDst,
		 signdx, signdy, axis, x1, y1, e, e1, e2, len, rrops, bgrrops)
int *pdashIndex;		/* current dash */
unsigned char *pDash;		/* dash list */
int numInDashList;		/* total length of dash list */
int *pdashOffset;		/* offset into current dash */
int isDoubleDash;
PixelType *addrlbase;		/* pointer to base of bitmap */
int nlwidth;				/* width in longwords of bitmap */
int sizeDst;
int depthDst;
int signdx, signdy;		/* signs of directions */
int axis;				/* major axis (Y_AXIS or X_AXIS) */
int x1, y1;				/* initial point */
register int e;				/* error accumulator */
register int e1;		/* bresenham increments */
int e2;
int len;				/* length of line */
unsigned char *rrops;
unsigned char *bgrrops;
{
	register int yinc;		/* increment to next scanline, in bytes */
	register PixelType *addrl;
	register int e3 = e2-e1;
	register unsigned long bit;
	PixelType leftbit = mfbGetmask(0); /* leftmost bit to process in new word */
	PixelType rightbit = mfbGetmask(PPW-1); /* rightmost bit to process in new word */
	int dashIndex;
	int dashOffset;
	int dashRemaining;
	int		rop;
	int fgrop;
	int bgrop;
	int saveE;
	int saveLen;
	int d;

	dashOffset = *pdashOffset;
	dashIndex = *pdashIndex;
	dashRemaining = pDash[dashIndex] - dashOffset;
	/* point to longword containing first point */

	yinc = signdy * nlwidth;
	e = e-e1;						/* to make looping easier */

	saveE = e;
	saveLen = len;

	for (d = 0; d < depthDst; d++) {
		addrl = afbScanline(addrlbase, x1, y1, nlwidth);
		addrlbase += sizeDst;	/* @@@ NEXT PLANE @@@ */

		fgrop = rrops[d];
		bgrop = bgrrops[d];

		e = saveE;
		len = saveLen;
		bit = mfbGetmask(x1 & PIM);

		rop = fgrop;
		if (!isDoubleDash)
			bgrop = -1;
		if (dashIndex & 1)
			rop = bgrop;

		if (axis == X_AXIS) {
			if (signdx > 0) {
				while(len--) {
					if (rop == RROP_BLACK)
						*addrl &= ~bit;
					else if (rop == RROP_WHITE)
						*addrl |= bit;
					else if (rop == RROP_INVERT)
						*addrl ^= bit;
					e += e1;
					if (e >= 0) {
						afbScanlineInc(addrl, yinc);
						e += e3;
					}
					bit = SCRRIGHT(bit,1);
					if (!bit) { bit = leftbit;addrl ++; }
					StepDash
				}
			} else {
				while(len--) {
					if (rop == RROP_BLACK)
						*addrl &= ~bit;
					else if (rop == RROP_WHITE)
						*addrl |= bit;
					else if (rop == RROP_INVERT)
						*addrl ^= bit;
					e += e1;
					if (e >= 0) {
						afbScanlineInc(addrl, yinc);
						e += e3;
					}
					bit = SCRLEFT(bit,1);
					if (!bit) { bit = rightbit;addrl --; }
					StepDash
				}
			}
		} /* if X_AXIS */ else {
			if (signdx > 0) {
				while(len--) {
					if (rop == RROP_BLACK)
						*addrl &= ~bit;
					else if (rop == RROP_WHITE)
						*addrl |= bit;
					else if (rop == RROP_INVERT)
						*addrl ^= bit;
					e += e1;
					if (e >= 0) {
						bit = SCRRIGHT(bit,1);
						if (!bit) { bit = leftbit;addrl ++; }
						e += e3;
					}
					afbScanlineInc(addrl, yinc);
					StepDash
				}
			} else {
				while(len--) {
					if (rop == RROP_BLACK)
						*addrl &= ~bit;
					else if (rop == RROP_WHITE)
						*addrl |= bit;
					else if (rop == RROP_INVERT)
						*addrl ^= bit;
					e += e1;
					if (e >= 0) {
						bit = SCRLEFT(bit,1);
						if (!bit) { bit = rightbit;addrl --; }
						e += e3;
					}
					afbScanlineInc(addrl, yinc);
					StepDash
				}
			}
		} /* else Y_AXIS */
	} /* for (d = ...) */
	*pdashIndex = dashIndex;
	*pdashOffset = pDash[dashIndex] - dashRemaining;
}
