.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH MODESETTING @drivermansuffix@ @vendorversion@
.SH NAME
modesetting \- video driver for framebuffer device
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qmodesetting\*q"
.BI "  BusID  \*qpci:" bus : dev : func \*q
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B modesetting
is an @xservername@ driver for KMS devices.  This is a non-accelerated
driver, the following framebuffer depths are supported: 8, 15, 16, 24.
All visual types are supported for depth 8, and TrueColor visual is
supported for the other depths.  RandR 1.2 is supported.
.SH SUPPORTED HARDWARE
The 
.B modesetting
driver supports all hardware where a KMS driver is available.
modesetting uses the Linux DRM KMS ioctls and dumb object create/map.
.SH CONFIGURATION DETAILS
Please refer to @xconfigfile@(@filemansuffix@) for general configuration
details.  This section only covers configuration details specific to
this driver.
.PP
For this driver it is not required to specify modes in the screen 
section of the config file.  The
.B modesetting
driver can pick up the currently used video mode from the kernel
driver and will use it if there are no video modes configured.
.PP
For PCI boards you might have to add a BusID line to the Device
section.  See above for a sample line.
.PP
The following driver 
.B Options
are supported:
.TP
.BI "Option \*qSWcursor\*q \*q" boolean \*q
Selects software cursor.  The default is
.B off.
.TP
.BI "Option \*qkmsdev\*q \*q" string \*q
The framebuffer device to use. Default: /dev/dri/card0.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Enable or disable use of the shadow framebuffer layer.  Default: on.
.TP
.BI "Option \*qAccelMethod\*q \*q" string \*q
One of \*qglamor\*q or \*qnone\*q.  Default: glamor
.TP
.BI "Option \*qPageFlip\*q \*q" boolean \*q
Enable DRI3 page flipping.  The default is
.B on.
.TP
.BI "Option \*qZaphodHeads\*q \*q" string \*q
Specify the RandR output(s) to use with zaphod mode for a particular driver
instance.  If you use this option you must use this option for all instances
of the driver.
.br
For example:
.B
Option \*qZaphodHeads\*q \*qLVDS,VGA-0\*q
will assign xrandr outputs LVDS and VGA-0 to this instance of the driver.
.TP
.SH "SEE ALSO"
@xservername@(@appmansuffix@), @xconfigfile@(@filemansuffix@), Xserver(@appmansuffix@),
X(@miscmansuffix@)
.SH AUTHORS
Authors include: Dave Airlie
