/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#pragma	ident	"@(#)lcbig5.c 1.20	99/09/28  SMI"

#include <iconv.h>
#include <stdio.h>
#include <X11/Xlibint.h>
#include "XlcGeneric.h"
#include <wchar.h>

#include <ctype.h>

#define CS0	codesets[0]		/* Codeset 0 - 7-bit ASCII	*/
#define CS1	codesets[1]		/* Codeset 1 - big5  	*/

#define ascii		(codeset->cs_num == 0)
#define big5		(codeset->cs_num == 1)

#define	ASCII_CODESET	0
#define BIG5_CODESET	1
#define MAX_CODESETS	2

#define GR	0x80	/* begins right-side (non-ascii) region */
#define GL	0x7f    /* ends left-side (ascii) region        */

#define isleftside(c)	(((c) & GR) ? 0 : 1)
#define isrightside(c)	(!isleftside(c))

typedef unsigned char   Uchar;
typedef unsigned long	Ulong;
typedef unsigned int	Uint;

#define BIT8OFF(c)	((c) & GL)
#define BIT8ON(c)	((c) | GR)

static iconv_t big5ToEuc_fd;
static iconv_t EucToBig5_fd;

static size_t big5_to_euc(s1,s2)
char *s1;
char *s2;
{
   size_t inbytesleft = 2;
   size_t outbytesleft = 4;
   size_t sz;
   sz = iconv(big5ToEuc_fd, (const char**)&s1,
	      &inbytesleft,&s2,&outbytesleft);
   return outbytesleft;
}

static size_t euc_to_big5(s1,s2, inbytesleft)
char *s1;
char *s2;
size_t inbytesleft;
{
   size_t outbytesleft = 4;
   size_t sz;
   sz = iconv(EucToBig5_fd, (const char**)&s1,
	      &inbytesleft,&s2,&outbytesleft);
   return outbytesleft;
}

static int isbig5(s)
unsigned char *s;
{
    /* consider the first byte */
    if((s[0] >= 0xa1 && s[0] <= 0xc5) || (s[0] >= 0xc9 &&  s[0] <= 0xf9)){
      if(s[1] < 0x40 || s[1] == 0xff || (s[1] >= 0x7f && s[1] <= 0xa0))
	return False;
      else
	return True;
    }else{
      /* a small section is missing on 0xc6 */
      if(s[0] == 0xc6 && (s[1] >= 0x40 && s[1] <= 0x7e))
	return True;
      else
	return False;
    }
}

euc_to_big_5_1(b1,b2,out_buf)
unsigned char b1;
unsigned char b2;
unsigned char *out_buf;
{
  unsigned char in[6];
  in[0] = b1;
  in[1] = b2;
  euc_to_big5(in,out_buf, 2);
}
euc_to_big_5_2(b1,b2,out_buf)
unsigned char  b1;
unsigned char  b2;
unsigned char *out_buf;
{
  unsigned char in[6];
  in[0] = 0x8e;
  in[1] = 0xa2;
  in[2] = b1;
  in[3] = b2;
  euc_to_big5(in,out_buf,4);
}
int
big5_mbtocs(conv, from, from_left, to, to_left, args, num_args)
    XlcConv conv;
    XPointer *from;
    int *from_left;
    XPointer *to;
    int *to_left;
    XPointer *args;
    int num_args;
{
    XLCd lcd = (XLCd)conv->state;
    XlcCharSet charset = NULL;
    int char_size = 0;
    int unconv_num = 0;
    register char *src = *from, *dst = *to;
    CodeSet *codesets = XLC_GENERIC(lcd, codeset_list);
    int codeset_num = XLC_GENERIC(lcd, codeset_num);
    unsigned char iconv_buf[6];

    if (isbig5(src)) {
	if (BIG5_CODESET >= codeset_num)
	    return -1;
	charset = *CS1->charset_list;
	char_size = charset->char_size;
	if (*from_left > 0 && *to_left >= char_size) {
            *dst++ = *src++;
	    *dst++ = *src++;
	    /* unconv_num++;  need it ????? */
	} else
	    return -1;

    	*from_left -= char_size;
    	*to_left -= char_size;
    }
    else if (isascii(*src)) {
	if (ASCII_CODESET >= codeset_num)
	    return -1;
	charset = *CS0->charset_list;
	char_size = charset->char_size;

	if (*from_left >= char_size && *to_left >= char_size)
	    *dst++ = *src++;
	else
	    return -1;

    	*from_left -= char_size;
    	*to_left -= char_size;
    }
    else { 	/* unknown */
	unconv_num++;
	src++;
        *from_left -= 1;
    }

    *to = dst;
    *from = src;

    if (num_args > 0)
	*((XlcCharSet *) args[0]) = charset;
    return unconv_num;
}


int
big5_mbstocs(conv, from, from_left, to, to_left, args, num_args)
    XlcConv conv;
    XPointer *from;
    int *from_left;
    XPointer *to;
    int *to_left;
    XPointer *args;
    int num_args;
{
    char *src = *from;
    char *dst = *to;
    XLCd lcd = (XLCd)conv->state;
    XlcCharSet charset = NULL;
    XPointer tmp_args[2], tmp_from, save_from = *from;
    char tmp[32];
    int char_size = 0;
    int length, ret, src_left = *from_left;
    int unconv_num = 0, tmp_num = 1;
    CodeSet *codesets = XLC_GENERIC(lcd, codeset_list);
    int codeset_num = XLC_GENERIC(lcd, codeset_num);
    int flag = 0;
    for(;;){
      if(isbig5(src)){
        if(flag == 0){
          flag = 1;
        }
        if(flag == 2)
           break;
	if (BIG5_CODESET >= codeset_num)
	  return -1;
	charset = *CS1->charset_list;
	char_size = charset->char_size;
	if (*from_left > 0 && *to_left >= char_size) {
          *dst++ = *src++;
          *dst++ = *src++;
          *to_left -= char_size;
          *from_left -= char_size;
        }else
          return -1;
      }
      else if (isascii(*src)) {
        if(flag == 0){
          flag = 2;
        }
        if(flag == 1)
          break;
	if (ASCII_CODESET >= codeset_num)
	  return -1;
	charset = *CS0->charset_list;
	char_size = charset->char_size;
	if (*from_left >= char_size && *to_left >= char_size){
	  *dst++ = *src++;
          *to_left -= char_size;
          *from_left -= char_size;
	}else
	  break;
      }
      else{ 	/* unknown */
	unconv_num++;
	src++;
	char_size=1;
	*from_left -= char_size;
      }

      src_left -= char_size;;
      if(src_left <= 0)
       break;
       
    }

    *from = (XPointer) src;
    *to = dst;
    *from_left = src_left; 

    if (num_args > 0)
	*((XlcCharSet *) args[0]) = charset;
    
    return unconv_num;

}

int
big5_wcstocs(conv, from, from_left, to, to_left, args, num_args)
    XlcConv conv;
    XPointer *from;
    int *from_left;
    XPointer *to;
    int *to_left;
    XPointer *args;
    int num_args;
{
    wchar_t wch;
    wchar_t *src = *((wchar_t **) from);
    char *dst = *to;
    XLCd lcd = (XLCd)conv->state;
    XlcCharSet charset = NULL;
    XPointer tmp_args[2], tmp_from, save_from = *from;
    char tmp[32];
    int char_size = 0;
    int length, ret, src_left = *from_left;
    int unconv_num = 0, tmp_num = 1;
    CodeSet *codesets = XLC_GENERIC(lcd, codeset_list);
    int codeset_num = XLC_GENERIC(lcd, codeset_num);
    int flag = 0;
    /* printf("*************** enter big5_wcstocs()\n"); */
    for(;;){
      wch = *src;
      length = wctomb(tmp, wch);
      if(isbig5(tmp)){
        if(flag == 0){
          flag = 1;
        }
        if(flag == 2)
           break;
	if (BIG5_CODESET >= codeset_num)
	  return -1;
	charset = *CS1->charset_list;
	char_size = charset->char_size;
	if (*from_left > 0 && *to_left >= char_size) {
          *dst++ = tmp[0];
          *dst++ = tmp[1];
          *to_left -= char_size;
        }else
          return -1;
      }
      else if (isascii(tmp[0])) {
        if(flag == 0){
          flag = 2;
        }
        if(flag == 1)
          break;
	if (ASCII_CODESET >= codeset_num)
	  return -1;
	charset = *CS0->charset_list;
	char_size = charset->char_size;
	if (*from_left >= char_size && *to_left >= char_size){
	  *dst++ = tmp[0];
          *to_left -= char_size;
	}else
	  return -1;
      }
      else{ 	/* unknown */
	unconv_num++;
      }

      src++;
      src_left--;
      if(src_left <= 0)
        break;
    }

    *from = (XPointer) src;
    *from_left = src_left;
    *to = dst;

    if (num_args > 0)
	*((XlcCharSet *) args[0]) = charset;
/* printf(" ****  reurn from in big5_wcstocs()  num_args = %d\n",num_args); */
    return unconv_num;

}

static CodeSet
GetCodeSetFromCharSet(lcd, charset)
    XLCd lcd;
    XlcCharSet charset;
{
    register CodeSet *codeset = XLC_GENERIC(lcd, codeset_list);
    register XlcCharSet *charset_list;
    register codeset_num, num_charsets;

    codeset_num = XLC_GENERIC(lcd, codeset_num);

    for ( ; codeset_num-- > 0; codeset++) {
	num_charsets = (*codeset)->num_charsets;
	charset_list = (*codeset)->charset_list;

	for ( ; num_charsets-- > 0; charset_list++)
	    if (*charset_list == charset)
		return *codeset;
    }

    return (CodeSet) NULL;
}


static int
big5_cstombs(conv, from, from_left, to, to_left, args, num_args)
    XlcConv conv;
    char **from;
    int *from_left;
    char **to;
    int *to_left;
    XPointer *args;
    int num_args;
{
    char *src = *from;
    char *dst = *to;
    XLCd lcd = (XLCd)conv->state;
    XlcCharSet charset = NULL;
    XPointer tmp_args[2], tmp_from, save_from = *from;
    char tmp[32];
    int char_size = 0;
    int length, ret, src_left = *from_left;
    int unconv_num = 0, tmp_num = 1;
    CodeSet *codesets = XLC_GENERIC(lcd, codeset_list);
    int codeset_num = XLC_GENERIC(lcd, codeset_num);
    int flag = 0;
    for(;;){
      if(isbig5(src)){
	char_size = 2;
	if (*from_left > 0 && *to_left >= char_size) {
          *dst++ = *src++;
          *dst++ = *src++;
          *to_left -= char_size;
          *from_left -= char_size;
        }else
          return -1;
      }
      else if (isascii(*src)) {
	char_size = 1;
	if (*from_left >= char_size && *to_left >= char_size){
	  *dst++ = *src++;
          *to_left -= char_size;
          *from_left -= char_size;
	}else
	  return -1;
      }
      else{ 	/* unknown */
	unconv_num++;
	src++;
	char_size = 1;
	*from_left -= char_size;
      }

      src_left -= char_size;;
      if(src_left <= 0)
       break;
       
    }

    *from = (XPointer) src;
    *to = dst;
    *from_left = src_left; 

    if (num_args > 0)
	*((XlcCharSet *) args[0]) = charset;
    
    return unconv_num;

}
/* since no one will call the following function, so it is incomplete ...*/
static int
big5_cstowcs(conv, from, from_left, to, to_left, args, num_args)
    XlcConv conv;
    XPointer *from;
    int *from_left;
    XPointer *to;
    int *to_left;
    XPointer *args;
    int num_args;
{
    XPointer inbufptr = *from;
    XPointer outbufptr, outbufptr_save;
    int from_left_1 = *from_left;
    int to_left_1_save = *to_left;
    int to_left_1 = *to_left;
    wchar_t *pwc = (wchar_t *) *to;
    int rtn, rtn_1;
    /*    printf("inside cstowcs *from_left = %d *to_left = %d\n",*from_left,*to_left); */
    outbufptr = (XPointer) Xmalloc(*to_left + 100); /* 100 safty tolerence */
    outbufptr_save = outbufptr;
    rtn = big5_cstombs(conv, &inbufptr, &from_left_1, &outbufptr, &to_left_1, args, num_args);
    *outbufptr='\0';
    rtn_1 = mbstowcs(pwc, outbufptr_save, (to_left_1_save - to_left_1));
    Xfree(outbufptr_save);

    *to_left = to_left_1_save - rtn_1;
    *from = inbufptr+from_left_1;
    *to = *to+ rtn_1 * sizeof(wchar_t);
    *from_left = from_left_1;
    return 0;
}

int
big5_wcstocts(conv, from, from_left, to, to_left, args, num_args)
    XlcConv conv;
    unsigned char **from;
    int *from_left;
    unsigned char **to;
    int *to_left;
    unsigned char **args;
    int num_args;
{

    wchar_t *pwc = (wchar_t *)*from;
    unsigned char inbufptr[10];
    unsigned char *outbufptr = *to;
    unsigned char iconv_buf_in[6];
    unsigned char iconv_buf_out[6];
    int conv_num = *from_left;
    int unconv_num = 0;
    int flag,j,i,k, more;
    i = k = j = 0;
    flag = 0;
    more = 0;
    for(;;){
      if(k >= *from_left)
        break;

      if(wctomb((char *)inbufptr, pwc[k++]) == -1)
         return (-1);
      i=0;
      if(isbig5(&inbufptr[i])){
        iconv_buf_in[0] = inbufptr[i++];
        iconv_buf_in[1] = inbufptr[i++];
        big5_to_euc(iconv_buf_in,iconv_buf_out);
	if(iconv_buf_out[0] == 0x8e && iconv_buf_out[1] == 0xa2){
	  if(flag == 0 || flag != 1){
	    outbufptr[j++] = 0x1b;
	    outbufptr[j++] = 0x24;
	    outbufptr[j++] = 0x29;
	    outbufptr[j++] = 0x48;
	    flag = 1;
	  }
	  outbufptr[j++] = iconv_buf_out[2]; 
	  outbufptr[j++] = iconv_buf_out[3];
	}else{
	  if(iconv_buf_out[0] != 0x8e){
	    if(flag == 0 || flag != 2){
	      outbufptr[j++] = 0x1b;
	      outbufptr[j++] = 0x24;
	      outbufptr[j++] = 0x29;
	      outbufptr[j++] = 0x47; 
	      flag = 2;
	    }
	    outbufptr[j++] = iconv_buf_out[0]; 
	    outbufptr[j++] = iconv_buf_out[1];
	  }else{
	    /* out of big5 range character set to space */
	    if(flag == 0 || flag != 2){
	      outbufptr[j++] = 0x1b;
	      outbufptr[j++] = 0x24;
	      outbufptr[j++] = 0x29;
	      outbufptr[j++] = 0x47; 
	      flag = 2;
	    }
	    outbufptr[j++] = 0xa1; 
	    outbufptr[j++] = 0x40;
	  }
	}
      }else if(isascii(inbufptr[i])){
	if(flag == 0 || flag != 3){
	  outbufptr[j++] = 0x1b;
	  outbufptr[j++] = 0x28;
	  outbufptr[j++] = 0x42;
	  flag = 3;
	}
	outbufptr[j++] = inbufptr[i++];
      }else{
	/* unknown character set */
	unconv_num++;
	/* This character is skipped as k is incremented in call to wctomb() */
      }
    }
    *from = (unsigned char *)&pwc[k];
    *to = &outbufptr[j];
    *from_left = *from_left - k;
    *to_left = *to_left - j;
    return unconv_num;


}

int
big5_ctstowcs(conv, from, from_left, to, to_left, args, num_args)
    XlcConv conv;
    XPointer *from;
    int *from_left;
    XPointer *to;
    int *to_left;
    XPointer *args;
    int num_args;
{
    XPointer inbufptr = *from;
    XPointer outbufptr, outbufptr_save;
    int from_left_1 = *from_left;
    int to_left_1_save = *to_left;
    int to_left_1 = *to_left;
    wchar_t *pwc = (wchar_t *) *to;
    int rtn, rtn_1;
    /*    printf("inside ctstowcs *from_left = %d *to_left = %d\n",*from_left,*to_left); */
    outbufptr = (XPointer) Xmalloc(*to_left + 100); /* 100 safty tolerence */
    outbufptr_save = outbufptr;
    rtn = big5_ctstombs(conv, &inbufptr, &from_left_1, &outbufptr, &to_left_1, args, num_args);
    *outbufptr='\0';
    rtn_1 = mbstowcs(pwc, outbufptr_save, (to_left_1_save - to_left_1));
    Xfree(outbufptr_save);

    *to_left = to_left_1_save - rtn_1;
    *from = inbufptr+from_left_1;
    *to = *to+ rtn_1 * sizeof(wchar_t);
    *from_left = from_left_1;

    return 0;
}

/* in big5 locale, we only consider the following 4 possibilities
 * all other ct formats are ignored, keep looping until end of buffer
 * 1b 24 29 47 follow by  2 bytes euc plane 1 code
 * 1b 24 29 48 follow by  2 bytes euc plane 2 code
 * 1b 28 42    follow by  ascii code
 * ascii code
 */
int
big5_ctstombs(conv, from, from_left, to, to_left, args, num_args)
    XlcConv conv;
    XPointer *from;
    int *from_left;
    XPointer *to;
    int *to_left;
    XPointer *args;
    int num_args;
{
    register XPointer inbufptr = *from;
    register XPointer outbufptr = *to;
    int unconv_num = 0;
    int num_conv,i,j,k;
    unsigned char iconv_buf[6];
    int save_outbuf = True; 
    /*
    printf("inside ctstombs *from_left = %d *to_left = %d\n",*from_left,*to_left);
    printf(" --- big5_ctstombs() from_left = %d (%x %x %x %x %x %x %x %x)\n",
          *from_left,inbufptr[0],inbufptr[1],inbufptr[2],inbufptr[3],inbufptr[4],inbufptr[5],inbufptr[6],inbufptr[7]);
	  */
    /* If outbufptr is NULL, doen't save output, but just counts
       a length to hold the output */
    if (outbufptr == NULL) save_outbuf = False;
    i = 0; j = 0;
    for(;;){
      if(i >= *from_left)  /* end of from buffer */
	break;
      if(inbufptr[i] == 0x1b){ /* got an escape */
        num_conv = i;
        i++;
        if(inbufptr[i] == 0x28 && inbufptr[i+1] == 0x42){ /* got ascii code */
          i++;
	  for(;;){
            i++;
            if(i >= *from_left){  /* end of from buffer */
               *from = &inbufptr[i];
	       *to = &outbufptr[j];
	       *from_left = 0;
               return (unconv_num);
	    }
            if((inbufptr[i] == 0x0a || inbufptr[i] == 0x09 || inbufptr[i] >= 0x20)
				&& isascii(inbufptr[i])){
	      if(*to_left < 1){  /* end of to buffer */
		*from = &inbufptr[i];
		*to = &outbufptr[j];
		*from_left = *from_left - i;
		return (unconv_num + *from_left); /* previous segement */
	      }
              if(save_outbuf == True)
		outbufptr[j++] = inbufptr[i];
	      *to_left -= 1;
            }else{
              break;
            }
          }
        }else{
          if(inbufptr[i] == 0x24 && inbufptr[i+1] == 0x29){
	    i = i + 2;
	    if(inbufptr[i] == 0x47){  /* got euc plane 1 code */
              i++;
              for(;;){
		if(i >= *from_left){  /* end of from buffer */
		  *from = &inbufptr[i];
		  *to = &outbufptr[j];
		  *from_left = 0;
		  return (unconv_num);
		}
		if((inbufptr[i] & 0x80) != 0x80) 
		  break;
		euc_to_big_5_1(inbufptr[i],inbufptr[i+1],iconv_buf);
		if(isbig5(iconv_buf)){
		 if(*to_left < 2){  /* almost end of to buffer, can not hold two more bytes */
		   *from = &inbufptr[i];
		   *to = &outbufptr[j];
		   *from_left = *from_left - i;
		   return (unconv_num + *from_left); /* previous segement */
		 }
		 if(save_outbuf == True){
		   outbufptr[j++] = iconv_buf[0];
		   outbufptr[j++] = iconv_buf[1];
		 }
		 *to_left -= 2;
                 i = i + 2;
               }else
                 break;
              }
	    }else{
	      if(inbufptr[i] == 0x48){ /* got euc plane 2 code */
		i++;
		for(;;){
		  if(i >= *from_left){  /* end of from buffer */
		    *from = &inbufptr[i];
		    *to = &outbufptr[j];
		    *from_left = 0;
		    return (unconv_num);
		  }
		  /* must have this check   */
		  if((inbufptr[i] & 0x80) != 0x80) 
                     break;
		  euc_to_big_5_2(inbufptr[i],inbufptr[i+1],iconv_buf);
		  if(isbig5(iconv_buf)){
		    if(*to_left < 2){  /* almost end of to buffer, can not hold two more bytes */
		      *from = &inbufptr[i];
		      *to = &outbufptr[j];
		      *from_left = *from_left - i;
		      return (unconv_num + *from_left); /* previous segement */
		    }
		    if(save_outbuf == True){
		      outbufptr[j++] = iconv_buf[0];
		      outbufptr[j++] = iconv_buf[1];
		    }
		    *to_left -= 2;
		    i = i + 2;
		  }else
		    break;
		}
	      }else{
                /* encountered plane 3 characters ignored */
		i++;
		unconv_num++;
	      }
	    }
	  }else{
            i++; /* encounter unknown escape sequence */
	    unconv_num++;
	  }
	}
      }else if ((inbufptr[i] == 0x0a || inbufptr[i] == 0x09 ||
		inbufptr[i] >= 0x20) && isascii(inbufptr[i])) {
		/* Process default CT G0 ascii character */
	 if(*to_left < 1){  /* end of to buffer */
		*from = &inbufptr[i];
		*to = &outbufptr[j];
		*from_left = *from_left - i;
		return (unconv_num + *from_left); /* previous segement */
	 }
         if(save_outbuf == True)
		outbufptr[j++] = inbufptr[i];
	 *to_left -= 1;
	 i++;
      }else { /* unknown character */
         i++;
	 unconv_num++;
      }
     if(i < 0)   /* meaningless statement just to keep compiler quiet */
         break;
    }  /* for(;;) */
    *from = &inbufptr[i];
    *to = &outbufptr[j];
    *from_left = *from_left - i;
    return (unconv_num);
}

/* the mbs is big5 code, must be converted to euc code, then pack to ct format 
*/
int
big5_mbstocts(conv, from, from_left, to, to_left, args, num_args)
    XlcConv conv;
    unsigned char **from;
    int *from_left;
    unsigned char **to;
    int *to_left;
    XPointer *args;
    int num_args;
{
    unsigned char *inbufptr = *from;
    unsigned char *outbufptr = *to;
    unsigned char iconv_buf_in[6];
    unsigned char iconv_buf_out[6];
    int conv_num = *from_left;
    int unconv_num = 0;
    int flag,j,i, more;
    j = 0;
    i = 0;
    flag = 0;
    more = 0;
    for(;;){
      if(i >= *from_left)
        break;
      if(isbig5(&inbufptr[i])){
        iconv_buf_in[0] = inbufptr[i++];
        iconv_buf_in[1] = inbufptr[i++];
        big5_to_euc(iconv_buf_in,iconv_buf_out);
	if(iconv_buf_out[0] == 0x8e && iconv_buf_out[1] == 0xa2){
	  if(flag == 0 || flag != 1){
	    outbufptr[j++] = 0x1b;
	    outbufptr[j++] = 0x24;
	    outbufptr[j++] = 0x29;
	    outbufptr[j++] = 0x48;
	    flag = 1;
	  }
	  outbufptr[j++] = iconv_buf_out[2]; 
	  outbufptr[j++] = iconv_buf_out[3];
	}else{
	  if(iconv_buf_out[0] != 0x8e){
	    if(flag == 0 || flag != 2){
	      outbufptr[j++] = 0x1b;
	      outbufptr[j++] = 0x24;
	      outbufptr[j++] = 0x29;
	      outbufptr[j++] = 0x47; 
	      flag = 2;
	    }
	    outbufptr[j++] = iconv_buf_out[0]; 
	    outbufptr[j++] = iconv_buf_out[1];
	  }else{
	    /* out of big5 range character set to space */
	    if(flag == 0 || flag != 2){
	      outbufptr[j++] = 0x1b;
	      outbufptr[j++] = 0x24;
	      outbufptr[j++] = 0x29;
	      outbufptr[j++] = 0x47; 
	      flag = 2;
	    }
	    outbufptr[j++] = 0xa1; 
	    outbufptr[j++] = 0x40;
	  }
	}
      }else if(isascii(inbufptr[i])){
	if(flag == 0 || flag != 3){
	  outbufptr[j++] = 0x1b;
	  outbufptr[j++] = 0x28;
	  outbufptr[j++] = 0x42;
	  flag = 3;
	}
	outbufptr[j++] = inbufptr[i++];
      }else{
	i++; /* Skip this byte */
	unconv_num++; /* Count this as an unconverted byte */
      }
    }
    *from = &inbufptr[i];
    *to = &outbufptr[j];
    *from_left = *from_left - i;
    *to_left = *to_left - j;
    return unconv_num;

}

static int
strtombs( conv, from, from_left, to, to_left, args, num_args )
XlcConv conv;
XPointer *from;
int *from_left;
XPointer *to;
int *to_left;
XPointer *args;
int num_args;
{
	register char *strptr;
	register char *mbsptr;
	int length;
	strptr = *((char **) from);
	mbsptr = *((char **) to);

	length = *from_left < *to_left ? *from_left : *to_left;

	memcpy( mbsptr, strptr, length );
	*from += length;
	*from_left -= length;
	*to += length;
	*to_left -= length;

	return *from_left;
}

/*
 * initCTptr(): Set ctptr[] to point at ctdata[], indexed by codeset_num.
 */
/*
static void
initCTptr(lcd)
    XLCd lcd;
{
    int num_codesets = XLC_GENERIC(lcd, codeset_num);
    int num_charsets;
    int i, j;
    CodeSet *codesets = XLC_GENERIC(lcd, codeset_list);
    CodeSet codeset;
    XlcCharSet charset;
    CTData ctdp = ctdata;

    ctdptr[ASCII] = &ctdata[0];         

    for (i = 0; i < num_codesets; i++) {

	codeset = codesets[i];
	num_charsets = codeset->num_charsets;

	for (j = 0; j < num_charsets; j++) {

	    charset = codeset->charset_list[j];

	    for (ctdp = ctdata; ctdp <= ctd_endp; ctdp++)

		if (! strcmp(ctdp->name, charset->name)) {

		    ctdptr[codeset->cs_num] = ctdp;

		    ctdptr[codeset->cs_num]->wc_encoding = codeset->wc_encoding;

		    ctdptr[codeset->cs_num]->set_size =
		      charset->set_size;

		    ctdptr[codeset->cs_num]->min_ch =
		      charset->set_size == 94 &&
		      (ctdptr[codeset->cs_num]->length > 1 ||
		      ctdptr[codeset->cs_num]->side == XlcGR) ? 0x21 : 0x20;

		    break;
		}
	}
    }
}
*/
#undef BADCHAR

static void
close_converter(conv)
    XlcConv conv;
{
	Xfree((char *) conv);
}


static XlcConv
create_conv(lcd, methods)
    XLCd lcd;
    XlcConvMethods methods;
{
    XlcConv conv;

    conv = (XlcConv) Xmalloc(sizeof(XlcConvRec));
    if (conv == NULL)
	return (XlcConv) NULL;
    
    conv->methods = methods;
    conv->state = (XPointer) lcd;
    return conv;
}

/*
enum { MBSTOCS, WCSTOCS, MBTOCS,MBSTOCTS, CTSTOMBS,
       CTSTOWCS, WCSTOCTS, MBSTOWCS, WCSTOMBS };
       */

enum { MBSTOCS, WCSTOCS, MBTOCS, CSTOMBS, CSTOWCS, MBSTOCTS, CTSTOMBS,
       CTSTOWCS, WCSTOCTS, MBSTOWCS, WCSTOMBS, STRTOMBS };

static XlcConvMethodsRec conv_methods[] = {
    {close_converter, big5_mbstocs,  NULL },
    {close_converter, big5_wcstocs,  NULL },
    {close_converter, big5_mbtocs,   NULL },
    {close_converter, big5_cstombs,  NULL },
    {close_converter, big5_cstowcs,  NULL },
    {close_converter, big5_mbstocts, NULL },
    {close_converter, big5_ctstombs, NULL },
    {close_converter, big5_ctstowcs, NULL },
    {close_converter, big5_wcstocts, NULL },
    /*
    {close_converter, big5_mbstowcs, NULL }, 
    {close_converter, big5_wcstombs, NULL },
    {close_converter, strtombs, NULL },
    */

};


static XlcConv
open_mbstocs(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    char *from_type;
    XLCd to_lcd;
    char *to_type;
{
    return create_conv(from_lcd, &conv_methods[MBSTOCS]);
}

static XlcConv
open_wcstocs(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    char *from_type;
    XLCd to_lcd;
    char *to_type;
{
    return create_conv(from_lcd, &conv_methods[WCSTOCS]);
}

static XlcConv
open_mbtocs(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    char *from_type;
    XLCd to_lcd;
    char *to_type;
{
    return create_conv(from_lcd, &conv_methods[MBTOCS]);
}

static XlcConv
open_cstombs(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    char *from_type;
    XLCd to_lcd;
    char *to_type;
{
    return create_conv(from_lcd, &conv_methods[CSTOMBS]);
}

static XlcConv
open_cstowcs(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    char *from_type;
    XLCd to_lcd;
    char *to_type;
{
    return create_conv(from_lcd, &conv_methods[CSTOWCS]);
}

static XlcConv
open_mbstowcs(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    char *from_type;
    XLCd to_lcd;
    char *to_type;
{
    return create_conv(from_lcd, &conv_methods[MBSTOWCS]);
}

static XlcConv
open_wcstombs(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    char *from_type;
    XLCd to_lcd;
    char *to_type;
{
    return create_conv(from_lcd, &conv_methods[WCSTOMBS]);
}

static XlcConv
open_wcstocts(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    char *from_type;
    XLCd to_lcd;
    char *to_type;
{
    return create_conv(from_lcd, &conv_methods[WCSTOCTS]);
}

static XlcConv
open_mbstocts(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    char *from_type;
    XLCd to_lcd;
    char *to_type;
{
    return create_conv(from_lcd, &conv_methods[MBSTOCTS]);
}

static XlcConv
open_ctstombs(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    char *from_type;
    XLCd to_lcd;
    char *to_type;
{
    return create_conv(from_lcd, &conv_methods[CTSTOMBS]);
}

static XlcConv
open_ctstowcs(from_lcd, from_type, to_lcd, to_type)
    XLCd from_lcd;
    char *from_type;
    XLCd to_lcd;
    char *to_type;
{
    return create_conv(from_lcd, &conv_methods[CTSTOWCS]);
}

static XlcConv
open_strtombs(from_lcd, from_type, to_lcd, to_type)
XLCd from_lcd;
char *from_type;
XLCd to_lcd;
char *to_type;
{
    return create_conv(from_lcd, &conv_methods[STRTOMBS]);
}

XLCd
#ifdef DYNAMIC_LOAD
_XlcGenericLoader(name)
#else
_XlcBig5Loader(name)
#endif
    char *name;
{
    XLCd lcd;

    /* printf("inside _XlcBig5Loader()\n"); */
    lcd = _XlcCreateLC(name, _XlcGenericMethods);
    if (lcd == NULL)
	return lcd;

    if ((_XlcNCompareISOLatin1(XLC_PUBLIC_PART(lcd)->codeset, "big5", 4))) {
	_XlcDestroyLC(lcd);
	return (XLCd) NULL;
    }

    /* open two iconv descripters, it stays open forever */
    big5ToEuc_fd = iconv_open("zh_TW-euc","zh_TW-big5");
    if((int) big5ToEuc_fd == -1){
       perror("can not open zh_TW-big5 to zh_TW-euc conversion\n");
    }
    EucToBig5_fd = iconv_open("zh_TW-big5","zh_TW-euc");
    if((int) EucToBig5_fd == -1){
        perror("can not open zh_TW-big5 to zh_TW-euc conversion\n");
    }
    /* may not need the following line */
    /* initCTptr(lcd);  */

    _XlcSetConverter(lcd, XlcNMultiByte,  lcd, XlcNCharSet,   open_mbstocs);
    _XlcSetConverter(lcd, XlcNWideChar,   lcd, XlcNCharSet,   open_wcstocs);
    _XlcSetConverter(lcd, XlcNCharSet,    lcd, XlcNMultiByte, open_cstombs); 
    _XlcSetConverter(lcd, XlcNCharSet,    lcd, XlcNWideChar,  open_cstowcs);
    _XlcSetConverter(lcd, XlcNMultiByte,  lcd, XlcNChar,      open_mbtocs);
    _XlcSetConverter(lcd, XlcNMultiByte, lcd, XlcNCompoundText, open_mbstocts);
    _XlcSetConverter(lcd, XlcNCompoundText, lcd, XlcNMultiByte, open_ctstombs);
    _XlcSetConverter(lcd, XlcNCompoundText, lcd, XlcNWideChar, open_ctstowcs);
    _XlcSetConverter(lcd, XlcNWideChar, lcd, XlcNCompoundText, open_wcstocts);
    /*
    _XlcSetConverter(lcd, XlcNMultiByte, lcd, XlcNWideChar, open_mbstowcs);
    _XlcSetConverter(lcd, XlcNWideChar, lcd, XlcNMultiByte, open_wcstombs);
    _XlcSetConverter(lcd, XlcNString, lcd, XlcNMultiByte, open_strtombs);
    */


    return lcd;
}

