.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XSetWMColormapWindows 3X11 "Release 6.1" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XSetWMColormapWindows, XGetWMColormapWindows \- set or read a window's WM_COLORMAP_WINDOWS property
.SH SYNTAX
Status XSetWMColormapWindows\^(\^\fIdisplay\fP, \fIw\fP, \
\fIcolormap_windows\fP, \fIcount\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      Window *\fIcolormap_windows\fP\^;
.br
      int \fIcount\fP\^;
.LP
Status XGetWMColormapWindows\^(\^\fIdisplay\fP, \fIw\fP, \
\fIcolormap_windows_return\fP, \fIcount_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      Window **\fIcolormap_windows_return\fP\^;
.br
      int *\fIcount_return\fP\^;
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIcolormap_windows\fP 1i
Specifies the list of windows.
.IP \fIcolormap_windows_return\fP 1i
Returns the list of windows.
.ds Cn windows in the list
.IP \fIcount\fP 1i
Specifies the number of \*(Cn.
.ds Cn windows in the list
.IP \fIcount_return\fP 1i
Returns the number of \*(Cn.
.IP \fIw\fP 1i
Specifies the window.
.SH DESCRIPTION
The 
.ZN XSetWMColormapWindows 
function replaces the WM_COLORMAP_WINDOWS property on the specified
window with the list of windows specified by the colormap_windows argument.
It the property does not already exist,
.ZN XSetWMColormapWindows
sets the WM_COLORMAP_WINDOWS property on the specified
window to the list of windows specified by the colormap_windows argument.
The property is stored with a type of WINDOW and a format of 32.
If it cannot intern the WM_COLORMAP_WINDOWS atom,
.ZN XSetWMColormapWindows
returns a zero status.
Otherwise, it returns a nonzero status.
.LP
.ZN XSetWMColormapWindows
can generate
.ZN BadAlloc
and
.ZN BadWindow
errors.
.LP
The 
.ZN XGetWMColormapWindows 
function returns the list of window identifiers stored 
in the WM_COLORMAP_WINDOWS property on the specified window.
These identifiers indicate the colormaps that the window manager
may need to install for this window.
If the property exists, is of type WINDOW, is of format 32, 
and the atom WM_COLORMAP_WINDOWS can be interned, 
.ZN XGetWMColormapWindows
sets the windows_return argument to a list of window identifiers, 
sets the count_return argument to the number of elements in the list, 
and returns a nonzero status.
Otherwise, it sets neither of the return arguments
and returns a zero status.
To release the list of window identifiers, use
.ZN XFree . 
.LP
.ZN XGetWMColormapWindows
can generate a
.ZN BadWindow
error.
.SH PROPERTIES
.TP 1i
\s-1WM_COLORMAP_WINDOWS\s+1
The list of window IDs that may need a different colormap
from that of their top-level window.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllocClassHint(3X11),
XAllocIconSize(3X11),
XAllocSizeHints(3X11),
XAllocWMHints(3X11),
XFree(3X11),
XSetCommand(3X11),
XSetTransientForHint(3X11),
XSetTextProperty(3X11),
XSetWMClientMachine(3X11),
XSetWMIconName(3X11),
XSetWMName(3X11),
XSetWMProperties(3X11),
XSetWMProtocols(3X11),
XStringListToTextProperty(3X11)
.br
\fI\*(xL\fP
