/* $XConsortium: xkbver.c /main/6 1996/02/01 21:04:12 kaleb $ */
/************************************************************
Copyright (c) 1993 by Silicon Graphics Computer Systems, Inc.

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of Silicon Graphics not be 
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
Silicon Graphics makes no representation about the suitability 
of this software for any purpose. It is provided "as is"
without any express or implied warranty.

SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include <stdio.h>
#include <X11/Xproto.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/extensions/XKBproto.h>
#include <X11/XKBlib.h>

/***====================================================================***/

static	char		*dpyName = NULL;
static	int		 synch = 0;

int
#if NeedFunctionPrototypes
parseArgs(int argc,char *argv[])
#else
parseArgs(argc,argv)
    int 	argc;
    char *	argv[];
#endif
{
int	i;

    for (i=1;i<argc;i++) {
	if ( strcmp(argv[i],"-display")==0 ) {
	    if ( ++i<argc )	dpyName= argv[i];
	    else {
		fprintf(stderr,"Must specify a display with -display option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-synch")==0 ) {
	    synch= 1;
	}
	else {
	    fprintf(stderr,"Unknown option %s\n",argv[i]);
	    return 0;
	}
    }
    return 1;
}

int
#if NeedFunctionPrototypes
main(int argc,char *argv[])
#else
main(argc,argv)
    int		argc;
    char *	argv[];
#endif
{
Display	*	dpy;
int		i1,i2,i3,i4,i5;
char *		srvName;
int		ok;
  
    if (!parseArgs(argc,argv)) {
	fprintf(stderr,"Usage: %s <options>\n",argv[0]);
	fprintf(stderr,"Where legal options are:\n");
	fprintf(stderr,"-display <dpy>     specifies display to use\n");
	fprintf(stderr,"-synch    turn on synchronization\n");
	return 1;
    }
    dpy = XOpenDisplay(dpyName);
    if ( !dpy ) {
	fprintf(stderr,"Couldn't open display \"%s\"\n",XDisplayName(dpyName));
	return 1;
    }
    srvName= XDisplayString(dpy);
    if (synch)
	XSynchronize(dpy,1);
    printf("%s compiled with XKB version %d.%02d\n",argv[0],XkbMajorVersion,
							XkbMinorVersion);
    i1= XkbMajorVersion;
    i2= XkbMinorVersion;
    ok= XkbLibraryVersion(&i1,&i2);
    printf("X library supports XKB version %d.%02d ",i1,i2);
    if (ok)
	printf("(compatible)\n");
    else {
	printf("(incompatible)\n");
	printf("WARNING!!! XkbLibraryVersion reports that %s was compiled\n",
								     argv[0]);
	printf("against an incompatible version of the X library.\n");
	printf("This program will attempt to query the X extension anyway\n");
	printf("but it is possible that the attempt will fail\n");
    }
    if ( !XkbQueryExtension(dpy,&i1,&i2,&i3,&i4,&i5) ) {
	if ((i4!=0)||(i5!=0)) {
	    printf("X server %s supports incompatible XKB version %d.%02d\n",
						(srvName?srvName:""),i4,i5);
	}
	else {
	    printf("XKB Extension not present on %s\n",(dpyName?dpyName:":0"));
	}
	goto BAIL;
    }
    printf("X server");
    if (srvName)
	printf(" (%s)",srvName);
    printf(" supports XKB version %d.%02d\n",i4,i5);
    printf("versions match\n");
    return 0;
BAIL:
    XCloseDisplay(dpy);
    return 1;
}
