/* $XConsortium: xkbsetgeom.c /main/1 1996/02/03 06:09:41 kaleb $ */
/************************************************************
 Copyright (c) 1996 by Silicon Graphics Computer Systems, Inc.

 Permission to use, copy, modify, and distribute this
 software and its documentation for any purpose and without
 fee is hereby granted, provided that the above copyright
 notice appear in all copies and that both that copyright
 notice and this permission notice appear in supporting
 documentation, and that the name of Silicon Graphics not be 
 used in advertising or publicity pertaining to distribution 
 of the software without specific prior written permission.
 Silicon Graphics makes no representation about the suitability 
 of this software for any purpose. It is provided "as is"
 without any express or implied warranty.
 
 SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
 AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
 GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
 DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
 OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
 THE USE OR PERFORMANCE OF THIS SOFTWARE.

 ********************************************************/

#include <stdio.h>
#include <ctype.h>
#include <locale.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/XKBlib.h>
#include <X11/extensions/XKBgeom.h>
#include <X11/extensions/XKM.h>
#include <X11/extensions/XKBfile.h>
#include <X11/keysym.h>

#ifndef X_NOT_STDC_ENV
#include <stdlib.h>
#endif

static	char *		inputFileName;
static  FILE *		inputFile;
static	char *		outDpyName;
static	Display *	outDpy;
	unsigned	warningLevel= 5;
	Bool		synch;

/***====================================================================***/

void
Usage(argc,argv)
    int 	argc;
    char *	argv[];
{
    fprintf(stderr,"Usage: %s [opts] input-file [ output-dpy ]\n",argv[0]);
    fprintf(stderr,"Legal options:\n");
    fprintf(stderr,"-?,-help      Print this message\n");
    fprintf(stderr,"-synch        Force synchronization\n");
    fprintf(stderr,"-w <lvl>      Set warning level (0=none, 10=all)\n");
    return;
}

/***====================================================================***/

Bool
parseArgs(argc,argv)
    int		argc;
    char *	argv[];
{
register int i;

    for (i=1;i<argc;i++) {
	if ((argv[i][0]!='-')||(strcmp(argv[i],"-")==0)) {
	    if (inputFileName==NULL) {
		inputFileName= argv[i];
	    }
	    else if (outDpyName==NULL) {
		outDpyName= argv[i];
	    }
	    else {
		fprintf(stderr,"Warning! Too many file names on command line\n");
		fprintf(stderr,"         Loading %s, writing to %s, ignoring %s\n",
					inputFileName,outDpyName,argv[i]);
	    }
	}
	else if ((strcmp(argv[i],"-?")==0)||(strcmp(argv[i],"-help")==0)) {
	    Usage(argc,argv);
	    exit(0);
	}
	else if ((strcmp(argv[i],"-synch")==0)||(strcmp(argv[i],"-s")==0)) {
	    synch= True;
	}
	else if (strcmp(argv[i],"-w")==0) {
	    if ((i>=(argc-1))||(!isdigit(argv[i+1][0]))) {
		warningLevel= 0;
	    }
	    else {
		sscanf(argv[++i],"%i",&warningLevel);
	    }
	}
	else {
	    fprintf(stderr,"Error! Unknown flag \"%s\" on command line\n",argv[i]);
	    Usage(argc,argv);
	    return False;
	}
    }
    if (inputFileName==NULL) {
	fprintf(stderr,"Error! No input file specified\n");
	Usage(argc,argv);
	return False;
    }
    return True;
}

Display *
GetDisplay(program,dpyName)
    char *	program;
    char *	dpyName;
{
int	mjr,mnr,error;
Display	*dpy;

    mjr= XkbMajorVersion;
    mnr= XkbMinorVersion;
    dpy= XkbOpenDisplay(dpyName,NULL,NULL,&mjr,&mnr,&error);
    if (dpy==NULL) {
	switch (error) {
	    case XkbOD_BadLibraryVersion:
		fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
				program,XkbMajorVersion,XkbMinorVersion);
		fprintf(stderr,"Error! X library supports incompatible version %d.%02d\n",
				mjr,mnr);
		break;
	    case XkbOD_ConnectionRefused:
		fprintf(stderr,"Cannot open display \"%s\"\n",dpyName);
		break;
	    case XkbOD_NonXkbServer:
		fprintf(stderr,"Error! XKB extension not present on %s\n",dpyName);
		break;
	    case XkbOD_BadServerVersion:
		fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
				program,XkbMajorVersion,XkbMinorVersion);
		fprintf(stderr,"Error! Server %s uses incompatible version %d.%02d\n",
				dpyName,mjr,mnr);
		break;
	    default:
		fprintf(stderr,"Fatal Error! Unknown error %d from XkbOpenDisplay\n",error);
	}
    }
    else if (synch)
	XSynchronize(dpy,True);
    return dpy;
}

/***====================================================================***/

int
main(argc,argv)
    int		argc;
    char *	argv[];
{
int		ok;
XkbFileInfo 	result;

    if (!parseArgs(argc,argv))
	exit(1);
    inputFile= NULL;
    XkbInitAtoms(NULL);
    if (strcmp(inputFileName,"-")==0) {
	static char *in= "stdin";
	inputFile= stdin;
	inputFileName= in;
    }
    else {
	inputFile= fopen(inputFileName,"r");
    }
    outDpy= GetDisplay(argv[0],outDpyName);
    if (!outDpy) {
	fprintf(stderr,"Exiting\n");
	exit(1);
    }
    if (inputFile) {
	unsigned tmp;
	ok= True;
	bzero((char *)&result,sizeof(result));
	if ((result.xkb= XkbAllocKeyboard())==NULL) {
	    fprintf(stderr,"Fatal! Cannot allocate keyboard description\n");
	    exit(1);
	    /* NOTREACHED */
	}
	tmp= XkmReadFile(inputFile,XkmGeometryMask,XkbGeometryMask,&result);
	if ((tmp&XkmGeometryMask)!=0) {
	    fprintf(stderr,"Error! Couldn't read geometry from XKM file \"%s\"\n",inputFile);
	    fprintf(stderr,"       Exiting\n");
	    ok= False;
	}
    }

    if (ok) {
	FILE *out;
	if (XkbChangeKbdDisplay(outDpy,&result)!=Success) {
	    fprintf(stderr,"Internal Error converting keyboard display from <file> to %s\n",
	    							outDpyName);
	    exit(1);
	}
	if (XkbSetGeometry(outDpy,XkbUseCoreKbd,result.xkb->geom)!=Success) {
	    fprintf(stderr,"Error setting geometry\n");
	}
	XSync(outDpy,False);
    }
    if (inputFile)
	fclose(inputFile);
    if (outDpy)
	XCloseDisplay(outDpy);
    return (ok==0);
}
