/* $XConsortium: xkblist.c /main/3 1996/02/05 11:45:07 kaleb $ */
/************************************************************
Copyright (c) 1995 by Silicon Graphics Computer Systems, Inc.

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of Silicon Graphics not be 
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
Silicon Graphics makes no representation about the suitability 
of this software for any purpose. It is provided "as is"
without any express or implied warranty.

SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/XKBlib.h>

#include <X11/extensions/XKM.h>
#include <X11/extensions/XKBfile.h>

static	char		*	dpyName = NULL;
static	unsigned	 	dev = XkbUseCoreKbd;
static	XkbComponentNamesRec	patterns;
static	int			synch;
static	unsigned		debug= 0;
static	int			max_rtrn= 65000;

int
#if NeedFunctionPrototypes
parseArgs(int argc,char *argv[])
#else
parseArgs(argc,argv)
    int argc;
    char *argv[];
#endif
{
int i;

    for (i=1;i<argc;i++) {
	if ( strcmp(argv[i],"-display")==0 ) {
	    if ( ++i<argc )	dpyName= argv[i];
	    else {
		fprintf(stderr,"Must specify a display with -display option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-debug")==0 ) {
	    if ( ++i<argc ) {
		if (sscanf(argv[i],"%i",&debug)!=1) {
		    fprintf(stderr,"Debug flags must be an integer\n");
		    return 0;
		}
	    }
	    else {
		fprintf(stderr,"Must specify flags with -debug option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-device")==0 ) {
	    if ( ++i<argc ) {
		if (sscanf(argv[i],"%i",&dev)!=1) {
		    fprintf(stderr,"Device specification must be an integer\n");
		    return 0;
		}
	    }
	    else {
		fprintf(stderr,"Must specify a device with -device option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-keymap")==0 ) {
	    if ( ++i<argc ) {
		patterns.keymap= argv[i];
	    }
	    else {
		fprintf(stderr,"Must specify a pattern for -keymap\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-keycodes")==0 ) {
	    if ( ++i<argc ) {
		patterns.keycodes= argv[i];
	    }
	    else {
		fprintf(stderr,"Must specify a pattern for -keycodes\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-types")==0 ) {
	    if ( ++i<argc ) {
		patterns.types= argv[i];
	    }
	    else {
		fprintf(stderr,"Must specify a pattern for -types\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-compat")==0 ) {
	    if ( ++i<argc ) {
		patterns.compat= argv[i];
	    }
	    else {
		fprintf(stderr,"Must specify a pattern for -compat\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-symbols")==0 ) {
	    if ( ++i<argc ) {
		patterns.symbols= argv[i];
	    }
	    else {
		fprintf(stderr,"Must specify a pattern for -symbols\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-geometry")==0 ) {
	    if ( ++i<argc ) {
		patterns.geometry= argv[i];
	    }
	    else {
		fprintf(stderr,"Must specify a pattern for -geometry\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-limit")==0 ) {
	    if ( ++i<argc ) {
		if (sscanf(argv[i],"%i",&max_rtrn)!=1) {
		    fprintf(stderr,"Limit on returned patterns must be integer\n");
		    return 0;
		}
	    }
	    else {
		fprintf(stderr,"Must specify a device with -device option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-synch")==0 ) {
	    synch= True;
	}
	else {
	    fprintf(stderr,"Unknown option %s\n",argv[i]);
	    return 0;
	}
    }
    return 1;
}

void
#if NeedFunctionPrototypes
Show(char *what,char *ptrn,int count,XkbComponentNamePtr names)
#else
Show(what,ptrn,count,list)
    char *		what;
    char *		ptrn;
    int			count;
    XkbComponentNamePtr	names;
#endif
{
register int		i;
XkbComponentNamePtr	name;
    if (count==0) {
	if (ptrn==NULL)	return;
	printf("No %s matched the pattern \"%s\"\n",what,ptrn);
	return;
    }
    printf("%d %s matched the pattern \"%s\"\n",count,what,
						(ptrn?ptrn:"!!!ERROR!!!"));
    for (i=0,name=names;i<count;i++,name++) {
	printf("    %s\n",(name->name?name->name:"!!!ERROR!!!"));
    }
    return;
}

int
#if NeedFunctionPrototypes
main(int argc,char *argv[])
#else
main(argc,argv)
    int argc;
    char *argv[];
#endif
{
Display	*		dpy;
int			major,minor,why;
unsigned		old_debug;
int			ok;
XkbComponentListPtr	list;
  
    if (!parseArgs(argc,argv)) {
	fprintf(stderr,"Usage: %s <options>\n",argv[0]);
	fprintf(stderr,"Where legal options are:\n");
	fprintf(stderr,"-display <dpy>     specifies display to use\n");
	fprintf(stderr,"-device <id>       specifies device to use\n");
	fprintf(stderr,"-synch             force synchronization\n");
	fprintf(stderr,"-keymap <ptrn>     pattern for keymap\n");
	fprintf(stderr,"-keycodes <ptrn>   pattern for keycodes\n");
	fprintf(stderr,"-types <ptrn>      pattern for types\n");
	fprintf(stderr,"-compat <ptrn>     pattern for compat map\n");
	fprintf(stderr,"-symbols <ptrn>    pattern for symbols map\n");
	fprintf(stderr,"-geometry <ptrn>   pattern for geometry\n");
	fprintf(stderr,"-limit <count>     maximum # of names to report\n");
	fprintf(stderr,"\nLists the elements of the server database whose\n");
	fprintf(stderr,"names match the specified patterns.\n");
	return 1;
    }
    ok= 1;
    major= XkbMajorVersion;
    minor= XkbMinorVersion;
    dpy = XkbOpenDisplay(dpyName,NULL,NULL,&major,&minor,&why);
    if (dpy==NULL) {
	if (dpyName==NULL)
	    dpyName= "default display";
        switch (why) {
            case XkbOD_BadLibraryVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Xlib supports incompatible version %d.%02d\n",
                                major,minor);
                break;
            case XkbOD_ConnectionRefused:
                fprintf(stderr,"Cannot open display \"%s\"\n",dpyName);
                break;
            case XkbOD_NonXkbServer:
                fprintf(stderr,"XKB extension not present on %s\n",dpyName);
                break;
            case XkbOD_BadServerVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Server %s uses incompatible version %d.%02d\n",
                                dpyName,major,minor);
                break;
            default:
                fprintf(stderr,
		    "Internal Error! Unknown error %d from XkbOpenDisplay\n",
		    why);
        }
	return 1;
    }
    if (synch)
	XSynchronize(dpy,1);
    if ((old_debug=debug)!=0) {
	XkbSetDebuggingFlags(dpy,~0,debug,argv[0],0,0,&old_debug,NULL);
	printf("Setting debugging flags to %d (from %d)\n",
							debug,old_debug);
    }
    list= XkbListComponents(dpy,dev,&patterns,&max_rtrn);
    if (list) {
	printf("XkbListComponents ok\n");
	if (max_rtrn>0)
	    printf("An additional %d matching names were not returned\n");
	Show("keymaps",patterns.keymap,list->num_keymaps,list->keymaps);
	Show("keycodes",patterns.keycodes,list->num_keycodes,list->keycodes);
	Show("types",patterns.types,list->num_types,list->types);
	Show("compat",patterns.compat,list->num_compat,list->compat);
	Show("symbols",patterns.symbols,list->num_symbols,list->symbols);
	Show("geometry",patterns.geometry,list->num_geometry,list->geometry);
    }
    else {
	 printf("XkbListComponents failed\n");
    }
    if (old_debug!=debug) {
    	XkbSetDebuggingFlags(dpy,~0,old_debug,argv[0],0,0,&debug,NULL);
	printf("Resetting debugging flags to %d (from %d)\n",
							old_debug,debug);
    }
    XCloseDisplay(dpy);
    return (ok!=0);
}
