/* $XConsortium: xkbget.c /main/5 1996/02/05 13:57:54 kaleb $ */
/************************************************************
Copyright (c) 1993 by Silicon Graphics Computer Systems, Inc.

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of Silicon Graphics not be 
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
Silicon Graphics makes no representation about the suitability 
of this software for any purpose. It is provided "as is"
without any express or implied warranty.

SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/XKBlib.h>
#include <X11/Xfuncs.h>

#include <X11/extensions/XKM.h>
#include <X11/extensions/XKBfile.h>

#define	SERVER_INTERNAL	0
#define	KEY_ONLY	1

static	char		*	dpyName = NULL;
static	unsigned	 	dev = XkbUseCoreKbd;
static	XkbComponentNamesRec	names;
static	char *			xkbFile;
static	int			synch;
static	unsigned		debug= 0;
static	unsigned		want= 0;
static	unsigned		need= 0;
static	Bool			load= False;

int
#if NeedFunctionPrototypes
parseArgs(int argc,char *argv[])
#else
parseArgs(argc,argv)
    int argc;
    char *argv[];
#endif
{
int i;

    for (i=1;i<argc;i++) {
	if ( strcmp(argv[i],"-display")==0 ) {
	    if ( ++i<argc )	dpyName= argv[i];
	    else {
		fprintf(stderr,"Must specify a display with -display option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-debug")==0 ) {
	    if ( ++i<argc ) {
		if (sscanf(argv[i],"%i",&debug)!=1) {
		    fprintf(stderr,"Debug flags must be an integer\n");
		    return 0;
		}
	    }
	    else {
		fprintf(stderr,"Must specify flags with -debug option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-device")==0 ) {
	    if ( ++i<argc ) {
		if (sscanf(argv[i],"%i",&dev)!=1) {
		    fprintf(stderr,"Device specification must be an integer\n");
		    return 0;
		}
	    }
	    else {
		fprintf(stderr,"Must specify a device with -device option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-keymap")==0 ) {
	    if ( ++i<argc ) {
		names.keymap= argv[i];
	    }
	    else {
		fprintf(stderr,"Must specify a name with -keymap option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-keycodes")==0 ) {
	    if ( ++i<argc ) {
		names.keycodes= argv[i];
		need|= XkbGBN_KeyNamesMask;
		want|= XkbGBN_IndicatorMapMask;
	    }
	    else {
		fprintf(stderr,"Must specify a name with -keycodes option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-load")==0 ) {
	    load= True;
	}
	else if ( strcmp(argv[i],"-types")==0 ) {
	    if ( ++i<argc ) {
		names.types= argv[i];
		need|= XkbGBN_TypesMask;
	    }
	    else {
		fprintf(stderr,"Must specify a name with -types option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-compat")==0 ) {
	    if ( ++i<argc ) {
		names.compat= argv[i];
		need|= XkbGBN_CompatMapMask;
		want|= XkbGBN_IndicatorMapMask;
	    }
	    else {
		fprintf(stderr,"Must specify a name with -compat option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-symbols")==0 ) {
	    if ( ++i<argc ) {
		names.symbols= argv[i];
		need|= XkbGBN_SymbolsMask;
		want|= XkbGBN_KeyNamesMask|XkbGBN_IndicatorMapMask;
	    }
	    else {
		fprintf(stderr,"Must specify a name with -symbols option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-geometry")==0 ) {
	    if ( ++i<argc ) {
		names.geometry= argv[i];
		need|= XkbGBN_GeometryMask;
	    }
	    else {
		fprintf(stderr,"Must specify a name with -geometry option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-xkb")==0 ) {
	    if ( ++i<argc ) {
		xkbFile= argv[i];
	    }
	    else {
		fprintf(stderr,"Must specify a file with -xkb option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-synch")==0 ) {
	    synch= True;
	}
	else {
	    fprintf(stderr,"Unknown option %s\n",argv[i]);
	    return 0;
	}
    }
    return 1;
}

int
#if NeedFunctionPrototypes
main(int argc,char *argv[])
#else
main(argc,argv)
    int argc;
    char *argv[];
#endif
{
Display	*	dpy;
int		major,minor,why;
unsigned	old_debug;
XkbDescPtr	xkb;
int		ok;
  
    if (!parseArgs(argc,argv)) {
	fprintf(stderr,"Usage: %s <options>\n",argv[0]);
	fprintf(stderr,"Where legal options are:\n");
	fprintf(stderr,"-display <dpy>     specifies display to use\n");
	fprintf(stderr,"-device <id>       specifies device to use\n");
	fprintf(stderr,"-synch             force synchronization\n");
	fprintf(stderr,"-keymap <name>     specifies name of keymap\n");
	fprintf(stderr,"-keycodes <name>   specifies name of keycodes\n");
	fprintf(stderr,"-load              load the keymap\n");
	fprintf(stderr,"-types <name>      specifies name of types\n");
	fprintf(stderr,"-compat <name>     specifies name of compat map\n");
	fprintf(stderr,"-symbols <name>    specifies name of symbols map\n");
	fprintf(stderr,"-geometry <name>   specifies name of geometry\n");
	fprintf(stderr,"-xkb <file>        produce an XKB keymap file\n");
	fprintf(stderr,"\nRetrieves a map made up of named components\n");
	fprintf(stderr,"If no names are specified, it just gets the current\n");
	fprintf(stderr,"map\n");
	return 1;
    }
    ok= 1;
    major= XkbMajorVersion;
    minor= XkbMinorVersion;
    dpy = XkbOpenDisplay(dpyName,NULL,NULL,&major,&minor,&why);
    if (dpy==NULL) {
	if (dpyName==NULL)
	    dpyName= "default display";
        switch (why) {
            case XkbOD_BadLibraryVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Xlib supports incompatible version %d.%02d\n",
                                major,minor);
                break;
            case XkbOD_ConnectionRefused:
                fprintf(stderr,"Cannot open display \"%s\"\n",dpyName);
                break;
            case XkbOD_NonXkbServer:
                fprintf(stderr,"XKB extension not present on %s\n",dpyName);
                break;
            case XkbOD_BadServerVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Server %s uses incompatible version %d.%02d\n",
                                dpyName,major,minor);
                break;
            default:
                fprintf(stderr,
		    "Internal Error! Unknown error %d from XkbOpenDisplay\n",
		    why);
        }
	return 1;
    }
    if (synch)
	XSynchronize(dpy,1);
    if ((old_debug=debug)!=0) {
	XkbSetDebuggingFlags(dpy,~0,debug,argv[0],0,0,&old_debug,NULL);
	fprintf(stderr,"Setting debugging flags to %d (from %d)\n",
							debug,old_debug);
    }
    if ((need==0)&&(want==0)) {
	want= XkbGBN_GeometryMask;
	need= XkbGBN_AllComponentsMask&(~want);
    }
    xkb= XkbGetKeyboardByName(dpy,dev,&names,want,need,load);
    if (!xkb) {
	 printf("GetKeyboardByName failed\n");
    }
    else {
	XkbFileInfo	finfo;
	FILE *	file;

	fprintf(stderr,"GetKeyboardByName ok\n");
	if (xkbFile==NULL)
	    xkbFile= "xkbget.xkb";
	if (strcmp(xkbFile,"-")==0)
	     file= stdout;
	else file= fopen(xkbFile,"w");
	if (file==NULL) {
	    fprintf(stderr,"Couldn't open \"%s\" to write XKB file\n",xkbFile);
	    exit(0);
	}
	bzero(&finfo,sizeof(finfo));
	finfo.xkb= xkb;
	if (XkbDetermineFileType(&finfo,XkbXKBFile,NULL)) {
	    ok= XkbWriteXKBFile(file,&finfo,False,NULL,NULL);
	    if (!ok)
		fprintf(stderr,"Error writing XKB file\n");
	}
	else {
	    fprintf(stderr,"Couldn't determine type of file to write\n");
	}
	fclose(file);
    }
    if (old_debug!=debug) {
    	XkbSetDebuggingFlags(dpy,~0,old_debug,argv[0],0,0,&debug,NULL);
	fprintf(stderr,"Resetting debugging flags to %d (from %d)\n",
							old_debug,debug);
    }
    XCloseDisplay(dpy);
    return (ok!=0);
}
