.TH MAZEWAR 6
.SH NAME
MazeWar \- distributed rats in a maze
.SH SYNTAX
.B /usr/games/mw
[
.I 
window system options
]
.SH DESCRIPTION
This program implements the age-old game of MazeWar.
MazeWar first appeared at MIT in the early 1970s, using IMLAC displays and
the ArpaNet network.
Legend has it that, at one point during that period, MazeWar was banned
by DARPA from the ArpaNet because half of all the packets in a given
month were MazeWar packets flying between Stanford and MIT.
.PP
MazeWar appeared again at the Xerox Palo Alto Research Center in the late
1970's on the Alto, the first personal computer.
This version has subsequently been ported to many
personal machines, and forms the basis for this Unix version.
.PP
.I Mw
attempts to be as faithful to the original Alto version as possible. 
The shape and pictures of the maze are as in the original, and there are
no embellishments such as teleport traps or robot amanuenses.
.SH PLAY
You, the player, are a rat in a maze, and the objective is to 
find your opponents and shoot them before they shoot you.
.PP
Each of the (up to eight) players in a game may be on a different host. 
Upon startup, you are asked for the name by which you wish to be known for
the duration of the game, and the name of the ``Duke host''.
If you type a bare carriage return to this query, 
.I mw
will find a game by broadcasting on the local network, and join any game
it finds. 
If you wish to join a specific game, or a game on another network, or your
network doesn't support broadcasting,
type in the name of one of the hosts involved in that game.
The program
.I mazefind
will aid you in finding out what games are currently being played.
.PP
Once in a game, you are presented with the game window.
This window is made up of three sections.
The upper section is a perspective view of your view forward. 
By pressing
the left or right mouse buttons, you may peek to the left or right around
corners.
.PP
The middle section of the window is a top view of the maze, showing your
current position and heading in the maze. 
You move around the maze by using the following keys:
.sp
.ta .6i
.nf
A	About face; flip end\-for\-end
S	Turn 90 degrees left
D	Move forward one cell
F	Turn 90 degrees right
<space>	Move backward one cell
Q	Quit
.fi
.sp
For left\-handers, there are equivalents on the numeric keypad. 
On the DEC LK201 keyboard, the `4', `5', `6', `,', and right cursor arrow
keys perform the equivalent operations.
.PP
The lower section of the window shows the names and scores of the other
players in the game.
When you sight another rat, that rat's score line is highlighted.
Shoot by pressing the middle mouse button.
When you are shot at, the mouse cursor changes from a rat to a dead rat,
and you have one second to move out of the way of the shot or shoot back
or both.
A shot costs one point; getting hit costs five points; hitting someone
adds ten points.
When you are hit, the screen flashes and you are transported to another
section of the maze.
.PP
If your window system supports it, when you iconify the game window, it
will let you know when someone joins the game or shoots at you (by
flashing, in most cases).
This way, you can be notified whenever someone else is interested in
wasting some time, by always leaving a game around.
.SH "SEE ALSO"
mazefind(6)
.SH AUTHOR
Christopher A. Kent
