.\" $XConsortium: Xqdss.man,v 1.5 88/10/26 16:16:31 keith Exp $
.TH XQDSS 1 "26 October 1988" "X Version 11"
.SH NAME
Xqdss - VAXStation II/GPX server for the X Window System
.SH DESCRIPTION
.PP
The QDSS hardware in the VAXStation II/GPX supports 8 plane or 4 plane
displays.
.PP
.SH OPTIONS
.br
\fB-bp\fP \fIpixel-value\fP	set default black-pixel color
.br
\fB-wp\fP \fIpixel-value\fP	set default white-pixel color
.sp
The server also takes all of the standard server options (See
\fIXserver(1)\fP for a complete list.)
.PP
.SH NOTE
You need to make sure your kernel is configured with DMA_BUFSIZ
set to 10 in sys/data/qd_data.c, or things won't work right.
.SH BUGS
.PP
Currently only numeric arguments from #000000 to #ffffff are
accepted for default BlackPixel and WhitePixel, and no screen 
number is accepted.
.PP
The GPX hardware contains a polygon edge address generation engine
which does not conform to the polygon edge
model specified in the X11 protocol document.
The effect is that GPX polygon edges extend on average
one-half pixel farther out than they ought.
.PP
Masks do not work correctly in most cases.  The fact that
scrollbars look fine is a fluke.  This bug affects stipple
operations, copyPlane operations, and XYbitmap putImage
as well.
.PP
ImageText does not paint enough background color -- the last character
will have too few bits filled in on the right side (all bits from
the edge of the character bitmap to the 'width' field of the character).
(The ``ultimate sleazoid hack'' in tlpolytext.c doesn't work right.)
.PP
Any tile or stipple which is too large to fit off-screen will
not work at all.  There should be provisions for punting to
MI code in these cases.
.PP
The console driver for the QDSS mashes the state of the drawing
engine -- this causes massive lossage when doing GetImage or
PutImage (which shut the engine down), and causes other
strange effects.  Use xcons to avoid the problem.
.PP
This driver uses MI code for all off-screen pixmap drawing operations, including
scrolling and text painting.  This is incredibly slow.  This could be
replaced with cfb, but would require reengineering much of the pixmap
management code as it doesn't conform to the cfb model at all.  Besides, cfb
isn't known for it's speed anyway...
.PP
GetImage is also amazingly slow, it fetches one pixel at a time
from the screen through a long sequence of instructions.  This can
be fixed, but requires rethought in how the template rams are managed.
.PP
Because BackingStore uses the GetImage code to fetch stuff from the screen,
it is useless on all but the fastest VaxStations (works reasonably well on
my 3200, don't bother on a 2000 or VaxStar).  For this reason, the -bs and
-su options were added to the server (see the \fIXserver\fP manual).  Also,
because the on-screen lines are drawn with the hardware, they don't match
off screen lines exactly, the differences are quite noticeable in some
contexts.
.PP
Be patient with this server, some operations are amazingly slow
(such as scrolling a partially-occluded window with backing store), but
others are quite fast (like text painting).  Make very sparing use
of backing store and save unders.
.SH "SEE ALSO"
.PP
Xserver(1), xdm(1), X(1)
.SH COPYRIGHT
Copyright 1987, 1988, Digital Equipment Corporation.
.br
Copyright 1987, 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
.PP
Donald Mullis and Matt Pappas, Digital Equipment Corporation.
.PP
Thanks to Ram Rao, Vasudev Bhandarkar and Mary Larsen of UEG for their 4-plane
code and numerous bug fixes.
