/*

Copyright (c) 1986, 1987 by Hewlett-Packard Company
Copyright (c) 1986, 1987 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

HEWLETT-PACKARD MAKES NO WARRANTY OF ANY KIND WITH REGARD
TO THIS SOFWARE, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE.  Hewlett-Packard shall not be liable for errors 
contained herein or direct, indirect, special, incidental or 
consequential damages in connection with the furnishing, 
performance, or use of this material.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/
/*
$Log:	hil_kmap.h,v $
 * Revision 1.1  87/12/16  13:27:41  hp
 * Initial revision
 * 
 * Revision 1.1  87/12/14  14:41:28  hp
 * Initial revision
 * 
 * Revision 1.1  87/09/22 18:04:08 GMT  leichner
 * Initial revision
 * 
 * Revision 3.0  87/08/12  16:14:46  16:14:46  bennett
 * beta 3.0
 * 
 * Revision 1.1  87/07/02  10:09:11  bennett
 * Initial revision
 * 
 * Revision 1.1  87/06/01  10:16:14  10:16:14  palevich (John H. Palevich)
 * Initial revision
 * 
 * Palevich
 * Re-assigned back-space code to match the X11 'standard' for such things.
 * also converted some of the octal codes to the KEY_ defines listed in
 * include/keynames.h
 *
 * Revision 1.2  87/03/11  13:22:51  13:22:51  sankar ()
 * Assigns button values to buttons 3, 4 etc of button devices.
 * 
 * Revision 1.5  86/11/21  18:04:51  18:04:51  sankar ()
 * Added back code for buttons 80-85.
 * 
 * Revision 3.0  86/11/06  09:28:15  09:28:15  root ()
 * QA1 release (plus some fixes)
 * 
 * Revision 2.0  86/10/10  15:21:33  15:21:33  dan ()
 * Alpha Release
 * 
 * Revision 1.3  86/09/29  09:47:53  09:47:53  sankar ()
 * Final allocation; unbound keys are F17-F20; Keypad top row keys are
 * PF1-PF4. (DEL/Esc) bound to (< >) of lk201. All function keys F1-F20
 * are at the top row of ITF keyboard.
 * 
 * Revision 1.3  86/09/08  15:27:27  15:27:27  dan ()
 * 
 * Latest version of the keymap.
 * 
 * Revision 1.2  86/08/12  13:37:43  13:37:43  sankar ()
 * Keymaps changed to conform to Term0 expectatations.
 * 
 * Revision 1.1  86/08/08  10:50:47  10:50:47  sankar ()
 * Initial revision
 * 
 * Revision 1.1  86/07/22  16:37:39  16:37:39  dan ()
 * Initial revision
 * 
 * Revision 1.2  86/06/04  11:25:33  11:25:33  sankar ()
 * Mouse buttons 80-84 are given new codes 0,2.
 * 
 * Revision 1.1  86/06/03  11:09:46  11:09:46  sankar ()
 * Initial revision
 * 
 * Revision 1.1  86/05/27  12:34:17  12:34:17  sankar ()
 * Initial revision
 * 
 * Revision 1.1  86/05/27  10:16:32  10:16:32  sankar ()
 * Initial revision
 * 
$Header: hil_kmap.h,v 1.1 87/12/16 13:27:41 hp Exp $
$Revision: 1.1 $
*
*	File: kmap1.c
*	Contains proposed translation of HP-Hil (SET 1) keycodes to
*	to lk201 keycodes for the X server.
*	
*	5/27/86:
*	Some of the keycodes are now unbound. Shall allocate
*	After some thought.
*	6/18/86:
*	The four unbound keys have been allocated as follows:
*	UB-1 : 0x4a, 0x4b  : 0261 - compose character;
*	UB-2 : 0x42, 0x43  : Mouse-Left 00
*	UB-3 : 0x46, 0x47  : Mouse-Middle 01
*	UB-4 : 0x4e, 0x4f  : Mouse-Right 02
*	
*	8/8/86:
*	  Above UB keys are bound to PF-keys of lk201c.
*	  Some of the unbound keys are allocated to meet specifications of
*	  Windex and Kanji projects.
*	9/29/86: Final allocation?
*/

#include <sys/types.h>
#include "keynames.h"

#define MAX_HIL_KEYCODES   0xFF
/*	#define MID_POINT	0x7f	*/

static u_char	Set1_lk201_map [ MAX_HIL_KEYCODES + 1] =
{
/* HP-Hil	 lk201 		  octal		  comment  */
/* keycode	keycode		value for		   */
/* hex		octal		Hil-hex			   */	


/*  0	*/	-1	,	/*  0 */  
/*  1	*/	-1	,	/*  1 */
/*----------------------------------------------------*/
/*  2	*/	-1	,	/*  2 */
/*  3	*/	-1	,	/*  3 */
/*----------------------------------------------------*/
/*  4	*/	0262	,	/*  4 */  /* extend char Right */
/*  5	*/	0262	,	/*  5 */  /*   for Kanji.	*/
/*----------------------------------------------------*/
/*  6	*/	0261	,	/*  6 */  /*extend char left */
/*  7	*/	0261	,	/*  7 */  /*  Meta/Compose	*/
/*----------------------------------------------------*/
/*  8	*/	0256	,	/*  10 */ /* shift-R	 */
/*  9	*/	0256	,	/*  11 */
/*----------------------------------------------------*/
/*  a	*/	0256	,	/*  12 */ /*  shift-L	*/
/*  b	*/	0256	,	/*  13 */
/*----------------------------------------------------*/
/*  c	*/	0257	,	/*  14 */  /*  Control 	*/
/*  d	*/	0257	,	/*  15 */
/*----------------------------------------------------*/
/*  e	*/			/*  16 */   /* Break/Reset	*/
/*  f	*/			/*  17 */   /* 		*/
	KEY_BREAK_RESET,
	KEY_BREAK_RESET,
/*----------------------------------------------------*/
/*  10	*/	0231	,	/*  20 */   /* Keypad 4	*/
/*  11	*/	0231	,	/*  21 */   /*  R4 	*/
/*----------------------------------------------------*/
/*  12	*/	0236	,	/*  22 */   /*  keypad 8	  */
/*  13	*/	0236	,	/*  23 */   /*  R8		  */
/*----------------------------------------------------*/
/*  14	*/	0232	,	/*  24 */   /*  Keypad 5	*/
/*  15	*/	0232	,	/*  25 */	/*  R5		*/
/*----------------------------------------------------*/
/*  16	*/	0237	,	/*  26 */	/* keypad 9	*/
/*  17	*/	0237	,	/*  27 */	/*	R9	*/
/*----------------------------------------------------*/
/*  18	*/	0233	,	/*  30 */	/* keypad 6	*/
/*  19	*/	0233	,	/*  31 */	/*	R6	*/
/*----------------------------------------------------*/
/*  1a	*/	0235	,	/*  32 */	/* keypad 7	*/
/*  1b	*/	0235	,	/*  33 */	/*	R7	*/
/*----------------------------------------------------*/
/*  1c	*/	0234	,	/*  34 */	/* keypad ,	*/
/*  1d	*/	0234	,	/*  35 */	/*	,	*/
/*----------------------------------------------------*/
/*  1e	*/	0225	,	/*  36 */	/*  keypad	*/
/*  1f	*/	0225	,	/*  37 */	/*  Enter	*/
/*----------------------------------------------------*/
/*  20	*/	0226	,	/*  40 */	/*  keypad 1	*/
/*  21	*/	0226	,	/*  41 */	/*	R1	*/
/*----------------------------------------------------*/
/*  22	*/			/*  42 */	/*  keypad /	*/
/*  23	*/			/*  43 */	/*  		*/
		KEY_KP_SLASH,
		KEY_KP_SLASH,
/*----------------------------------------------------*/
/*  24	*/	0227	,	/*  44 */	/*   keypad 2	*/
/*  25	*/	0227	,	/*  45 */	/*	R2	*/
/*----------------------------------------------------*/
/*  26	*/			/*  46 */	/*    keypad +	*/
/*  27	*/			/*  47 */	/*		*/
		KEY_KP_PLUS,
		KEY_KP_PLUS,
/*----------------------------------------------------*/
/*  28	*/	0230	,	/*  50 */	/*    keypad 3	*/
/*  29	*/	0230	,	/*  51 */	/*	R3	*/
/*----------------------------------------------------*/
/*  2a	*/	0205	,	/*  52 */	/*  keypad *	*/
/*  2b	*/	0205	,	/*  53 */	/*  		*
/*----------------------------------------------------*/
/*  2c	*/	0222	,	/*  54 */	/*	keypad 0  */
/*  2d	*/	0222	,	/*  55 */	/*	R0	*/
/*----------------------------------------------------*/
/*  2e	*/	0240	,	/*  56 */	/*	keypad  */
/*  2f	*/	0240	,	/*  57 */	/*	-	*/
/*----------------------------------------------------*/
/*  30	*/	0331	,	/*  60 */	/*	b/B	*/
/*  31	*/	0331	,	/*  61 */
/*----------------------------------------------------*/
/*  32	*/	0323	,	/*  62 */	/*	v/V	*/
/*  33	*/	0323	,	/*  63 */
/*----------------------------------------------------*/
/*  34	*/	0316	,	/*  64 */	/*	c/C	*/
/*  35	*/	0316	,	/*  65 */
/*----------------------------------------------------*/
/*  36	*/	0310	,	/*  66 */	/*	x/X	*/
/*  37	*/	0310	,	/*  67 */
/*----------------------------------------------------*/
/*  38	*/	0303	,	/*  70 */	/*	z/Z	*/
/*  39	*/	0303	,	/*  71 */
/*----------------------------------------------------*/
/*  3a	*/	0263	,	/*  72 */	/*  Kanji Left	*/
/*  3b	*/	0263	,	/*  73 */
/*----------------------------------------------------*/
/*  3c	*/	-1	,	/*  74 */
/*  3d	*/	-1	,	/*  75 */
/*----------------------------------------------------*/
/*  3e	*/	0211	,	/*  76 */	/* Del/Escape	*/
/*  3f	*/	0211	,	/*  77 */	/*  		*/
/*----------------------------------------------------*/
/*  40	*/	-1	,	/*  100 */	/* 	keypad 	*/
/*  41	*/	-1	,	/*  101 */	/*	6	*/
/*----------------------------------------------------*/
/*  42	*/	0242	,	/*  102 */	/*   UB-2	*/
/*  43	*/	0242	,	/*  103 */	/*   PF2	*/
/*----------------------------------------------------*/
/*  44	*/	-1	,	/*  104 */	/*	keypad	*/
/*  45	*/	-1	,	/*  105 */	/*	3	*/
/*----------------------------------------------------*/
/*  46	*/	0243	,	/*  106 */	/*    UB-3	*/
/*  47	*/	0243	,	/*  107 */	/*    PF3	*/
/*----------------------------------------------------*/
/*  48	*/	0224	,	/*  110 */	/* keypad .	*/
/*  49	*/	0224	,	/*  111 */	/*  R .		*/
/*----------------------------------------------------*/
/*  4a	*/	0241	,	/*  112 */      /* UB-1		*/
/*  4b	*/	0241	,	/*  113 */	/*  PF1		*/
/*----------------------------------------------------*/
/*  4c	*/			/*  114 */	/* Keypad tab	*/
/*  4d	*/			/*  115 */	/*   		*/
		KEY_KP_TAB,
		KEY_KP_TAB,
/*----------------------------------------------------*/
/*  4e	*/	0244	,	/*  116 */	/*    UB-4	*/
/*  4f	*/	0244	,	/*  117 */	/*    PF4	*/
/*----------------------------------------------------*/
/*  50	*/	0335	,	/*  120 */	/*	h/H	*/
/*  51	*/	0335	,	/*  121 */
/*----------------------------------------------------*/
/*  52	*/	0330	,	/*  122 */	/*	g/G	*/
/*  53	*/	0330	,	/*  123 */
/*----------------------------------------------------*/
/*  54	*/	0322	,	/*  124 */	/*	f/F	*/
/*  55	*/	0322	,	/*  125 */
/*----------------------------------------------------*/
/*  56	*/	0315	,	/*  126 */	/*	d/D	*/
/*  57	*/	0315	,	/*  127 */
/*----------------------------------------------------*/
/*  58	*/	0307	,	/*  130 */	/*	s/S	*/
/*  59	*/	0307	,	/*  131 */
/*----------------------------------------------------*/
/*  5a	*/	0302	,	/*  132 */	/*	a/A	*/
/*  5b	*/	0302	,	/*  133 */
/*----------------------------------------------------*/
/*  5c	*/	-1	,	/*  134 */
/*  5d	*/	-1	,	/*  135 */
/*----------------------------------------------------*/
/*  5e	*/	0260	,	/*  136 */	/* Caps/Lock	*/
/*  5f	*/	0260	,	/*  137 */
/*----------------------------------------------------*/
/*  60	*/	0341	,	/*  140 */	/*	u/U	*/
/*  61	*/	0341	,	/*  141 */
/*----------------------------------------------------*/
/*  62	*/	0334	,	/*  142 */	/*	y/Y	*/
/*  63	*/	0334	,	/*  143 */
/*----------------------------------------------------*/
/*  64	*/	0327	,	/*  144 */	/*	t/T	*/
/*  65	*/	0327	,	/*  145 */
/*----------------------------------------------------*/
/*  66	*/	0321	,	/*  146 */	/*	r/R	*/
/*  67	*/	0321	,	/*  147 */
/*----------------------------------------------------*/
/*  68	*/	0314	,	/*  150 */	/*	e/E	*/
/*  69	*/	0314	,	/*  151 */
/*----------------------------------------------------*/
/*  6a	*/	0306	,	/*  152 */	/*	w/W	*/
/*  6b	*/	0306	,	/*  153 */
/*----------------------------------------------------*/
/*  6c	*/	0301	,	/*  154 */	/*	q/Q	*/
/*  6d	*/	0301	,	/*  155 */
/*----------------------------------------------------*/
/*  6e	*/	0276	,	/*  156 */	/*	tab	*/
/*  6f	*/	0276	,	/*  157 */
/*----------------------------------------------------*/
/*  70	*/	0340	,	/*  160 */	/*	7/&	*/
/*  71	*/	0340	,	/*  161 */
/*----------------------------------------------------*/
/*  72	*/	0333	,	/*  162 */	/*	6/^	*/
/*  73	*/	0333	,	/*  163 */
/*----------------------------------------------------*/
/*  74	*/	0326	,	/*  164 */	/*	5/%	*/
/*  75	*/	0326	,	/*  165 */
/*----------------------------------------------------*/
/*  76	*/	0320	,	/*  166 */	/*	4/$	*/
/*  77	*/	0320	,	/*  167 */
/*----------------------------------------------------*/
/*  78	*/	0313	,	/*  170 */	/* 	3/#	*/
/*  79	*/	0313	,	/*  171 */
/*----------------------------------------------------*/
/*  7a	*/	0305	,	/*  172 */	/*	2/@	*/
/*  7b	*/	0305	,	/*  173 */
/*----------------------------------------------------*/
/*  7c	*/	KEY_TR_1,	/*  174 */	/*	1/!	*/
/*  7d	*/	KEY_TR_1,	/*  175 */
/*----------------------------------------------------*/
/*  7e	*/	KEY_TILDE,	/*  176 */	/*	`/~	*/
/*  7f	*/	KEY_TILDE,	/*  177 */
/*----------------------------------------------------*/
/*  80	*/	00	,	/*  200 */	/* Mouse-L	*/
/*  81	*/	00	,	/*  200 */	/*  		*/
/*----------------------------------------------------*/
/*  82	*/	01	,	/*  202 */	/* Mouse-M	*/
/*  83	*/	01	,	/*  203 */	/* 		*/
/*----------------------------------------------------*/
/*  84	*/	02	,	/*  204 */	/* Mouse-R	*/
/*  85	*/	02	,	/*  205 */
/*----------------------------------------------------*/
/*  86	*/	03	,	/*  206 */	/* 4 button puck */
/*  87	*/	03	,	/*  207 */
/*----------------------------------------------------*/
/*  88	*/	-1	,	/*  210 */
/*  89	*/	-1	,	/*  211 */
/*----------------------------------------------------*/
/*  8a	*/	-1	,	/*  212 */
/*  8b	*/	-1	,	/*  213 */
/*----------------------------------------------------*/
/*  8c	*/	-1	,	/*  214 */
/*  8d	*/	-1	,	/*  215 */
/*----------------------------------------------------*/
/*  8e	*/	-1	,	/*  216 */
/*  8f	*/	-1	,	/*  217 */
/*----------------------------------------------------*/
/*  90	*/	KEY_MENU,	/*  220 */	/* Menu		*/
/*  91	*/	KEY_MENU,	/*  221 */	/* 		*/
/*----------------------------------------------------*/
/*  92	*/	KEY_F4,		/*  222 */	/*	f4	*/
/*  93	*/	KEY_F4,		/*  223 */
/*----------------------------------------------------*/
/*  94	*/	KEY_F3,		/*  224 */	/*	f3	*/
/*  95	*/	KEY_F3,		/*  225 */
/*----------------------------------------------------*/
/*  96	*/	KEY_F2,		/*  226 */	/*	f2	*/
/*  97	*/	KEY_F2,		/*  227 */
/*----------------------------------------------------*/
/*  98	*/	KEY_F1,		/*  230 */	/*	f1	*/
/*  99	*/	KEY_F1,		/*  231 */
/*----------------------------------------------------*/
/*  9a	*/	-1	,	/*  232 */	/*	8+LIne?	*/
/*  9b	*/	-1	,	/*  233 */
/*----------------------------------------------------*/
/*  9c	*/	KEY_STOP,	/*  234 */	/*	STOP	*/
/*  9d	*/	KEY_STOP,	/*  235 */	/*   		*/
/*----------------------------------------------------*/
/*  9e	*/	KEY_ENTER_PRINT,/*  236 */	/*	Enter/Print */
/*  9f	*/	KEY_ENTER_PRINT,/*  237 */	/*	****	    */
/*----------------------------------------------------*/
/*  a0	*/	KEY_SYSTEM_USER,/*  240 */	/* 	User/System */
/*  a1	*/	KEY_SYSTEM_USER,/*  241 */	/* 		    */
/*----------------------------------------------------*/
/*  a2	*/	KEY_F5,		/*  242 */	/* 	f5	*/
/*  a3	*/	KEY_F5,		/*  243 */
/*----------------------------------------------------*/
/*  a4	*/	KEY_F6,		/*  244 */	/*	f6	*/
/*  a5	*/	KEY_F6,		/*  245 */
/*----------------------------------------------------*/
/*  a6	*/	KEY_F7,		/*  246 */	/*	f7	*/
/*  a7	*/	KEY_F7,		/*  247 */
/*----------------------------------------------------*/
/*  a8	*/	KEY_F8,		/*  250 */	/*	f8	*/
/*  a9	*/	KEY_F8,		/*  251 */
/*----------------------------------------------------*/
/*  aa	*/	-1	,	/*  252 */	/*	9/-	*/
/*  ab	*/	-1	,	/*  253 */	/*	Unbound	*/
/*----------------------------------------------------*/
/*  ac	*/	KEY_CLEAR_LINE,	/*  254 */	/*	clearline*/
/*  ad	*/	KEY_CLEAR_LINE,	/*  255 */	/*		*/
/*----------------------------------------------------*/
/*  ae	*/ 	KEY_CLEAR_DISPLAY,/*  256 */	/*	Cleardisp*/
/*  af	*/	KEY_CLEAR_DISPLAY,/*  257 */	/*		*/
/*----------------------------------------------------*/
/*  b0	*/	KEY_TR_8,	/*  260 */	/*	8/*	*/
/*  b1	*/	KEY_TR_8,	/*  261 */
/*----------------------------------------------------*/
/*  b2	*/	KEY_TR_9,	/*  262 */	/*	9/(	*/
/*  b3	*/	KEY_TR_9,	/*  263 */
/*----------------------------------------------------*/
/*  b4	*/	KEY_TR_0,	/*  264 */	/*	0 / )	*/
/*  b5	*/	KEY_TR_0,	/*  265 */
/*----------------------------------------------------*/
/*  b6	*/	0371	,	/*  266 */	/*	-/_	*/
/*  b7	*/	0371	,	/*  267 */
/*----------------------------------------------------*/
/*  b8	*/	0365	,	/*  270 */	/*	=/+	*/
/*  b9	*/	0365	,	/*  271 */
/*----------------------------------------------------*/
/*  ba	*/	KEY_BS,		/*  272 */	/* \b: backspace*/
/*  bb	*/	KEY_BS,		/*  273 */	/*  back	*/
/*----------------------------------------------------*/
/*  bc	*/	KEY_INSERT_LINE,/*  274 */	/* Insert line	*/
/*  bd	*/	KEY_INSERT_LINE,/*  275 */	/* 		*/
/*----------------------------------------------------*/
/*  be	*/	KEY_DELETE_LINE,/*  276 */	/* Delete line	*/
/*  bf	*/	KEY_DELETE_LINE,/*  277 */	/* 		*/
/*----------------------------------------------------*/
/*  c0	*/	0346	,	/*  300 */	/*	i/I	*/
/*  c1	*/	0346	,	/*  301 */
/*----------------------------------------------------*/
/*  c2	*/	0353	,	/*  302 */	/*	o/O	*/
/*  c3	*/	0353	,	/*  303 */
/*----------------------------------------------------*/
/*  c4	*/	0360	,	/*  304 */	/*	p/P	*/
/*  c5	*/	0360	,	/*  305 */
/*----------------------------------------------------*/
/*  c6	*/	0372	,	/*  306 */	/*	[/{	*/
/*  c7	*/	0372	,	/*  307 */
/*----------------------------------------------------*/
/*  c8	*/	0366	,	/*  310 */	/*	]/}	*/
/*  c9	*/	0366	,	/*  311 */
/*----------------------------------------------------*/
/*  ca	*/	0367	,	/*  312 */	/*	\/|	*/
/*  cb	*/	0367	,	/*  313 */
/*----------------------------------------------------*/
/*  cc	*/	0213	,	/*  314 */	/* insert char	*/
/*  cd	*/	0213	,	/*  315 */	/* Insert	*/
/*----------------------------------------------------*/
/*  ce	*/	0214	,	/*  316 */	/* delete char	*/
/*  cf	*/	0214	,	/*  317 */	/* Remove	*/
/*----------------------------------------------------*/
/*  d0	*/	0342	,	/*  320 */	/*	j/J	*/
/*  d1	*/	0342	,	/*  321 */
/*----------------------------------------------------*/
/*  d2	*/	0347	,	/*  322 */	/*	k/K	*/
/*  d3	*/	0347	,	/*  323 */
/*----------------------------------------------------*/
/*  d4	*/	0354	,	/*  324 */	/*	l/L	*/
/*  d5	*/	0354	,	/*  325 */
/*----------------------------------------------------*/
/*  d6	*/	0362	,	/*  326 */	/*	;/:	*/
/*  d7	*/	0362	,	/*  327 */
/*----------------------------------------------------*/
/*  d8	*/	0373	,	/*  330 */	/*	'/"	*/
/*  d9	*/	0373	,	/*  331 */
/*----------------------------------------------------*/
/*  da	*/	0275	,	/*  332 */	/*	\r	*/
/*  db	*/	0275	,	/*  333 */
/*----------------------------------------------------*/
/*  dc	*/	0253	,	/*  334 */	/*	Home	*/
/*  dd	*/	0253	,	/*  335 */	/*  		*/
/*----------------------------------------------------*/
/*  de	*/	0216	,	/*  336 */	/*	Prev	*/
/*  df	*/	0216	,	/*  337 */	/* Prev screen	*/
/*----------------------------------------------------*/
/*  e0	*/	0343	,	/*  340 */	/*	m/M	*/
/*  e1	*/	0343	,	/*  341 */
/*----------------------------------------------------*/
/*  e2	*/	0350	,	/*  342 */	/*	,/<	*/
/*  e3	*/	0350	,	/*  343 */
/*----------------------------------------------------*/
/*  e4	*/	0355	,	/*  344 */	/*	./>	*/
/*  e5	*/	0355	,	/*  345 */
/*----------------------------------------------------*/
/*  e6	*/	0363	,	/*  346 */	/*   /		*/
/*  e7	*/	0363	,	/*  347 */
/*----------------------------------------------------*/
/*  e8	*/	-1	,	/*  350 */
/*  e9	*/	-1	,	/*  351 */
/*----------------------------------------------------*/
/*  ea	*/	0215	,	/*  352 */	/*	select	*/
/*  eb	*/	0215	,	/*  353 */	/*	Select	*/
/*----------------------------------------------------*/
/*  ec	*/	-1	,	/*  354 */	
/*  ed	*/	-1	,	/*  355 */
/*----------------------------------------------------*/
/*  ee	*/	0217	,	/*  356 */	/*	Next	*/
/*  ef	*/	0217	,	/*  357 */	/* Next Screen	*/
/*----------------------------------------------------*/
/*  f0	*/	0336	,	/*  360 */	/*	n/N	*/
/*  f1	*/	0336	,	/*  361 */
/*----------------------------------------------------*/
/*  f2	*/	0324	,	/*  362 */	/*	' '	*/
/*  f3	*/	0324	,	/*  363 */
/*----------------------------------------------------*/
/*  f4	*/	-1	,	/*  364 */
/*  f5	*/	-1	,	/*  365 */
/*----------------------------------------------------*/
/*  f6	*/	0264	,	/*  366 */	/*  Unbound	*/
/*  f7	*/	0264	,	/*  367 */	/*  Kanji Right */
/*----------------------------------------------------*/
/*  f8	*/	0247	,	/*  370 */	/* left cursor	*/
/*  f9	*/	0247	,	/*  371 */
/*----------------------------------------------------*/
/*  fa	*/	0251	,	/*  372 */	/* down cursor	*/
/*  fb	*/	0251	,	/*  373 */
/*----------------------------------------------------*/
/*  fc	*/	0252	,	/*  374 */	/* up cursor	*/
/*  fd	*/	0252	,	/*  375 */	/* up cursor	*/
/*----------------------------------------------------*/
/*  fe	*/	0250	,	/*  376 */	/* right cursor	*/
/*  ff	*/	0250	,	/*  377 */
/*----------------------------------------------------*/

};

