.TH XSETROOT 1 "12 June 1987" "X Version 11"
.SH NAME
xsetroot \- X window system root window parameter setting utility
.SH SYNOPSIS
.B xsetroot
[ -help ]
[ -def ]
[-cursor
.I cursorfile mask\ file
]
[-bitmap
.I filename
]
[-mod
.I x y
]
[ -gray ]
[ -grey ]
[-fg
.I color
]
[-bg
.I color
]
[ -rv ]
[-solid
.I color
]
[-name
.I string
]
[
.I host : display
]
.SH DESCRIPTION
.I Xsetroot
allows you to tailor the appearance of the background ("root")
window on a workstation display running X.  Normally, you experiment with
.I xsetroot
until you find a personalized look that you like, then put the
.I xsetroot
command that produces it into your .login file.
If no options are specified, or if
.I -def
is specified, the window is reset to its default state.
.I -def
can be specified along with other options and only the non-specified
characteristics will be reset to the default state.
.PP
Only one of the background color/tileing changing options (
.IR -solid ,
.IR -gray ,
.IR -grey ,
.IR -bitmap
and
.IR -mod )
may be specified at a time.

.PP
The various options are as follows:
.IP -help
Print a usage message and exit.
.IP -def
Reset unspecified attributes to the default values.  (Restores the background
to the familiar gray mesh and the cursor to the hollow x shape.)
.IP "-cursor cursorfile maskfile"
This lets you change the mouse cursor to whatever
you want when the mouse cursor is outside of any window.
Cursor and mask files are bitmaps (little pictures) made with the
.I bitmap(1)
program.  You probably want the mask file to be all black until you
get used to the way masks work.
.IP "-bitmap filename"
Use the bitmap specified in the file to set the window pattern.  You can
make your own bitmap files (little pictures) using the
.I bitmap(1)
program.  The entire background will be made up of repeated "tiles" of
the bitmap.
.IP "-mod x y"
This is used if you want a plaid-like grid pattern on your screen.
x and y are integers ranging from 1 to 16.  Try the different combinations.
Zero and negative numbers are taken as 1.
.IP -gray
Make the entire background gray.  (Easier on the eyes.)
.IP -grey
Make the entire background grey.
.IP "-fg color"
Use ``color'' as the foreground color when setting attributes.
.IP "-bg color"
Use ``color'' as the background color when setting attributes.
.IP -rv
This exchanges the foreground and background colors.  Normally the foreground
color is black and the background color is white.
This option can go with any of the above.
.IP "-solid color"
Set the window color to ``color''.
.IP "-name string"
Set the name of the root window to ``string''.  There is no default value.
Usually a name is assigned to a window so that the
window manager can use a text representation when the window is iconified.
This option is unused since you can't iconify the background.
.IP "host:display"
Defaults to the DISPLAY environment variable, which is usually set
to be one's own workstation host, display 0.  
.SH "SEE ALSO"
xset(1), X(1)
.SH AUTHOR
Mark Lillibridge, MIT Project Athena
.br
Copyright (c) 1987 by Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full copyright notice.
