/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import vlcskineditor.ProgressWindow;
import vlcskineditor.SliderBGGen;

public class SliderBGBuilder {
    SliderBGGen sbgg;
    BufferedImage bg;
    BufferedImage e1;
    BufferedImage middle;
    BufferedImage e2;
    BufferedImage overlay;
    int width;
    int height;
    int margin_top;
    int margin_bottom;
    int margin_left;
    int margin_right;
    int overlay_x;
    int overlay_y;
    public int nbframes;
    int total_height;
    boolean usebg;
    boolean usee1;
    boolean usee2;
    boolean useoverlay;
    boolean tile_bg;
    boolean tile_middle;
    boolean horizontal;
    int bg_width;
    int e1_width;
    int middle_width;
    int e2_width;
    int e1_height;
    int e2_height;
    int middle_height;
    int bg_height;
    BufferedImage output;
    JFrame frame;
    ProgressWindow pg_win;
    public boolean cancontinue = true;

    public SliderBGBuilder(SliderBGGen sliderBGGen) {
        this.sbgg = sliderBGGen;
        this.usebg = true;
        try {
            this.bg = ImageIO.read(new File(this.sbgg.bg_tf.getText()));
            this.bg_width = this.bg.getWidth(null);
            this.bg_height = this.bg.getHeight(null);
        }
        catch (Exception exception) {
            this.usebg = false;
        }
        this.usee1 = true;
        try {
            this.e1 = ImageIO.read(new File(this.sbgg.e1_tf.getText()));
            this.e1_width = this.e1.getWidth(null);
            this.e1_height = this.e1.getHeight(null);
        }
        catch (Exception exception) {
            this.usee1 = false;
        }
        try {
            this.middle = ImageIO.read(new File(this.sbgg.md_tf.getText()));
            this.middle_width = this.middle.getWidth(null);
            this.middle_height = this.middle.getHeight(null);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.sbgg, "Could not load middle image!\nAt least the middle part of the slider is needed to generate a slider background.", exception.getLocalizedMessage(), 0);
            this.cancontinue = false;
        }
        this.usee2 = true;
        try {
            this.e2 = ImageIO.read(new File(this.sbgg.e2_tf.getText()));
            this.e2_width = this.e2.getWidth(null);
            this.e2_height = this.e2.getHeight(null);
        }
        catch (Exception exception) {
            this.usee2 = false;
        }
        this.useoverlay = true;
        try {
            this.overlay = ImageIO.read(new File(this.sbgg.ol_tf.getText()));
        }
        catch (Exception exception) {
            this.useoverlay = false;
        }
        this.usee1 = false;
        if (false) {
            this.e1 = this.middle;
        }
        this.usee2 = false;
        if (false) {
            this.e2 = this.middle;
        }
        this.width = Integer.parseInt(this.sbgg.width_tf.getText());
        this.height = Integer.parseInt(this.sbgg.height_tf.getText());
        this.margin_top = Integer.parseInt(this.sbgg.margin_t_tf.getText());
        this.margin_bottom = Integer.parseInt(this.sbgg.margin_b_tf.getText());
        this.margin_left = Integer.parseInt(this.sbgg.margin_l_tf.getText());
        this.margin_right = Integer.parseInt(this.sbgg.margin_r_tf.getText());
        this.tile_bg = this.sbgg.bgt_rb.isSelected();
        this.tile_middle = this.sbgg.mdt_rb.isSelected();
        this.horizontal = this.sbgg.ltr_rb.isSelected();
    }

    public void build() {
        if (this.horizontal && this.cancontinue) {
            this.nbframes = this.width - this.margin_left - this.margin_right + 1;
            this.total_height = this.nbframes * this.height;
            this.output = new BufferedImage(this.width, this.total_height, 2);
            Graphics2D graphics2D = this.output.createGraphics();
            this.pg_win = new ProgressWindow(this.sbgg, "Generating the background...");
            for (int i = 0; i <= this.nbframes; ++i) {
                int n;
                int n2;
                int n3;
                System.out.println("Processing frame " + i + " of " + this.nbframes + "...");
                this.pg_win.setProgress(this.nbframes / 100 * i);
                if (this.usebg) {
                    if (this.tile_bg) {
                        n3 = this.width / this.bg_width;
                        n2 = this.width % this.bg_width;
                        for (n = 0; n < n3; ++n) {
                            graphics2D.drawImage((Image)this.bg, n * this.bg_width, this.height * i, this.sbgg);
                        }
                        graphics2D.drawImage(this.bg, n3 * this.bg_width, this.height * i, n2, this.height, this.sbgg);
                    } else {
                        graphics2D.drawImage(this.bg, 0, this.height * i, this.width, this.height, this.sbgg);
                    }
                }
                if (i > 0) {
                    if (i < this.e1_width) {
                        BufferedImage bufferedImage = this.e1.getSubimage(0, 0, i, this.e1_height);
                        graphics2D.drawImage(bufferedImage, this.margin_left, this.height * i + this.margin_top, i, this.height - this.margin_top - this.margin_bottom, this.sbgg);
                    } else if (i < this.e1_width + this.middle_width) {
                        graphics2D.drawImage((Image)this.e1, this.margin_left, this.height * i + this.margin_top, this.sbgg);
                        graphics2D.drawImage(this.middle, this.margin_left + this.e1_width, this.height * i + this.margin_top, i - this.e1_width, this.height - this.margin_top - this.margin_bottom, this.sbgg);
                    } else if (i < this.e1_width + this.middle_width + this.e2_width) {
                        graphics2D.drawImage((Image)this.e1, this.margin_left, this.height * i + this.margin_top, this.sbgg);
                        graphics2D.drawImage((Image)this.middle, this.margin_left + this.e1_width, this.height * i + this.margin_top, this.sbgg);
                        graphics2D.drawImage(this.e2, this.margin_left + this.e1_width + this.middle_width, this.height * i + this.margin_top, i - this.e1_width - this.middle_width, this.height - this.margin_top - this.margin_bottom, this.sbgg);
                    } else {
                        graphics2D.drawImage((Image)this.e1, this.margin_left, this.height * i + this.margin_top, this.sbgg);
                        if (this.tile_middle) {
                            n3 = i - this.e1_width - this.e2_width;
                            n2 = n3 / this.middle_width;
                            n = n3 % this.middle_width;
                            for (int j = 0; j < n2; ++j) {
                                graphics2D.drawImage((Image)this.middle, this.margin_left + this.e1_width + j * this.middle_width, this.height * i + this.margin_top, this.sbgg);
                            }
                            graphics2D.drawImage(this.middle, this.margin_left + this.e1_width + n2 * this.middle_width, this.height * i + this.margin_top, n, this.height - this.margin_top - this.margin_bottom, this.sbgg);
                        } else {
                            n3 = i - this.e1_width - this.e2_width;
                            graphics2D.drawImage(this.middle, this.margin_left + this.e1_width, this.height * i + this.margin_top, n3, this.height - this.margin_top - this.margin_bottom, this.sbgg);
                        }
                        graphics2D.drawImage((Image)this.e2, this.margin_left + i - this.e2_width, this.height * i + this.margin_top, this.sbgg);
                    }
                }
                if (!this.useoverlay) continue;
                graphics2D.drawImage((Image)this.overlay, this.overlay_x, this.overlay_y + this.height * i, this.sbgg);
            }
        } else if (!this.horizontal && this.cancontinue) {
            JOptionPane.showMessageDialog(this.sbgg, "Sorry, generating of vertical sliders has not yet been implemented.");
        }
    }

    public void save(File file) {
        try {
            ImageIO.write((RenderedImage)this.output, "png", file);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.sbgg, "Could not save image!\n" + exception.toString());
            return;
        }
    }
}

