require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&LINUX_PCI_H)) {
    eval 'sub LINUX_PCI_H () {1;}' unless defined(&LINUX_PCI_H);
    eval 'sub PCI_VENDOR_ID () {0x;}' unless defined(&PCI_VENDOR_ID);
    eval 'sub PCI_DEVICE_ID () {0x2;}' unless defined(&PCI_DEVICE_ID);
    eval 'sub PCI_COMMAND () {0x4;}' unless defined(&PCI_COMMAND);
    eval 'sub PCI_COMMAND_IO () {0x1;}' unless defined(&PCI_COMMAND_IO);
    eval 'sub PCI_COMMAND_MEMORY () {0x2;}' unless defined(&PCI_COMMAND_MEMORY);
    eval 'sub PCI_COMMAND_MASTER () {0x4;}' unless defined(&PCI_COMMAND_MASTER);
    eval 'sub PCI_COMMAND_SPECIAL () {0x8;}' unless defined(&PCI_COMMAND_SPECIAL);
    eval 'sub PCI_COMMAND_INVALIDATE () {0x10;}' unless defined(&PCI_COMMAND_INVALIDATE);
    eval 'sub PCI_COMMAND_VGA_PALETTE () {0x20;}' unless defined(&PCI_COMMAND_VGA_PALETTE);
    eval 'sub PCI_COMMAND_PARITY () {0x40;}' unless defined(&PCI_COMMAND_PARITY);
    eval 'sub PCI_COMMAND_WAIT () {0x80;}' unless defined(&PCI_COMMAND_WAIT);
    eval 'sub PCI_COMMAND_SERR () {0x100;}' unless defined(&PCI_COMMAND_SERR);
    eval 'sub PCI_COMMAND_FAST_BACK () {0x200;}' unless defined(&PCI_COMMAND_FAST_BACK);
    eval 'sub PCI_STATUS () {0x6;}' unless defined(&PCI_STATUS);
    eval 'sub PCI_STATUS_CAP_LIST () {0x10;}' unless defined(&PCI_STATUS_CAP_LIST);
    eval 'sub PCI_STATUS_66MHZ () {0x20;}' unless defined(&PCI_STATUS_66MHZ);
    eval 'sub PCI_STATUS_UDF () {0x40;}' unless defined(&PCI_STATUS_UDF);
    eval 'sub PCI_STATUS_FAST_BACK () {0x80;}' unless defined(&PCI_STATUS_FAST_BACK);
    eval 'sub PCI_STATUS_PARITY () {0x100;}' unless defined(&PCI_STATUS_PARITY);
    eval 'sub PCI_STATUS_DEVSEL_MASK () {0x600;}' unless defined(&PCI_STATUS_DEVSEL_MASK);
    eval 'sub PCI_STATUS_DEVSEL_FAST () {0x;}' unless defined(&PCI_STATUS_DEVSEL_FAST);
    eval 'sub PCI_STATUS_DEVSEL_MEDIUM () {0x200;}' unless defined(&PCI_STATUS_DEVSEL_MEDIUM);
    eval 'sub PCI_STATUS_DEVSEL_SLOW () {0x400;}' unless defined(&PCI_STATUS_DEVSEL_SLOW);
    eval 'sub PCI_STATUS_SIG_TARGET_ABORT () {0x800;}' unless defined(&PCI_STATUS_SIG_TARGET_ABORT);
    eval 'sub PCI_STATUS_REC_TARGET_ABORT () {0x1000;}' unless defined(&PCI_STATUS_REC_TARGET_ABORT);
    eval 'sub PCI_STATUS_REC_MASTER_ABORT () {0x2000;}' unless defined(&PCI_STATUS_REC_MASTER_ABORT);
    eval 'sub PCI_STATUS_SIG_SYSTEM_ERROR () {0x4000;}' unless defined(&PCI_STATUS_SIG_SYSTEM_ERROR);
    eval 'sub PCI_STATUS_DETECTED_PARITY () {0x8000;}' unless defined(&PCI_STATUS_DETECTED_PARITY);
    eval 'sub PCI_CLASS_REVISION () {0x8;}' unless defined(&PCI_CLASS_REVISION);
    eval 'sub PCI_REVISION_ID () {0x8;}' unless defined(&PCI_REVISION_ID);
    eval 'sub PCI_CLASS_PROG () {0x9;}' unless defined(&PCI_CLASS_PROG);
    eval 'sub PCI_CLASS_DEVICE () {0xa;}' unless defined(&PCI_CLASS_DEVICE);
    eval 'sub PCI_CACHE_LINE_SIZE () {0xc;}' unless defined(&PCI_CACHE_LINE_SIZE);
    eval 'sub PCI_LATENCY_TIMER () {0xd;}' unless defined(&PCI_LATENCY_TIMER);
    eval 'sub PCI_HEADER_TYPE () {0xe;}' unless defined(&PCI_HEADER_TYPE);
    eval 'sub PCI_HEADER_TYPE_NORMAL () {0;}' unless defined(&PCI_HEADER_TYPE_NORMAL);
    eval 'sub PCI_HEADER_TYPE_BRIDGE () {1;}' unless defined(&PCI_HEADER_TYPE_BRIDGE);
    eval 'sub PCI_HEADER_TYPE_CARDBUS () {2;}' unless defined(&PCI_HEADER_TYPE_CARDBUS);
    eval 'sub PCI_BIST () {0xf;}' unless defined(&PCI_BIST);
    eval 'sub PCI_BIST_CODE_MASK () {0xf;}' unless defined(&PCI_BIST_CODE_MASK);
    eval 'sub PCI_BIST_START () {0x40;}' unless defined(&PCI_BIST_START);
    eval 'sub PCI_BIST_CAPABLE () {0x80;}' unless defined(&PCI_BIST_CAPABLE);
    eval 'sub PCI_BASE_ADDRESS_0 () {0x10;}' unless defined(&PCI_BASE_ADDRESS_0);
    eval 'sub PCI_BASE_ADDRESS_1 () {0x14;}' unless defined(&PCI_BASE_ADDRESS_1);
    eval 'sub PCI_BASE_ADDRESS_2 () {0x18;}' unless defined(&PCI_BASE_ADDRESS_2);
    eval 'sub PCI_BASE_ADDRESS_3 () {0x1c;}' unless defined(&PCI_BASE_ADDRESS_3);
    eval 'sub PCI_BASE_ADDRESS_4 () {0x20;}' unless defined(&PCI_BASE_ADDRESS_4);
    eval 'sub PCI_BASE_ADDRESS_5 () {0x24;}' unless defined(&PCI_BASE_ADDRESS_5);
    eval 'sub PCI_BASE_ADDRESS_SPACE () {0x1;}' unless defined(&PCI_BASE_ADDRESS_SPACE);
    eval 'sub PCI_BASE_ADDRESS_SPACE_IO () {0x1;}' unless defined(&PCI_BASE_ADDRESS_SPACE_IO);
    eval 'sub PCI_BASE_ADDRESS_SPACE_MEMORY () {0x;}' unless defined(&PCI_BASE_ADDRESS_SPACE_MEMORY);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_MASK () {0x6;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_MASK);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_32 () {0x;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_32);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_1M () {0x2;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_1M);
    eval 'sub PCI_BASE_ADDRESS_MEM_TYPE_64 () {0x4;}' unless defined(&PCI_BASE_ADDRESS_MEM_TYPE_64);
    eval 'sub PCI_BASE_ADDRESS_MEM_PREFETCH () {0x8;}' unless defined(&PCI_BASE_ADDRESS_MEM_PREFETCH);
    eval 'sub PCI_BASE_ADDRESS_MEM_MASK () {(~0xf);}' unless defined(&PCI_BASE_ADDRESS_MEM_MASK);
    eval 'sub PCI_BASE_ADDRESS_IO_MASK () {(~0x3);}' unless defined(&PCI_BASE_ADDRESS_IO_MASK);
    eval 'sub PCI_CARDBUS_CIS () {0x28;}' unless defined(&PCI_CARDBUS_CIS);
    eval 'sub PCI_SUBSYSTEM_VENDOR_ID () {0x2c;}' unless defined(&PCI_SUBSYSTEM_VENDOR_ID);
    eval 'sub PCI_SUBSYSTEM_ID () {0x2e;}' unless defined(&PCI_SUBSYSTEM_ID);
    eval 'sub PCI_ROM_ADDRESS () {0x30;}' unless defined(&PCI_ROM_ADDRESS);
    eval 'sub PCI_ROM_ADDRESS_ENABLE () {0x1;}' unless defined(&PCI_ROM_ADDRESS_ENABLE);
    eval 'sub PCI_ROM_ADDRESS_MASK () {(~0x7ff);}' unless defined(&PCI_ROM_ADDRESS_MASK);
    eval 'sub PCI_CAPABILITY_LIST () {0x34;}' unless defined(&PCI_CAPABILITY_LIST);
    eval 'sub PCI_INTERRUPT_LINE () {0x3c;}' unless defined(&PCI_INTERRUPT_LINE);
    eval 'sub PCI_INTERRUPT_PIN () {0x3d;}' unless defined(&PCI_INTERRUPT_PIN);
    eval 'sub PCI_MIN_GNT () {0x3e;}' unless defined(&PCI_MIN_GNT);
    eval 'sub PCI_MAX_LAT () {0x3f;}' unless defined(&PCI_MAX_LAT);
    eval 'sub PCI_PRIMARY_BUS () {0x18;}' unless defined(&PCI_PRIMARY_BUS);
    eval 'sub PCI_SECONDARY_BUS () {0x19;}' unless defined(&PCI_SECONDARY_BUS);
    eval 'sub PCI_SUBORDINATE_BUS () {0x1a;}' unless defined(&PCI_SUBORDINATE_BUS);
    eval 'sub PCI_SEC_LATENCY_TIMER () {0x1b;}' unless defined(&PCI_SEC_LATENCY_TIMER);
    eval 'sub PCI_IO_BASE () {0x1c;}' unless defined(&PCI_IO_BASE);
    eval 'sub PCI_IO_LIMIT () {0x1d;}' unless defined(&PCI_IO_LIMIT);
    eval 'sub PCI_IO_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_IO_RANGE_TYPE_MASK);
    eval 'sub PCI_IO_RANGE_TYPE_16 () {0x;}' unless defined(&PCI_IO_RANGE_TYPE_16);
    eval 'sub PCI_IO_RANGE_TYPE_32 () {0x1;}' unless defined(&PCI_IO_RANGE_TYPE_32);
    eval 'sub PCI_IO_RANGE_MASK () {~0xf;}' unless defined(&PCI_IO_RANGE_MASK);
    eval 'sub PCI_SEC_STATUS () {0x1e;}' unless defined(&PCI_SEC_STATUS);
    eval 'sub PCI_MEMORY_BASE () {0x20;}' unless defined(&PCI_MEMORY_BASE);
    eval 'sub PCI_MEMORY_LIMIT () {0x22;}' unless defined(&PCI_MEMORY_LIMIT);
    eval 'sub PCI_MEMORY_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_MEMORY_RANGE_TYPE_MASK);
    eval 'sub PCI_MEMORY_RANGE_MASK () {~0xf;}' unless defined(&PCI_MEMORY_RANGE_MASK);
    eval 'sub PCI_PREF_MEMORY_BASE () {0x24;}' unless defined(&PCI_PREF_MEMORY_BASE);
    eval 'sub PCI_PREF_MEMORY_LIMIT () {0x26;}' unless defined(&PCI_PREF_MEMORY_LIMIT);
    eval 'sub PCI_PREF_RANGE_TYPE_MASK () {0xf;}' unless defined(&PCI_PREF_RANGE_TYPE_MASK);
    eval 'sub PCI_PREF_RANGE_TYPE_32 () {0x;}' unless defined(&PCI_PREF_RANGE_TYPE_32);
    eval 'sub PCI_PREF_RANGE_TYPE_64 () {0x1;}' unless defined(&PCI_PREF_RANGE_TYPE_64);
    eval 'sub PCI_PREF_RANGE_MASK () {~0xf;}' unless defined(&PCI_PREF_RANGE_MASK);
    eval 'sub PCI_PREF_BASE_UPPER32 () {0x28;}' unless defined(&PCI_PREF_BASE_UPPER32);
    eval 'sub PCI_PREF_LIMIT_UPPER32 () {0x2c;}' unless defined(&PCI_PREF_LIMIT_UPPER32);
    eval 'sub PCI_IO_BASE_UPPER16 () {0x30;}' unless defined(&PCI_IO_BASE_UPPER16);
    eval 'sub PCI_IO_LIMIT_UPPER16 () {0x32;}' unless defined(&PCI_IO_LIMIT_UPPER16);
    eval 'sub PCI_ROM_ADDRESS1 () {0x38;}' unless defined(&PCI_ROM_ADDRESS1);
    eval 'sub PCI_BRIDGE_CONTROL () {0x3e;}' unless defined(&PCI_BRIDGE_CONTROL);
    eval 'sub PCI_BRIDGE_CTL_PARITY () {0x1;}' unless defined(&PCI_BRIDGE_CTL_PARITY);
    eval 'sub PCI_BRIDGE_CTL_SERR () {0x2;}' unless defined(&PCI_BRIDGE_CTL_SERR);
    eval 'sub PCI_BRIDGE_CTL_NO_ISA () {0x4;}' unless defined(&PCI_BRIDGE_CTL_NO_ISA);
    eval 'sub PCI_BRIDGE_CTL_VGA () {0x8;}' unless defined(&PCI_BRIDGE_CTL_VGA);
    eval 'sub PCI_BRIDGE_CTL_MASTER_ABORT () {0x20;}' unless defined(&PCI_BRIDGE_CTL_MASTER_ABORT);
    eval 'sub PCI_BRIDGE_CTL_BUS_RESET () {0x40;}' unless defined(&PCI_BRIDGE_CTL_BUS_RESET);
    eval 'sub PCI_BRIDGE_CTL_FAST_BACK () {0x80;}' unless defined(&PCI_BRIDGE_CTL_FAST_BACK);
    eval 'sub PCI_CB_CAPABILITY_LIST () {0x14;}' unless defined(&PCI_CB_CAPABILITY_LIST);
    eval 'sub PCI_CB_SEC_STATUS () {0x16;}' unless defined(&PCI_CB_SEC_STATUS);
    eval 'sub PCI_CB_PRIMARY_BUS () {0x18;}' unless defined(&PCI_CB_PRIMARY_BUS);
    eval 'sub PCI_CB_CARD_BUS () {0x19;}' unless defined(&PCI_CB_CARD_BUS);
    eval 'sub PCI_CB_SUBORDINATE_BUS () {0x1a;}' unless defined(&PCI_CB_SUBORDINATE_BUS);
    eval 'sub PCI_CB_LATENCY_TIMER () {0x1b;}' unless defined(&PCI_CB_LATENCY_TIMER);
    eval 'sub PCI_CB_MEMORY_BASE_0 () {0x1c;}' unless defined(&PCI_CB_MEMORY_BASE_0);
    eval 'sub PCI_CB_MEMORY_LIMIT_0 () {0x20;}' unless defined(&PCI_CB_MEMORY_LIMIT_0);
    eval 'sub PCI_CB_MEMORY_BASE_1 () {0x24;}' unless defined(&PCI_CB_MEMORY_BASE_1);
    eval 'sub PCI_CB_MEMORY_LIMIT_1 () {0x28;}' unless defined(&PCI_CB_MEMORY_LIMIT_1);
    eval 'sub PCI_CB_IO_BASE_0 () {0x2c;}' unless defined(&PCI_CB_IO_BASE_0);
    eval 'sub PCI_CB_IO_BASE_0_HI () {0x2e;}' unless defined(&PCI_CB_IO_BASE_0_HI);
    eval 'sub PCI_CB_IO_LIMIT_0 () {0x30;}' unless defined(&PCI_CB_IO_LIMIT_0);
    eval 'sub PCI_CB_IO_LIMIT_0_HI () {0x32;}' unless defined(&PCI_CB_IO_LIMIT_0_HI);
    eval 'sub PCI_CB_IO_BASE_1 () {0x34;}' unless defined(&PCI_CB_IO_BASE_1);
    eval 'sub PCI_CB_IO_BASE_1_HI () {0x36;}' unless defined(&PCI_CB_IO_BASE_1_HI);
    eval 'sub PCI_CB_IO_LIMIT_1 () {0x38;}' unless defined(&PCI_CB_IO_LIMIT_1);
    eval 'sub PCI_CB_IO_LIMIT_1_HI () {0x3a;}' unless defined(&PCI_CB_IO_LIMIT_1_HI);
    eval 'sub PCI_CB_IO_RANGE_MASK () {~0x3;}' unless defined(&PCI_CB_IO_RANGE_MASK);
    eval 'sub PCI_CB_BRIDGE_CONTROL () {0x3e;}' unless defined(&PCI_CB_BRIDGE_CONTROL);
    eval 'sub PCI_CB_BRIDGE_CTL_PARITY () {0x1;}' unless defined(&PCI_CB_BRIDGE_CTL_PARITY);
    eval 'sub PCI_CB_BRIDGE_CTL_SERR () {0x2;}' unless defined(&PCI_CB_BRIDGE_CTL_SERR);
    eval 'sub PCI_CB_BRIDGE_CTL_ISA () {0x4;}' unless defined(&PCI_CB_BRIDGE_CTL_ISA);
    eval 'sub PCI_CB_BRIDGE_CTL_VGA () {0x8;}' unless defined(&PCI_CB_BRIDGE_CTL_VGA);
    eval 'sub PCI_CB_BRIDGE_CTL_MASTER_ABORT () {0x20;}' unless defined(&PCI_CB_BRIDGE_CTL_MASTER_ABORT);
    eval 'sub PCI_CB_BRIDGE_CTL_CB_RESET () {0x40;}' unless defined(&PCI_CB_BRIDGE_CTL_CB_RESET);
    eval 'sub PCI_CB_BRIDGE_CTL_16BIT_INT () {0x80;}' unless defined(&PCI_CB_BRIDGE_CTL_16BIT_INT);
    eval 'sub PCI_CB_BRIDGE_CTL_PREFETCH_MEM0 () {0x100;}' unless defined(&PCI_CB_BRIDGE_CTL_PREFETCH_MEM0);
    eval 'sub PCI_CB_BRIDGE_CTL_PREFETCH_MEM1 () {0x200;}' unless defined(&PCI_CB_BRIDGE_CTL_PREFETCH_MEM1);
    eval 'sub PCI_CB_BRIDGE_CTL_POST_WRITES () {0x400;}' unless defined(&PCI_CB_BRIDGE_CTL_POST_WRITES);
    eval 'sub PCI_CB_SUBSYSTEM_VENDOR_ID () {0x40;}' unless defined(&PCI_CB_SUBSYSTEM_VENDOR_ID);
    eval 'sub PCI_CB_SUBSYSTEM_ID () {0x42;}' unless defined(&PCI_CB_SUBSYSTEM_ID);
    eval 'sub PCI_CB_LEGACY_MODE_BASE () {0x44;}' unless defined(&PCI_CB_LEGACY_MODE_BASE);
    eval 'sub PCI_CAP_LIST_ID () {0;}' unless defined(&PCI_CAP_LIST_ID);
    eval 'sub PCI_CAP_ID_PM () {0x1;}' unless defined(&PCI_CAP_ID_PM);
    eval 'sub PCI_CAP_ID_AGP () {0x2;}' unless defined(&PCI_CAP_ID_AGP);
    eval 'sub PCI_CAP_ID_VPD () {0x3;}' unless defined(&PCI_CAP_ID_VPD);
    eval 'sub PCI_CAP_ID_SLOTID () {0x4;}' unless defined(&PCI_CAP_ID_SLOTID);
    eval 'sub PCI_CAP_ID_MSI () {0x5;}' unless defined(&PCI_CAP_ID_MSI);
    eval 'sub PCI_CAP_ID_CHSWP () {0x6;}' unless defined(&PCI_CAP_ID_CHSWP);
    eval 'sub PCI_CAP_LIST_NEXT () {1;}' unless defined(&PCI_CAP_LIST_NEXT);
    eval 'sub PCI_CAP_FLAGS () {2;}' unless defined(&PCI_CAP_FLAGS);
    eval 'sub PCI_CAP_SIZEOF () {4;}' unless defined(&PCI_CAP_SIZEOF);
    eval 'sub PCI_PM_PMC () {2;}' unless defined(&PCI_PM_PMC);
    eval 'sub PCI_PM_CAP_VER_MASK () {0x7;}' unless defined(&PCI_PM_CAP_VER_MASK);
    eval 'sub PCI_PM_CAP_PME_CLOCK () {0x8;}' unless defined(&PCI_PM_CAP_PME_CLOCK);
    eval 'sub PCI_PM_CAP_RESERVED () {0x10;}' unless defined(&PCI_PM_CAP_RESERVED);
    eval 'sub PCI_PM_CAP_DSI () {0x20;}' unless defined(&PCI_PM_CAP_DSI);
    eval 'sub PCI_PM_CAP_AUX_POWER () {0x1c0;}' unless defined(&PCI_PM_CAP_AUX_POWER);
    eval 'sub PCI_PM_CAP_D1 () {0x200;}' unless defined(&PCI_PM_CAP_D1);
    eval 'sub PCI_PM_CAP_D2 () {0x400;}' unless defined(&PCI_PM_CAP_D2);
    eval 'sub PCI_PM_CAP_PME () {0x800;}' unless defined(&PCI_PM_CAP_PME);
    eval 'sub PCI_PM_CAP_PME_MASK () {0xf800;}' unless defined(&PCI_PM_CAP_PME_MASK);
    eval 'sub PCI_PM_CAP_PME_D0 () {0x800;}' unless defined(&PCI_PM_CAP_PME_D0);
    eval 'sub PCI_PM_CAP_PME_D1 () {0x1000;}' unless defined(&PCI_PM_CAP_PME_D1);
    eval 'sub PCI_PM_CAP_PME_D2 () {0x2000;}' unless defined(&PCI_PM_CAP_PME_D2);
    eval 'sub PCI_PM_CAP_PME_D3 () {0x4000;}' unless defined(&PCI_PM_CAP_PME_D3);
    eval 'sub PCI_PM_CAP_PME_D3cold () {0x8000;}' unless defined(&PCI_PM_CAP_PME_D3cold);
    eval 'sub PCI_PM_CTRL () {4;}' unless defined(&PCI_PM_CTRL);
    eval 'sub PCI_PM_CTRL_STATE_MASK () {0x3;}' unless defined(&PCI_PM_CTRL_STATE_MASK);
    eval 'sub PCI_PM_CTRL_PME_ENABLE () {0x100;}' unless defined(&PCI_PM_CTRL_PME_ENABLE);
    eval 'sub PCI_PM_CTRL_DATA_SEL_MASK () {0x1e00;}' unless defined(&PCI_PM_CTRL_DATA_SEL_MASK);
    eval 'sub PCI_PM_CTRL_DATA_SCALE_MASK () {0x6000;}' unless defined(&PCI_PM_CTRL_DATA_SCALE_MASK);
    eval 'sub PCI_PM_CTRL_PME_STATUS () {0x8000;}' unless defined(&PCI_PM_CTRL_PME_STATUS);
    eval 'sub PCI_PM_PPB_EXTENSIONS () {6;}' unless defined(&PCI_PM_PPB_EXTENSIONS);
    eval 'sub PCI_PM_PPB_B2_B3 () {0x40;}' unless defined(&PCI_PM_PPB_B2_B3);
    eval 'sub PCI_PM_BPCC_ENABLE () {0x80;}' unless defined(&PCI_PM_BPCC_ENABLE);
    eval 'sub PCI_PM_DATA_REGISTER () {7;}' unless defined(&PCI_PM_DATA_REGISTER);
    eval 'sub PCI_PM_SIZEOF () {8;}' unless defined(&PCI_PM_SIZEOF);
    eval 'sub PCI_AGP_VERSION () {2;}' unless defined(&PCI_AGP_VERSION);
    eval 'sub PCI_AGP_RFU () {3;}' unless defined(&PCI_AGP_RFU);
    eval 'sub PCI_AGP_STATUS () {4;}' unless defined(&PCI_AGP_STATUS);
    eval 'sub PCI_AGP_STATUS_RQ_MASK () {0xff000000;}' unless defined(&PCI_AGP_STATUS_RQ_MASK);
    eval 'sub PCI_AGP_STATUS_SBA () {0x200;}' unless defined(&PCI_AGP_STATUS_SBA);
    eval 'sub PCI_AGP_STATUS_64BIT () {0x20;}' unless defined(&PCI_AGP_STATUS_64BIT);
    eval 'sub PCI_AGP_STATUS_FW () {0x10;}' unless defined(&PCI_AGP_STATUS_FW);
    eval 'sub PCI_AGP_STATUS_RATE4 () {0x4;}' unless defined(&PCI_AGP_STATUS_RATE4);
    eval 'sub PCI_AGP_STATUS_RATE2 () {0x2;}' unless defined(&PCI_AGP_STATUS_RATE2);
    eval 'sub PCI_AGP_STATUS_RATE1 () {0x1;}' unless defined(&PCI_AGP_STATUS_RATE1);
    eval 'sub PCI_AGP_COMMAND () {8;}' unless defined(&PCI_AGP_COMMAND);
    eval 'sub PCI_AGP_COMMAND_RQ_MASK () {0xff000000;}' unless defined(&PCI_AGP_COMMAND_RQ_MASK);
    eval 'sub PCI_AGP_COMMAND_SBA () {0x200;}' unless defined(&PCI_AGP_COMMAND_SBA);
    eval 'sub PCI_AGP_COMMAND_AGP () {0x100;}' unless defined(&PCI_AGP_COMMAND_AGP);
    eval 'sub PCI_AGP_COMMAND_64BIT () {0x20;}' unless defined(&PCI_AGP_COMMAND_64BIT);
    eval 'sub PCI_AGP_COMMAND_FW () {0x10;}' unless defined(&PCI_AGP_COMMAND_FW);
    eval 'sub PCI_AGP_COMMAND_RATE4 () {0x4;}' unless defined(&PCI_AGP_COMMAND_RATE4);
    eval 'sub PCI_AGP_COMMAND_RATE2 () {0x2;}' unless defined(&PCI_AGP_COMMAND_RATE2);
    eval 'sub PCI_AGP_COMMAND_RATE1 () {0x1;}' unless defined(&PCI_AGP_COMMAND_RATE1);
    eval 'sub PCI_AGP_SIZEOF () {12;}' unless defined(&PCI_AGP_SIZEOF);
    eval 'sub PCI_SID_ESR () {2;}' unless defined(&PCI_SID_ESR);
    eval 'sub PCI_SID_ESR_NSLOTS () {0x1f;}' unless defined(&PCI_SID_ESR_NSLOTS);
    eval 'sub PCI_SID_ESR_FIC () {0x20;}' unless defined(&PCI_SID_ESR_FIC);
    eval 'sub PCI_SID_CHASSIS_NR () {3;}' unless defined(&PCI_SID_CHASSIS_NR);
    eval 'sub PCI_MSI_FLAGS () {2;}' unless defined(&PCI_MSI_FLAGS);
    eval 'sub PCI_MSI_FLAGS_64BIT () {0x80;}' unless defined(&PCI_MSI_FLAGS_64BIT);
    eval 'sub PCI_MSI_FLAGS_QSIZE () {0x70;}' unless defined(&PCI_MSI_FLAGS_QSIZE);
    eval 'sub PCI_MSI_FLAGS_QMASK () {0xe;}' unless defined(&PCI_MSI_FLAGS_QMASK);
    eval 'sub PCI_MSI_FLAGS_ENABLE () {0x1;}' unless defined(&PCI_MSI_FLAGS_ENABLE);
    eval 'sub PCI_MSI_RFU () {3;}' unless defined(&PCI_MSI_RFU);
    eval 'sub PCI_MSI_ADDRESS_LO () {4;}' unless defined(&PCI_MSI_ADDRESS_LO);
    eval 'sub PCI_MSI_ADDRESS_HI () {8;}' unless defined(&PCI_MSI_ADDRESS_HI);
    eval 'sub PCI_MSI_DATA_32 () {8;}' unless defined(&PCI_MSI_DATA_32);
    eval 'sub PCI_MSI_DATA_64 () {12;}' unless defined(&PCI_MSI_DATA_64);
    require 'linux/pci_ids.ph';
    eval 'sub PCI_DEVFN {
        my($slot,$func) = @_;
	    eval q((((($slot) & 0x1f) << 3) | (($func) & 0x7)));
    }' unless defined(&PCI_DEVFN);
    eval 'sub PCI_SLOT {
        my($devfn) = @_;
	    eval q(((($devfn) >> 3) & 0x1f));
    }' unless defined(&PCI_SLOT);
    eval 'sub PCI_FUNC {
        my($devfn) = @_;
	    eval q((($devfn) & 0x7));
    }' unless defined(&PCI_FUNC);
    eval 'sub PCIIOC_BASE () {(ord(\'P\' << 24 | \'C\' << 16 | \'I\') << 8);}' unless defined(&PCIIOC_BASE);
    eval 'sub PCIIOC_CONTROLLER () {( &PCIIOC_BASE | 0x);}' unless defined(&PCIIOC_CONTROLLER);
    eval 'sub PCIIOC_MMAP_IS_IO () {( &PCIIOC_BASE | 0x1);}' unless defined(&PCIIOC_MMAP_IS_IO);
    eval 'sub PCIIOC_MMAP_IS_MEM () {( &PCIIOC_BASE | 0x2);}' unless defined(&PCIIOC_MMAP_IS_MEM);
    eval 'sub PCIIOC_WRITE_COMBINE () {( &PCIIOC_BASE | 0x3);}' unless defined(&PCIIOC_WRITE_COMBINE);
}
1;
