require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&FPU_SAVE)) {
    sub FPU_SAVE () {	"(assembly code)";}
}
unless(defined(&FPU_RESTORE)) {
    sub FPU_RESTORE () {	"(assembly code)";}
}
unless(defined(&LD)) {
    sub LD {
	my($x,$y) = @_;
	eval q(\"       movq   8*(\"$x\")(%1), %%mm\"$y\"   ;\\n\");
    }
}
unless(defined(&ST)) {
    sub ST {
	my($x,$y) = @_;
	eval q(\"       movq %%mm\"$y\",   8*(\"$x\")(%1)   ;\\n\");
    }
}
unless(defined(&XO1)) {
    sub XO1 {
	my($x,$y) = @_;
	eval q(\"       pxor   8*(\"$x\")(%2), %%mm\"$y\"   ;\\n\");
    }
}
unless(defined(&XO2)) {
    sub XO2 {
	my($x,$y) = @_;
	eval q(\"       pxor   8*(\"$x\")(%3), %%mm\"$y\"   ;\\n\");
    }
}
unless(defined(&XO3)) {
    sub XO3 {
	my($x,$y) = @_;
	eval q(\"       pxor   8*(\"$x\")(%4), %%mm\"$y\"   ;\\n\");
    }
}
unless(defined(&XO4)) {
    sub XO4 {
	my($x,$y) = @_;
	eval q(\"       pxor   8*(\"$x\")(%5), %%mm\"$y\"   ;\\n\");
    }
}
undef(&BLOCK) if defined(&BLOCK);
unless(defined(&BLOCK)) {
    sub BLOCK {
	my($i) = @_;
	eval q( &LD($i,0)  &LD($i+1,1)  &LD($i+2,2)  &LD($i+3,3)  &XO1($i,0)  &ST($i,0)  &XO1($i+1,1)  &ST($i+1,1)  &XO1($i+2,2)  &ST($i+2,2)  &XO1($i+3,3)  &ST($i+3,3));
    }
}
undef(&BLOCK) if defined(&BLOCK);
unless(defined(&BLOCK)) {
    sub BLOCK {
	my($i) = @_;
	eval q( &LD($i,0)  &LD($i+1,1)  &LD($i+2,2)  &LD($i+3,3)  &XO1($i,0)  &XO1($i+1,1)  &XO1($i+2,2)  &XO1($i+3,3)  &XO2($i,0)  &ST($i,0)  &XO2($i+1,1)  &ST($i+1,1)  &XO2($i+2,2)  &ST($i+2,2)  &XO2($i+3,3)  &ST($i+3,3));
    }
}
undef(&BLOCK) if defined(&BLOCK);
unless(defined(&BLOCK)) {
    sub BLOCK {
	my($i) = @_;
	eval q( &LD($i,0)  &LD($i+1,1)  &LD($i+2,2)  &LD($i+3,3)  &XO1($i,0)  &XO1($i+1,1)  &XO1($i+2,2)  &XO1($i+3,3)  &XO2($i,0)  &XO2($i+1,1)  &XO2($i+2,2)  &XO2($i+3,3)  &XO3($i,0)  &ST($i,0)  &XO3($i+1,1)  &ST($i+1,1)  &XO3($i+2,2)  &ST($i+2,2)  &XO3($i+3,3)  &ST($i+3,3));
    }
}
undef(&BLOCK) if defined(&BLOCK);
unless(defined(&BLOCK)) {
    sub BLOCK {
	my($i) = @_;
	eval q( &LD($i,0)  &LD($i+1,1)  &LD($i+2,2)  &LD($i+3,3)  &XO1($i,0)  &XO1($i+1,1)  &XO1($i+2,2)  &XO1($i+3,3)  &XO2($i,0)  &XO2($i+1,1)  &XO2($i+2,2)  &XO2($i+3,3)  &XO3($i,0)  &XO3($i+1,1)  &XO3($i+2,2)  &XO3($i+3,3)  &XO4($i,0)  &ST($i,0)  &XO4($i+1,1)  &ST($i+1,1)  &XO4($i+2,2)  &ST($i+2,2)  &XO4($i+3,3)  &ST($i+3,3));
    }
}
undef(&LD) if defined(&LD);
undef(&XO1) if defined(&XO1);
undef(&XO2) if defined(&XO2);
undef(&XO3) if defined(&XO3);
undef(&XO4) if defined(&XO4);
undef(&ST) if defined(&ST);
undef(&BLOCK) if defined(&BLOCK);
undef(&FPU_SAVE) if defined(&FPU_SAVE);
undef(&FPU_RESTORE) if defined(&FPU_RESTORE);
unless(defined(&XMMS_SAVE)) {
    sub XMMS_SAVE () {	"(assembly code)";}
}
unless(defined(&XMMS_RESTORE)) {
    sub XMMS_RESTORE () {	"(assembly code)";}
}
unless(defined(&OFFS)) {
    sub OFFS {
	my($x) = @_;
	eval q(\"16*(\"$x\")\");
    }
}
unless(defined(&PF_OFFS)) {
    sub PF_OFFS {
	my($x) = @_;
	eval q(\"256+16*(\"$x\")\");
    }
}
unless(defined(&PF0)) {
    sub PF0 {
	my($x) = @_;
	eval q(\"	prefetchnta \" &PF_OFFS($x)\"(%1)		;\\n\");
    }
}
unless(defined(&LD)) {
    sub LD {
	my($x,$y) = @_;
	eval q(\"       movaps   \" &OFFS($x)\"(%1), %%xmm\"$y\"	;\\n\");
    }
}
unless(defined(&ST)) {
    sub ST {
	my($x,$y) = @_;
	eval q(\"       movaps %%xmm\"$y\",   \" &OFFS($x)\"(%1)	;\\n\");
    }
}
unless(defined(&PF1)) {
    sub PF1 {
	my($x) = @_;
	eval q(\"	prefetchnta \" &PF_OFFS($x)\"(%2)		;\\n\");
    }
}
unless(defined(&PF2)) {
    sub PF2 {
	my($x) = @_;
	eval q(\"	prefetchnta \" &PF_OFFS($x)\"(%3)		;\\n\");
    }
}
unless(defined(&PF3)) {
    sub PF3 {
	my($x) = @_;
	eval q(\"	prefetchnta \" &PF_OFFS($x)\"(%4)		;\\n\");
    }
}
unless(defined(&PF4)) {
    sub PF4 {
	my($x) = @_;
	eval q(\"	prefetchnta \" &PF_OFFS($x)\"(%5)		;\\n\");
    }
}
unless(defined(&PF5)) {
    sub PF5 {
	my($x) = @_;
	eval q(\"	prefetchnta \" &PF_OFFS($x)\"(%6)		;\\n\");
    }
}
unless(defined(&XO1)) {
    sub XO1 {
	my($x,$y) = @_;
	eval q(\"       xorps   \" &OFFS($x)\"(%2), %%xmm\"$y\"	;\\n\");
    }
}
unless(defined(&XO2)) {
    sub XO2 {
	my($x,$y) = @_;
	eval q(\"       xorps   \" &OFFS($x)\"(%3), %%xmm\"$y\"	;\\n\");
    }
}
unless(defined(&XO3)) {
    sub XO3 {
	my($x,$y) = @_;
	eval q(\"       xorps   \" &OFFS($x)\"(%4), %%xmm\"$y\"	;\\n\");
    }
}
unless(defined(&XO4)) {
    sub XO4 {
	my($x,$y) = @_;
	eval q(\"       xorps   \" &OFFS($x)\"(%5), %%xmm\"$y\"	;\\n\");
    }
}
unless(defined(&XO5)) {
    sub XO5 {
	my($x,$y) = @_;
	eval q(\"       xorps   \" &OFFS($x)\"(%6), %%xmm\"$y\"	;\\n\");
    }
}
undef(&BLOCK) if defined(&BLOCK);
unless(defined(&BLOCK)) {
    sub BLOCK {
	my($i) = @_;
	eval q( &LD($i,0)  &LD($i+1,1)  &PF1($i)  &PF1($i+2)  &LD($i+2,2)  &LD($i+3,3)  &PF0($i+4)  &PF0($i+6)  &XO1($i,0)  &XO1($i+1,1)  &XO1($i+2,2)  &XO1($i+3,3)  &ST($i,0)  &ST($i+1,1)  &ST($i+2,2)  &ST($i+3,3));
    }
}
undef(&BLOCK) if defined(&BLOCK);
unless(defined(&BLOCK)) {
    sub BLOCK {
	my($i) = @_;
	eval q( &PF1($i)  &PF1($i+2)  &LD($i,0)  &LD($i+1,1)  &LD($i+2,2)  &LD($i+3,3)  &PF2($i)  &PF2($i+2)  &PF0($i+4)  &PF0($i+6)  &XO1($i,0)  &XO1($i+1,1)  &XO1($i+2,2)  &XO1($i+3,3)  &XO2($i,0)  &XO2($i+1,1)  &XO2($i+2,2)  &XO2($i+3,3)  &ST($i,0)  &ST($i+1,1)  &ST($i+2,2)  &ST($i+3,3));
    }
}
undef(&BLOCK) if defined(&BLOCK);
unless(defined(&BLOCK)) {
    sub BLOCK {
	my($i) = @_;
	eval q( &PF1($i)  &PF1($i+2)  &LD($i,0)  &LD($i+1,1)  &LD($i+2,2)  &LD($i+3,3)  &PF2($i)  &PF2($i+2)  &XO1($i,0)  &XO1($i+1,1)  &XO1($i+2,2)  &XO1($i+3,3)  &PF3($i)  &PF3($i+2)  &PF0($i+4)  &PF0($i+6)  &XO2($i,0)  &XO2($i+1,1)  &XO2($i+2,2)  &XO2($i+3,3)  &XO3($i,0)  &XO3($i+1,1)  &XO3($i+2,2)  &XO3($i+3,3)  &ST($i,0)  &ST($i+1,1)  &ST($i+2,2)  &ST($i+3,3));
    }
}
undef(&BLOCK) if defined(&BLOCK);
unless(defined(&BLOCK)) {
    sub BLOCK {
	my($i) = @_;
	eval q( &PF1($i)  &PF1($i+2)  &LD($i,0)  &LD($i+1,1)  &LD($i+2,2)  &LD($i+3,3)  &PF2($i)  &PF2($i+2)  &XO1($i,0)  &XO1($i+1,1)  &XO1($i+2,2)  &XO1($i+3,3)  &PF3($i)  &PF3($i+2)  &XO2($i,0)  &XO2($i+1,1)  &XO2($i+2,2)  &XO2($i+3,3)  &PF4($i)  &PF4($i+2)  &PF0($i+4)  &PF0($i+6)  &XO3($i,0)  &XO3($i+1,1)  &XO3($i+2,2)  &XO3($i+3,3)  &XO4($i,0)  &XO4($i+1,1)  &XO4($i+2,2)  &XO4($i+3,3)  &ST($i,0)  &ST($i+1,1)  &ST($i+2,2)  &ST($i+3,3));
    }
}
require 'asm-generic/xor.ph';
undef(&XOR_TRY_TEMPLATES) if defined(&XOR_TRY_TEMPLATES);
unless(defined(&XOR_TRY_TEMPLATES)) {
    sub XOR_TRY_TEMPLATES () {	 &do {  &xor_speed( &xor_block_8regs);  &xor_speed( &xor_block_32regs);  &if ( &cpu_has_xmm)  &xor_speed( &xor_block_pIII_sse);  &if ( &md_cpu_has_mmx()) {  &xor_speed( &xor_block_pII_mmx);  &xor_speed( &xor_block_p5_mmx); } }  &while (0);}
}
unless(defined(&XOR_SELECT_TEMPLATE)) {
    sub XOR_SELECT_TEMPLATE {
	my($FASTEST) = @_;
	eval q(( &cpu_has_xmm ?  &xor_block_pIII_sse : $FASTEST));
    }
}
1;
