require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__X86_64_UACCESS_H)) {
    eval 'sub __X86_64_UACCESS_H () {1;}' unless defined(&__X86_64_UACCESS_H);
    require 'linux/config.ph';
    require 'linux/sched.ph';
    require 'asm/page.ph';
    eval 'sub VERIFY_READ () {0;}' unless defined(&VERIFY_READ);
    eval 'sub VERIFY_WRITE () {1;}' unless defined(&VERIFY_WRITE);
    eval 'sub MAKE_MM_SEG {
        my($s) = @_;
	    eval q((( &mm_segment_t) { ($s) }));
    }' unless defined(&MAKE_MM_SEG);
    eval 'sub KERNEL_DS () { &MAKE_MM_SEG(0xffffffffffffffff);}' unless defined(&KERNEL_DS);
    eval 'sub USER_DS () { &MAKE_MM_SEG( &PAGE_OFFSET);}' unless defined(&USER_DS);
    eval 'sub get_ds () {
        eval q(( &KERNEL_DS));
    }' unless defined(&get_ds);
    eval 'sub get_fs () {
        eval q(( ($current->{addr_limit})));
    }' unless defined(&get_fs);
    eval 'sub set_fs {
        my($x) = @_;
	    eval q(( ($current->{addr_limit}) = ($x)));
    }' unless defined(&set_fs);
    eval 'sub segment_eq {
        my($a,$b) = @_;
	    eval q((($a). &seg == ($b). &seg));
    }' unless defined(&segment_eq);
    eval 'sub __addr_ok {
        my($addr) = @_;
	    eval q((!(($addr) & ( ($current->{addr_limit}->{seg})))));
    }' unless defined(&__addr_ok);
    eval 'sub __range_not_ok {
        my($addr,$size) = @_;
	    eval q(({ \'unsigned long flag\', &sum;  &asm(\\"# range_ok\\\\n\\\\r\\" \\"addq %3,%1 ; sbbq %0,%0 ; cmpq %1,%4 ; sbbq $0,%0\\" :\\"=&r\\" , \\"=r\\" :\\"1\\" ,\\"g\\" (($size)),\\"g\\" ( ($current->{addr_limit}->{seg})));  &flag; }));
    }' unless defined(&__range_not_ok);
    eval 'sub access_ok {
        my($type,$addr,$size) = @_;
	    eval q(( &__range_not_ok($addr,$size) == 0));
    }' unless defined(&access_ok);
    eval 'sub verify_area {
        my($type,$addr,$size) = @_;
	    eval q({  &access_ok($type,$addr,$size) ? 0: - &EFAULT; });
    }' unless defined(&verify_area);
    eval 'sub __get_user_x {
        my($size,$ret,$x,$ptr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__get_user_x);
    eval 'sub get_user {
        my($x,$ptr) = @_;
	    eval q(({ \'long __ret_gu\', &__val_gu;  &switch($sizeof{($ptr)}) {  &case 1:  &__get_user_x(1, &__ret_gu, &__val_gu,$ptr);  &break;  &case 2:  &__get_user_x(2, &__ret_gu, &__val_gu,$ptr);  &break;  &case 4:  &__get_user_x(4, &__ret_gu, &__val_gu,$ptr);  &break;  &case 8:  &__get_user_x(8, &__ret_gu, &__val_gu,$ptr);  &break;  &default:  &__get_user_bad();  &break; } ($x) = ( &__typeof__(*($ptr))) &__val_gu;  &__ret_gu; }));
    }' unless defined(&get_user);
    eval 'sub __put_user_x {
        my($size,$ret,$x,$ptr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__put_user_x);
    eval 'sub put_user {
        my($x,$ptr) = @_;
	    eval q( &__put_user_check(( &__typeof__(*($ptr)))($x),($ptr),$sizeof{($ptr)}));
    }' unless defined(&put_user);
    eval 'sub __get_user {
        my($x,$ptr) = @_;
	    eval q( &__get_user_nocheck(($x),($ptr),$sizeof{($ptr)}));
    }' unless defined(&__get_user);
    eval 'sub __put_user {
        my($x,$ptr) = @_;
	    eval q( &__put_user_nocheck(( &__typeof__(*($ptr)))($x),($ptr),$sizeof{($ptr)}));
    }' unless defined(&__put_user);
    eval 'sub __put_user_nocheck {
        my($x,$ptr,$size) = @_;
	    eval q(({ \'long __pu_err\';  &__put_user_size(($x),($ptr),($size), &__pu_err);  &__pu_err; }));
    }' unless defined(&__put_user_nocheck);
    eval 'sub __put_user_check {
        my($x,$ptr,$size) = @_;
	    eval q(({ \'long __pu_err\' = - &EFAULT;  &__typeof__(*($ptr)) * &__pu_addr = ($ptr);  &if ( &access_ok( &VERIFY_WRITE, &__pu_addr,$size))  &__put_user_size(($x), &__pu_addr,($size), &__pu_err);  &__pu_err; }));
    }' unless defined(&__put_user_check);
    eval 'sub __put_user_size {
        my($x,$ptr,$size,$retval) = @_;
	    eval q( &do { $retval = 0;  &switch ($size) {  &case 1:  &__put_user_asm($x,$ptr,$retval,\\"b\\",\\"b\\",\\"iq\\");  &break;  &case 2:  &__put_user_asm($x,$ptr,$retval,\\"w\\",\\"w\\",\\"ir\\");  &break;  &case 4:  &__put_user_asm($x,$ptr,$retval,\\"l\\",\\"k\\",\\"ir\\");  &break;  &case 8:  &__put_user_asm($x,$ptr,$retval,\\"q\\",\\"\\",\\"ir\\");  &break;  &default:  &__put_user_bad(); } }  &while (0));
    }' unless defined(&__put_user_size);
    eval 'sub __m {
        my($x) = @_;
	    eval q((*($x)));
    }' unless defined(&__m);
    eval 'sub __put_user_asm {
        my($x, $addr, $err, $itype, $rtype, $ltype) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__put_user_asm);
    eval 'sub __get_user_nocheck {
        my($x,$ptr,$size) = @_;
	    eval q(({ \'long __gu_err\',  &__gu_val;  &__get_user_size( &__gu_val,($ptr),($size), &__gu_err); ($x) = ( &__typeof__(*($ptr))) &__gu_val;  &__gu_err; }));
    }' unless defined(&__get_user_nocheck);
    eval 'sub __get_user_size {
        my($x,$ptr,$size,$retval) = @_;
	    eval q( &do { $retval = 0;  &switch ($size) {  &case 1:  &__get_user_asm($x,$ptr,$retval,\\"b\\",\\"b\\",\\"=q\\");  &break;  &case 2:  &__get_user_asm($x,$ptr,$retval,\\"w\\",\\"w\\",\\"=r\\");  &break;  &case 4:  &__get_user_asm($x,$ptr,$retval,\\"l\\",\\"k\\",\\"=r\\");  &break;  &case 8:  &__get_user_asm($x,$ptr,$retval,\\"q\\",\\"\\",\\"=r\\");  &break;  &default: ($x) =  &__get_user_bad(); } }  &while (0));
    }' unless defined(&__get_user_size);
    eval 'sub __get_user_asm {
        my($x, $addr, $err, $itype, $rtype, $ltype) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__get_user_asm);
    eval 'sub __copy_user {
        my($to,$from,$size) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__copy_user);
    eval 'sub __copy_user_zeroing {
        my($to,$from,$size) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__copy_user_zeroing);
    eval 'sub __generic_copy_to_user_nocheck {
        my($to,$from,$n) = @_;
	    eval q({  &prefetch($from);  &__copy_user($to,$from,$n); $n; });
    }' unless defined(&__generic_copy_to_user_nocheck);
    eval 'sub __constant_copy_to_user {
        my($to,$from,$n) = @_;
	    eval q({  &if ( &access_ok( &VERIFY_WRITE, $to, $n))  &__copy_user($to,$from,$n); $n; });
    }' unless defined(&__constant_copy_to_user);
    eval 'sub __constant_copy_from_user {
        my($to,$from,$n) = @_;
	    eval q({  &if ( &access_ok( &VERIFY_READ, $from, $n))  &__copy_user_zeroing($to,$from,$n);  &else  &memset($to, 0, $n); $n; });
    }' unless defined(&__constant_copy_from_user);
    eval 'sub __constant_copy_to_user_nocheck {
        my($to,$from,$n) = @_;
	    eval q({  &__copy_user($to,$from,$n); $n; });
    }' unless defined(&__constant_copy_to_user_nocheck);
    eval 'sub __constant_copy_from_user_nocheck {
        my($to,$from,$n) = @_;
	    eval q({  &__copy_user_zeroing($to,$from,$n); $n; });
    }' unless defined(&__constant_copy_from_user_nocheck);
    eval 'sub copy_to_user {
        my($to,$from,$n) = @_;
	    eval q(( &__builtin_constant_p($n) ?  &__constant_copy_to_user(($to),($from),($n)) :  &__generic_copy_to_user(($to),($from),($n))));
    }' unless defined(&copy_to_user);
    eval 'sub copy_from_user {
        my($to,$from,$n) = @_;
	    eval q(( &__builtin_constant_p($n) ?  &__constant_copy_from_user(($to),($from),($n)) :  &__generic_copy_from_user(($to),($from),($n))));
    }' unless defined(&copy_from_user);
    eval 'sub __copy_to_user {
        my($to,$from,$n) = @_;
	    eval q(( &__builtin_constant_p($n) ?  &__constant_copy_to_user_nocheck(($to),($from),($n)) :  &__generic_copy_to_user_nocheck(($to),($from),($n))));
    }' unless defined(&__copy_to_user);
    eval 'sub __copy_from_user {
        my($to,$from,$n) = @_;
	    eval q(( &__builtin_constant_p($n) ?  &__constant_copy_from_user_nocheck(($to),($from),($n)) :  &__generic_copy_from_user_nocheck(($to),($from),($n))));
    }' unless defined(&__copy_from_user);
    eval 'sub strlen_user {
        my($str) = @_;
	    eval q( &strnlen_user($str, ~0 >> 1));
    }' unless defined(&strlen_user);
}
1;
