#!/bin/sh
# Copyright 1999-2007 Gentoo Foundation
# Copyright 2007-2008 Roy Marples <roy@marples.name>
# All rights reserved. Released under the 2-clause BSD license.

# This basically mounts $RC_SVCDIR as a ramdisk.
# The tricky part is finding something our kernel supports
# tmpfs and ramfs are easy, so force one or the other.
mount_svcdir()
{
	local fs= fsopts="-o rw,noexec,nodev,nosuid"
	local devdir="rc-svcdir" x=
	local svcsize=${rc_svcsize:-1024}

	if grep -Eq "[[:space:]]+tmpfs$" /proc/filesystems; then
		fs="tmpfs"
		fsopts="${fsopts},mode=0755,size=${svcsize}k"
	elif grep -Eq "[[:space:]]+ramfs$" /proc/filesystems; then
		fs="ramfs"
		# ramfs has no special options
	elif [ -e /dev/ram0 ] \
		&& grep -Eq "[[:space:]]+ext2$" /proc/filesystems; then
		devdir="/dev/ram0"
		fs="ext2"
		dd if=/dev/zero of="${devdir}" bs=1k count="${svcsize}"
		mkfs -t "${fs}" -i 1024 -vm0 "${devdir}" "${svcsize}"
	else
		echo
		eerror "OpenRC requires tmpfs, ramfs or a ramdisk + ext2"
		eerror "compiled into the kernel"
		echo
		return 1
	fi

	# If we have no entry in fstab for $RC_SVCDIR, provide our own
	if ! fstabinfo --mount "${RC_SVCDIR}"; then
		mount -n -t "${fs}" ${fsopts} "${devdir}" "${RC_SVCDIR}"
	fi
}

. /etc/init.d/functions.sh
[ -r /etc/rc.conf ] && . /etc/rc.conf

# By default VServer already has /proc mounted, but OpenVZ does not!
# However, some of our users have an old proc image in /proc
# NFC how they managed that, but the end result means we have to test if
# /proc actually works or not. We to this by comparing uptime to one a second
# ago
mountproc=true
if [ -e /proc/uptime ]; then
	up="$(cat /proc/uptime)"
	sleep 1
	if [ "${up}" = "$(cat /proc/uptime)" ]; then
		eerror "You have cruft in /proc that should be deleted"
	else
		einfo "/proc is already mounted, skipping"
		mountproc=false
	fi
fi

if ${mountproc}; then
	procfs="proc"
	[ "${RC_UNAME}" = "GNU/kFreeBSD" ] && proc="linprocfs"
	ebegin "Mounting /proc"
	if ! fstabinfo --mount /proc; then
		mount -n -t "${procfs}" -o noexec,nosuid,nodev proc /proc
	fi
	eend $?
fi

. "${RC_LIBDIR}"/sh/init-common-post.sh
