/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.exports.information;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import tr.extract.Extract;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamsDialog;
import tr.extract.prefs.ExtractPrefs;
import tr.model.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportXML
extends Extract {
    public String getID() {
        return "information-xml";
    }

    public String getName() {
        return this.getString("CTL_ExportXMLAction");
    }

    public List<Param> getParams() {
        Vector<Param> params = new Vector<Param>(2);
        params.add((Param)new ParamBoolean("include-topic", this.getString("param-include-topic")));
        params.add((Param)new ParamBoolean("include-notes", this.getString("param-include-notes")));
        return params;
    }

    public void process(Data data) throws Exception {
        List<Param> params = this.getParams();
        String title = this.getDialogTitleExport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), params);
        if (dlg.showDialog() == 2) {
            return;
        }
        File xmlfile = ExportXML.getTmpFile((String)"data.xml");
        this.extractData(data, xmlfile, Extract.FormatType.XML);
        URL xslURL = ((Object)((Object)this)).getClass().getResource("reference-xml.xsl");
        File outfile = ExportXML.getOutFile((String)("reference-" + ExportXML.getTimeStamp() + ".xml"));
        String encoding = ExtractPrefs.getEncoding();
        this.transformXSL(xmlfile, xslURL, params, outfile, encoding, true);
        this.openTextFile(outfile);
    }
}

