/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Component;
import java.io.IOException;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.NewObjectPanel;
import org.openide.loaders.TemplateWizard;
import org.openide.loaders.TemplateWizard2;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NewObjectWizardPanel
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private NewObjectPanel newObjectPanelUI;
    private ChangeListener listener;
    DataFolder targetFolder;
    private String extension;
    private TemplateWizard wizard;

    NewObjectWizardPanel() {
    }

    private NewObjectPanel getPanelUI() {
        if (this.newObjectPanelUI == null) {
            this.newObjectPanelUI = new NewObjectPanel();
            this.newObjectPanelUI.addChangeListener(this.listener);
        }
        return this.newObjectPanelUI;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        if (this.newObjectPanelUI != null) {
            this.newObjectPanelUI.addChangeListener(changeListener);
        }
        this.listener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listener = null;
        if (this.newObjectPanelUI != null) {
            this.newObjectPanelUI.removeChangeListener(changeListener);
        }
    }

    public Component getComponent() {
        return this.getPanelUI();
    }

    public HelpCtx getHelp() {
        return new HelpCtx(NewObjectPanel.class);
    }

    public boolean isValid() {
        String string = null;
        boolean bl = true;
        if (!this.targetFolder.getPrimaryFile().canWrite()) {
            string = NbBundle.getMessage(TemplateWizard2.class, (String)"MSG_fs_is_readonly");
            bl = false;
        }
        if (bl) {
            Object object = this.targetFolder.getPrimaryFile().getAttribute("isRemoteAndSlow");
            boolean bl2 = true;
            if (object instanceof Boolean) {
                boolean bl3 = bl2 = (Boolean)object == false;
            }
            if (bl2) {
                FileObject fileObject = this.targetFolder.getPrimaryFile().getFileObject(this.getPanelUI().getNewObjectName(), this.extension);
                if (fileObject != null) {
                    string = NbBundle.getMessage(TemplateWizard2.class, (String)"MSG_file_already_exist", (Object)fileObject.getNameExt());
                    bl = false;
                }
                if ((Utilities.isWindows() || Utilities.getOperatingSystem() == 2048) && TemplateWizard.checkCaseInsensitiveName(this.targetFolder.getPrimaryFile(), this.getPanelUI().getNewObjectName(), this.extension)) {
                    string = NbBundle.getMessage(TemplateWizard2.class, (String)"MSG_file_already_exist", (Object)this.getPanelUI().getNewObjectName());
                    bl = false;
                }
            }
        }
        this.wizard.putProperty("WizardPanel_errorMessage", string);
        return bl;
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wizard = (TemplateWizard)wizardDescriptor;
        DataObject dataObject = this.wizard.getTemplate();
        if (dataObject != null) {
            this.extension = dataObject.getPrimaryFile().getExt();
        }
        try {
            this.targetFolder = this.wizard.getTargetFolder();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        String string = this.getPanelUI().getNewObjectName();
        if (string.equals(NewObjectPanel.defaultNewObjectName())) {
            string = null;
        }
        if (this.wizard != null) {
            this.wizard.setTargetName(string);
            this.wizard = null;
        }
    }

    public boolean isFinishPanel() {
        return true;
    }
}

