/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.MaxScoreCollector;
import org.apache.solr.search.QueryCommand;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrMultiCollectorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadedSearcher {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final SolrIndexSearcher searcher;

    public MultiThreadedSearcher(SolrIndexSearcher searcher) {
        this.searcher = searcher;
    }

    SearchResult searchCollectorManagers(int len, QueryCommand cmd, Query query, boolean needTopDocs, boolean needMaxScore, boolean needDocSet) throws IOException {
        Object[] ret;
        ArrayList<Object> collectors = new ArrayList<Object>();
        int firstCollectorsSize = 0;
        int firstTopDocsCollectorIndex = needTopDocs ? firstCollectorsSize++ : -1;
        int firstMaxScoreCollectorIndex = needMaxScore ? firstCollectorsSize++ : -1;
        Collector[] firstCollectors = new Collector[firstCollectorsSize];
        if (needTopDocs) {
            collectors.add(new TopDocsCM(len, cmd, firstCollectors, firstTopDocsCollectorIndex));
        }
        if (needMaxScore) {
            collectors.add(new MaxScoreCM(firstCollectors, firstMaxScoreCollectorIndex));
        }
        if (needDocSet) {
            int maxDoc = this.searcher.getRawReader().maxDoc();
            collectors.add(new DocSetCM(maxDoc));
        }
        CollectorManager[] colls = collectors.toArray(new CollectorManager[0]);
        SolrMultiCollectorManager manager = new SolrMultiCollectorManager(colls);
        try {
            ret = (Object[])this.searcher.search(query, manager);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException && ex.getCause() != null && ex.getCause() instanceof ExecutionException && ex.getCause().getCause() != null && ex.getCause().getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause().getCause();
            }
            throw ex;
        }
        ScoreMode scoreMode = SolrMultiCollectorManager.scoreMode(firstCollectors);
        return new SearchResult(scoreMode, ret);
    }

    static boolean allowMT(DelegatingCollector postFilter, QueryCommand cmd) {
        return postFilter == null && !cmd.getSegmentTerminateEarly() && cmd.getMultiThreaded();
    }

    static class TopDocsResult {
        final TopDocs topDocs;
        final int totalHits;

        public TopDocsResult(TopDocs topDocs, int totalHits) {
            this.topDocs = topDocs;
            this.totalHits = totalHits;
        }
    }

    private class TopDocsCM
    implements CollectorManager<Collector, Object> {
        private final int len;
        private final QueryCommand cmd;
        private final Collector[] firstCollectors;
        private final int firstTopDocsCollectorIndex;

        public TopDocsCM(int len, QueryCommand cmd, Collector[] firstCollectors, int firstTopDocsCollectorIndex) {
            this.len = len;
            this.cmd = cmd;
            this.firstCollectors = firstCollectors;
            this.firstTopDocsCollectorIndex = firstTopDocsCollectorIndex;
        }

        public Collector newCollector() throws IOException {
            TopDocsCollector<? extends ScoreDoc> collector = MultiThreadedSearcher.this.searcher.buildTopDocsCollector(this.len, this.cmd);
            if (this.firstCollectors[this.firstTopDocsCollectorIndex] == null) {
                this.firstCollectors[this.firstTopDocsCollectorIndex] = collector;
            }
            return collector;
        }

        public Object reduce(Collection collectors) throws IOException {
            TopDocs[] topDocs = new TopDocs[collectors.size()];
            int totalHits = -1;
            int i = 0;
            for (Object o : collectors) {
                Collector collector = (Collector)o;
                if (!(collector instanceof TopDocsCollector)) continue;
                TopDocs td = ((TopDocsCollector)collector).topDocs(0, this.len);
                assert (td != null) : Arrays.asList(topDocs);
                topDocs[i++] = td;
            }
            TopDocs mergedTopDocs = null;
            if (topDocs.length > 0 && topDocs[0] != null) {
                if (topDocs[0] instanceof TopFieldDocs) {
                    TopFieldDocs[] topFieldDocs = (TopFieldDocs[])Arrays.copyOf(topDocs, topDocs.length, TopFieldDocs[].class);
                    mergedTopDocs = TopFieldDocs.merge((Sort)MultiThreadedSearcher.this.searcher.weightSort(this.cmd.getSort()), (int)this.len, (TopFieldDocs[])topFieldDocs);
                } else {
                    mergedTopDocs = TopDocs.merge((int)0, (int)this.len, (TopDocs[])topDocs);
                }
                totalHits = (int)mergedTopDocs.totalHits.value;
            }
            return new TopDocsResult(mergedTopDocs, totalHits);
        }
    }

    private static class DocSetCM
    implements CollectorManager<Collector, Object> {
        private final int maxDoc;

        public DocSetCM(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        public Collector newCollector() throws IOException {
            return new FixedBitSetCollector();
        }

        public Object reduce(Collection collectors) throws IOException {
            FixedBitSet reduced = new FixedBitSet(this.maxDoc);
            for (Object collector : collectors) {
                if (!(collector instanceof FixedBitSetCollector)) continue;
                FixedBitSetCollector fixedBitSetCollector = (FixedBitSetCollector)((Object)collector);
                fixedBitSetCollector.update(reduced);
            }
            return reduced;
        }
    }

    private static class MaxScoreCM
    implements CollectorManager<Collector, Object> {
        private final Collector[] firstCollectors;
        private final int firstMaxScoreCollectorIndex;

        public MaxScoreCM(Collector[] firstCollectors, int firstMaxScoreCollectorIndex) {
            this.firstCollectors = firstCollectors;
            this.firstMaxScoreCollectorIndex = firstMaxScoreCollectorIndex;
        }

        public Collector newCollector() throws IOException {
            MaxScoreCollector collector = new MaxScoreCollector();
            if (this.firstCollectors[this.firstMaxScoreCollectorIndex] == null) {
                this.firstCollectors[this.firstMaxScoreCollectorIndex] = collector;
            }
            return collector;
        }

        public Object reduce(Collection collectors) throws IOException {
            float maxScore = 0.0f;
            for (MaxScoreCollector collector : collectors) {
                maxScore = Math.max(maxScore, collector.getMaxScore());
            }
            return new MaxScoreResult(maxScore);
        }
    }

    static class SearchResult {
        final ScoreMode scoreMode;
        private final Object[] result;

        public SearchResult(ScoreMode scoreMode, Object[] result) {
            this.scoreMode = scoreMode;
            this.result = result;
        }

        public TopDocsResult getTopDocsResult() {
            for (Object res : this.result) {
                if (!(res instanceof TopDocsResult)) continue;
                return (TopDocsResult)res;
            }
            return null;
        }

        public float getMaxScore(int totalHits) {
            if (totalHits > 0) {
                for (Object res : this.result) {
                    if (!(res instanceof MaxScoreResult)) continue;
                    return ((MaxScoreResult)res).maxScore;
                }
                return Float.NaN;
            }
            return 0.0f;
        }

        public FixedBitSet getFixedBitSet() {
            for (Object res : this.result) {
                if (!(res instanceof FixedBitSet)) continue;
                return (FixedBitSet)res;
            }
            return null;
        }
    }

    static class FixedBitSetCollector
    extends SimpleCollector {
        private final LinkedList<FixedBitSet> bitSets = new LinkedList();
        private final LinkedList<Integer> skipWords = new LinkedList();
        private final LinkedList<Integer> skipBits = new LinkedList();

        FixedBitSetCollector() {
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.bitSets.add(null);
            this.skipWords.add(context.docBase / 64);
            this.skipBits.add(context.docBase % 64);
        }

        public void collect(int doc) throws IOException {
            FixedBitSet bitSet = this.bitSets.getLast();
            int idx = this.skipBits.getLast() + doc;
            int numWords = FixedBitSet.bits2words((int)(idx + 1));
            if (bitSet == null) {
                this.bitSets.removeLast();
                bitSet = new FixedBitSet(numWords * 64);
                this.bitSets.addLast(bitSet);
            } else if (bitSet.getBits().length < numWords) {
                FixedBitSet smallerBitSet = this.bitSets.removeLast();
                bitSet = new FixedBitSet(numWords * 64);
                bitSet.xor(smallerBitSet);
                this.bitSets.addLast(bitSet);
            }
            bitSet.set(idx);
        }

        void update(FixedBitSet allBitSet) {
            long[] allBits = allBitSet.getBits();
            for (int bs_idx = 0; bs_idx < this.bitSets.size(); ++bs_idx) {
                FixedBitSet itBitSet = this.bitSets.get(bs_idx);
                if (itBitSet == null) continue;
                int skipWords = this.skipWords.get(bs_idx);
                long[] itBits = itBitSet.getBits();
                for (int idx = 0; idx < itBits.length && skipWords + idx < allBits.length; ++idx) {
                    int n = skipWords + idx;
                    allBits[n] = allBits[n] ^ itBits[idx];
                }
            }
        }

        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    }

    static class MaxScoreResult {
        final float maxScore;

        public MaxScoreResult(float maxScore) {
            this.maxScore = maxScore;
        }
    }
}

