/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.charstream.CharStream;
import org.apache.lucene.queryparser.charstream.FastCharStream;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.apache.solr.parser.ParseException;
import org.apache.solr.parser.QueryParserConstants;
import org.apache.solr.parser.QueryParserTokenManager;
import org.apache.solr.parser.SolrQueryParserBase;
import org.apache.solr.parser.Token;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;

public class QueryParser
extends SolrQueryParserBase
implements QueryParserConstants {
    public static final boolean DEFAULT_SPLIT_ON_WHITESPACE = false;
    private boolean splitOnWhitespace = false;
    private static Set<Integer> disallowedPostMultiTerm = new HashSet<Integer>(Arrays.asList(21, 22, 26, 23, 13, 14));
    public QueryParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[27];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[3];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    public QueryParser(String defaultField, QParser parser) {
        this((CharStream)new FastCharStream((Reader)new StringReader("")));
        this.init(defaultField, parser);
    }

    public boolean getSplitOnWhitespace() {
        return this.splitOnWhitespace;
    }

    public void setSplitOnWhitespace(boolean splitOnWhitespace) {
        this.splitOnWhitespace = splitOnWhitespace;
    }

    private static boolean allowedPostMultiTerm(int tokenKind) {
        return !disallowedPostMultiTerm.contains(tokenKind);
    }

    @Override
    protected Query newFieldQuery(Analyzer analyzer, String field, String queryText, boolean quoted, boolean fieldAutoGenPhraseQueries, boolean fieldEnableGraphQueries, SolrQueryParserBase.SynonymQueryStyle synonymQueryStyle) throws SyntaxError {
        this.setAutoGenerateMultiTermSynonymsPhraseQuery(fieldAutoGenPhraseQueries || this.getAutoGeneratePhraseQueries());
        boolean treatAsQuoted = this.getSplitOnWhitespace() ? quoted || fieldAutoGenPhraseQueries || this.getAutoGeneratePhraseQueries() : quoted;
        return super.newFieldQuery(analyzer, field, queryText, treatAsQuoted, false, fieldEnableGraphQueries, synonymQueryStyle);
    }

    public final int Conjunction() throws ParseException {
        int ret = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: 
            case 14: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        ret = 1;
                        break block0;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        ret = 2;
                        break block0;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return ret;
    }

    public final int Modifiers() throws ParseException {
        int ret = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 16: 
            case 17: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        ret = 11;
                        break block0;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        ret = 10;
                        break block0;
                    }
                    case 15: {
                        this.jj_consume_token(15);
                        ret = 10;
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        return ret;
    }

    @Override
    public final Query TopLevelQuery(String field) throws ParseException, SyntaxError {
        Query q = this.Query(field);
        this.jj_consume_token(0);
        return q;
    }

    public final Query Query(String field) throws ParseException, SyntaxError {
        Query firstQuery;
        ArrayList<BooleanClause> clauses;
        block14: {
            Query q;
            int mods;
            clauses = new ArrayList<BooleanClause>();
            if (this.jj_2_1(2)) {
                this.MultiTerm(field, clauses);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: {
                        mods = this.Modifiers();
                        q = this.Clause(field);
                        this.addClause(clauses, 0, mods, q);
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        break block14;
                    }
                }
                if (this.jj_2_2(2)) {
                    this.MultiTerm(field, clauses);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: {
                        int conj = this.Conjunction();
                        mods = this.Modifiers();
                        q = this.Clause(field);
                        this.addClause(clauses, conj, mods, q);
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[6] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (!(clauses.size() != 1 || ((BooleanClause)clauses.get(0)).getOccur() != BooleanClause.Occur.SHOULD || (firstQuery = ((BooleanClause)clauses.get(0)).getQuery()) instanceof SolrQueryParserBase.RawQuery && ((SolrQueryParserBase.RawQuery)firstQuery).getTermCount() != 1)) {
            return this.rawToNormal(firstQuery);
        }
        return this.getBooleanQuery(clauses);
    }

    public final Query Clause(String field) throws ParseException, SyntaxError {
        Query q;
        Token fieldToken = null;
        Token boost = null;
        Token localParams = null;
        int flags = 0;
        if (this.jj_2_3(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: {
                    fieldToken = this.jj_consume_token(25);
                    this.jj_consume_token(21);
                    field = this.discardEscapeChar(fieldToken.image);
                    break;
                }
                case 22: {
                    this.jj_consume_token(22);
                    this.jj_consume_token(21);
                    field = "*";
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block4 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                q = this.Term(field);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                q = this.Query(field);
                this.jj_consume_token(20);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        boost = this.jj_consume_token(34);
                        break block4;
                    }
                }
                this.jj_la1[8] = this.jj_gen;
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                flags = this.startFilter();
                q = this.Query(field);
                this.jj_consume_token(20);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        boost = this.jj_consume_token(34);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                q = this.getFilter(q);
                this.restoreFlags(flags);
                break;
            }
            case 32: {
                localParams = this.jj_consume_token(32);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        boost = this.jj_consume_token(34);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                q = this.getLocalParams(field, localParams.image);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.handleBoost(q, boost);
    }

    public final Query Term(String field) throws ParseException, SyntaxError {
        Query q;
        Token boost = null;
        Token fuzzySlop = null;
        boolean prefix = false;
        boolean wildcard = false;
        boolean fuzzy = false;
        boolean regexp = false;
        boolean startInc = false;
        boolean endInc = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 34: {
                Token term;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 25: {
                        term = this.jj_consume_token(25);
                        break;
                    }
                    case 22: {
                        term = this.jj_consume_token(22);
                        wildcard = true;
                        break;
                    }
                    case 27: {
                        term = this.jj_consume_token(27);
                        prefix = true;
                        break;
                    }
                    case 28: {
                        term = this.jj_consume_token(28);
                        wildcard = true;
                        break;
                    }
                    case 29: {
                        term = this.jj_consume_token(29);
                        regexp = true;
                        break;
                    }
                    case 34: {
                        term = this.jj_consume_token(34);
                        break;
                    }
                    case 18: {
                        term = this.jj_consume_token(18);
                        term.image = term.image.substring(0, 1);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block14 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: 
                    case 26: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 23: {
                                this.jj_consume_token(23);
                                boost = this.jj_consume_token(34);
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 26: {
                                        fuzzySlop = this.jj_consume_token(26);
                                        fuzzy = true;
                                        break block14;
                                    }
                                }
                                this.jj_la1[13] = this.jj_gen;
                                break block14;
                            }
                            case 26: {
                                fuzzySlop = this.jj_consume_token(26);
                                fuzzy = true;
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 23: {
                                        this.jj_consume_token(23);
                                        boost = this.jj_consume_token(34);
                                        break block14;
                                    }
                                }
                                this.jj_la1[14] = this.jj_gen;
                                break block14;
                            }
                        }
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                q = this.handleBareTokenQuery(this.getField(field), term, fuzzySlop, prefix, wildcard, fuzzy, regexp);
                break;
            }
            case 30: 
            case 31: {
                Token goop2;
                Token goop1;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 30: {
                        this.jj_consume_token(30);
                        startInc = true;
                        break;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        goop1 = this.jj_consume_token(39);
                        break;
                    }
                    case 38: {
                        goop1 = this.jj_consume_token(38);
                        break;
                    }
                    case 35: {
                        goop1 = this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(35);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        goop2 = this.jj_consume_token(39);
                        break;
                    }
                    case 38: {
                        goop2 = this.jj_consume_token(38);
                        break;
                    }
                    case 35: {
                        goop2 = this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 36: {
                        this.jj_consume_token(36);
                        endInc = true;
                        break;
                    }
                    case 37: {
                        this.jj_consume_token(37);
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        boost = this.jj_consume_token(34);
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                    }
                }
                boolean startOpen = false;
                boolean endOpen = false;
                if (goop1.kind == 38) {
                    goop1.image = goop1.image.substring(1, goop1.image.length() - 1);
                } else if ("*".equals(goop1.image)) {
                    startOpen = true;
                }
                if (goop2.kind == 38) {
                    goop2.image = goop2.image.substring(1, goop2.image.length() - 1);
                } else if ("*".equals(goop2.image)) {
                    endOpen = true;
                }
                q = this.getRangeQuery(this.getField(field), startOpen ? null : this.discardEscapeChar(goop1.image), endOpen ? null : this.discardEscapeChar(goop2.image), startInc, endInc);
                break;
            }
            case 24: {
                Token term = this.jj_consume_token(24);
                block48 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: 
                    case 26: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 23: {
                                this.jj_consume_token(23);
                                boost = this.jj_consume_token(34);
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 26: {
                                        fuzzySlop = this.jj_consume_token(26);
                                        fuzzy = true;
                                        break block48;
                                    }
                                }
                                this.jj_la1[22] = this.jj_gen;
                                break block48;
                            }
                            case 26: {
                                fuzzySlop = this.jj_consume_token(26);
                                fuzzy = true;
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 23: {
                                        this.jj_consume_token(23);
                                        boost = this.jj_consume_token(34);
                                        break block48;
                                    }
                                }
                                this.jj_la1[23] = this.jj_gen;
                                break block48;
                            }
                        }
                        this.jj_la1[24] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                    }
                }
                q = this.handleQuotedTerm(this.getField(field), term, fuzzySlop);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.handleBoost(q, boost);
    }

    public final void MultiTerm(String field, List<BooleanClause> clauses) throws ParseException, SyntaxError {
        Query q;
        ArrayList<String> terms = null;
        Token text = this.jj_consume_token(25);
        if (this.splitOnWhitespace) {
            q = this.getFieldQuery(this.getField(field), this.discardEscapeChar(text.image), false, true);
            this.addClause(clauses, 0, 0, q);
        } else {
            terms = new ArrayList<String>();
            terms.add(this.discardEscapeChar(text.image));
        }
        if (this.getToken((int)1).kind != 25 || !QueryParser.allowedPostMultiTerm(this.getToken((int)2).kind)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        do {
            text = this.jj_consume_token(25);
            if (this.splitOnWhitespace) {
                q = this.getFieldQuery(this.getField(field), this.discardEscapeChar(text.image), false, true);
                this.addClause(clauses, 0, 0, q);
                continue;
            }
            terms.add(this.discardEscapeChar(text.image));
        } while (this.getToken((int)1).kind == 25 && QueryParser.allowedPostMultiTerm(this.getToken((int)2).kind));
        if (!this.splitOnWhitespace) {
            q = this.getFieldQuery(this.getField(field), terms, true);
            this.addMultiTermClause(clauses, q);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    private boolean jj_3_2() {
        return this.jj_3R_MultiTerm_329_3_3();
    }

    private boolean jj_3R_Clause_252_9_5() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_MultiTerm_342_5_7() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_Clause_251_7_4() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_scan_token(21);
    }

    private boolean jj_3_1() {
        return this.jj_3R_MultiTerm_329_3_3();
    }

    private boolean jj_3R_MultiTerm_340_3_6() {
        return false;
    }

    private boolean jj_3R_MultiTerm_329_3_3() {
        Token xsp;
        if (this.jj_scan_token(25)) {
            return true;
        }
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 25 && QueryParser.allowedPostMultiTerm(this.getToken((int)2).kind);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_MultiTerm_340_3_6()) {
            return true;
        }
        if (this.jj_3R_MultiTerm_342_5_7()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_MultiTerm_342_5_7());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Clause_251_7_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Clause_252_9_5()) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{24576, 24576, 229376, 229376, -78675968, -78651392, -78651392, 0x2400000, 0x800000, 0x800000, 0x800000, -78905344, 977534976, 0x4000000, 0x800000, 0x4800000, 0x4800000, -1073741824, 0, 0, 0, 0x800000, 0x4000000, 0x800000, 0x4800000, 0x4800000, -79429632};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 7, 7, 7, 0, 0, 0, 0, 7, 4, 0, 0, 0, 0, 0, 200, 200, 48, 0, 0, 0, 0, 0, 4};
    }

    protected QueryParser(CharStream stream) {
        int i;
        this.token_source = new QueryParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    @Override
    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_lookingAhead = false;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    protected QueryParser(QueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(QueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[40];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 27; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 40; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 3; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        QueryParser.jj_la1_init_0();
        QueryParser.jj_la1_init_1();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static enum Operator {
        OR,
        AND;

    }
}

