/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.handler.export.DoubleComp;
import org.apache.solr.handler.export.SortValue;

class DoubleValue
implements SortValue {
    protected NumericDocValues vals;
    protected String field;
    protected double currentValue;
    protected DoubleComp comp;
    private int lastDocID;
    private LeafReader reader;
    private boolean present;

    public DoubleValue(String field, DoubleComp comp) {
        this.field = field;
        this.comp = comp;
        this.currentValue = comp.resetValue();
        this.present = false;
    }

    @Override
    public Object getCurrentValue() {
        assert (this.present);
        return this.currentValue;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public DoubleValue copy() {
        return new DoubleValue(this.field, this.comp);
    }

    @Override
    public void setNextReader(LeafReaderContext context) throws IOException {
        this.reader = context.reader();
        this.vals = DocValues.getNumeric((LeafReader)this.reader, (String)this.field);
        this.lastDocID = 0;
    }

    @Override
    public void setCurrentValue(int docId) throws IOException {
        if (docId < this.lastDocID) {
            throw new AssertionError((Object)("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs doc=" + docId));
        }
        this.lastDocID = docId;
        int curDocID = this.vals.docID();
        if (docId > curDocID) {
            curDocID = this.vals.advance(docId);
        }
        if (docId == curDocID) {
            this.present = true;
            this.currentValue = Double.longBitsToDouble(this.vals.longValue());
        } else {
            this.present = false;
            this.currentValue = 0.0;
        }
    }

    @Override
    public void toGlobalValue(SortValue previousValue) {
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public void setCurrentValue(SortValue sv) {
        DoubleValue dv = (DoubleValue)sv;
        this.currentValue = dv.currentValue;
        this.present = dv.present;
    }

    @Override
    public void reset() {
        this.currentValue = this.comp.resetValue();
        this.present = false;
    }

    @Override
    public int compareTo(SortValue o) {
        DoubleValue dv = (DoubleValue)o;
        return this.comp.compare(this.currentValue, dv.currentValue);
    }
}

