/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import java.util.Objects;
import java.util.function.Function;
import org.apache.solr.client.solrj.impl.NodeValueFetcher;
import org.apache.solr.cluster.placement.NodeMetric;
import org.apache.solr.cluster.placement.impl.MetricImpl;

public class NodeMetricImpl<T>
extends MetricImpl<T>
implements NodeMetric<T> {
    public static final NodeMetricImpl<Double> TOTAL_DISK_GB = new NodeMetricImpl("totalDisk", NodeMetric.Registry.SOLR_NODE, "CONTAINER.fs.totalSpace", BYTES_TO_GB_CONVERTER);
    public static final NodeMetricImpl<Double> FREE_DISK_GB = new NodeMetricImpl("freeDisk", NodeMetric.Registry.SOLR_NODE, "CONTAINER.fs.usableSpace", BYTES_TO_GB_CONVERTER);
    public static final NodeMetricImpl<Integer> NUM_CORES = new NodeMetricImpl("cores");
    public static final NodeMetricImpl<Double> HEAP_USAGE = new NodeMetricImpl(NodeValueFetcher.Tags.HEAPUSAGE.tagName);
    public static final NodeMetricImpl<Double> SYSLOAD_AVG = new NodeMetricImpl(NodeValueFetcher.Tags.SYSLOADAVG.tagName, NodeMetric.Registry.SOLR_JVM, NodeValueFetcher.Tags.SYSLOADAVG.prefix);
    public static final NodeMetricImpl<Integer> AVAILABLE_PROCESSORS = new NodeMetricImpl("availableProcessors", NodeMetric.Registry.SOLR_JVM, "os.availableProcessors");
    private final NodeMetric.Registry registry;

    public NodeMetricImpl(String name, NodeMetric.Registry registry, String internalName) {
        this(name, registry, internalName, null);
    }

    public NodeMetricImpl(String name, NodeMetric.Registry registry, String internalName, Function<Object, T> converter) {
        super(name, internalName, converter);
        Objects.requireNonNull(registry);
        this.registry = registry;
    }

    public NodeMetricImpl(String key) {
        this(key, (Function<Object, T>)null);
    }

    public NodeMetricImpl(String key, Function<Object, T> converter) {
        super(key, key, converter);
        this.registry = NodeMetric.Registry.UNSPECIFIED;
    }

    @Override
    public NodeMetric.Registry getRegistry() {
        return this.registry;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeMetricImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeMetricImpl that = (NodeMetricImpl)o;
        return this.registry == that.registry;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.registry});
    }

    @Override
    public String toString() {
        if (this.registry != null) {
            return "NodeMetricImpl{name='" + this.name + "', internalName='" + this.internalName + "', converter=" + this.converter + ", registry=" + this.registry + "}";
        }
        return "NodeMetricImpl{key=" + this.internalName + "}";
    }
}

