/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr;

import org.apache.solr.ltr.FeatureLogger;
import org.apache.solr.ltr.LTRScoringQuery;

public class CSVFeatureLogger
extends FeatureLogger {
    public static final char DEFAULT_KEY_VALUE_SEPARATOR = '=';
    public static final char DEFAULT_FEATURE_SEPARATOR = ',';
    private final char keyValueSep;
    private final char featureSep;

    public CSVFeatureLogger(String fvCacheName, FeatureLogger.FeatureFormat f, Boolean logAll) {
        super(fvCacheName, f, logAll);
        this.keyValueSep = (char)61;
        this.featureSep = (char)44;
    }

    public CSVFeatureLogger(String fvCacheName, FeatureLogger.FeatureFormat f, Boolean logAll, char keyValueSep, char featureSep) {
        super(fvCacheName, f, logAll);
        this.keyValueSep = keyValueSep;
        this.featureSep = featureSep;
    }

    @Override
    public String makeFeatureVector(LTRScoringQuery.FeatureInfo[] featuresInfo) {
        StringBuilder sb = new StringBuilder(featuresInfo.length * 3);
        boolean isDense = this.featureFormat.equals((Object)FeatureLogger.FeatureFormat.DENSE);
        for (LTRScoringQuery.FeatureInfo featInfo : featuresInfo) {
            if (featInfo == null || !isDense && !featInfo.isUsed()) continue;
            sb.append(featInfo.getName()).append(this.keyValueSep).append(featInfo.getValue()).append(this.featureSep);
        }
        String features = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
        return features;
    }
}

