/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;

public class QueryLabelFilter
extends SingleLabelFilterBase {
    public QueryLabelFilter() {
        super("Query label filter enabled");
    }

    @Override
    public boolean acceptPhrase(PreprocessingContext context, int phraseIndex) {
        int[] wordIndices = context.allPhrases.wordIndices[phraseIndex];
        short[] flag = context.allWords.type;
        for (int i = 0; i < wordIndices.length; ++i) {
            if (this.isQueryWord(flag[wordIndices[i]])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptWord(PreprocessingContext context, int wordIndex) {
        return !this.isQueryWord(context.allWords.type[wordIndex]);
    }

    private final boolean isQueryWord(short flag) {
        return (flag & 0x2000) != 0;
    }
}

