# This file was automatically generated by bifcl from /local/pobj/zeek-8.0.3/zeek-8.0.3/src/analyzer/protocol/sip/events.bif (plugin mode).

export {
## Generated for :abbr:`SIP (Session Initiation Protocol)` requests, used in Voice over IP (VoIP).
##
## This event is generated as soon as a request's initial line has been parsed.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Session_Initiation_Protocol>`__
## for more information about the :abbr:`SIP (Session Initiation Protocol)` protocol.
##
## c: The connection.
##
## method: The :abbr:`SIP (Session Initiation Protocol)` method extracted from the request (e.g., ``REGISTER``, ``NOTIFY``).
##
## original_URI: The unprocessed URI as specified in the request.
##
## version: The version number specified in the request (e.g., ``2.0``).
##
## .. zeek:see:: sip_reply sip_header sip_all_headers sip_begin_entity sip_end_entity
global sip_request: event(c: connection , method: string , original_URI: string , version: string );


## Generated for :abbr:`SIP (Session Initiation Protocol)` replies, used in Voice over IP (VoIP).
##
## This event is generated as soon as a reply's initial line has been parsed.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Session_Initiation_Protocol>`__
## for more information about the :abbr:`SIP (Session Initiation Protocol)` protocol.
##
## c: The connection.
##
## version: The :abbr:`SIP (Session Initiation Protocol)` version in use.
##
## code: The response code.
##
## reason: Textual details for the response code.
##
## .. zeek:see:: sip_request sip_header sip_all_headers sip_begin_entity sip_end_entity
global sip_reply: event(c: connection , version: string , code: count , reason: string );


## Generated for each :abbr:`SIP (Session Initiation Protocol)` header.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Session_Initiation_Protocol>`__
## for more information about the :abbr:`SIP (Session Initiation Protocol)` protocol.
##
## c: The connection.
##
## is_orig: Whether the header came from the originator.
##
## name: Header name.
##
## value: Header value.
##
## .. zeek:see:: sip_request sip_reply sip_all_headers sip_begin_entity sip_end_entity
global sip_header: event(c: connection , is_orig: bool , name: string , value: string );


## Generated once for all :abbr:`SIP (Session Initiation Protocol)` headers from the originator or responder.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Session_Initiation_Protocol>`__
## for more information about the :abbr:`SIP (Session Initiation Protocol)` protocol.
##
## c: The connection.
##
## is_orig: Whether the headers came from the originator.
##
## hlist: All the headers, and their values
##
## .. zeek:see:: sip_request sip_reply sip_header sip_begin_entity sip_end_entity
global sip_all_headers: event(c: connection , is_orig: bool , hlist: mime_header_list );


## Generated at the beginning of a :abbr:`SIP (Session Initiation Protocol)` message.
##
## This event is generated as soon as a message's initial line has been parsed.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Session_Initiation_Protocol>`__
## for more information about the :abbr:`SIP (Session Initiation Protocol)` protocol.
##
## c: The connection.
##
## is_orig: Whether the message came from the originator.
##
## .. zeek:see:: sip_request sip_reply sip_header sip_all_headers sip_end_entity
global sip_begin_entity: event(c: connection , is_orig: bool );


## Generated at the end of a :abbr:`SIP (Session Initiation Protocol)` message.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Session_Initiation_Protocol>`__
## for more information about the :abbr:`SIP (Session Initiation Protocol)` protocol.
##
## c: The connection.
##
## is_orig: Whether the message came from the originator.
##
## .. zeek:see:: sip_request sip_reply sip_header sip_all_headers sip_begin_entity
global sip_end_entity: event(c: connection , is_orig: bool );

} # end of export section
module GLOBAL;
