/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser;

import java.io.IOException;
import java.io.InputStream;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.parser.CSSParserContext;
import org.jfree.layouting.input.style.parser.CSSParserFactory;
import org.jfree.layouting.input.style.parser.CSSParserInstantiationException;
import org.jfree.layouting.input.style.parser.StyleSheetHandler;
import org.pentaho.reporting.libraries.resourceloader.CompoundResource;
import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;

public class StyleSheetFactory
implements ResourceFactory {
    public Resource create(ResourceManager resourceManager, ResourceData resourceData, ResourceKey resourceKey) throws ResourceCreationException, ResourceLoadingException {
        try {
            long l;
            ResourceKey resourceKey2;
            Parser parser = CSSParserFactory.getInstance().createCSSParser();
            if (resourceKey == null) {
                resourceKey2 = resourceData.getKey();
                l = resourceData.getVersion(resourceManager);
            } else {
                resourceKey2 = resourceKey;
                l = -1L;
            }
            StyleSheetHandler styleSheetHandler = new StyleSheetHandler();
            styleSheetHandler.init(resourceManager, resourceKey2, l, StyleKeyRegistry.getRegistry(), null);
            parser.setDocumentHandler((DocumentHandler)styleSheetHandler);
            parser.setErrorHandler((ErrorHandler)styleSheetHandler);
            InputStream inputStream = resourceData.getResourceAsStream(resourceManager);
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(inputStream);
            parser.parseStyleSheet(inputSource);
            DependencyCollector dependencyCollector = styleSheetHandler.getDependencies();
            if (resourceKey != null) {
                dependencyCollector.add(resourceData.getKey(), resourceData.getVersion(resourceManager));
            }
            CSSParserContext.getContext().destroy();
            CompoundResource compoundResource = new CompoundResource(resourceData.getKey(), dependencyCollector, (Object)styleSheetHandler.getStyleSheet(), this.getFactoryType());
            return compoundResource;
        }
        catch (CSSParserInstantiationException cSSParserInstantiationException) {
            throw new ResourceCreationException("Failed to parse the stylesheet.");
        }
        catch (IOException iOException) {
            throw new ResourceLoadingException("Failed to load the stylesheet.");
        }
    }

    public Class getFactoryType() {
        return StyleSheet.class;
    }

    public void initializeDefaults() {
    }
}

