/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.memory;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.Constants;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedObject;

public final class MetaspaceSummaryHandler
implements RecordedEventHandler {
    private static final String EVENT_NAME = "jdk.MetaspaceSummary";
    private static final Attributes ATTR_MEMORY_METASPACE = Attributes.of(Constants.ATTR_MEMORY_TYPE, (Object)"non_heap", Constants.ATTR_MEMORY_POOL, (Object)"Metaspace");
    private static final Attributes ATTR_MEMORY_COMPRESSED_CLASS_SPACE = Attributes.of(Constants.ATTR_MEMORY_TYPE, (Object)"non_heap", Constants.ATTR_MEMORY_POOL, (Object)"Compressed Class Space");
    private final List<AutoCloseable> observables = new ArrayList<AutoCloseable>();
    private volatile long classUsage = 0L;
    private volatile long classCommitted = 0L;
    private volatile long totalUsage = 0L;
    private volatile long totalCommitted = 0L;
    private volatile long classLimit = 0L;
    private volatile long totalLimit = 0L;

    public MetaspaceSummaryHandler(Meter meter) {
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.used").setDescription("Measure of memory used.").setUnit("By").buildWithCallback(measurement -> {
            measurement.record(this.classUsage, ATTR_MEMORY_COMPRESSED_CLASS_SPACE);
            measurement.record(this.totalUsage, ATTR_MEMORY_METASPACE);
        }));
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.committed").setDescription("Measure of memory committed.").setUnit("By").buildWithCallback(measurement -> {
            measurement.record(this.classCommitted, ATTR_MEMORY_COMPRESSED_CLASS_SPACE);
            measurement.record(this.totalCommitted, ATTR_MEMORY_METASPACE);
        }));
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.limit").setDescription("Measure of max obtainable memory.").setUnit("By").buildWithCallback(measurement -> {
            measurement.record(this.classLimit, ATTR_MEMORY_COMPRESSED_CLASS_SPACE);
            measurement.record(this.totalLimit, ATTR_MEMORY_METASPACE);
        }));
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.MEMORY_POOL_METRICS;
    }

    @Override
    public void accept(RecordedEvent event) {
        MetaspaceSummaryHandler.doIfAvailable(event, "classSpace", classSpace -> {
            if (classSpace.hasField("committed")) {
                this.classCommitted = classSpace.getLong("committed");
            }
            if (classSpace.hasField("used")) {
                this.classUsage = classSpace.getLong("used");
            }
            if (classSpace.hasField("reserved")) {
                this.classLimit = classSpace.getLong("reserved");
            }
        });
        MetaspaceSummaryHandler.doIfAvailable(event, "metaspace", metaspace -> {
            if (metaspace.hasField("committed")) {
                this.totalCommitted = metaspace.getLong("committed");
            }
            if (metaspace.hasField("used")) {
                this.totalUsage = metaspace.getLong("used");
            }
            if (metaspace.hasField("reserved")) {
                this.totalLimit = metaspace.getLong("reserved");
            }
        });
    }

    private static void doIfAvailable(RecordedEvent event, String field, Consumer<RecordedObject> closure) {
        if (!event.hasField(field)) {
            return;
        }
        Object value = event.getValue(field);
        if (value instanceof RecordedObject) {
            closure.accept((RecordedObject)value);
        }
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.ofSeconds(1L));
    }

    @Override
    public void close() {
        RecordedEventHandler.closeObservables(this.observables);
    }
}

