/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.httppost;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.httppost.HTTPPOSTData;
import org.pentaho.di.trans.steps.httppost.HTTPPOSTMeta;
import org.pentaho.di.trans.steps.httppost.Messages;

public class HTTPPOST
extends BaseStep
implements StepInterface {
    private HTTPPOSTMeta meta;
    private HTTPPOSTData data;

    public HTTPPOST(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] callHTTPPOST(Object[] rowData) throws KettleException {
        if (this.meta.isUrlInField()) {
            this.data.realUrl = this.data.inputRowMeta.getString(rowData, this.data.indexOfUrlField);
        }
        try {
            Object[] objectArray;
            PostMethod post;
            block20: {
                int i;
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("HTTPPOST.Log.ConnectingToURL", this.data.realUrl));
                }
                HttpClient HTTPPOSTclient = new HttpClient();
                post = new PostMethod(this.data.realUrl);
                if (Const.isEmpty((String)this.data.realEncoding)) {
                    post.setRequestHeader("Content-type", "text/xml");
                } else {
                    post.setRequestHeader("Content-type", "text/xml; " + this.data.realEncoding);
                }
                if (this.data.useBodyParameters) {
                    for (i = 0; i < this.data.body_parameters_nrs.length; ++i) {
                        this.data.bodyParameters[i].setValue(this.data.inputRowMeta.getString(rowData, this.data.body_parameters_nrs[i]));
                    }
                    post.setRequestBody(this.data.bodyParameters);
                }
                if (this.data.useQueryParameters) {
                    for (i = 0; i < this.data.query_parameters_nrs.length; ++i) {
                        this.data.queryParameters[i].setValue(this.data.inputRowMeta.getString(rowData, this.data.query_parameters_nrs[i]));
                    }
                    post.setQueryString(this.data.queryParameters);
                }
                if (this.data.indexOfRequestEntity >= 0) {
                    String tmp = this.data.inputRowMeta.getString(rowData, this.data.indexOfRequestEntity);
                    if (this.meta.isPostAFile()) {
                        File input = new File(tmp);
                        post.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new FileInputStream(input), input.length()));
                    } else {
                        post.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(tmp.getBytes()), (long)tmp.length()));
                    }
                }
                InputStream inputStream = null;
                try {
                    int statusCode = HTTPPOSTclient.executeMethod((HttpMethod)post);
                    if (this.log.isDebug()) {
                        this.log.logDebug(this.toString(), Messages.getString("HTTPPOST.Log.ResponseCode", "" + statusCode), new Object[0]);
                    }
                    String body = null;
                    if (statusCode != -1) {
                        int c;
                        inputStream = post.getResponseBodyAsStream();
                        StringBuffer bodyBuffer = new StringBuffer();
                        while ((c = inputStream.read()) != -1) {
                            bodyBuffer.append((char)c);
                        }
                        inputStream.close();
                        body = bodyBuffer.toString();
                        if (this.log.isDebug()) {
                            this.log.logDebug(this.toString(), Messages.getString("HTTPPOST.Log.ResponseBody", body), new Object[0]);
                        }
                    }
                    objectArray = RowDataUtil.addValueData((Object[])rowData, (int)this.data.inputRowMeta.size(), body);
                    Object var10_13 = null;
                    if (inputStream == null) break block20;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    post.releaseConnection();
                    throw throwable;
                }
                inputStream.close();
            }
            post.releaseConnection();
            return objectArray;
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("HTTPPOST.Error.CanNotReadURL", this.data.realUrl), (Throwable)e);
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block19: {
            this.meta = (HTTPPOSTMeta)smi;
            this.data = (HTTPPOSTData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int nrQuery;
                int nrargs;
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                if (this.meta.isUrlInField()) {
                    if (Const.isEmpty((String)this.meta.getUrlField())) {
                        this.logError(Messages.getString("HTTPPOST.Log.NoField"));
                        throw new KettleException(Messages.getString("HTTPPOST.Log.NoField"));
                    }
                    if (this.data.indexOfUrlField < 0) {
                        String realUrlfieldName = this.environmentSubstitute(this.meta.getUrlField());
                        this.data.indexOfUrlField = this.data.inputRowMeta.indexOfValue(realUrlfieldName);
                        if (this.data.indexOfUrlField < 0) {
                            this.logError(Messages.getString("HTTPPOST.Log.ErrorFindingField", realUrlfieldName));
                            throw new KettleException(Messages.getString("HTTPPOST.Exception.ErrorFindingField", realUrlfieldName));
                        }
                    }
                } else {
                    this.data.realUrl = this.environmentSubstitute(this.meta.getUrl());
                }
                if ((nrargs = this.meta.getArgumentField().length) > 0) {
                    this.data.useBodyParameters = true;
                    this.data.body_parameters_nrs = new int[nrargs];
                    this.data.bodyParameters = new NameValuePair[nrargs];
                    for (int i = 0; i < nrargs; ++i) {
                        this.data.body_parameters_nrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getArgumentField()[i]);
                        if (this.data.body_parameters_nrs[i] < 0) {
                            this.logError(Messages.getString("HTTPPOST.Log.ErrorFindingField") + this.meta.getArgumentField()[i] + "]");
                            throw new KettleStepException(Messages.getString("HTTPPOST.Exception.CouldnotFindField", this.meta.getArgumentField()[i]));
                        }
                        this.data.bodyParameters[i] = new NameValuePair(this.environmentSubstitute(this.meta.getArgumentParameter()[i]), this.data.outputRowMeta.getString(r, this.data.body_parameters_nrs[i]));
                    }
                }
                if ((nrQuery = this.meta.getQueryField().length) > 0) {
                    this.data.useQueryParameters = true;
                    this.data.query_parameters_nrs = new int[nrQuery];
                    this.data.queryParameters = new NameValuePair[nrQuery];
                    for (int i = 0; i < nrQuery; ++i) {
                        this.data.query_parameters_nrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getQueryField()[i]);
                        if (this.data.query_parameters_nrs[i] < 0) {
                            this.logError(Messages.getString("HTTPPOST.Log.ErrorFindingField") + this.meta.getQueryField()[i] + "]");
                            throw new KettleStepException(Messages.getString("HTTPPOST.Exception.CouldnotFindField", this.meta.getQueryField()[i]));
                        }
                        this.data.queryParameters[i] = new NameValuePair(this.environmentSubstitute(this.meta.getQueryParameter()[i]), this.data.outputRowMeta.getString(r, this.data.query_parameters_nrs[i]));
                    }
                }
                if (!Const.isEmpty((String)this.meta.getRequestEntity())) {
                    this.data.indexOfRequestEntity = this.data.inputRowMeta.indexOfValue(this.environmentSubstitute(this.meta.getRequestEntity()));
                    if (this.data.indexOfRequestEntity < 0) {
                        throw new KettleStepException(Messages.getString("HTTPPOST.Exception.CouldnotFindRequestEntityField", this.meta.getRequestEntity()));
                    }
                }
                this.data.realEncoding = this.environmentSubstitute(this.meta.getEncoding());
            }
            try {
                Object[] outputRowData = this.callHTTPPOST(r);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("HTTPPOST.LineNumber") + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("HTTPPOST.ErrorInStepRunning") + e.getMessage());
                    this.setErrors(1L);
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block19;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "HTTPPOST001");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPPOSTMeta)smi;
        this.data = (HTTPPOSTData)sdi;
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPPOSTMeta)smi;
        this.data = (HTTPPOSTData)sdi;
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

