/* DO NOT EDIT - This file generated automatically by api_exec_decl_h.py script */

/*
 * Copyright (C) 2012 Intel Corporation
 * Copyright (C) 2021 Advanced Micro Devices, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.  IN NO EVENT SHALL
 * AUTHORS,
 * AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
 * OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef API_EXEC_DECL_H
#define API_EXEC_DECL_H

#include "util/glheader.h"

#ifdef __cplusplus
extern "C" {
#endif

void GLAPIENTRY _mesa_NewList(GLuint list, GLenum mode);
void GLAPIENTRY _mesa_EndList(void);
void GLAPIENTRY _mesa_CallList(GLuint list);
void GLAPIENTRY _mesa_CallLists(GLsizei n, GLenum type, const GLvoid *lists);
void GLAPIENTRY _mesa_DeleteLists(GLuint list, GLsizei range);
GLuint GLAPIENTRY _mesa_GenLists(GLsizei range);
void GLAPIENTRY _mesa_ListBase(GLuint base);
void GLAPIENTRY _mesa_Begin(GLenum mode);
void GLAPIENTRY _mesa_Bitmap(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
void GLAPIENTRY _mesa_Color3b(GLbyte red, GLbyte green, GLbyte blue);
void GLAPIENTRY _mesa_Color3bv(const GLbyte *v);
void GLAPIENTRY _mesa_Color3d(GLdouble red, GLdouble green, GLdouble blue);
void GLAPIENTRY _mesa_Color3dv(const GLdouble *v);
void GLAPIENTRY _mesa_Color3f(GLfloat red, GLfloat green, GLfloat blue);
void GLAPIENTRY _mesa_Color3fv(const GLfloat *v);
void GLAPIENTRY _mesa_Color3i(GLint red, GLint green, GLint blue);
void GLAPIENTRY _mesa_Color3iv(const GLint *v);
void GLAPIENTRY _mesa_Color3s(GLshort red, GLshort green, GLshort blue);
void GLAPIENTRY _mesa_Color3sv(const GLshort *v);
void GLAPIENTRY _mesa_Color3ub(GLubyte red, GLubyte green, GLubyte blue);
void GLAPIENTRY _mesa_Color3ubv(const GLubyte *v);
void GLAPIENTRY _mesa_Color3ui(GLuint red, GLuint green, GLuint blue);
void GLAPIENTRY _mesa_Color3uiv(const GLuint *v);
void GLAPIENTRY _mesa_Color3us(GLushort red, GLushort green, GLushort blue);
void GLAPIENTRY _mesa_Color3usv(const GLushort *v);
void GLAPIENTRY _mesa_Color4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
void GLAPIENTRY _mesa_Color4bv(const GLbyte *v);
void GLAPIENTRY _mesa_Color4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
void GLAPIENTRY _mesa_Color4dv(const GLdouble *v);
void GLAPIENTRY _mesa_Color4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void GLAPIENTRY _mesa_Color4fv(const GLfloat *v);
void GLAPIENTRY _mesa_Color4i(GLint red, GLint green, GLint blue, GLint alpha);
void GLAPIENTRY _mesa_Color4iv(const GLint *v);
void GLAPIENTRY _mesa_Color4s(GLshort red, GLshort green, GLshort blue, GLshort alpha);
void GLAPIENTRY _mesa_Color4sv(const GLshort *v);
void GLAPIENTRY _mesa_Color4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
void GLAPIENTRY _mesa_Color4ubv(const GLubyte *v);
void GLAPIENTRY _mesa_Color4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha);
void GLAPIENTRY _mesa_Color4uiv(const GLuint *v);
void GLAPIENTRY _mesa_Color4us(GLushort red, GLushort green, GLushort blue, GLushort alpha);
void GLAPIENTRY _mesa_Color4usv(const GLushort *v);
void GLAPIENTRY _mesa_EdgeFlag(GLboolean flag);
void GLAPIENTRY _mesa_EdgeFlagv(const GLboolean *flag);
void GLAPIENTRY _mesa_End(void);
void GLAPIENTRY _mesa_Indexd(GLdouble c);
void GLAPIENTRY _mesa_Indexdv(const GLdouble *c);
void GLAPIENTRY _mesa_Indexf(GLfloat c);
void GLAPIENTRY _mesa_Indexfv(const GLfloat *c);
void GLAPIENTRY _mesa_Indexi(GLint c);
void GLAPIENTRY _mesa_Indexiv(const GLint *c);
void GLAPIENTRY _mesa_Indexs(GLshort c);
void GLAPIENTRY _mesa_Indexsv(const GLshort *c);
void GLAPIENTRY _mesa_Normal3b(GLbyte nx, GLbyte ny, GLbyte nz);
void GLAPIENTRY _mesa_Normal3bv(const GLbyte *v);
void GLAPIENTRY _mesa_Normal3d(GLdouble nx, GLdouble ny, GLdouble nz);
void GLAPIENTRY _mesa_Normal3dv(const GLdouble *v);
void GLAPIENTRY _mesa_Normal3f(GLfloat nx, GLfloat ny, GLfloat nz);
void GLAPIENTRY _mesa_Normal3fv(const GLfloat *v);
void GLAPIENTRY _mesa_Normal3i(GLint nx, GLint ny, GLint nz);
void GLAPIENTRY _mesa_Normal3iv(const GLint *v);
void GLAPIENTRY _mesa_Normal3s(GLshort nx, GLshort ny, GLshort nz);
void GLAPIENTRY _mesa_Normal3sv(const GLshort *v);
void GLAPIENTRY _mesa_RasterPos2d(GLdouble x, GLdouble y);
void GLAPIENTRY _mesa_RasterPos2dv(const GLdouble *v);
void GLAPIENTRY _mesa_RasterPos2f(GLfloat x, GLfloat y);
void GLAPIENTRY _mesa_RasterPos2fv(const GLfloat *v);
void GLAPIENTRY _mesa_RasterPos2i(GLint x, GLint y);
void GLAPIENTRY _mesa_RasterPos2iv(const GLint *v);
void GLAPIENTRY _mesa_RasterPos2s(GLshort x, GLshort y);
void GLAPIENTRY _mesa_RasterPos2sv(const GLshort *v);
void GLAPIENTRY _mesa_RasterPos3d(GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_RasterPos3dv(const GLdouble *v);
void GLAPIENTRY _mesa_RasterPos3f(GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_RasterPos3fv(const GLfloat *v);
void GLAPIENTRY _mesa_RasterPos3i(GLint x, GLint y, GLint z);
void GLAPIENTRY _mesa_RasterPos3iv(const GLint *v);
void GLAPIENTRY _mesa_RasterPos3s(GLshort x, GLshort y, GLshort z);
void GLAPIENTRY _mesa_RasterPos3sv(const GLshort *v);
void GLAPIENTRY _mesa_RasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLAPIENTRY _mesa_RasterPos4dv(const GLdouble *v);
void GLAPIENTRY _mesa_RasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void GLAPIENTRY _mesa_RasterPos4fv(const GLfloat *v);
void GLAPIENTRY _mesa_RasterPos4i(GLint x, GLint y, GLint z, GLint w);
void GLAPIENTRY _mesa_RasterPos4iv(const GLint *v);
void GLAPIENTRY _mesa_RasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w);
void GLAPIENTRY _mesa_RasterPos4sv(const GLshort *v);
void GLAPIENTRY _mesa_Rectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
void GLAPIENTRY _mesa_Rectdv(const GLdouble *v1, const GLdouble *v2);
void GLAPIENTRY _mesa_Rectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
void GLAPIENTRY _mesa_Rectfv(const GLfloat *v1, const GLfloat *v2);
void GLAPIENTRY _mesa_Recti(GLint x1, GLint y1, GLint x2, GLint y2);
void GLAPIENTRY _mesa_Rectiv(const GLint *v1, const GLint *v2);
void GLAPIENTRY _mesa_Rects(GLshort x1, GLshort y1, GLshort x2, GLshort y2);
void GLAPIENTRY _mesa_Rectsv(const GLshort *v1, const GLshort *v2);
void GLAPIENTRY _mesa_TexCoord1d(GLdouble s);
void GLAPIENTRY _mesa_TexCoord1dv(const GLdouble *v);
void GLAPIENTRY _mesa_TexCoord1f(GLfloat s);
void GLAPIENTRY _mesa_TexCoord1fv(const GLfloat *v);
void GLAPIENTRY _mesa_TexCoord1i(GLint s);
void GLAPIENTRY _mesa_TexCoord1iv(const GLint *v);
void GLAPIENTRY _mesa_TexCoord1s(GLshort s);
void GLAPIENTRY _mesa_TexCoord1sv(const GLshort *v);
void GLAPIENTRY _mesa_TexCoord2d(GLdouble s, GLdouble t);
void GLAPIENTRY _mesa_TexCoord2dv(const GLdouble *v);
void GLAPIENTRY _mesa_TexCoord2f(GLfloat s, GLfloat t);
void GLAPIENTRY _mesa_TexCoord2fv(const GLfloat *v);
void GLAPIENTRY _mesa_TexCoord2i(GLint s, GLint t);
void GLAPIENTRY _mesa_TexCoord2iv(const GLint *v);
void GLAPIENTRY _mesa_TexCoord2s(GLshort s, GLshort t);
void GLAPIENTRY _mesa_TexCoord2sv(const GLshort *v);
void GLAPIENTRY _mesa_TexCoord3d(GLdouble s, GLdouble t, GLdouble r);
void GLAPIENTRY _mesa_TexCoord3dv(const GLdouble *v);
void GLAPIENTRY _mesa_TexCoord3f(GLfloat s, GLfloat t, GLfloat r);
void GLAPIENTRY _mesa_TexCoord3fv(const GLfloat *v);
void GLAPIENTRY _mesa_TexCoord3i(GLint s, GLint t, GLint r);
void GLAPIENTRY _mesa_TexCoord3iv(const GLint *v);
void GLAPIENTRY _mesa_TexCoord3s(GLshort s, GLshort t, GLshort r);
void GLAPIENTRY _mesa_TexCoord3sv(const GLshort *v);
void GLAPIENTRY _mesa_TexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q);
void GLAPIENTRY _mesa_TexCoord4dv(const GLdouble *v);
void GLAPIENTRY _mesa_TexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q);
void GLAPIENTRY _mesa_TexCoord4fv(const GLfloat *v);
void GLAPIENTRY _mesa_TexCoord4i(GLint s, GLint t, GLint r, GLint q);
void GLAPIENTRY _mesa_TexCoord4iv(const GLint *v);
void GLAPIENTRY _mesa_TexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q);
void GLAPIENTRY _mesa_TexCoord4sv(const GLshort *v);
void GLAPIENTRY _mesa_Vertex2d(GLdouble x, GLdouble y);
void GLAPIENTRY _mesa_Vertex2dv(const GLdouble *v);
void GLAPIENTRY _mesa_Vertex2f(GLfloat x, GLfloat y);
void GLAPIENTRY _mesa_Vertex2fv(const GLfloat *v);
void GLAPIENTRY _mesa_Vertex2i(GLint x, GLint y);
void GLAPIENTRY _mesa_Vertex2iv(const GLint *v);
void GLAPIENTRY _mesa_Vertex2s(GLshort x, GLshort y);
void GLAPIENTRY _mesa_Vertex2sv(const GLshort *v);
void GLAPIENTRY _mesa_Vertex3d(GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_Vertex3dv(const GLdouble *v);
void GLAPIENTRY _mesa_Vertex3f(GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_Vertex3fv(const GLfloat *v);
void GLAPIENTRY _mesa_Vertex3i(GLint x, GLint y, GLint z);
void GLAPIENTRY _mesa_Vertex3iv(const GLint *v);
void GLAPIENTRY _mesa_Vertex3s(GLshort x, GLshort y, GLshort z);
void GLAPIENTRY _mesa_Vertex3sv(const GLshort *v);
void GLAPIENTRY _mesa_Vertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLAPIENTRY _mesa_Vertex4dv(const GLdouble *v);
void GLAPIENTRY _mesa_Vertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void GLAPIENTRY _mesa_Vertex4fv(const GLfloat *v);
void GLAPIENTRY _mesa_Vertex4i(GLint x, GLint y, GLint z, GLint w);
void GLAPIENTRY _mesa_Vertex4iv(const GLint *v);
void GLAPIENTRY _mesa_Vertex4s(GLshort x, GLshort y, GLshort z, GLshort w);
void GLAPIENTRY _mesa_Vertex4sv(const GLshort *v);
void GLAPIENTRY _mesa_ClipPlane(GLenum plane, const GLdouble *equation);
void GLAPIENTRY _mesa_ColorMaterial(GLenum face, GLenum mode);
void GLAPIENTRY _mesa_CullFace(GLenum mode);
void GLAPIENTRY _mesa_CullFace_no_error(GLenum mode);
void GLAPIENTRY _mesa_Fogf(GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_Fogfv(GLenum pname, const GLfloat *params);
void GLAPIENTRY _mesa_Fogi(GLenum pname, GLint param);
void GLAPIENTRY _mesa_Fogiv(GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_FrontFace(GLenum mode);
void GLAPIENTRY _mesa_FrontFace_no_error(GLenum mode);
void GLAPIENTRY _mesa_Hint(GLenum target, GLenum mode);
void GLAPIENTRY _mesa_Lightf(GLenum light, GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_Lightfv(GLenum light, GLenum pname, const GLfloat *params);
void GLAPIENTRY _mesa_Lighti(GLenum light, GLenum pname, GLint param);
void GLAPIENTRY _mesa_Lightiv(GLenum light, GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_LightModelf(GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_LightModelfv(GLenum pname, const GLfloat *params);
void GLAPIENTRY _mesa_LightModeli(GLenum pname, GLint param);
void GLAPIENTRY _mesa_LightModeliv(GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_LineStipple(GLint factor, GLushort pattern);
void GLAPIENTRY _mesa_LineWidth(GLfloat width);
void GLAPIENTRY _mesa_LineWidth_no_error(GLfloat width);
void GLAPIENTRY _mesa_Materialf(GLenum face, GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_Materialfv(GLenum face, GLenum pname, const GLfloat *params);
void GLAPIENTRY _mesa_Materiali(GLenum face, GLenum pname, GLint param);
void GLAPIENTRY _mesa_Materialiv(GLenum face, GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_PointSize(GLfloat size);
void GLAPIENTRY _mesa_PointSize_no_error(GLfloat size);
void GLAPIENTRY _mesa_PolygonMode(GLenum face, GLenum mode);
void GLAPIENTRY _mesa_PolygonMode_no_error(GLenum face, GLenum mode);
void GLAPIENTRY _mesa_PolygonStipple(const GLubyte *mask);
void GLAPIENTRY _mesa_Scissor(GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_Scissor_no_error(GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_ShadeModel(GLenum mode);
void GLAPIENTRY _mesa_TexParameterf(GLenum target, GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_TexParameterfv(GLenum target, GLenum pname, const GLfloat *params);
void GLAPIENTRY _mesa_TexParameteri(GLenum target, GLenum pname, GLint param);
void GLAPIENTRY _mesa_TexParameteriv(GLenum target, GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_TexImage1D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TexImage1D_no_error(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TexImage2D_no_error(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TexEnvf(GLenum target, GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_TexEnvfv(GLenum target, GLenum pname, const GLfloat *params);
void GLAPIENTRY _mesa_TexEnvi(GLenum target, GLenum pname, GLint param);
void GLAPIENTRY _mesa_TexEnviv(GLenum target, GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_TexGend(GLenum coord, GLenum pname, GLdouble param);
void GLAPIENTRY _mesa_TexGendv(GLenum coord, GLenum pname, const GLdouble *params);
void GLAPIENTRY _mesa_TexGenf(GLenum coord, GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_TexGenfv(GLenum coord, GLenum pname, const GLfloat *params);
void GLAPIENTRY _mesa_TexGeni(GLenum coord, GLenum pname, GLint param);
void GLAPIENTRY _mesa_TexGeniv(GLenum coord, GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_FeedbackBuffer(GLsizei size, GLenum type, GLfloat *buffer);
void GLAPIENTRY _mesa_SelectBuffer(GLsizei size, GLuint *buffer);
GLint GLAPIENTRY _mesa_RenderMode(GLenum mode);
void GLAPIENTRY _mesa_InitNames(void);
void GLAPIENTRY _mesa_LoadName(GLuint name);
void GLAPIENTRY _mesa_PassThrough(GLfloat token);
void GLAPIENTRY _mesa_PopName(void);
void GLAPIENTRY _mesa_PushName(GLuint name);
void GLAPIENTRY _mesa_DrawBuffer(GLenum mode);
void GLAPIENTRY _mesa_DrawBuffer_no_error(GLenum mode);
void GLAPIENTRY _mesa_Clear(GLbitfield mask);
void GLAPIENTRY _mesa_Clear_no_error(GLbitfield mask);
void GLAPIENTRY _mesa_ClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void GLAPIENTRY _mesa_ClearIndex(GLfloat c);
void GLAPIENTRY _mesa_ClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
void GLAPIENTRY _mesa_ClearStencil(GLint s);
void GLAPIENTRY _mesa_ClearDepth(GLclampd depth);
void GLAPIENTRY _mesa_StencilMask(GLuint mask);
void GLAPIENTRY _mesa_ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
void GLAPIENTRY _mesa_DepthMask(GLboolean flag);
void GLAPIENTRY _mesa_IndexMask(GLuint mask);
void GLAPIENTRY _mesa_Accum(GLenum op, GLfloat value);
void GLAPIENTRY _mesa_Disable(GLenum cap);
void GLAPIENTRY _mesa_Enable(GLenum cap);
void GLAPIENTRY _mesa_Finish(void);
void GLAPIENTRY _mesa_Flush(void);
void GLAPIENTRY _mesa_PopAttrib(void);
void GLAPIENTRY _mesa_PushAttrib(GLbitfield mask);
void GLAPIENTRY _mesa_Map1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
void GLAPIENTRY _mesa_Map1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
void GLAPIENTRY _mesa_Map2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
void GLAPIENTRY _mesa_Map2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
void GLAPIENTRY _mesa_MapGrid1d(GLint un, GLdouble u1, GLdouble u2);
void GLAPIENTRY _mesa_MapGrid1f(GLint un, GLfloat u1, GLfloat u2);
void GLAPIENTRY _mesa_MapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
void GLAPIENTRY _mesa_MapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
void GLAPIENTRY _mesa_EvalCoord1d(GLdouble u);
void GLAPIENTRY _mesa_EvalCoord1dv(const GLdouble *u);
void GLAPIENTRY _mesa_EvalCoord1f(GLfloat u);
void GLAPIENTRY _mesa_EvalCoord1fv(const GLfloat *u);
void GLAPIENTRY _mesa_EvalCoord2d(GLdouble u, GLdouble v);
void GLAPIENTRY _mesa_EvalCoord2dv(const GLdouble *u);
void GLAPIENTRY _mesa_EvalCoord2f(GLfloat u, GLfloat v);
void GLAPIENTRY _mesa_EvalCoord2fv(const GLfloat *u);
void GLAPIENTRY _mesa_EvalMesh1(GLenum mode, GLint i1, GLint i2);
void GLAPIENTRY _mesa_EvalPoint1(GLint i);
void GLAPIENTRY _mesa_EvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
void GLAPIENTRY _mesa_EvalPoint2(GLint i, GLint j);
void GLAPIENTRY _mesa_AlphaFunc(GLenum func, GLclampf ref);
void GLAPIENTRY _mesa_BlendFunc(GLenum sfactor, GLenum dfactor);
void GLAPIENTRY _mesa_BlendFunc_no_error(GLenum sfactor, GLenum dfactor);
void GLAPIENTRY _mesa_LogicOp(GLenum opcode);
void GLAPIENTRY _mesa_LogicOp_no_error(GLenum opcode);
void GLAPIENTRY _mesa_StencilFunc(GLenum func, GLint ref, GLuint mask);
void GLAPIENTRY _mesa_StencilFunc_no_error(GLenum func, GLint ref, GLuint mask);
void GLAPIENTRY _mesa_StencilOp(GLenum fail, GLenum zfail, GLenum zpass);
void GLAPIENTRY _mesa_StencilOp_no_error(GLenum fail, GLenum zfail, GLenum zpass);
void GLAPIENTRY _mesa_DepthFunc(GLenum func);
void GLAPIENTRY _mesa_DepthFunc_no_error(GLenum func);
void GLAPIENTRY _mesa_PixelZoom(GLfloat xfactor, GLfloat yfactor);
void GLAPIENTRY _mesa_PixelTransferf(GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_PixelTransferi(GLenum pname, GLint param);
void GLAPIENTRY _mesa_PixelStoref(GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_PixelStoref_no_error(GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_PixelStorei(GLenum pname, GLint param);
void GLAPIENTRY _mesa_PixelStorei_no_error(GLenum pname, GLint param);
void GLAPIENTRY _mesa_PixelMapfv(GLenum map, GLsizei mapsize, const GLfloat *values);
void GLAPIENTRY _mesa_PixelMapuiv(GLenum map, GLsizei mapsize, const GLuint *values);
void GLAPIENTRY _mesa_PixelMapusv(GLenum map, GLsizei mapsize, const GLushort *values);
void GLAPIENTRY _mesa_ReadBuffer(GLenum mode);
void GLAPIENTRY _mesa_ReadBuffer_no_error(GLenum mode);
void GLAPIENTRY _mesa_CopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
void GLAPIENTRY _mesa_ReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
void GLAPIENTRY _mesa_ReadPixels_no_error(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
void GLAPIENTRY _mesa_DrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_GetBooleanv(GLenum pname, GLboolean *params);
void GLAPIENTRY _mesa_GetClipPlane(GLenum plane, GLdouble *equation);
void GLAPIENTRY _mesa_GetDoublev(GLenum pname, GLdouble *params);
GLenum GLAPIENTRY _mesa_GetError(void);
void GLAPIENTRY _mesa_GetFloatv(GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetIntegerv(GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetLightfv(GLenum light, GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetLightiv(GLenum light, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetMapdv(GLenum target, GLenum query, GLdouble *v);
void GLAPIENTRY _mesa_GetMapfv(GLenum target, GLenum query, GLfloat *v);
void GLAPIENTRY _mesa_GetMapiv(GLenum target, GLenum query, GLint *v);
void GLAPIENTRY _mesa_GetMaterialfv(GLenum face, GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetMaterialiv(GLenum face, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetPixelMapfv(GLenum map, GLfloat *values);
void GLAPIENTRY _mesa_GetPixelMapuiv(GLenum map, GLuint *values);
void GLAPIENTRY _mesa_GetPixelMapusv(GLenum map, GLushort *values);
void GLAPIENTRY _mesa_GetPolygonStipple(GLubyte *mask);
const GLubyte * GLAPIENTRY _mesa_GetString(GLenum name);
void GLAPIENTRY _mesa_GetTexEnvfv(GLenum target, GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetTexEnviv(GLenum target, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetTexGendv(GLenum coord, GLenum pname, GLdouble *params);
void GLAPIENTRY _mesa_GetTexGenfv(GLenum coord, GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetTexGeniv(GLenum coord, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
void GLAPIENTRY _mesa_GetTexParameterfv(GLenum target, GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetTexParameteriv(GLenum target, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params);
GLboolean GLAPIENTRY _mesa_IsEnabled(GLenum cap);
GLboolean GLAPIENTRY _mesa_IsList(GLuint list);
void GLAPIENTRY _mesa_DepthRange(GLclampd zNear, GLclampd zFar);
void GLAPIENTRY _mesa_Frustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
void GLAPIENTRY _mesa_LoadIdentity(void);
void GLAPIENTRY _mesa_LoadMatrixf(const GLfloat *m);
void GLAPIENTRY _mesa_LoadMatrixd(const GLdouble *m);
void GLAPIENTRY _mesa_MatrixMode(GLenum mode);
void GLAPIENTRY _mesa_MultMatrixf(const GLfloat *m);
void GLAPIENTRY _mesa_MultMatrixd(const GLdouble *m);
void GLAPIENTRY _mesa_Ortho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
void GLAPIENTRY _mesa_PopMatrix(void);
void GLAPIENTRY _mesa_PushMatrix(void);
void GLAPIENTRY _mesa_Rotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_Scaled(GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_Scalef(GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_Translated(GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_Translatef(GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_Viewport(GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_Viewport_no_error(GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_ArrayElement(GLint i);
void GLAPIENTRY _mesa_ColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_ColorPointer_no_error(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_DisableClientState(GLenum array);
void GLAPIENTRY _mesa_DrawArrays(GLenum mode, GLint first, GLsizei count);
void GLAPIENTRY _mesa_DrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
void GLAPIENTRY _mesa_EdgeFlagPointer(GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_EdgeFlagPointer_no_error(GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_EnableClientState(GLenum array);
void GLAPIENTRY _mesa_GetPointerv(GLenum pname, GLvoid **params);
void GLAPIENTRY _mesa_IndexPointer(GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_IndexPointer_no_error(GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_InterleavedArrays(GLenum format, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_NormalPointer(GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_NormalPointer_no_error(GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_TexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_TexCoordPointer_no_error(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_VertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_VertexPointer_no_error(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_PolygonOffset(GLfloat factor, GLfloat units);
void GLAPIENTRY _mesa_CopyTexImage1D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
void GLAPIENTRY _mesa_CopyTexImage1D_no_error(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
void GLAPIENTRY _mesa_CopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
void GLAPIENTRY _mesa_CopyTexImage2D_no_error(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
void GLAPIENTRY _mesa_CopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
void GLAPIENTRY _mesa_CopyTexSubImage1D_no_error(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
void GLAPIENTRY _mesa_CopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_CopyTexSubImage2D_no_error(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_TexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TexSubImage1D_no_error(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TexSubImage2D_no_error(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
GLboolean GLAPIENTRY _mesa_AreTexturesResident(GLsizei n, const GLuint *textures, GLboolean *residences);
void GLAPIENTRY _mesa_BindTexture(GLenum target, GLuint texture);
void GLAPIENTRY _mesa_BindTexture_no_error(GLenum target, GLuint texture);
void GLAPIENTRY _mesa_DeleteTextures(GLsizei n, const GLuint *textures);
void GLAPIENTRY _mesa_DeleteTextures_no_error(GLsizei n, const GLuint *textures);
void GLAPIENTRY _mesa_GenTextures(GLsizei n, GLuint *textures);
void GLAPIENTRY _mesa_GenTextures_no_error(GLsizei n, GLuint *textures);
GLboolean GLAPIENTRY _mesa_IsTexture(GLuint texture);
void GLAPIENTRY _mesa_PrioritizeTextures(GLsizei n, const GLuint *textures, const GLclampf *priorities);
void GLAPIENTRY _mesa_Indexub(GLubyte c);
void GLAPIENTRY _mesa_Indexubv(const GLubyte *c);
void GLAPIENTRY _mesa_PopClientAttrib(void);
void GLAPIENTRY _mesa_PushClientAttrib(GLbitfield mask);
void GLAPIENTRY _mesa_BlendColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
void GLAPIENTRY _mesa_BlendEquation(GLenum mode);
void GLAPIENTRY _mesa_DrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);
void GLAPIENTRY _mesa_TexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TexImage3D_no_error(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TexSubImage3D_no_error(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_CopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_CopyTexSubImage3D_no_error(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_ActiveTexture(GLenum texture);
void GLAPIENTRY _mesa_ActiveTexture_no_error(GLenum texture);
void GLAPIENTRY _mesa_ClientActiveTexture(GLenum texture);
void GLAPIENTRY _mesa_MultiTexCoord1d(GLenum target, GLdouble s);
void GLAPIENTRY _mesa_MultiTexCoord1dv(GLenum target, const GLdouble *v);
void GLAPIENTRY _mesa_MultiTexCoord1fARB(GLenum target, GLfloat s);
void GLAPIENTRY _mesa_MultiTexCoord1fvARB(GLenum target, const GLfloat *v);
void GLAPIENTRY _mesa_MultiTexCoord1i(GLenum target, GLint s);
void GLAPIENTRY _mesa_MultiTexCoord1iv(GLenum target, const GLint *v);
void GLAPIENTRY _mesa_MultiTexCoord1s(GLenum target, GLshort s);
void GLAPIENTRY _mesa_MultiTexCoord1sv(GLenum target, const GLshort *v);
void GLAPIENTRY _mesa_MultiTexCoord2d(GLenum target, GLdouble s, GLdouble t);
void GLAPIENTRY _mesa_MultiTexCoord2dv(GLenum target, const GLdouble *v);
void GLAPIENTRY _mesa_MultiTexCoord2fARB(GLenum target, GLfloat s, GLfloat t);
void GLAPIENTRY _mesa_MultiTexCoord2fvARB(GLenum target, const GLfloat *v);
void GLAPIENTRY _mesa_MultiTexCoord2i(GLenum target, GLint s, GLint t);
void GLAPIENTRY _mesa_MultiTexCoord2iv(GLenum target, const GLint *v);
void GLAPIENTRY _mesa_MultiTexCoord2s(GLenum target, GLshort s, GLshort t);
void GLAPIENTRY _mesa_MultiTexCoord2sv(GLenum target, const GLshort *v);
void GLAPIENTRY _mesa_MultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r);
void GLAPIENTRY _mesa_MultiTexCoord3dv(GLenum target, const GLdouble *v);
void GLAPIENTRY _mesa_MultiTexCoord3fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r);
void GLAPIENTRY _mesa_MultiTexCoord3fvARB(GLenum target, const GLfloat *v);
void GLAPIENTRY _mesa_MultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r);
void GLAPIENTRY _mesa_MultiTexCoord3iv(GLenum target, const GLint *v);
void GLAPIENTRY _mesa_MultiTexCoord3s(GLenum target, GLshort s, GLshort t, GLshort r);
void GLAPIENTRY _mesa_MultiTexCoord3sv(GLenum target, const GLshort *v);
void GLAPIENTRY _mesa_MultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
void GLAPIENTRY _mesa_MultiTexCoord4dv(GLenum target, const GLdouble *v);
void GLAPIENTRY _mesa_MultiTexCoord4fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
void GLAPIENTRY _mesa_MultiTexCoord4fvARB(GLenum target, const GLfloat *v);
void GLAPIENTRY _mesa_MultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q);
void GLAPIENTRY _mesa_MultiTexCoord4iv(GLenum target, const GLint *v);
void GLAPIENTRY _mesa_MultiTexCoord4s(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
void GLAPIENTRY _mesa_MultiTexCoord4sv(GLenum target, const GLshort *v);
void GLAPIENTRY _mesa_LoadTransposeMatrixf(const GLfloat *m);
void GLAPIENTRY _mesa_LoadTransposeMatrixd(const GLdouble *m);
void GLAPIENTRY _mesa_MultTransposeMatrixf(const GLfloat *m);
void GLAPIENTRY _mesa_MultTransposeMatrixd(const GLdouble *m);
void GLAPIENTRY _mesa_SampleCoverage(GLclampf value, GLboolean invert);
void GLAPIENTRY _mesa_CompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTexImage3D_no_error(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTexImage2D_no_error(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTexImage1D_no_error(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTexSubImage3D_no_error(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTexSubImage2D_no_error(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTexSubImage1D_no_error(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_GetCompressedTexImage(GLenum target, GLint level, GLvoid *img);
void GLAPIENTRY _mesa_BlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
void GLAPIENTRY _mesa_BlendFuncSeparate_no_error(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
void GLAPIENTRY _mesa_FogCoordfEXT(GLfloat coord);
void GLAPIENTRY _mesa_FogCoordfvEXT(const GLfloat *coord);
void GLAPIENTRY _mesa_FogCoordd(GLdouble coord);
void GLAPIENTRY _mesa_FogCoorddv(const GLdouble *coord);
void GLAPIENTRY _mesa_FogCoordPointer(GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_FogCoordPointer_no_error(GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_MultiDrawArrays(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount);
void GLAPIENTRY _mesa_MultiDrawElements(GLenum mode, const GLsizei *count, GLenum type, const GLvoid * const *indices, GLsizei primcount);
void GLAPIENTRY _mesa_PointParameterf(GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_PointParameterfv(GLenum pname, const GLfloat *params);
void GLAPIENTRY _mesa_PointParameteri(GLenum pname, GLint param);
void GLAPIENTRY _mesa_PointParameteriv(GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_SecondaryColor3b(GLbyte red, GLbyte green, GLbyte blue);
void GLAPIENTRY _mesa_SecondaryColor3bv(const GLbyte *v);
void GLAPIENTRY _mesa_SecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue);
void GLAPIENTRY _mesa_SecondaryColor3dv(const GLdouble *v);
void GLAPIENTRY _mesa_SecondaryColor3fEXT(GLfloat red, GLfloat green, GLfloat blue);
void GLAPIENTRY _mesa_SecondaryColor3fvEXT(const GLfloat *v);
void GLAPIENTRY _mesa_SecondaryColor3i(GLint red, GLint green, GLint blue);
void GLAPIENTRY _mesa_SecondaryColor3iv(const GLint *v);
void GLAPIENTRY _mesa_SecondaryColor3s(GLshort red, GLshort green, GLshort blue);
void GLAPIENTRY _mesa_SecondaryColor3sv(const GLshort *v);
void GLAPIENTRY _mesa_SecondaryColor3ub(GLubyte red, GLubyte green, GLubyte blue);
void GLAPIENTRY _mesa_SecondaryColor3ubv(const GLubyte *v);
void GLAPIENTRY _mesa_SecondaryColor3ui(GLuint red, GLuint green, GLuint blue);
void GLAPIENTRY _mesa_SecondaryColor3uiv(const GLuint *v);
void GLAPIENTRY _mesa_SecondaryColor3us(GLushort red, GLushort green, GLushort blue);
void GLAPIENTRY _mesa_SecondaryColor3usv(const GLushort *v);
void GLAPIENTRY _mesa_SecondaryColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_SecondaryColorPointer_no_error(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_WindowPos2d(GLdouble x, GLdouble y);
void GLAPIENTRY _mesa_WindowPos2dv(const GLdouble *v);
void GLAPIENTRY _mesa_WindowPos2f(GLfloat x, GLfloat y);
void GLAPIENTRY _mesa_WindowPos2fv(const GLfloat *v);
void GLAPIENTRY _mesa_WindowPos2i(GLint x, GLint y);
void GLAPIENTRY _mesa_WindowPos2iv(const GLint *v);
void GLAPIENTRY _mesa_WindowPos2s(GLshort x, GLshort y);
void GLAPIENTRY _mesa_WindowPos2sv(const GLshort *v);
void GLAPIENTRY _mesa_WindowPos3d(GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_WindowPos3dv(const GLdouble *v);
void GLAPIENTRY _mesa_WindowPos3f(GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_WindowPos3fv(const GLfloat *v);
void GLAPIENTRY _mesa_WindowPos3i(GLint x, GLint y, GLint z);
void GLAPIENTRY _mesa_WindowPos3iv(const GLint *v);
void GLAPIENTRY _mesa_WindowPos3s(GLshort x, GLshort y, GLshort z);
void GLAPIENTRY _mesa_WindowPos3sv(const GLshort *v);
void GLAPIENTRY _mesa_BindBuffer(GLenum target, GLuint buffer);
void GLAPIENTRY _mesa_BindBuffer_no_error(GLenum target, GLuint buffer);
void GLAPIENTRY _mesa_BufferData(GLenum target, GLsizeiptr size, const GLvoid *data, GLenum usage);
void GLAPIENTRY _mesa_BufferData_no_error(GLenum target, GLsizeiptr size, const GLvoid *data, GLenum usage);
void GLAPIENTRY _mesa_BufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid *data);
void GLAPIENTRY _mesa_BufferSubData_no_error(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid *data);
void GLAPIENTRY _mesa_DeleteBuffers(GLsizei n, const GLuint *buffer);
void GLAPIENTRY _mesa_DeleteBuffers_no_error(GLsizei n, const GLuint *buffer);
void GLAPIENTRY _mesa_GenBuffers(GLsizei n, GLuint *buffer);
void GLAPIENTRY _mesa_GenBuffers_no_error(GLsizei n, GLuint *buffer);
void GLAPIENTRY _mesa_GetBufferParameteriv(GLenum target, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetBufferPointerv(GLenum target, GLenum pname, GLvoid **params);
void GLAPIENTRY _mesa_GetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid *data);
GLboolean GLAPIENTRY _mesa_IsBuffer(GLuint buffer);
GLvoid * GLAPIENTRY _mesa_MapBuffer(GLenum target, GLenum access);
GLvoid * GLAPIENTRY _mesa_MapBuffer_no_error(GLenum target, GLenum access);
GLboolean GLAPIENTRY _mesa_UnmapBuffer(GLenum target);
GLboolean GLAPIENTRY _mesa_UnmapBuffer_no_error(GLenum target);
void GLAPIENTRY _mesa_GenQueries(GLsizei n, GLuint *ids);
void GLAPIENTRY _mesa_DeleteQueries(GLsizei n, const GLuint *ids);
GLboolean GLAPIENTRY _mesa_IsQuery(GLuint id);
void GLAPIENTRY _mesa_BeginQuery(GLenum target, GLuint id);
void GLAPIENTRY _mesa_EndQuery(GLenum target);
void GLAPIENTRY _mesa_GetQueryiv(GLenum target, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetQueryObjectiv(GLuint id, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params);
void GLAPIENTRY _mesa_BlendEquationSeparate(GLenum modeRGB, GLenum modeA);
void GLAPIENTRY _mesa_BlendEquationSeparate_no_error(GLenum modeRGB, GLenum modeA);
void GLAPIENTRY _mesa_DrawBuffers(GLsizei n, const GLenum *bufs);
void GLAPIENTRY _mesa_DrawBuffers_no_error(GLsizei n, const GLenum *bufs);
void GLAPIENTRY _mesa_StencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask);
void GLAPIENTRY _mesa_StencilFuncSeparate_no_error(GLenum face, GLenum func, GLint ref, GLuint mask);
void GLAPIENTRY _mesa_StencilOpSeparate(GLenum face, GLenum sfail, GLenum zfail, GLenum zpass);
void GLAPIENTRY _mesa_StencilOpSeparate_no_error(GLenum face, GLenum sfail, GLenum zfail, GLenum zpass);
void GLAPIENTRY _mesa_StencilMaskSeparate(GLenum face, GLuint mask);
void GLAPIENTRY _mesa_StencilMaskSeparate_no_error(GLenum face, GLuint mask);
void GLAPIENTRY _mesa_AttachShader(GLuint program, GLuint shader);
void GLAPIENTRY _mesa_AttachShader_no_error(GLuint program, GLuint shader);
void GLAPIENTRY _mesa_BindAttribLocation(GLuint program, GLuint index, const GLchar *name);
void GLAPIENTRY _mesa_BindAttribLocation_no_error(GLuint program, GLuint index, const GLchar *name);
void GLAPIENTRY _mesa_CompileShader(GLuint shader);
GLuint GLAPIENTRY _mesa_CreateProgram(void);
GLuint GLAPIENTRY _mesa_CreateShader(GLenum type);
GLuint GLAPIENTRY _mesa_CreateShader_no_error(GLenum type);
void GLAPIENTRY _mesa_DeleteProgram(GLuint program);
void GLAPIENTRY _mesa_DeleteShader(GLuint program);
void GLAPIENTRY _mesa_DetachShader(GLuint program, GLuint shader);
void GLAPIENTRY _mesa_DetachShader_no_error(GLuint program, GLuint shader);
void GLAPIENTRY _mesa_DisableVertexAttribArray(GLuint index);
void GLAPIENTRY _mesa_DisableVertexAttribArray_no_error(GLuint index);
void GLAPIENTRY _mesa_EnableVertexAttribArray(GLuint index);
void GLAPIENTRY _mesa_EnableVertexAttribArray_no_error(GLuint index);
void GLAPIENTRY _mesa_GetActiveAttrib(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
void GLAPIENTRY _mesa_GetActiveUniform(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
void GLAPIENTRY _mesa_GetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *obj);
GLint GLAPIENTRY _mesa_GetAttribLocation(GLuint program, const GLchar *name);
void GLAPIENTRY _mesa_GetProgramiv(GLuint program, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
void GLAPIENTRY _mesa_GetShaderiv(GLuint shader, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
void GLAPIENTRY _mesa_GetShaderSource(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source);
GLint GLAPIENTRY _mesa_GetUniformLocation(GLuint program, const GLchar *name);
GLint GLAPIENTRY _mesa_GetUniformLocation_no_error(GLuint program, const GLchar *name);
void GLAPIENTRY _mesa_GetUniformfv(GLuint program, GLint location, GLfloat *params);
void GLAPIENTRY _mesa_GetUniformiv(GLuint program, GLint location, GLint *params);
void GLAPIENTRY _mesa_GetVertexAttribdv(GLuint index, GLenum pname, GLdouble *params);
void GLAPIENTRY _mesa_GetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetVertexAttribiv(GLuint index, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetVertexAttribPointerv(GLuint index, GLenum pname, GLvoid **pointer);
GLboolean GLAPIENTRY _mesa_IsProgram(GLuint program);
GLboolean GLAPIENTRY _mesa_IsShader(GLuint shader);
void GLAPIENTRY _mesa_LinkProgram(GLuint program);
void GLAPIENTRY _mesa_LinkProgram_no_error(GLuint program);
void GLAPIENTRY _mesa_ShaderSource(GLuint shader, GLsizei count, const GLchar * const *string, const GLint *length);
void GLAPIENTRY _mesa_ShaderSource_no_error(GLuint shader, GLsizei count, const GLchar * const *string, const GLint *length);
void GLAPIENTRY _mesa_UseProgram(GLuint program);
void GLAPIENTRY _mesa_UseProgram_no_error(GLuint program);
void GLAPIENTRY _mesa_Uniform1f(GLint location, GLfloat v0);
void GLAPIENTRY _mesa_Uniform2f(GLint location, GLfloat v0, GLfloat v1);
void GLAPIENTRY _mesa_Uniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
void GLAPIENTRY _mesa_Uniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
void GLAPIENTRY _mesa_Uniform1i(GLint location, GLint v0);
void GLAPIENTRY _mesa_Uniform2i(GLint location, GLint v0, GLint v1);
void GLAPIENTRY _mesa_Uniform3i(GLint location, GLint v0, GLint v1, GLint v2);
void GLAPIENTRY _mesa_Uniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
void GLAPIENTRY _mesa_Uniform1fv(GLint location, GLsizei count, const GLfloat *value);
void GLAPIENTRY _mesa_Uniform2fv(GLint location, GLsizei count, const GLfloat *value);
void GLAPIENTRY _mesa_Uniform3fv(GLint location, GLsizei count, const GLfloat *value);
void GLAPIENTRY _mesa_Uniform4fv(GLint location, GLsizei count, const GLfloat *value);
void GLAPIENTRY _mesa_Uniform1iv(GLint location, GLsizei count, const GLint *value);
void GLAPIENTRY _mesa_Uniform2iv(GLint location, GLsizei count, const GLint *value);
void GLAPIENTRY _mesa_Uniform3iv(GLint location, GLsizei count, const GLint *value);
void GLAPIENTRY _mesa_Uniform4iv(GLint location, GLsizei count, const GLint *value);
void GLAPIENTRY _mesa_UniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_UniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_UniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_ValidateProgram(GLuint program);
void GLAPIENTRY _mesa_VertexAttrib1d(GLuint index, GLdouble x);
void GLAPIENTRY _mesa_VertexAttrib1dv(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttrib1fARB(GLuint index, GLfloat x);
void GLAPIENTRY _mesa_VertexAttrib1fvARB(GLuint index, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttrib1s(GLuint index, GLshort x);
void GLAPIENTRY _mesa_VertexAttrib1sv(GLuint index, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttrib2d(GLuint index, GLdouble x, GLdouble y);
void GLAPIENTRY _mesa_VertexAttrib2dv(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttrib2fARB(GLuint index, GLfloat x, GLfloat y);
void GLAPIENTRY _mesa_VertexAttrib2fvARB(GLuint index, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttrib2s(GLuint index, GLshort x, GLshort y);
void GLAPIENTRY _mesa_VertexAttrib2sv(GLuint index, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_VertexAttrib3dv(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttrib3fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_VertexAttrib3fvARB(GLuint index, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttrib3s(GLuint index, GLshort x, GLshort y, GLshort z);
void GLAPIENTRY _mesa_VertexAttrib3sv(GLuint index, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttrib4Nbv(GLuint index, const GLbyte *v);
void GLAPIENTRY _mesa_VertexAttrib4Niv(GLuint index, const GLint *v);
void GLAPIENTRY _mesa_VertexAttrib4Nsv(GLuint index, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttrib4Nub(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
void GLAPIENTRY _mesa_VertexAttrib4Nubv(GLuint index, const GLubyte *v);
void GLAPIENTRY _mesa_VertexAttrib4Nuiv(GLuint index, const GLuint *v);
void GLAPIENTRY _mesa_VertexAttrib4Nusv(GLuint index, const GLushort *v);
void GLAPIENTRY _mesa_VertexAttrib4bv(GLuint index, const GLbyte *v);
void GLAPIENTRY _mesa_VertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLAPIENTRY _mesa_VertexAttrib4dv(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttrib4fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void GLAPIENTRY _mesa_VertexAttrib4fvARB(GLuint index, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttrib4iv(GLuint index, const GLint *v);
void GLAPIENTRY _mesa_VertexAttrib4s(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
void GLAPIENTRY _mesa_VertexAttrib4sv(GLuint index, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttrib4ubv(GLuint index, const GLubyte *v);
void GLAPIENTRY _mesa_VertexAttrib4uiv(GLuint index, const GLuint *v);
void GLAPIENTRY _mesa_VertexAttrib4usv(GLuint index, const GLushort *v);
void GLAPIENTRY _mesa_VertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_VertexAttribPointer_no_error(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_UniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_UniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_UniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_UniformMatrix4x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_UniformMatrix3x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_UniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramStringARB(GLenum target, GLenum format, GLsizei len, const GLvoid *string);
void GLAPIENTRY _mesa_BindProgramARB(GLenum target, GLuint program);
void GLAPIENTRY _mesa_DeleteProgramsARB(GLsizei n, const GLuint *programs);
void GLAPIENTRY _mesa_GenProgramsARB(GLsizei n, GLuint *programs);
GLboolean GLAPIENTRY _mesa_IsProgramARB(GLuint program);
void GLAPIENTRY _mesa_ProgramEnvParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLAPIENTRY _mesa_ProgramEnvParameter4dvARB(GLenum target, GLuint index, const GLdouble *params);
void GLAPIENTRY _mesa_ProgramEnvParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void GLAPIENTRY _mesa_ProgramEnvParameter4fvARB(GLenum target, GLuint index, const GLfloat *params);
void GLAPIENTRY _mesa_ProgramLocalParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLAPIENTRY _mesa_ProgramLocalParameter4dvARB(GLenum target, GLuint index, const GLdouble *params);
void GLAPIENTRY _mesa_ProgramLocalParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void GLAPIENTRY _mesa_ProgramLocalParameter4fvARB(GLenum target, GLuint index, const GLfloat *params);
void GLAPIENTRY _mesa_GetProgramEnvParameterdvARB(GLenum target, GLuint index, GLdouble *params);
void GLAPIENTRY _mesa_GetProgramEnvParameterfvARB(GLenum target, GLuint index, GLfloat *params);
void GLAPIENTRY _mesa_GetProgramLocalParameterdvARB(GLenum target, GLuint index, GLdouble *params);
void GLAPIENTRY _mesa_GetProgramLocalParameterfvARB(GLenum target, GLuint index, GLfloat *params);
void GLAPIENTRY _mesa_GetProgramivARB(GLenum target, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetProgramStringARB(GLenum target, GLenum pname, GLvoid *string);
void GLAPIENTRY _mesa_DeleteObjectARB(GLhandleARB obj);
GLhandleARB GLAPIENTRY _mesa_GetHandleARB(GLenum pname);
void GLAPIENTRY _mesa_DetachObjectARB(GLhandleARB containerObj, GLhandleARB attachedObj);
void GLAPIENTRY _mesa_DetachObjectARB_no_error(GLhandleARB containerObj, GLhandleARB attachedObj);
GLhandleARB GLAPIENTRY _mesa_CreateShaderObjectARB(GLenum shaderType);
GLhandleARB GLAPIENTRY _mesa_CreateShaderObjectARB_no_error(GLenum shaderType);
GLhandleARB GLAPIENTRY _mesa_CreateProgramObjectARB(void);
void GLAPIENTRY _mesa_AttachObjectARB(GLhandleARB containerObj, GLhandleARB obj);
void GLAPIENTRY _mesa_AttachObjectARB_no_error(GLhandleARB containerObj, GLhandleARB obj);
void GLAPIENTRY _mesa_GetObjectParameterfvARB(GLhandleARB obj, GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetObjectParameterivARB(GLhandleARB obj, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetInfoLogARB(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog);
void GLAPIENTRY _mesa_GetAttachedObjectsARB(GLhandleARB containerObj, GLsizei maxLength, GLsizei *length, GLhandleARB *infoLog);
void GLAPIENTRY _mesa_ClampColor(GLenum target, GLenum clamp);
void GLAPIENTRY _mesa_DrawArraysInstanced(GLenum mode, GLint first, GLsizei count, GLsizei primcount);
void GLAPIENTRY _mesa_DrawElementsInstanced(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instance_count);
GLboolean GLAPIENTRY _mesa_IsRenderbuffer(GLuint renderbuffer);
void GLAPIENTRY _mesa_BindRenderbuffer(GLenum target, GLuint renderbuffer);
void GLAPIENTRY _mesa_DeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers);
void GLAPIENTRY _mesa_GenRenderbuffers(GLsizei n, GLuint *renderbuffers);
void GLAPIENTRY _mesa_GenRenderbuffers_no_error(GLsizei n, GLuint *renderbuffers);
void GLAPIENTRY _mesa_RenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_RenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_GetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params);
GLboolean GLAPIENTRY _mesa_IsFramebuffer(GLuint framebuffer);
void GLAPIENTRY _mesa_BindFramebuffer(GLenum target, GLuint framebuffer);
void GLAPIENTRY _mesa_DeleteFramebuffers(GLsizei n, const GLuint *framebuffers);
void GLAPIENTRY _mesa_GenFramebuffers(GLsizei n, GLuint *framebuffers);
GLenum GLAPIENTRY _mesa_CheckFramebufferStatus(GLenum target);
GLenum GLAPIENTRY _mesa_CheckFramebufferStatus_no_error(GLenum target);
void GLAPIENTRY _mesa_FramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
void GLAPIENTRY _mesa_FramebufferTexture1D_no_error(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
void GLAPIENTRY _mesa_FramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
void GLAPIENTRY _mesa_FramebufferTexture2D_no_error(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
void GLAPIENTRY _mesa_FramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint layer);
void GLAPIENTRY _mesa_FramebufferTexture3D_no_error(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint layer);
void GLAPIENTRY _mesa_FramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
void GLAPIENTRY _mesa_FramebufferTextureLayer_no_error(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
void GLAPIENTRY _mesa_FramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
void GLAPIENTRY _mesa_FramebufferRenderbuffer_no_error(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
void GLAPIENTRY _mesa_GetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_BlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
void GLAPIENTRY _mesa_BlitFramebuffer_no_error(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
void GLAPIENTRY _mesa_GenerateMipmap(GLenum target);
void GLAPIENTRY _mesa_GenerateMipmap_no_error(GLenum target);
void GLAPIENTRY _mesa_FramebufferTextureMultiviewOVR(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint baseviewindex, GLsizei numviews);
void GLAPIENTRY _mesa_FramebufferTextureMultiviewOVR_no_error(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint baseviewindex, GLsizei numviews);
void GLAPIENTRY _mesa_NamedFramebufferTextureMultiviewOVR(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint baseviewindex, GLsizei numviews);
void GLAPIENTRY _mesa_NamedFramebufferTextureMultiviewOVR_no_error(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint baseviewindex, GLsizei numviews);
void GLAPIENTRY _mesa_FramebufferTextureMultisampleMultiviewOVR(GLenum target, GLenum attachment, GLuint texture, GLint level, GLsizei samples, GLint baseviewindex, GLsizei numviews);
void GLAPIENTRY _mesa_FramebufferTextureMultisampleMultiviewOVR_no_error(GLenum target, GLenum attachment, GLuint texture, GLint level, GLsizei samples, GLint baseviewindex, GLsizei numviews);
void GLAPIENTRY _mesa_VertexAttribDivisor(GLuint index, GLuint divisor);
void GLAPIENTRY _mesa_VertexAttribDivisor_no_error(GLuint index, GLuint divisor);
void GLAPIENTRY _mesa_VertexArrayVertexAttribDivisorEXT(GLuint vaobj, GLuint index, GLuint divisor);
GLvoid * GLAPIENTRY _mesa_MapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
GLvoid * GLAPIENTRY _mesa_MapBufferRange_no_error(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
void GLAPIENTRY _mesa_FlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length);
void GLAPIENTRY _mesa_FlushMappedBufferRange_no_error(GLenum target, GLintptr offset, GLsizeiptr length);
void GLAPIENTRY _mesa_TexBuffer(GLenum target, GLenum internalFormat, GLuint buffer);
void GLAPIENTRY _mesa_BindVertexArray(GLuint array);
void GLAPIENTRY _mesa_BindVertexArray_no_error(GLuint array);
void GLAPIENTRY _mesa_DeleteVertexArrays(GLsizei n, const GLuint *arrays);
void GLAPIENTRY _mesa_DeleteVertexArrays_no_error(GLsizei n, const GLuint *arrays);
void GLAPIENTRY _mesa_GenVertexArrays(GLsizei n, GLuint *arrays);
void GLAPIENTRY _mesa_GenVertexArrays_no_error(GLsizei n, GLuint *arrays);
GLboolean GLAPIENTRY _mesa_IsVertexArray(GLuint array);
void GLAPIENTRY _mesa_GetUniformIndices(GLuint program, GLsizei uniformCount, const GLchar * const *uniformNames, GLuint *uniformIndices);
void GLAPIENTRY _mesa_GetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetActiveUniformName(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName);
GLuint GLAPIENTRY _mesa_GetUniformBlockIndex(GLuint program, const GLchar *uniformBlockName);
void GLAPIENTRY _mesa_GetActiveUniformBlockiv(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetActiveUniformBlockName(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName);
void GLAPIENTRY _mesa_UniformBlockBinding(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);
void GLAPIENTRY _mesa_UniformBlockBinding_no_error(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);
void GLAPIENTRY _mesa_CopyBufferSubData(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
void GLAPIENTRY _mesa_CopyBufferSubData_no_error(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
void GLAPIENTRY _mesa_DrawElementsBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
void GLAPIENTRY _mesa_DrawRangeElementsBaseVertex(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
void GLAPIENTRY _mesa_MultiDrawElementsBaseVertex(GLenum mode, const GLsizei *count, GLenum type, const GLvoid * const *indices, GLsizei primcount, const GLint *basevertex);
void GLAPIENTRY _mesa_DrawElementsInstancedBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount, GLint basevertex);
GLsync GLAPIENTRY _mesa_FenceSync(GLenum condition, GLbitfield flags);
GLsync GLAPIENTRY _mesa_FenceSync_no_error(GLenum condition, GLbitfield flags);
GLboolean GLAPIENTRY _mesa_IsSync(GLsync sync);
void GLAPIENTRY _mesa_DeleteSync(GLsync sync);
void GLAPIENTRY _mesa_DeleteSync_no_error(GLsync sync);
GLenum GLAPIENTRY _mesa_ClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout);
GLenum GLAPIENTRY _mesa_ClientWaitSync_no_error(GLsync sync, GLbitfield flags, GLuint64 timeout);
void GLAPIENTRY _mesa_WaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout);
void GLAPIENTRY _mesa_WaitSync_no_error(GLsync sync, GLbitfield flags, GLuint64 timeout);
void GLAPIENTRY _mesa_GetInteger64v(GLenum pname, GLint64 *params);
void GLAPIENTRY _mesa_GetSynciv(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values);
void GLAPIENTRY _mesa_TexImage2DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
void GLAPIENTRY _mesa_TexImage3DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
void GLAPIENTRY _mesa_GetMultisamplefv(GLenum pname, GLuint index, GLfloat *val);
void GLAPIENTRY _mesa_SampleMaski(GLuint index, GLbitfield mask);
void GLAPIENTRY _mesa_SampleMaski_no_error(GLuint index, GLbitfield mask);
void GLAPIENTRY _mesa_BlendEquationiARB(GLuint buf, GLenum mode);
void GLAPIENTRY _mesa_BlendEquationiARB_no_error(GLuint buf, GLenum mode);
void GLAPIENTRY _mesa_BlendEquationSeparateiARB(GLuint buf, GLenum modeRGB, GLenum modeA);
void GLAPIENTRY _mesa_BlendEquationSeparateiARB_no_error(GLuint buf, GLenum modeRGB, GLenum modeA);
void GLAPIENTRY _mesa_BlendFunciARB(GLuint buf, GLenum src, GLenum dst);
void GLAPIENTRY _mesa_BlendFunciARB_no_error(GLuint buf, GLenum src, GLenum dst);
void GLAPIENTRY _mesa_BlendFuncSeparateiARB(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcA, GLenum dstA);
void GLAPIENTRY _mesa_BlendFuncSeparateiARB_no_error(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcA, GLenum dstA);
void GLAPIENTRY _mesa_MinSampleShading(GLfloat value);
void GLAPIENTRY _mesa_MinSampleShading_no_error(GLfloat value);
void GLAPIENTRY _mesa_NamedStringARB(GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string);
void GLAPIENTRY _mesa_DeleteNamedStringARB(GLint namelen, const GLchar *name);
void GLAPIENTRY _mesa_CompileShaderIncludeARB(GLuint shader, GLsizei count, const GLchar * const *path, const GLint *length);
GLboolean GLAPIENTRY _mesa_IsNamedStringARB(GLint namelen, const GLchar *name);
void GLAPIENTRY _mesa_GetNamedStringARB(GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string);
void GLAPIENTRY _mesa_GetNamedStringivARB(GLint namelen, const GLchar *name, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_BindFragDataLocationIndexed(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name);
void GLAPIENTRY _mesa_BindFragDataLocationIndexed_no_error(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name);
GLint GLAPIENTRY _mesa_GetFragDataIndex(GLuint program, const GLchar *name);
void GLAPIENTRY _mesa_GenSamplers(GLsizei count, GLuint *samplers);
void GLAPIENTRY _mesa_GenSamplers_no_error(GLsizei count, GLuint *samplers);
void GLAPIENTRY _mesa_DeleteSamplers(GLsizei count, const GLuint *samplers);
void GLAPIENTRY _mesa_DeleteSamplers_no_error(GLsizei count, const GLuint *samplers);
GLboolean GLAPIENTRY _mesa_IsSampler(GLuint sampler);
void GLAPIENTRY _mesa_BindSampler(GLuint unit, GLuint sampler);
void GLAPIENTRY _mesa_BindSampler_no_error(GLuint unit, GLuint sampler);
void GLAPIENTRY _mesa_SamplerParameteri(GLuint sampler, GLenum pname, GLint param);
void GLAPIENTRY _mesa_SamplerParameterf(GLuint sampler, GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_SamplerParameteriv(GLuint sampler, GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_SamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat *params);
void GLAPIENTRY _mesa_SamplerParameterIiv(GLuint sampler, GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_SamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint *params);
void GLAPIENTRY _mesa_GetSamplerParameteriv(GLuint sampler, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint *params);
void GLAPIENTRY _mesa_GetQueryObjecti64v(GLuint id, GLenum pname, GLint64 *params);
void GLAPIENTRY _mesa_GetQueryObjectui64v(GLuint id, GLenum pname, GLuint64 *params);
void GLAPIENTRY _mesa_QueryCounter(GLuint id, GLenum target);
void GLAPIENTRY _mesa_VertexP2ui(GLenum type, GLuint value);
void GLAPIENTRY _mesa_VertexP3ui(GLenum type, GLuint value);
void GLAPIENTRY _mesa_VertexP4ui(GLenum type, GLuint value);
void GLAPIENTRY _mesa_VertexP2uiv(GLenum type, const GLuint *value);
void GLAPIENTRY _mesa_VertexP3uiv(GLenum type, const GLuint *value);
void GLAPIENTRY _mesa_VertexP4uiv(GLenum type, const GLuint *value);
void GLAPIENTRY _mesa_TexCoordP1ui(GLenum type, GLuint coords);
void GLAPIENTRY _mesa_TexCoordP2ui(GLenum type, GLuint coords);
void GLAPIENTRY _mesa_TexCoordP3ui(GLenum type, GLuint coords);
void GLAPIENTRY _mesa_TexCoordP4ui(GLenum type, GLuint coords);
void GLAPIENTRY _mesa_TexCoordP1uiv(GLenum type, const GLuint *coords);
void GLAPIENTRY _mesa_TexCoordP2uiv(GLenum type, const GLuint *coords);
void GLAPIENTRY _mesa_TexCoordP3uiv(GLenum type, const GLuint *coords);
void GLAPIENTRY _mesa_TexCoordP4uiv(GLenum type, const GLuint *coords);
void GLAPIENTRY _mesa_MultiTexCoordP1ui(GLenum texture, GLenum type, GLuint coords);
void GLAPIENTRY _mesa_MultiTexCoordP2ui(GLenum texture, GLenum type, GLuint coords);
void GLAPIENTRY _mesa_MultiTexCoordP3ui(GLenum texture, GLenum type, GLuint coords);
void GLAPIENTRY _mesa_MultiTexCoordP4ui(GLenum texture, GLenum type, GLuint coords);
void GLAPIENTRY _mesa_MultiTexCoordP1uiv(GLenum texture, GLenum type, const GLuint *coords);
void GLAPIENTRY _mesa_MultiTexCoordP2uiv(GLenum texture, GLenum type, const GLuint *coords);
void GLAPIENTRY _mesa_MultiTexCoordP3uiv(GLenum texture, GLenum type, const GLuint *coords);
void GLAPIENTRY _mesa_MultiTexCoordP4uiv(GLenum texture, GLenum type, const GLuint *coords);
void GLAPIENTRY _mesa_NormalP3ui(GLenum type, GLuint coords);
void GLAPIENTRY _mesa_NormalP3uiv(GLenum type, const GLuint *coords);
void GLAPIENTRY _mesa_ColorP3ui(GLenum type, GLuint color);
void GLAPIENTRY _mesa_ColorP4ui(GLenum type, GLuint color);
void GLAPIENTRY _mesa_ColorP3uiv(GLenum type, const GLuint *color);
void GLAPIENTRY _mesa_ColorP4uiv(GLenum type, const GLuint *color);
void GLAPIENTRY _mesa_SecondaryColorP3ui(GLenum type, GLuint color);
void GLAPIENTRY _mesa_SecondaryColorP3uiv(GLenum type, const GLuint *color);
void GLAPIENTRY _mesa_VertexAttribP1ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
void GLAPIENTRY _mesa_VertexAttribP2ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
void GLAPIENTRY _mesa_VertexAttribP3ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
void GLAPIENTRY _mesa_VertexAttribP4ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
void GLAPIENTRY _mesa_VertexAttribP1uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
void GLAPIENTRY _mesa_VertexAttribP2uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
void GLAPIENTRY _mesa_VertexAttribP3uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
void GLAPIENTRY _mesa_VertexAttribP4uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
GLint GLAPIENTRY _mesa_GetSubroutineUniformLocation(GLuint program, GLenum shadertype, const GLchar *name);
GLuint GLAPIENTRY _mesa_GetSubroutineIndex(GLuint program, GLenum shadertype, const GLchar *name);
void GLAPIENTRY _mesa_GetActiveSubroutineUniformiv(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint *values);
void GLAPIENTRY _mesa_GetActiveSubroutineUniformName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);
void GLAPIENTRY _mesa_GetActiveSubroutineName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name);
void GLAPIENTRY _mesa_UniformSubroutinesuiv(GLenum shadertype, GLsizei count, const GLuint *indices);
void GLAPIENTRY _mesa_GetUniformSubroutineuiv(GLenum shadertype, GLint location, GLuint *params);
void GLAPIENTRY _mesa_GetProgramStageiv(GLuint program, GLenum shadertype, GLenum pname, GLint *values);
void GLAPIENTRY _mesa_PatchParameteri(GLenum pname, GLint value);
void GLAPIENTRY _mesa_PatchParameteri_no_error(GLenum pname, GLint value);
void GLAPIENTRY _mesa_PatchParameterfv(GLenum pname, const GLfloat *values);
void GLAPIENTRY _mesa_DrawArraysIndirect(GLenum mode, const GLvoid *indirect);
void GLAPIENTRY _mesa_DrawElementsIndirect(GLenum mode, GLenum type, const GLvoid *indirect);
void GLAPIENTRY _mesa_MultiDrawArraysIndirect(GLenum mode, const GLvoid *indirect, GLsizei primcount, GLsizei stride);
void GLAPIENTRY _mesa_MultiDrawElementsIndirect(GLenum mode, GLenum type, const GLvoid *indirect, GLsizei primcount, GLsizei stride);
void GLAPIENTRY _mesa_Uniform1d(GLint location, GLdouble x);
void GLAPIENTRY _mesa_Uniform2d(GLint location, GLdouble x, GLdouble y);
void GLAPIENTRY _mesa_Uniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_Uniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLAPIENTRY _mesa_Uniform1dv(GLint location, GLsizei count, const GLdouble *value);
void GLAPIENTRY _mesa_Uniform2dv(GLint location, GLsizei count, const GLdouble *value);
void GLAPIENTRY _mesa_Uniform3dv(GLint location, GLsizei count, const GLdouble *value);
void GLAPIENTRY _mesa_Uniform4dv(GLint location, GLsizei count, const GLdouble *value);
void GLAPIENTRY _mesa_UniformMatrix2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_UniformMatrix3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_UniformMatrix4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_UniformMatrix2x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_UniformMatrix2x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_UniformMatrix3x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_UniformMatrix3x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_UniformMatrix4x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_UniformMatrix4x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_GetUniformdv(GLuint program, GLint location, GLdouble *params);
void GLAPIENTRY _mesa_ProgramUniform1d(GLuint program, GLint location, GLdouble x);
void GLAPIENTRY _mesa_ProgramUniform2d(GLuint program, GLint location, GLdouble x, GLdouble y);
void GLAPIENTRY _mesa_ProgramUniform3d(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_ProgramUniform4d(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLAPIENTRY _mesa_ProgramUniform1dv(GLuint program, GLint location, GLsizei count, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniform2dv(GLuint program, GLint location, GLsizei count, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniform3dv(GLuint program, GLint location, GLsizei count, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniform4dv(GLuint program, GLint location, GLsizei count, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix2x3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix2x4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix3x2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix3x4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix4x2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix4x3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value);
void GLAPIENTRY _mesa_DrawTransformFeedbackStream(GLenum mode, GLuint id, GLuint stream);
void GLAPIENTRY _mesa_BeginQueryIndexed(GLenum target, GLuint index, GLuint id);
void GLAPIENTRY _mesa_EndQueryIndexed(GLenum target, GLuint index);
void GLAPIENTRY _mesa_GetQueryIndexediv(GLenum target, GLuint index, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_UseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program);
void GLAPIENTRY _mesa_UseProgramStages_no_error(GLuint pipeline, GLbitfield stages, GLuint program);
void GLAPIENTRY _mesa_ActiveShaderProgram(GLuint pipeline, GLuint program);
void GLAPIENTRY _mesa_ActiveShaderProgram_no_error(GLuint pipeline, GLuint program);
GLuint GLAPIENTRY _mesa_CreateShaderProgramv(GLenum type, GLsizei count, const GLchar * const *strings);
void GLAPIENTRY _mesa_BindProgramPipeline(GLuint pipeline);
void GLAPIENTRY _mesa_BindProgramPipeline_no_error(GLuint pipeline);
void GLAPIENTRY _mesa_DeleteProgramPipelines(GLsizei n, const GLuint *pipelines);
void GLAPIENTRY _mesa_GenProgramPipelines(GLsizei n, GLuint *pipelines);
void GLAPIENTRY _mesa_GenProgramPipelines_no_error(GLsizei n, GLuint *pipelines);
GLboolean GLAPIENTRY _mesa_IsProgramPipeline(GLuint pipeline);
void GLAPIENTRY _mesa_GetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_ProgramUniform1i(GLuint program, GLint location, GLint x);
void GLAPIENTRY _mesa_ProgramUniform2i(GLuint program, GLint location, GLint x, GLint y);
void GLAPIENTRY _mesa_ProgramUniform3i(GLuint program, GLint location, GLint x, GLint y, GLint z);
void GLAPIENTRY _mesa_ProgramUniform4i(GLuint program, GLint location, GLint x, GLint y, GLint z, GLint w);
void GLAPIENTRY _mesa_ProgramUniform1ui(GLuint program, GLint location, GLuint x);
void GLAPIENTRY _mesa_ProgramUniform2ui(GLuint program, GLint location, GLuint x, GLuint y);
void GLAPIENTRY _mesa_ProgramUniform3ui(GLuint program, GLint location, GLuint x, GLuint y, GLuint z);
void GLAPIENTRY _mesa_ProgramUniform4ui(GLuint program, GLint location, GLuint x, GLuint y, GLuint z, GLuint w);
void GLAPIENTRY _mesa_ProgramUniform1f(GLuint program, GLint location, GLfloat x);
void GLAPIENTRY _mesa_ProgramUniform2f(GLuint program, GLint location, GLfloat x, GLfloat y);
void GLAPIENTRY _mesa_ProgramUniform3f(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_ProgramUniform4f(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void GLAPIENTRY _mesa_ProgramUniform1iv(GLuint program, GLint location, GLsizei count, const GLint *value);
void GLAPIENTRY _mesa_ProgramUniform2iv(GLuint program, GLint location, GLsizei count, const GLint *value);
void GLAPIENTRY _mesa_ProgramUniform3iv(GLuint program, GLint location, GLsizei count, const GLint *value);
void GLAPIENTRY _mesa_ProgramUniform4iv(GLuint program, GLint location, GLsizei count, const GLint *value);
void GLAPIENTRY _mesa_ProgramUniform1uiv(GLuint program, GLint location, GLsizei count, const GLuint *value);
void GLAPIENTRY _mesa_ProgramUniform2uiv(GLuint program, GLint location, GLsizei count, const GLuint *value);
void GLAPIENTRY _mesa_ProgramUniform3uiv(GLuint program, GLint location, GLsizei count, const GLuint *value);
void GLAPIENTRY _mesa_ProgramUniform4uiv(GLuint program, GLint location, GLsizei count, const GLuint *value);
void GLAPIENTRY _mesa_ProgramUniform1fv(GLuint program, GLint location, GLsizei count, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniform2fv(GLuint program, GLint location, GLsizei count, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniform3fv(GLuint program, GLint location, GLsizei count, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniform4fv(GLuint program, GLint location, GLsizei count, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix2x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix3x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix2x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix4x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix3x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_ProgramUniformMatrix4x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
void GLAPIENTRY _mesa_ValidateProgramPipeline(GLuint pipeline);
void GLAPIENTRY _mesa_GetProgramPipelineInfoLog(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
void GLAPIENTRY _mesa_VertexAttribL1d(GLuint index, GLdouble x);
void GLAPIENTRY _mesa_VertexAttribL2d(GLuint index, GLdouble x, GLdouble y);
void GLAPIENTRY _mesa_VertexAttribL3d(GLuint index, GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_VertexAttribL4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLAPIENTRY _mesa_VertexAttribL1dv(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttribL2dv(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttribL3dv(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttribL4dv(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttribLPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_VertexAttribLPointer_no_error(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_GetVertexAttribLdv(GLuint index, GLenum pname, GLdouble *params);
void GLAPIENTRY _mesa_VertexArrayVertexAttribLOffsetEXT(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_GetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision);
void GLAPIENTRY _mesa_ReleaseShaderCompiler(void);
void GLAPIENTRY _mesa_ShaderBinary(GLsizei n, const GLuint *shaders, GLenum binaryformat, const GLvoid *binary, GLsizei length);
void GLAPIENTRY _mesa_ClearDepthf(GLclampf depth);
void GLAPIENTRY _mesa_DepthRangef(GLclampf zNear, GLclampf zFar);
void GLAPIENTRY _mesa_GetProgramBinary(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary);
void GLAPIENTRY _mesa_ProgramBinary(GLuint program, GLenum binaryFormat, const GLvoid *binary, GLsizei length);
void GLAPIENTRY _mesa_ProgramParameteri(GLuint program, GLenum pname, GLint value);
void GLAPIENTRY _mesa_ProgramParameteri_no_error(GLuint program, GLenum pname, GLint value);
void GLAPIENTRY _mesa_DebugMessageControl(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled);
void GLAPIENTRY _mesa_DebugMessageInsert(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf);
void GLAPIENTRY _mesa_DebugMessageCallback(GLDEBUGPROC callback, const GLvoid *userParam);
GLuint GLAPIENTRY _mesa_GetDebugMessageLog(GLuint count, GLsizei bufsize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog);
GLenum GLAPIENTRY _mesa_GetGraphicsResetStatusARB(void);
void GLAPIENTRY _mesa_GetnMapdvARB(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v);
void GLAPIENTRY _mesa_GetnMapfvARB(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v);
void GLAPIENTRY _mesa_GetnMapivARB(GLenum target, GLenum query, GLsizei bufSize, GLint *v);
void GLAPIENTRY _mesa_GetnPixelMapfvARB(GLenum map, GLsizei bufSize, GLfloat *values);
void GLAPIENTRY _mesa_GetnPixelMapuivARB(GLenum map, GLsizei bufSize, GLuint *values);
void GLAPIENTRY _mesa_GetnPixelMapusvARB(GLenum map, GLsizei bufSize, GLushort *values);
void GLAPIENTRY _mesa_GetnPolygonStippleARB(GLsizei bufSize, GLubyte *pattern);
void GLAPIENTRY _mesa_GetnTexImageARB(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid *img);
void GLAPIENTRY _mesa_ReadnPixelsARB(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, GLvoid *data);
void GLAPIENTRY _mesa_ReadnPixelsARB_no_error(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, GLvoid *data);
void GLAPIENTRY _mesa_GetnCompressedTexImageARB(GLenum target, GLint lod, GLsizei bufSize, GLvoid *img);
void GLAPIENTRY _mesa_GetnUniformfvARB(GLuint program, GLint location, GLsizei bufSize, GLfloat *params);
void GLAPIENTRY _mesa_GetnUniformivARB(GLuint program, GLint location, GLsizei bufSize, GLint *params);
void GLAPIENTRY _mesa_GetnUniformuivARB(GLuint program, GLint location, GLsizei bufSize, GLuint *params);
void GLAPIENTRY _mesa_GetnUniformdvARB(GLuint program, GLint location, GLsizei bufSize, GLdouble *params);
void GLAPIENTRY _mesa_DrawArraysInstancedBaseInstance(GLenum mode, GLint first, GLsizei count, GLsizei instance_count, GLuint baseinstance);
void GLAPIENTRY _mesa_DrawElementsInstancedBaseInstance(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount, GLuint baseinstance);
void GLAPIENTRY _mesa_DrawElementsInstancedBaseVertexBaseInstance(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instance_count, GLint basevertex, GLuint baseinstance);
void GLAPIENTRY _mesa_DrawTransformFeedbackInstanced(GLenum mode, GLuint id, GLsizei primcount);
void GLAPIENTRY _mesa_DrawTransformFeedbackStreamInstanced(GLenum mode, GLuint id, GLuint stream, GLsizei primcount);
void GLAPIENTRY _mesa_GetInternalformativ(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params);
void GLAPIENTRY _mesa_GetActiveAtomicCounterBufferiv(GLuint program, GLuint bufferIndex, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_BindImageTexture(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format);
void GLAPIENTRY _mesa_BindImageTexture_no_error(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format);
void GLAPIENTRY _mesa_MemoryBarrier(GLbitfield barriers);
void GLAPIENTRY _mesa_TexStorage1D(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width);
void GLAPIENTRY _mesa_TexStorage1D_no_error(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width);
void GLAPIENTRY _mesa_TexStorage2D(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_TexStorage2D_no_error(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_TexStorage3D(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth);
void GLAPIENTRY _mesa_TexStorage3D_no_error(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth);
void GLAPIENTRY _mesa_PushDebugGroup(GLenum source, GLuint id, GLsizei length, const GLchar *message);
void GLAPIENTRY _mesa_PopDebugGroup(void);
void GLAPIENTRY _mesa_ObjectLabel(GLenum identifier, GLuint name, GLsizei length, const GLchar *label);
void GLAPIENTRY _mesa_GetObjectLabel(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label);
void GLAPIENTRY _mesa_ObjectPtrLabel(const GLvoid *ptr, GLsizei length, const GLchar *label);
void GLAPIENTRY _mesa_GetObjectPtrLabel(const GLvoid *ptr, GLsizei bufSize, GLsizei *length, GLchar *label);
void GLAPIENTRY _mesa_ClearBufferData(GLenum target, GLenum internalformat, GLenum format, GLenum type, const GLvoid *data);
void GLAPIENTRY _mesa_ClearBufferData_no_error(GLenum target, GLenum internalformat, GLenum format, GLenum type, const GLvoid *data);
void GLAPIENTRY _mesa_ClearBufferSubData(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid *data);
void GLAPIENTRY _mesa_ClearBufferSubData_no_error(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid *data);
void GLAPIENTRY _mesa_ClearNamedBufferDataEXT(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const GLvoid *data);
void GLAPIENTRY _mesa_ClearNamedBufferSubDataEXT(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid *data);
void GLAPIENTRY _mesa_DispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z);
void GLAPIENTRY _mesa_DispatchCompute_no_error(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z);
void GLAPIENTRY _mesa_DispatchComputeIndirect(GLintptr indirect);
void GLAPIENTRY _mesa_DispatchComputeIndirect_no_error(GLintptr indirect);
void GLAPIENTRY _mesa_CopyImageSubData(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth);
void GLAPIENTRY _mesa_CopyImageSubData_no_error(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth);
void GLAPIENTRY _mesa_TextureView(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers);
void GLAPIENTRY _mesa_TextureView_no_error(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers);
void GLAPIENTRY _mesa_BindVertexBuffer(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
void GLAPIENTRY _mesa_BindVertexBuffer_no_error(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
void GLAPIENTRY _mesa_VertexAttribFormat(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
void GLAPIENTRY _mesa_VertexAttribIFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
void GLAPIENTRY _mesa_VertexAttribLFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
void GLAPIENTRY _mesa_VertexAttribBinding(GLuint attribindex, GLuint bindingindex);
void GLAPIENTRY _mesa_VertexAttribBinding_no_error(GLuint attribindex, GLuint bindingindex);
void GLAPIENTRY _mesa_VertexBindingDivisor(GLuint bindingindex, GLuint divisor);
void GLAPIENTRY _mesa_VertexBindingDivisor_no_error(GLuint bindingindex, GLuint divisor);
void GLAPIENTRY _mesa_VertexArrayBindVertexBufferEXT(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
void GLAPIENTRY _mesa_VertexArrayVertexAttribFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
void GLAPIENTRY _mesa_VertexArrayVertexAttribIFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
void GLAPIENTRY _mesa_VertexArrayVertexAttribLFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
void GLAPIENTRY _mesa_VertexArrayVertexAttribBindingEXT(GLuint vaobj, GLuint attribindex, GLuint bindingindex);
void GLAPIENTRY _mesa_VertexArrayVertexBindingDivisorEXT(GLuint vaobj, GLuint bindingindex, GLuint divisor);
void GLAPIENTRY _mesa_FramebufferParameteri(GLenum target, GLenum pname, GLint param);
void GLAPIENTRY _mesa_GetFramebufferParameteriv(GLenum target, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_NamedFramebufferParameteriEXT(GLuint framebuffer, GLenum pname, GLint param);
void GLAPIENTRY _mesa_GetNamedFramebufferParameterivEXT(GLuint framebuffer, GLenum pname, GLint*params);
void GLAPIENTRY _mesa_GetInternalformati64v(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params);
void GLAPIENTRY _mesa_InvalidateTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth);
void GLAPIENTRY _mesa_InvalidateTexSubImage_no_error(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth);
void GLAPIENTRY _mesa_InvalidateTexImage(GLuint texture, GLint level);
void GLAPIENTRY _mesa_InvalidateTexImage_no_error(GLuint texture, GLint level);
void GLAPIENTRY _mesa_InvalidateBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr length);
void GLAPIENTRY _mesa_InvalidateBufferSubData_no_error(GLuint buffer, GLintptr offset, GLsizeiptr length);
void GLAPIENTRY _mesa_InvalidateBufferData(GLuint buffer);
void GLAPIENTRY _mesa_InvalidateBufferData_no_error(GLuint buffer);
void GLAPIENTRY _mesa_InvalidateSubFramebuffer(GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_InvalidateSubFramebuffer_no_error(GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_InvalidateFramebuffer(GLenum target, GLsizei numAttachments, const GLenum *attachments);
void GLAPIENTRY _mesa_InvalidateFramebuffer_no_error(GLenum target, GLsizei numAttachments, const GLenum *attachments);
void GLAPIENTRY _mesa_GetProgramInterfaceiv(GLuint program, GLenum programInterface, GLenum pname, GLint *params);
GLuint GLAPIENTRY _mesa_GetProgramResourceIndex(GLuint program, GLenum programInterface, const GLchar *name);
void GLAPIENTRY _mesa_GetProgramResourceName(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name);
void GLAPIENTRY _mesa_GetProgramResourceiv(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params);
GLint GLAPIENTRY _mesa_GetProgramResourceLocation(GLuint program, GLenum programInterface, const GLchar *name);
GLint GLAPIENTRY _mesa_GetProgramResourceLocationIndex(GLuint program, GLenum programInterface, const GLchar *name);
void GLAPIENTRY _mesa_ShaderStorageBlockBinding(GLuint program, GLuint shaderStorageBlockIndex, GLuint shaderStorageBlockBinding);
void GLAPIENTRY _mesa_ShaderStorageBlockBinding_no_error(GLuint program, GLuint shaderStorageBlockIndex, GLuint shaderStorageBlockBinding);
void GLAPIENTRY _mesa_TexBufferRange(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
void GLAPIENTRY _mesa_TextureBufferRangeEXT(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
void GLAPIENTRY _mesa_TexStorage2DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
void GLAPIENTRY _mesa_TexStorage3DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
void GLAPIENTRY _mesa_TextureStorage2DMultisampleEXT(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
void GLAPIENTRY _mesa_TextureStorage3DMultisampleEXT(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
void GLAPIENTRY _mesa_BufferStorage(GLenum target, GLsizeiptr size, const GLvoid *data, GLbitfield flags);
void GLAPIENTRY _mesa_BufferStorage_no_error(GLenum target, GLsizeiptr size, const GLvoid *data, GLbitfield flags);
void GLAPIENTRY _mesa_NamedBufferStorageEXT(GLuint buffer, GLsizeiptr size, const GLvoid *data, GLbitfield flags);
void GLAPIENTRY _mesa_ClearTexImage(GLuint texture, GLint level, GLenum format, GLenum type, const GLvoid *data);
void GLAPIENTRY _mesa_ClearTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *data);
void GLAPIENTRY _mesa_BindBuffersBase(GLenum target, GLuint first, GLsizei count, const GLuint *buffers);
void GLAPIENTRY _mesa_BindBuffersRange(GLenum target, GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizeiptr *sizes);
void GLAPIENTRY _mesa_BindTextures(GLuint first, GLsizei count, const GLuint *textures);
void GLAPIENTRY _mesa_BindTextures_no_error(GLuint first, GLsizei count, const GLuint *textures);
void GLAPIENTRY _mesa_BindSamplers(GLuint first, GLsizei count, const GLuint *samplers);
void GLAPIENTRY _mesa_BindSamplers_no_error(GLuint first, GLsizei count, const GLuint *samplers);
void GLAPIENTRY _mesa_BindImageTextures(GLuint first, GLsizei count, const GLuint *textures);
void GLAPIENTRY _mesa_BindImageTextures_no_error(GLuint first, GLsizei count, const GLuint *textures);
void GLAPIENTRY _mesa_BindVertexBuffers(GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizei *strides);
void GLAPIENTRY _mesa_BindVertexBuffers_no_error(GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizei *strides);
GLuint64 GLAPIENTRY _mesa_GetTextureHandleARB(GLuint texture);
GLuint64 GLAPIENTRY _mesa_GetTextureHandleARB_no_error(GLuint texture);
GLuint64 GLAPIENTRY _mesa_GetTextureSamplerHandleARB(GLuint texture, GLuint sampler);
GLuint64 GLAPIENTRY _mesa_GetTextureSamplerHandleARB_no_error(GLuint texture, GLuint sampler);
void GLAPIENTRY _mesa_MakeTextureHandleResidentARB(GLuint64 handle);
void GLAPIENTRY _mesa_MakeTextureHandleResidentARB_no_error(GLuint64 handle);
void GLAPIENTRY _mesa_MakeTextureHandleNonResidentARB(GLuint64 handle);
void GLAPIENTRY _mesa_MakeTextureHandleNonResidentARB_no_error(GLuint64 handle);
GLuint64 GLAPIENTRY _mesa_GetImageHandleARB(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format);
GLuint64 GLAPIENTRY _mesa_GetImageHandleARB_no_error(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format);
void GLAPIENTRY _mesa_MakeImageHandleResidentARB(GLuint64 handle, GLenum access);
void GLAPIENTRY _mesa_MakeImageHandleResidentARB_no_error(GLuint64 handle, GLenum access);
void GLAPIENTRY _mesa_MakeImageHandleNonResidentARB(GLuint64 handle);
void GLAPIENTRY _mesa_MakeImageHandleNonResidentARB_no_error(GLuint64 handle);
void GLAPIENTRY _mesa_UniformHandleui64ARB(GLint location, GLuint64 value);
void GLAPIENTRY _mesa_UniformHandleui64vARB(GLint location, GLsizei count, const GLuint64 *value);
void GLAPIENTRY _mesa_ProgramUniformHandleui64ARB(GLuint program, GLint location, GLuint64 value);
void GLAPIENTRY _mesa_ProgramUniformHandleui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 *value);
GLboolean GLAPIENTRY _mesa_IsTextureHandleResidentARB(GLuint64 handle);
GLboolean GLAPIENTRY _mesa_IsTextureHandleResidentARB_no_error(GLuint64 handle);
GLboolean GLAPIENTRY _mesa_IsImageHandleResidentARB(GLuint64 handle);
GLboolean GLAPIENTRY _mesa_IsImageHandleResidentARB_no_error(GLuint64 handle);
void GLAPIENTRY _mesa_VertexAttribL1ui64ARB(GLuint index, GLuint64EXT x);
void GLAPIENTRY _mesa_VertexAttribL1ui64vARB(GLuint index, const GLuint64EXT *v);
void GLAPIENTRY _mesa_GetVertexAttribLui64vARB(GLuint index, GLenum pname, GLuint64EXT *params);
void GLAPIENTRY _mesa_DispatchComputeGroupSizeARB(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z);
void GLAPIENTRY _mesa_DispatchComputeGroupSizeARB_no_error(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z);
void GLAPIENTRY _mesa_MultiDrawArraysIndirectCountARB(GLenum mode, GLintptr indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride);
void GLAPIENTRY _mesa_MultiDrawElementsIndirectCountARB(GLenum mode, GLenum type, GLintptr indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride);
void GLAPIENTRY _mesa_TexPageCommitmentARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit);
void GLAPIENTRY _mesa_TexturePageCommitmentEXT(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit);
void GLAPIENTRY _mesa_ClipControl(GLenum origin, GLenum depth);
void GLAPIENTRY _mesa_ClipControl_no_error(GLenum origin, GLenum depth);
void GLAPIENTRY _mesa_CreateTransformFeedbacks(GLsizei n, GLuint *ids);
void GLAPIENTRY _mesa_TransformFeedbackBufferBase(GLuint xfb, GLuint index, GLuint buffer);
void GLAPIENTRY _mesa_TransformFeedbackBufferRange(GLuint xfb, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
void GLAPIENTRY _mesa_GetTransformFeedbackiv(GLuint xfb, GLenum pname, GLint *param);
void GLAPIENTRY _mesa_GetTransformFeedbacki_v(GLuint xfb, GLenum pname, GLuint index, GLint *param);
void GLAPIENTRY _mesa_GetTransformFeedbacki64_v(GLuint xfb, GLenum pname, GLuint index, GLint64 *param);
void GLAPIENTRY _mesa_CreateBuffers(GLsizei n, GLuint *buffers);
void GLAPIENTRY _mesa_CreateBuffers_no_error(GLsizei n, GLuint *buffers);
void GLAPIENTRY _mesa_NamedBufferStorage(GLuint buffer, GLsizeiptr size, const GLvoid *data, GLbitfield flags);
void GLAPIENTRY _mesa_NamedBufferStorage_no_error(GLuint buffer, GLsizeiptr size, const GLvoid *data, GLbitfield flags);
void GLAPIENTRY _mesa_NamedBufferData(GLuint buffer, GLsizeiptr size, const GLvoid *data, GLenum usage);
void GLAPIENTRY _mesa_NamedBufferData_no_error(GLuint buffer, GLsizeiptr size, const GLvoid *data, GLenum usage);
void GLAPIENTRY _mesa_NamedBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr size, const GLvoid *data);
void GLAPIENTRY _mesa_NamedBufferSubData_no_error(GLuint buffer, GLintptr offset, GLsizeiptr size, const GLvoid *data);
void GLAPIENTRY _mesa_CopyNamedBufferSubData(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
void GLAPIENTRY _mesa_CopyNamedBufferSubData_no_error(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
void GLAPIENTRY _mesa_ClearNamedBufferData(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const GLvoid *data);
void GLAPIENTRY _mesa_ClearNamedBufferData_no_error(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const GLvoid *data);
void GLAPIENTRY _mesa_ClearNamedBufferSubData(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid *data);
void GLAPIENTRY _mesa_ClearNamedBufferSubData_no_error(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid *data);
GLvoid * GLAPIENTRY _mesa_MapNamedBuffer(GLuint buffer, GLenum access);
GLvoid * GLAPIENTRY _mesa_MapNamedBuffer_no_error(GLuint buffer, GLenum access);
GLvoid * GLAPIENTRY _mesa_MapNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access);
GLvoid * GLAPIENTRY _mesa_MapNamedBufferRange_no_error(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access);
GLboolean GLAPIENTRY _mesa_UnmapNamedBufferEXT(GLuint buffer);
GLboolean GLAPIENTRY _mesa_UnmapNamedBufferEXT_no_error(GLuint buffer);
void GLAPIENTRY _mesa_FlushMappedNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length);
void GLAPIENTRY _mesa_FlushMappedNamedBufferRange_no_error(GLuint buffer, GLintptr offset, GLsizeiptr length);
void GLAPIENTRY _mesa_GetNamedBufferParameteriv(GLuint buffer, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetNamedBufferParameteri64v(GLuint buffer, GLenum pname, GLint64 *params);
void GLAPIENTRY _mesa_GetNamedBufferPointerv(GLuint buffer, GLenum pname, GLvoid **params);
void GLAPIENTRY _mesa_GetNamedBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr size, GLvoid *data);
void GLAPIENTRY _mesa_CreateFramebuffers(GLsizei n, GLuint *framebuffers);
void GLAPIENTRY _mesa_NamedFramebufferRenderbuffer(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
void GLAPIENTRY _mesa_NamedFramebufferRenderbuffer_no_error(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
void GLAPIENTRY _mesa_NamedFramebufferParameteri(GLuint framebuffer, GLenum pname, GLint param);
void GLAPIENTRY _mesa_NamedFramebufferTexture(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level);
void GLAPIENTRY _mesa_NamedFramebufferTexture_no_error(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level);
void GLAPIENTRY _mesa_NamedFramebufferTextureLayer(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer);
void GLAPIENTRY _mesa_NamedFramebufferTextureLayer_no_error(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer);
void GLAPIENTRY _mesa_NamedFramebufferDrawBuffer(GLuint framebuffer, GLenum buf);
void GLAPIENTRY _mesa_NamedFramebufferDrawBuffer_no_error(GLuint framebuffer, GLenum buf);
void GLAPIENTRY _mesa_NamedFramebufferDrawBuffers(GLuint framebuffer, GLsizei n, const GLenum *bufs);
void GLAPIENTRY _mesa_NamedFramebufferDrawBuffers_no_error(GLuint framebuffer, GLsizei n, const GLenum *bufs);
void GLAPIENTRY _mesa_NamedFramebufferReadBuffer(GLuint framebuffer, GLenum buf);
void GLAPIENTRY _mesa_NamedFramebufferReadBuffer_no_error(GLuint framebuffer, GLenum buf);
void GLAPIENTRY _mesa_InvalidateNamedFramebufferData(GLuint framebuffer, GLsizei numAttachments, const GLenum *attachments);
void GLAPIENTRY _mesa_InvalidateNamedFramebufferSubData(GLuint framebuffer, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_ClearNamedFramebufferiv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLint *value);
void GLAPIENTRY _mesa_ClearNamedFramebufferuiv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLuint *value);
void GLAPIENTRY _mesa_ClearNamedFramebufferfv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLfloat *value);
void GLAPIENTRY _mesa_ClearNamedFramebufferfi(GLuint framebuffer, GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil);
void GLAPIENTRY _mesa_BlitNamedFramebuffer(GLuint readFramebuffer, GLuint drawFramebuffer, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
void GLAPIENTRY _mesa_BlitNamedFramebuffer_no_error(GLuint readFramebuffer, GLuint drawFramebuffer, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
GLenum GLAPIENTRY _mesa_CheckNamedFramebufferStatus(GLuint framebuffer, GLenum target);
void GLAPIENTRY _mesa_GetNamedFramebufferParameteriv(GLuint framebuffer, GLenum pname, GLint *param);
void GLAPIENTRY _mesa_GetNamedFramebufferAttachmentParameteriv(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_CreateRenderbuffers(GLsizei n, GLuint *renderbuffers);
void GLAPIENTRY _mesa_CreateRenderbuffers_no_error(GLsizei n, GLuint *renderbuffers);
void GLAPIENTRY _mesa_NamedRenderbufferStorage(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_NamedRenderbufferStorageMultisample(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_GetNamedRenderbufferParameteriv(GLuint renderbuffer, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_CreateTextures(GLenum target, GLsizei n, GLuint *textures);
void GLAPIENTRY _mesa_CreateTextures_no_error(GLenum target, GLsizei n, GLuint *textures);
void GLAPIENTRY _mesa_TextureBuffer(GLuint texture, GLenum internalformat, GLuint buffer);
void GLAPIENTRY _mesa_TextureBufferRange(GLuint texture, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
void GLAPIENTRY _mesa_TextureStorage1D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width);
void GLAPIENTRY _mesa_TextureStorage1D_no_error(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width);
void GLAPIENTRY _mesa_TextureStorage2D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_TextureStorage2D_no_error(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_TextureStorage3D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
void GLAPIENTRY _mesa_TextureStorage3D_no_error(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
void GLAPIENTRY _mesa_TextureStorage2DMultisample(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
void GLAPIENTRY _mesa_TextureStorage3DMultisample(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
void GLAPIENTRY _mesa_TextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TextureSubImage1D_no_error(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TextureSubImage2D_no_error(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TextureSubImage3D_no_error(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_CompressedTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTextureSubImage1D_no_error(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTextureSubImage2D_no_error(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTextureSubImage3D_no_error(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CopyTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
void GLAPIENTRY _mesa_CopyTextureSubImage1D_no_error(GLuint texture, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
void GLAPIENTRY _mesa_CopyTextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_CopyTextureSubImage2D_no_error(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_CopyTextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_CopyTextureSubImage3D_no_error(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_TextureParameterf(GLuint texture, GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_TextureParameterfv(GLuint texture, GLenum pname, const GLfloat *param);
void GLAPIENTRY _mesa_TextureParameteri(GLuint texture, GLenum pname, GLint param);
void GLAPIENTRY _mesa_TextureParameterIiv(GLuint texture, GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_TextureParameterIuiv(GLuint texture, GLenum pname, const GLuint *params);
void GLAPIENTRY _mesa_TextureParameteriv(GLuint texture, GLenum pname, const GLint *param);
void GLAPIENTRY _mesa_GenerateTextureMipmap(GLuint texture);
void GLAPIENTRY _mesa_GenerateTextureMipmap_no_error(GLuint texture);
void GLAPIENTRY _mesa_BindTextureUnit(GLuint unit, GLuint texture);
void GLAPIENTRY _mesa_BindTextureUnit_no_error(GLuint unit, GLuint texture);
void GLAPIENTRY _mesa_GetTextureImage(GLuint texture, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid *pixels);
void GLAPIENTRY _mesa_GetCompressedTextureImage(GLuint texture, GLint level, GLsizei bufSize, GLvoid *pixels);
void GLAPIENTRY _mesa_GetTextureLevelParameterfv(GLuint texture, GLint level, GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetTextureLevelParameteriv(GLuint texture, GLint level, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetTextureParameterfv(GLuint texture, GLenum pname, GLfloat *params);
void GLAPIENTRY _mesa_GetTextureParameterIiv(GLuint texture, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetTextureParameterIuiv(GLuint texture, GLenum pname, GLuint *params);
void GLAPIENTRY _mesa_GetTextureParameteriv(GLuint texture, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_CreateVertexArrays(GLsizei n, GLuint *arrays);
void GLAPIENTRY _mesa_CreateVertexArrays_no_error(GLsizei n, GLuint *arrays);
void GLAPIENTRY _mesa_DisableVertexArrayAttrib(GLuint vaobj, GLuint index);
void GLAPIENTRY _mesa_DisableVertexArrayAttrib_no_error(GLuint vaobj, GLuint index);
void GLAPIENTRY _mesa_EnableVertexArrayAttrib(GLuint vaobj, GLuint index);
void GLAPIENTRY _mesa_EnableVertexArrayAttrib_no_error(GLuint vaobj, GLuint index);
void GLAPIENTRY _mesa_VertexArrayElementBuffer(GLuint vaobj, GLuint buffer);
void GLAPIENTRY _mesa_VertexArrayElementBuffer_no_error(GLuint vaobj, GLuint buffer);
void GLAPIENTRY _mesa_VertexArrayVertexBuffer(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
void GLAPIENTRY _mesa_VertexArrayVertexBuffer_no_error(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
void GLAPIENTRY _mesa_VertexArrayVertexBuffers(GLuint vaobj, GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizei *strides);
void GLAPIENTRY _mesa_VertexArrayVertexBuffers_no_error(GLuint vaobj, GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizei *strides);
void GLAPIENTRY _mesa_VertexArrayAttribFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
void GLAPIENTRY _mesa_VertexArrayAttribIFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
void GLAPIENTRY _mesa_VertexArrayAttribLFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
void GLAPIENTRY _mesa_VertexArrayAttribBinding(GLuint vaobj, GLuint attribindex, GLuint bindingindex);
void GLAPIENTRY _mesa_VertexArrayAttribBinding_no_error(GLuint vaobj, GLuint attribindex, GLuint bindingindex);
void GLAPIENTRY _mesa_VertexArrayBindingDivisor(GLuint vaobj, GLuint bindingindex, GLuint divisor);
void GLAPIENTRY _mesa_VertexArrayBindingDivisor_no_error(GLuint vaobj, GLuint bindingindex, GLuint divisor);
void GLAPIENTRY _mesa_GetVertexArrayiv(GLuint vaobj, GLenum pname, GLint *param);
void GLAPIENTRY _mesa_GetVertexArrayIndexediv(GLuint vaobj, GLuint index, GLenum pname, GLint *param);
void GLAPIENTRY _mesa_GetVertexArrayIndexed64iv(GLuint vaobj, GLuint index, GLenum pname, GLint64 *param);
void GLAPIENTRY _mesa_CreateSamplers(GLsizei n, GLuint *samplers);
void GLAPIENTRY _mesa_CreateSamplers_no_error(GLsizei n, GLuint *samplers);
void GLAPIENTRY _mesa_CreateProgramPipelines(GLsizei n, GLuint *pipelines);
void GLAPIENTRY _mesa_CreateProgramPipelines_no_error(GLsizei n, GLuint *pipelines);
void GLAPIENTRY _mesa_CreateQueries(GLenum target, GLsizei n, GLuint *ids);
void GLAPIENTRY _mesa_GetQueryBufferObjectiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset);
void GLAPIENTRY _mesa_GetQueryBufferObjectuiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset);
void GLAPIENTRY _mesa_GetQueryBufferObjecti64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset);
void GLAPIENTRY _mesa_GetQueryBufferObjectui64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset);
void GLAPIENTRY _mesa_GetTextureSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLsizei bufSize, GLvoid *pixels);
void GLAPIENTRY _mesa_GetCompressedTextureSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei bufSize, GLvoid *pixels);
void GLAPIENTRY _mesa_TextureBarrierNV(void);
void GLAPIENTRY _mesa_BufferPageCommitmentARB(GLenum target, GLintptr offset, GLsizeiptr size, GLboolean commit);
void GLAPIENTRY _mesa_NamedBufferPageCommitmentEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, GLboolean commit);
void GLAPIENTRY _mesa_NamedBufferPageCommitmentARB(GLuint buffer, GLintptr offset, GLsizeiptr size, GLboolean commit);
void GLAPIENTRY _mesa_PrimitiveBoundingBox(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW);
void GLAPIENTRY _mesa_BlendBarrier(void);
void GLAPIENTRY _mesa_Uniform1i64ARB(GLint location, GLint64 x);
void GLAPIENTRY _mesa_Uniform2i64ARB(GLint location, GLint64 x, GLint64 y);
void GLAPIENTRY _mesa_Uniform3i64ARB(GLint location, GLint64 x, GLint64 y, GLint64 z);
void GLAPIENTRY _mesa_Uniform4i64ARB(GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w);
void GLAPIENTRY _mesa_Uniform1i64vARB(GLint location, GLsizei count, const GLint64 *value);
void GLAPIENTRY _mesa_Uniform2i64vARB(GLint location, GLsizei count, const GLint64 *value);
void GLAPIENTRY _mesa_Uniform3i64vARB(GLint location, GLsizei count, const GLint64 *value);
void GLAPIENTRY _mesa_Uniform4i64vARB(GLint location, GLsizei count, const GLint64 *value);
void GLAPIENTRY _mesa_Uniform1ui64ARB(GLint location, GLuint64 x);
void GLAPIENTRY _mesa_Uniform2ui64ARB(GLint location, GLuint64 x, GLuint64 y);
void GLAPIENTRY _mesa_Uniform3ui64ARB(GLint location, GLuint64 x, GLuint64 y, GLuint64 z);
void GLAPIENTRY _mesa_Uniform4ui64ARB(GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w);
void GLAPIENTRY _mesa_Uniform1ui64vARB(GLint location, GLsizei count, const GLuint64 *value);
void GLAPIENTRY _mesa_Uniform2ui64vARB(GLint location, GLsizei count, const GLuint64 *value);
void GLAPIENTRY _mesa_Uniform3ui64vARB(GLint location, GLsizei count, const GLuint64 *value);
void GLAPIENTRY _mesa_Uniform4ui64vARB(GLint location, GLsizei count, const GLuint64 *value);
void GLAPIENTRY _mesa_GetUniformi64vARB(GLuint program, GLint location, GLint64 *params);
void GLAPIENTRY _mesa_GetUniformui64vARB(GLuint program, GLint location, GLuint64 *params);
void GLAPIENTRY _mesa_GetnUniformi64vARB(GLuint program, GLint location, GLsizei bufSize, GLint64 *params);
void GLAPIENTRY _mesa_GetnUniformui64vARB(GLuint program, GLint location, GLsizei bufSize, GLuint64 *params);
void GLAPIENTRY _mesa_ProgramUniform1i64ARB(GLuint program, GLint location, GLint64 x);
void GLAPIENTRY _mesa_ProgramUniform2i64ARB(GLuint program, GLint location, GLint64 x, GLint64 y);
void GLAPIENTRY _mesa_ProgramUniform3i64ARB(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z);
void GLAPIENTRY _mesa_ProgramUniform4i64ARB(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w);
void GLAPIENTRY _mesa_ProgramUniform1i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 *value);
void GLAPIENTRY _mesa_ProgramUniform2i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 *value);
void GLAPIENTRY _mesa_ProgramUniform3i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 *value);
void GLAPIENTRY _mesa_ProgramUniform4i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 *value);
void GLAPIENTRY _mesa_ProgramUniform1ui64ARB(GLuint program, GLint location, GLuint64 x);
void GLAPIENTRY _mesa_ProgramUniform2ui64ARB(GLuint program, GLint location, GLuint64 x, GLuint64 y);
void GLAPIENTRY _mesa_ProgramUniform3ui64ARB(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z);
void GLAPIENTRY _mesa_ProgramUniform4ui64ARB(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w);
void GLAPIENTRY _mesa_ProgramUniform1ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 *value);
void GLAPIENTRY _mesa_ProgramUniform2ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 *value);
void GLAPIENTRY _mesa_ProgramUniform3ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 *value);
void GLAPIENTRY _mesa_ProgramUniform4ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 *value);
void GLAPIENTRY _mesa_MaxShaderCompilerThreadsKHR(GLuint count);
void GLAPIENTRY _mesa_SpecializeShaderARB(GLuint shader, const GLchar *pEntryPoint, GLuint numSpecializationConstants, const GLuint *pConstantIndex, const GLuint *pConstantValue);
void GLAPIENTRY _mesa_ColorPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
void GLAPIENTRY _mesa_EdgeFlagPointerEXT(GLsizei stride, GLsizei count, const GLboolean *pointer);
void GLAPIENTRY _mesa_IndexPointerEXT(GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
void GLAPIENTRY _mesa_NormalPointerEXT(GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
void GLAPIENTRY _mesa_TexCoordPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
void GLAPIENTRY _mesa_VertexPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
void GLAPIENTRY _mesa_LockArraysEXT(GLint first, GLsizei count);
void GLAPIENTRY _mesa_UnlockArraysEXT(void);
void GLAPIENTRY _mesa_ViewportArrayv(GLuint first, GLsizei count, const GLfloat *v);
void GLAPIENTRY _mesa_ViewportArrayv_no_error(GLuint first, GLsizei count, const GLfloat *v);
void GLAPIENTRY _mesa_ViewportIndexedf(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h);
void GLAPIENTRY _mesa_ViewportIndexedf_no_error(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h);
void GLAPIENTRY _mesa_ViewportIndexedfv(GLuint index, const GLfloat *v);
void GLAPIENTRY _mesa_ViewportIndexedfv_no_error(GLuint index, const GLfloat *v);
void GLAPIENTRY _mesa_ScissorArrayv(GLuint first, GLsizei count, const int *v);
void GLAPIENTRY _mesa_ScissorArrayv_no_error(GLuint first, GLsizei count, const int *v);
void GLAPIENTRY _mesa_ScissorIndexed(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_ScissorIndexed_no_error(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_ScissorIndexedv(GLuint index, const GLint *v);
void GLAPIENTRY _mesa_ScissorIndexedv_no_error(GLuint index, const GLint *v);
void GLAPIENTRY _mesa_DepthRangeArrayv(GLuint first, GLsizei count, const GLclampd *v);
void GLAPIENTRY _mesa_DepthRangeArrayv_no_error(GLuint first, GLsizei count, const GLclampd *v);
void GLAPIENTRY _mesa_DepthRangeIndexed(GLuint index, GLclampd n, GLclampd f);
void GLAPIENTRY _mesa_DepthRangeIndexed_no_error(GLuint index, GLclampd n, GLclampd f);
void GLAPIENTRY _mesa_GetFloati_v(GLenum target, GLuint index, GLfloat *data);
void GLAPIENTRY _mesa_GetDoublei_v(GLenum target, GLuint index, GLdouble *data);
void GLAPIENTRY _mesa_FramebufferSampleLocationsfvARB(GLenum target, GLuint start, GLsizei count, const GLfloat *v);
void GLAPIENTRY _mesa_FramebufferSampleLocationsfvARB_no_error(GLenum target, GLuint start, GLsizei count, const GLfloat *v);
void GLAPIENTRY _mesa_NamedFramebufferSampleLocationsfvARB(GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v);
void GLAPIENTRY _mesa_NamedFramebufferSampleLocationsfvARB_no_error(GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v);
void GLAPIENTRY _mesa_EvaluateDepthValuesARB(void);
void GLAPIENTRY _mesa_WindowPos4dMESA(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLAPIENTRY _mesa_WindowPos4dvMESA(const GLdouble *v);
void GLAPIENTRY _mesa_WindowPos4fMESA(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void GLAPIENTRY _mesa_WindowPos4fvMESA(const GLfloat *v);
void GLAPIENTRY _mesa_WindowPos4iMESA(GLint x, GLint y, GLint z, GLint w);
void GLAPIENTRY _mesa_WindowPos4ivMESA(const GLint *v);
void GLAPIENTRY _mesa_WindowPos4sMESA(GLshort x, GLshort y, GLshort z, GLshort w);
void GLAPIENTRY _mesa_WindowPos4svMESA(const GLshort *v);
void GLAPIENTRY _mesa_MultiModeDrawArraysIBM(const GLenum *mode, const GLint *first, const GLsizei *count, GLsizei primcount, GLint modestride);
void GLAPIENTRY _mesa_MultiModeDrawElementsIBM(const GLenum *mode, const GLsizei *count, GLenum type, const GLvoid * const *indices, GLsizei primcount, GLint modestride);
void GLAPIENTRY _mesa_VertexAttrib1sNV(GLuint index, GLshort x);
void GLAPIENTRY _mesa_VertexAttrib1svNV(GLuint index, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttrib2sNV(GLuint index, GLshort x, GLshort y);
void GLAPIENTRY _mesa_VertexAttrib2svNV(GLuint index, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttrib3sNV(GLuint index, GLshort x, GLshort y, GLshort z);
void GLAPIENTRY _mesa_VertexAttrib3svNV(GLuint index, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttrib4sNV(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
void GLAPIENTRY _mesa_VertexAttrib4svNV(GLuint index, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttrib1fNV(GLuint index, GLfloat x);
void GLAPIENTRY _mesa_VertexAttrib1fvNV(GLuint index, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttrib2fNV(GLuint index, GLfloat x, GLfloat y);
void GLAPIENTRY _mesa_VertexAttrib2fvNV(GLuint index, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttrib3fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_VertexAttrib3fvNV(GLuint index, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttrib4fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void GLAPIENTRY _mesa_VertexAttrib4fvNV(GLuint index, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttrib1dNV(GLuint index, GLdouble x);
void GLAPIENTRY _mesa_VertexAttrib1dvNV(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttrib2dNV(GLuint index, GLdouble x, GLdouble y);
void GLAPIENTRY _mesa_VertexAttrib2dvNV(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttrib3dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_VertexAttrib3dvNV(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttrib4dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLAPIENTRY _mesa_VertexAttrib4dvNV(GLuint index, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttrib4ubNV(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
void GLAPIENTRY _mesa_VertexAttrib4ubvNV(GLuint index, const GLubyte *v);
void GLAPIENTRY _mesa_VertexAttribs1svNV(GLuint index, GLsizei n, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttribs2svNV(GLuint index, GLsizei n, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttribs3svNV(GLuint index, GLsizei n, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttribs4svNV(GLuint index, GLsizei n, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttribs1fvNV(GLuint index, GLsizei n, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttribs2fvNV(GLuint index, GLsizei n, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttribs3fvNV(GLuint index, GLsizei n, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttribs4fvNV(GLuint index, GLsizei n, const GLfloat *v);
void GLAPIENTRY _mesa_VertexAttribs1dvNV(GLuint index, GLsizei n, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttribs2dvNV(GLuint index, GLsizei n, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttribs3dvNV(GLuint index, GLsizei n, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttribs4dvNV(GLuint index, GLsizei n, const GLdouble *v);
void GLAPIENTRY _mesa_VertexAttribs4ubvNV(GLuint index, GLsizei n, const GLubyte *v);
GLuint GLAPIENTRY _mesa_GenFragmentShadersATI(GLuint range);
void GLAPIENTRY _mesa_BindFragmentShaderATI(GLuint id);
void GLAPIENTRY _mesa_DeleteFragmentShaderATI(GLuint id);
void GLAPIENTRY _mesa_BeginFragmentShaderATI(void);
void GLAPIENTRY _mesa_EndFragmentShaderATI(void);
void GLAPIENTRY _mesa_PassTexCoordATI(GLuint dst, GLuint coord, GLenum swizzle);
void GLAPIENTRY _mesa_SampleMapATI(GLuint dst, GLuint interp, GLenum swizzle);
void GLAPIENTRY _mesa_ColorFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod);
void GLAPIENTRY _mesa_ColorFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod);
void GLAPIENTRY _mesa_ColorFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod);
void GLAPIENTRY _mesa_AlphaFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod);
void GLAPIENTRY _mesa_AlphaFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod);
void GLAPIENTRY _mesa_AlphaFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod);
void GLAPIENTRY _mesa_SetFragmentShaderConstantATI(GLuint dst, const GLfloat *value);
void GLAPIENTRY _mesa_ActiveStencilFaceEXT(GLenum face);
void GLAPIENTRY _mesa_DepthBoundsEXT(GLclampd zmin, GLclampd zmax);
void GLAPIENTRY _mesa_BindRenderbufferEXT(GLenum target, GLuint renderbuffer);
void GLAPIENTRY _mesa_BindFramebufferEXT(GLenum target, GLuint framebuffer);
void GLAPIENTRY _mesa_StringMarkerGREMEDY(GLsizei len, const GLvoid *string);
void GLAPIENTRY _mesa_ProvokingVertex(GLenum mode);
void GLAPIENTRY _mesa_ColorMaski(GLuint buf, GLboolean r, GLboolean g, GLboolean b, GLboolean a);
void GLAPIENTRY _mesa_GetBooleani_v(GLenum value, GLuint index, GLboolean *data);
void GLAPIENTRY _mesa_GetIntegeri_v(GLenum value, GLuint index, GLint *data);
void GLAPIENTRY _mesa_Enablei(GLenum target, GLuint index);
void GLAPIENTRY _mesa_Disablei(GLenum target, GLuint index);
GLboolean GLAPIENTRY _mesa_IsEnabledi(GLenum target, GLuint index);
void GLAPIENTRY _mesa_GetPerfMonitorGroupsAMD(GLint *numGroups, GLsizei groupsSize, GLuint *groups);
void GLAPIENTRY _mesa_GetPerfMonitorCountersAMD(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei countersSize, GLuint *counters);
void GLAPIENTRY _mesa_GetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString);
void GLAPIENTRY _mesa_GetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString);
void GLAPIENTRY _mesa_GetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, GLvoid *data);
void GLAPIENTRY _mesa_GenPerfMonitorsAMD(GLsizei n, GLuint *monitors);
void GLAPIENTRY _mesa_DeletePerfMonitorsAMD(GLsizei n, GLuint *monitors);
void GLAPIENTRY _mesa_SelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *counterList);
void GLAPIENTRY _mesa_BeginPerfMonitorAMD(GLuint monitor);
void GLAPIENTRY _mesa_EndPerfMonitorAMD(GLuint monitor);
void GLAPIENTRY _mesa_GetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten);
void GLAPIENTRY _mesa_CopyImageSubDataNV(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth);
void GLAPIENTRY _mesa_CopyImageSubDataNV_no_error(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth);
void GLAPIENTRY _mesa_MatrixLoadfEXT(GLenum matrixMode, const GLfloat *m);
void GLAPIENTRY _mesa_MatrixLoaddEXT(GLenum matrixMode, const GLdouble *m);
void GLAPIENTRY _mesa_MatrixMultfEXT(GLenum matrixMode, const GLfloat *m);
void GLAPIENTRY _mesa_MatrixMultdEXT(GLenum matrixMode, const GLdouble *m);
void GLAPIENTRY _mesa_MatrixLoadIdentityEXT(GLenum matrixMode);
void GLAPIENTRY _mesa_MatrixRotatefEXT(GLenum matrixMode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_MatrixRotatedEXT(GLenum matrixMode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_MatrixScalefEXT(GLenum matrixMode, GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_MatrixScaledEXT(GLenum matrixMode, GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_MatrixTranslatefEXT(GLenum matrixMode, GLfloat x, GLfloat y, GLfloat z);
void GLAPIENTRY _mesa_MatrixTranslatedEXT(GLenum matrixMode, GLdouble x, GLdouble y, GLdouble z);
void GLAPIENTRY _mesa_MatrixOrthoEXT(GLenum matrixMode, GLdouble l, GLdouble r, GLdouble b, GLdouble t, GLdouble n, GLdouble f);
void GLAPIENTRY _mesa_MatrixFrustumEXT(GLenum matrixMode, GLdouble l, GLdouble r, GLdouble b, GLdouble t, GLdouble n, GLdouble f);
void GLAPIENTRY _mesa_MatrixPushEXT(GLenum matrixMode);
void GLAPIENTRY _mesa_MatrixPopEXT(GLenum matrixMode);
void GLAPIENTRY _mesa_ClientAttribDefaultEXT(GLbitfield mask);
void GLAPIENTRY _mesa_PushClientAttribDefaultEXT(GLbitfield mask);
void GLAPIENTRY _mesa_GetTextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetTextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, float *params);
void GLAPIENTRY _mesa_GetTextureLevelParameterivEXT(GLuint texture, GLenum target, GLint level, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetTextureLevelParameterfvEXT(GLuint texture, GLenum target, GLint level, GLenum pname, float *params);
void GLAPIENTRY _mesa_TextureParameteriEXT(GLuint texture, GLenum target, GLenum pname, int param);
void GLAPIENTRY _mesa_TextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_TextureParameterfEXT(GLuint texture, GLenum target, GLenum pname, float param);
void GLAPIENTRY _mesa_TextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, const float *params);
void GLAPIENTRY _mesa_TextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLint internalFormat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_TextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
void GLAPIENTRY _mesa_CopyTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, int border);
void GLAPIENTRY _mesa_CopyTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, int border);
void GLAPIENTRY _mesa_CopyTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
void GLAPIENTRY _mesa_CopyTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_CopyTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_GetTextureImageEXT(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
void GLAPIENTRY _mesa_BindMultiTextureEXT(GLenum texunit, GLenum target, GLuint texture);
void GLAPIENTRY _mesa_EnableClientStateiEXT(GLenum array, GLuint index);
void GLAPIENTRY _mesa_DisableClientStateiEXT(GLenum array, GLuint index);
void GLAPIENTRY _mesa_GetPointerIndexedvEXT(GLenum target, GLuint index, GLvoid**params);
void GLAPIENTRY _mesa_MultiTexEnviEXT(GLenum texunit, GLenum target, GLenum pname, GLint param);
void GLAPIENTRY _mesa_MultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint *param);
void GLAPIENTRY _mesa_MultiTexEnvfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_MultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat *param);
void GLAPIENTRY _mesa_GetMultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, GLint *param);
void GLAPIENTRY _mesa_GetMultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat *param);
void GLAPIENTRY _mesa_MultiTexParameteriEXT(GLenum texunit, GLenum target, GLenum pname, GLint param);
void GLAPIENTRY _mesa_MultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint*param);
void GLAPIENTRY _mesa_MultiTexParameterfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_MultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat*param);
void GLAPIENTRY _mesa_GetMultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, GLint*params);
void GLAPIENTRY _mesa_GetMultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat*params);
void GLAPIENTRY _mesa_GetMultiTexImageEXT(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, GLvoid*pixels);
void GLAPIENTRY _mesa_GetMultiTexLevelParameterivEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint*params);
void GLAPIENTRY _mesa_GetMultiTexLevelParameterfvEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat*params);
void GLAPIENTRY _mesa_MultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid*pixels);
void GLAPIENTRY _mesa_MultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid*pixels);
void GLAPIENTRY _mesa_MultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid*pixels);
void GLAPIENTRY _mesa_MultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid*pixels);
void GLAPIENTRY _mesa_MultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid*pixels);
void GLAPIENTRY _mesa_MultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid*pixels);
void GLAPIENTRY _mesa_CopyMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
void GLAPIENTRY _mesa_CopyMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
void GLAPIENTRY _mesa_CopyMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
void GLAPIENTRY _mesa_CopyMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_CopyMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_MultiTexGendEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble param);
void GLAPIENTRY _mesa_MultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLdouble*param);
void GLAPIENTRY _mesa_MultiTexGenfEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_MultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLfloat *param);
void GLAPIENTRY _mesa_MultiTexGeniEXT(GLenum texunit, GLenum coord, GLenum pname, GLint param);
void GLAPIENTRY _mesa_MultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, const GLint *param);
void GLAPIENTRY _mesa_GetMultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble *param);
void GLAPIENTRY _mesa_GetMultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat *param);
void GLAPIENTRY _mesa_GetMultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, GLint *param);
void GLAPIENTRY _mesa_MultiTexCoordPointerEXT(GLenum texunit, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_MatrixLoadTransposefEXT(GLenum matrixMode, const GLfloat *m);
void GLAPIENTRY _mesa_MatrixLoadTransposedEXT(GLenum matrixMode, const GLdouble *m);
void GLAPIENTRY _mesa_MatrixMultTransposefEXT(GLenum matrixMode, const GLfloat *m);
void GLAPIENTRY _mesa_MatrixMultTransposedEXT(GLenum matrixMode, const GLdouble *m);
void GLAPIENTRY _mesa_CompressedTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_GetCompressedTextureImageEXT(GLuint texture, GLenum target, GLint level, GLvoid *img);
void GLAPIENTRY _mesa_CompressedMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedMultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei border, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_CompressedMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
void GLAPIENTRY _mesa_GetCompressedMultiTexImageEXT(GLenum texunit, GLenum target, GLint level, GLvoid *img);
void GLAPIENTRY _mesa_NamedBufferDataEXT(GLuint buffer, GLsizeiptr size, const GLvoid *data, GLenum usage);
void GLAPIENTRY _mesa_NamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, const GLvoid *data);
GLvoid * GLAPIENTRY _mesa_MapNamedBufferEXT(GLuint buffer, GLenum access);
void GLAPIENTRY _mesa_GetNamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, GLvoid *data);
void GLAPIENTRY _mesa_GetNamedBufferPointervEXT(GLuint buffer, GLenum pname, GLvoid **params);
void GLAPIENTRY _mesa_GetNamedBufferParameterivEXT(GLuint buffer, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_FlushMappedNamedBufferRangeEXT(GLuint buffer, GLintptr offset, GLsizeiptr length);
GLvoid * GLAPIENTRY _mesa_MapNamedBufferRangeEXT(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access);
void GLAPIENTRY _mesa_FramebufferDrawBufferEXT(GLuint framebuffer, GLenum mode);
void GLAPIENTRY _mesa_FramebufferDrawBuffersEXT(GLuint framebuffer, GLsizei n, const GLenum *bufs);
void GLAPIENTRY _mesa_FramebufferReadBufferEXT(GLuint framebuffer, GLenum mode);
void GLAPIENTRY _mesa_GetFramebufferParameterivEXT(GLuint framebuffer, GLenum pname, GLint *param);
GLenum GLAPIENTRY _mesa_CheckNamedFramebufferStatusEXT(GLuint framebuffer, GLenum target);
void GLAPIENTRY _mesa_NamedFramebufferTexture1DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
void GLAPIENTRY _mesa_NamedFramebufferTexture2DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
void GLAPIENTRY _mesa_NamedFramebufferTexture3DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
void GLAPIENTRY _mesa_NamedFramebufferRenderbufferEXT(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
void GLAPIENTRY _mesa_GetNamedFramebufferAttachmentParameterivEXT(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_NamedRenderbufferStorageEXT(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_GetNamedRenderbufferParameterivEXT(GLuint renderbuffer, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GenerateTextureMipmapEXT(GLuint texture, GLenum target);
void GLAPIENTRY _mesa_GenerateMultiTexMipmapEXT(GLenum texunit, GLenum target);
void GLAPIENTRY _mesa_NamedRenderbufferStorageMultisampleEXT(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_NamedCopyBufferSubDataEXT(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
void GLAPIENTRY _mesa_VertexArrayVertexOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_VertexArrayColorOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_VertexArrayEdgeFlagOffsetEXT(GLuint vaobj, GLuint buffer, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_VertexArrayIndexOffsetEXT(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_VertexArrayNormalOffsetEXT(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_VertexArrayTexCoordOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_VertexArrayMultiTexCoordOffsetEXT(GLuint vaobj, GLuint buffer, GLenum texunit, GLint size, GLenum type, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_VertexArrayFogCoordOffsetEXT(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_VertexArraySecondaryColorOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_VertexArrayVertexAttribOffsetEXT(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_VertexArrayVertexAttribIOffsetEXT(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset);
void GLAPIENTRY _mesa_EnableVertexArrayEXT(GLuint vaobj, GLenum array);
void GLAPIENTRY _mesa_DisableVertexArrayEXT(GLuint vaobj, GLenum array);
void GLAPIENTRY _mesa_EnableVertexArrayAttribEXT(GLuint vaobj, GLuint index);
void GLAPIENTRY _mesa_DisableVertexArrayAttribEXT(GLuint vaobj, GLuint index);
void GLAPIENTRY _mesa_GetVertexArrayIntegervEXT(GLuint vaobj, GLenum pname, GLint*param);
void GLAPIENTRY _mesa_GetVertexArrayPointervEXT(GLuint vaobj, GLenum pname, GLvoid**param);
void GLAPIENTRY _mesa_GetVertexArrayIntegeri_vEXT(GLuint vaobj, GLuint index, GLenum pname, GLint*param);
void GLAPIENTRY _mesa_GetVertexArrayPointeri_vEXT(GLuint vaobj, GLuint index, GLenum pname, GLvoid**param);
void GLAPIENTRY _mesa_NamedProgramStringEXT(GLuint program, GLenum target, GLenum format, GLsizei len, const GLvoid*string);
void GLAPIENTRY _mesa_GetNamedProgramStringEXT(GLuint program, GLenum target, GLenum pname, GLvoid*string);
void GLAPIENTRY _mesa_NamedProgramLocalParameter4fEXT(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void GLAPIENTRY _mesa_NamedProgramLocalParameter4fvEXT(GLuint program, GLenum target, GLuint index, const GLfloat*params);
void GLAPIENTRY _mesa_GetNamedProgramLocalParameterfvEXT(GLuint program, GLenum target, GLuint index, GLfloat*params);
void GLAPIENTRY _mesa_NamedProgramLocalParameter4dEXT(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void GLAPIENTRY _mesa_NamedProgramLocalParameter4dvEXT(GLuint program, GLenum target, GLuint index, const GLdouble*params);
void GLAPIENTRY _mesa_GetNamedProgramLocalParameterdvEXT(GLuint program, GLenum target, GLuint index, GLdouble*params);
void GLAPIENTRY _mesa_GetNamedProgramivEXT(GLuint program, GLenum target, GLenum pname, GLint*params);
void GLAPIENTRY _mesa_TextureBufferEXT(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer);
void GLAPIENTRY _mesa_MultiTexBufferEXT(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer);
void GLAPIENTRY _mesa_TextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, const GLint*params);
void GLAPIENTRY _mesa_TextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, const GLuint*params);
void GLAPIENTRY _mesa_GetTextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, GLint*params);
void GLAPIENTRY _mesa_GetTextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, GLuint*params);
void GLAPIENTRY _mesa_MultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint*params);
void GLAPIENTRY _mesa_MultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, const GLuint*params);
void GLAPIENTRY _mesa_GetMultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, GLint*params);
void GLAPIENTRY _mesa_GetMultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, GLuint*params);
void GLAPIENTRY _mesa_NamedProgramLocalParameters4fvEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat*params);
void GLAPIENTRY _mesa_BindImageTextureEXT(GLuint index, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLint format);
void GLAPIENTRY _mesa_LabelObjectEXT(GLenum type, GLuint object, GLsizei length, const GLchar *label);
void GLAPIENTRY _mesa_GetObjectLabelEXT(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label);
void GLAPIENTRY _mesa_SubpixelPrecisionBiasNV(GLuint xbits, GLuint ybits);
void GLAPIENTRY _mesa_SubpixelPrecisionBiasNV_no_error(GLuint xbits, GLuint ybits);
void GLAPIENTRY _mesa_ConservativeRasterParameterfNV(GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_ConservativeRasterParameterfNV_no_error(GLenum pname, GLfloat param);
void GLAPIENTRY _mesa_ConservativeRasterParameteriNV(GLenum pname, GLint param);
void GLAPIENTRY _mesa_ConservativeRasterParameteriNV_no_error(GLenum pname, GLint param);
void GLAPIENTRY _mesa_GetFirstPerfQueryIdINTEL(GLuint *queryId);
void GLAPIENTRY _mesa_GetNextPerfQueryIdINTEL(GLuint queryId, GLuint *nextQueryId);
void GLAPIENTRY _mesa_GetPerfQueryIdByNameINTEL(GLchar *queryName, GLuint *queryId);
void GLAPIENTRY _mesa_GetPerfQueryInfoINTEL(GLuint queryId, GLuint queryNameLength, GLchar *queryName, GLuint *dataSize, GLuint *noCounters, GLuint *noInstances, GLuint *capsMask);
void GLAPIENTRY _mesa_GetPerfCounterInfoINTEL(GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar *counterName, GLuint counterDescLength, GLchar *counterDesc, GLuint *counterOffset, GLuint *counterDataSize, GLuint *counterTypeEnum, GLuint *counterDataTypeEnum, GLuint64 *rawCounterMaxValue);
void GLAPIENTRY _mesa_CreatePerfQueryINTEL(GLuint queryId, GLuint *queryHandle);
void GLAPIENTRY _mesa_DeletePerfQueryINTEL(GLuint queryHandle);
void GLAPIENTRY _mesa_BeginPerfQueryINTEL(GLuint queryHandle);
void GLAPIENTRY _mesa_EndPerfQueryINTEL(GLuint queryHandle);
void GLAPIENTRY _mesa_GetPerfQueryDataINTEL(GLuint queryHandle, GLuint flags, GLsizei dataSize, GLvoid *data, GLuint *bytesWritten);
void GLAPIENTRY _mesa_AlphaToCoverageDitherControlNV(GLenum mode);
void GLAPIENTRY _mesa_AlphaToCoverageDitherControlNV_no_error(GLenum mode);
void GLAPIENTRY _mesa_PolygonOffsetClampEXT(GLfloat factor, GLfloat units, GLfloat clamp);
void GLAPIENTRY _mesa_WindowRectanglesEXT(GLenum mode, GLsizei count, const GLint *box);
void GLAPIENTRY _mesa_FramebufferFetchBarrierEXT(void);
void GLAPIENTRY _mesa_TextureStorage1DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width);
void GLAPIENTRY _mesa_TextureStorage2DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_TextureStorage3DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth);
void GLAPIENTRY _mesa_RenderbufferStorageMultisampleAdvancedAMD(GLenum target, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_NamedRenderbufferStorageMultisampleAdvancedAMD(GLuint renderbuffer, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height);
void GLAPIENTRY _mesa_StencilFuncSeparateATI(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask);
void GLAPIENTRY _mesa_ProgramEnvParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat *params);
void GLAPIENTRY _mesa_ProgramLocalParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat *params);
void GLAPIENTRY _mesa_InternalBufferSubDataCopyMESA(GLintptr srcBuffer, GLuint srcOffset, GLuint dstTargetOrName, GLintptr dstOffset, GLsizeiptr size, GLboolean named, GLboolean ext_dsa);
void GLAPIENTRY _mesa_InternalSetError(GLenum error);
void GLAPIENTRY _mesa_DrawArraysUserBuf(void);
void GLAPIENTRY _mesa_DrawElementsUserBuf(const GLvoid *cmd);
void GLAPIENTRY _mesa_DrawElementsUserBufPacked(const GLvoid *cmd);
void GLAPIENTRY _mesa_MultiDrawArraysUserBuf(void);
void GLAPIENTRY _mesa_MultiDrawElementsUserBuf(GLintptr indexBuf, GLenum mode, const GLsizei *count, GLenum type, const GLvoid * const *indices, GLsizei primcount, const GLint *basevertex);
void GLAPIENTRY _mesa_DrawArraysInstancedBaseInstanceDrawID(void);
void GLAPIENTRY _mesa_DrawElementsInstancedBaseVertexBaseInstanceDrawID(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instance_count, GLint basevertex, GLuint baseinstance, GLuint drawid);
void GLAPIENTRY _mesa_DrawElementsPacked(GLenum mode, GLenum type, GLushort count, GLushort indices);
void GLAPIENTRY _mesa_InternalInvalidateFramebufferAncillaryMESA(void);
void GLAPIENTRY _mesa_EGLImageTargetTexture2DOES(GLenum target, GLvoid *writeOffset);
void GLAPIENTRY _mesa_EGLImageTargetRenderbufferStorageOES(GLenum target, GLvoid *writeOffset);
void GLAPIENTRY _mesa_EGLImageTargetTexStorageEXT(GLenum target, GLvoid *image, const GLint *attrib_list);
void GLAPIENTRY _mesa_EGLImageTargetTextureStorageEXT(GLuint texture, GLvoid *image, const GLint *attrib_list);
void GLAPIENTRY _mesa_ClearColorIiEXT(GLint r, GLint g, GLint b, GLint a);
void GLAPIENTRY _mesa_ClearColorIuiEXT(GLuint r, GLuint g, GLuint b, GLuint a);
void GLAPIENTRY _mesa_TexParameterIiv(GLenum target, GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_TexParameterIuiv(GLenum target, GLenum pname, const GLuint *params);
void GLAPIENTRY _mesa_GetTexParameterIiv(GLenum target, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetTexParameterIuiv(GLenum target, GLenum pname, GLuint *params);
void GLAPIENTRY _mesa_VertexAttribI1iEXT(GLuint index, GLint x);
void GLAPIENTRY _mesa_VertexAttribI2iEXT(GLuint index, GLint x, GLint y);
void GLAPIENTRY _mesa_VertexAttribI3iEXT(GLuint index, GLint x, GLint y, GLint z);
void GLAPIENTRY _mesa_VertexAttribI4iEXT(GLuint index, GLint x, GLint y, GLint z, GLint w);
void GLAPIENTRY _mesa_VertexAttribI1uiEXT(GLuint index, GLuint x);
void GLAPIENTRY _mesa_VertexAttribI2uiEXT(GLuint index, GLuint x, GLuint y);
void GLAPIENTRY _mesa_VertexAttribI3uiEXT(GLuint index, GLuint x, GLuint y, GLuint z);
void GLAPIENTRY _mesa_VertexAttribI4uiEXT(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
void GLAPIENTRY _mesa_VertexAttribI1iv(GLuint index, const GLint *v);
void GLAPIENTRY _mesa_VertexAttribI2ivEXT(GLuint index, const GLint *v);
void GLAPIENTRY _mesa_VertexAttribI3ivEXT(GLuint index, const GLint *v);
void GLAPIENTRY _mesa_VertexAttribI4ivEXT(GLuint index, const GLint *v);
void GLAPIENTRY _mesa_VertexAttribI1uiv(GLuint index, const GLuint *v);
void GLAPIENTRY _mesa_VertexAttribI2uivEXT(GLuint index, const GLuint *v);
void GLAPIENTRY _mesa_VertexAttribI3uivEXT(GLuint index, const GLuint *v);
void GLAPIENTRY _mesa_VertexAttribI4uivEXT(GLuint index, const GLuint *v);
void GLAPIENTRY _mesa_VertexAttribI4bv(GLuint index, const GLbyte *v);
void GLAPIENTRY _mesa_VertexAttribI4sv(GLuint index, const GLshort *v);
void GLAPIENTRY _mesa_VertexAttribI4ubv(GLuint index, const GLubyte *v);
void GLAPIENTRY _mesa_VertexAttribI4usv(GLuint index, const GLushort *v);
void GLAPIENTRY _mesa_VertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_VertexAttribIPointer_no_error(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_GetVertexAttribIiv(GLuint index, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_GetVertexAttribIuiv(GLuint index, GLenum pname, GLuint *params);
void GLAPIENTRY _mesa_Uniform1ui(GLint location, GLuint x);
void GLAPIENTRY _mesa_Uniform2ui(GLint location, GLuint x, GLuint y);
void GLAPIENTRY _mesa_Uniform3ui(GLint location, GLuint x, GLuint y, GLuint z);
void GLAPIENTRY _mesa_Uniform4ui(GLint location, GLuint x, GLuint y, GLuint z, GLuint w);
void GLAPIENTRY _mesa_Uniform1uiv(GLint location, GLsizei count, const GLuint *value);
void GLAPIENTRY _mesa_Uniform2uiv(GLint location, GLsizei count, const GLuint *value);
void GLAPIENTRY _mesa_Uniform3uiv(GLint location, GLsizei count, const GLuint *value);
void GLAPIENTRY _mesa_Uniform4uiv(GLint location, GLsizei count, const GLuint *value);
void GLAPIENTRY _mesa_GetUniformuiv(GLuint program, GLint location, GLuint *params);
void GLAPIENTRY _mesa_BindFragDataLocation(GLuint program, GLuint colorNumber, const GLchar *name);
void GLAPIENTRY _mesa_BindFragDataLocation_no_error(GLuint program, GLuint colorNumber, const GLchar *name);
GLint GLAPIENTRY _mesa_GetFragDataLocation(GLuint program, const GLchar *name);
void GLAPIENTRY _mesa_ClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint *value);
void GLAPIENTRY _mesa_ClearBufferiv_no_error(GLenum buffer, GLint drawbuffer, const GLint *value);
void GLAPIENTRY _mesa_ClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint *value);
void GLAPIENTRY _mesa_ClearBufferuiv_no_error(GLenum buffer, GLint drawbuffer, const GLuint *value);
void GLAPIENTRY _mesa_ClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat *value);
void GLAPIENTRY _mesa_ClearBufferfv_no_error(GLenum buffer, GLint drawbuffer, const GLfloat *value);
void GLAPIENTRY _mesa_ClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil);
void GLAPIENTRY _mesa_ClearBufferfi_no_error(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil);
const GLubyte * GLAPIENTRY _mesa_GetStringi(GLenum name, GLuint index);
void GLAPIENTRY _mesa_BeginTransformFeedback(GLenum mode);
void GLAPIENTRY _mesa_BeginTransformFeedback_no_error(GLenum mode);
void GLAPIENTRY _mesa_EndTransformFeedback(void);
void GLAPIENTRY _mesa_EndTransformFeedback_no_error(void);
void GLAPIENTRY _mesa_BindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
void GLAPIENTRY _mesa_BindBufferRange_no_error(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
void GLAPIENTRY _mesa_BindBufferBase(GLenum target, GLuint index, GLuint buffer);
void GLAPIENTRY _mesa_TransformFeedbackVaryings(GLuint program, GLsizei count, const GLchar * const *varyings, GLenum bufferMode);
void GLAPIENTRY _mesa_TransformFeedbackVaryings_no_error(GLuint program, GLsizei count, const GLchar * const *varyings, GLenum bufferMode);
void GLAPIENTRY _mesa_GetTransformFeedbackVarying(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
void GLAPIENTRY _mesa_BeginConditionalRender(GLuint query, GLenum mode);
void GLAPIENTRY _mesa_BeginConditionalRender_no_error(GLuint query, GLenum mode);
void GLAPIENTRY _mesa_EndConditionalRender(void);
void GLAPIENTRY _mesa_EndConditionalRender_no_error(void);
void GLAPIENTRY _mesa_PrimitiveRestartIndex(GLuint index);
void GLAPIENTRY _mesa_PrimitiveRestartIndex_no_error(GLuint index);
void GLAPIENTRY _mesa_GetInteger64i_v(GLenum cap, GLuint index, GLint64 *data);
void GLAPIENTRY _mesa_GetBufferParameteri64v(GLenum target, GLenum pname, GLint64 *params);
void GLAPIENTRY _mesa_FramebufferTexture(GLenum target, GLenum attachment, GLuint texture, GLint level);
void GLAPIENTRY _mesa_FramebufferTexture_no_error(GLenum target, GLenum attachment, GLuint texture, GLint level);
void GLAPIENTRY _mesa_PrimitiveRestartNV(void);
void GLAPIENTRY _mesa_BindBufferOffsetEXT(GLenum target, GLuint index, GLuint buffer, GLintptr offset);
void GLAPIENTRY _mesa_BindBufferOffsetEXT_no_error(GLenum target, GLuint index, GLuint buffer, GLintptr offset);
void GLAPIENTRY _mesa_BindTransformFeedback(GLenum target, GLuint id);
void GLAPIENTRY _mesa_BindTransformFeedback_no_error(GLenum target, GLuint id);
void GLAPIENTRY _mesa_DeleteTransformFeedbacks(GLsizei n, const GLuint *ids);
void GLAPIENTRY _mesa_GenTransformFeedbacks(GLsizei n, GLuint *ids);
GLboolean GLAPIENTRY _mesa_IsTransformFeedback(GLuint id);
void GLAPIENTRY _mesa_PauseTransformFeedback(void);
void GLAPIENTRY _mesa_PauseTransformFeedback_no_error(void);
void GLAPIENTRY _mesa_ResumeTransformFeedback(void);
void GLAPIENTRY _mesa_ResumeTransformFeedback_no_error(void);
void GLAPIENTRY _mesa_DrawTransformFeedback(GLenum mode, GLuint id);
void GLAPIENTRY _mesa_VDPAUInitNV(const GLvoid *vdpDevice, const GLvoid *getProcAddress);
void GLAPIENTRY _mesa_VDPAUFiniNV(void);
GLintptr GLAPIENTRY _mesa_VDPAURegisterVideoSurfaceNV(const GLvoid *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames);
GLintptr GLAPIENTRY _mesa_VDPAURegisterOutputSurfaceNV(const GLvoid *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames);
GLboolean GLAPIENTRY _mesa_VDPAUIsSurfaceNV(GLintptr surface);
void GLAPIENTRY _mesa_VDPAUUnregisterSurfaceNV(GLintptr surface);
void GLAPIENTRY _mesa_VDPAUGetSurfaceivNV(GLintptr surface, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values);
void GLAPIENTRY _mesa_VDPAUSurfaceAccessNV(GLintptr surface, GLenum access);
void GLAPIENTRY _mesa_VDPAUMapSurfacesNV(GLsizei numSurfaces, const GLintptr *surfaces);
void GLAPIENTRY _mesa_VDPAUUnmapSurfacesNV(GLsizei numSurfaces, const GLintptr *surfaces);
void GLAPIENTRY _mesa_GetUnsignedBytevEXT(GLenum pname, GLubyte *data);
void GLAPIENTRY _mesa_GetUnsignedBytei_vEXT(GLenum target, GLuint index, GLubyte *data);
void GLAPIENTRY _mesa_DeleteMemoryObjectsEXT(GLsizei n, const GLuint *memoryObjects);
GLboolean GLAPIENTRY _mesa_IsMemoryObjectEXT(GLuint memoryObject);
void GLAPIENTRY _mesa_CreateMemoryObjectsEXT(GLsizei n, GLuint *memoryObjects);
void GLAPIENTRY _mesa_MemoryObjectParameterivEXT(GLuint memoryObject, GLenum pname, const GLint *params);
void GLAPIENTRY _mesa_GetMemoryObjectParameterivEXT(GLuint memoryObject, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_TexStorageMem2DEXT(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_TexStorageMem2DMultisampleEXT(GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_TexStorageMem3DEXT(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_TexStorageMem3DMultisampleEXT(GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_BufferStorageMemEXT(GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_BufferStorageMemEXT_no_error(GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_TextureStorageMem2DEXT(GLenum texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_TextureStorageMem2DMultisampleEXT(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_TextureStorageMem3DEXT(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_TextureStorageMem3DMultisampleEXT(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_NamedBufferStorageMemEXT(GLuint buffer, GLsizeiptr size, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_NamedBufferStorageMemEXT_no_error(GLuint buffer, GLsizeiptr size, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_TexStorageMem1DEXT(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_TextureStorageMem1DEXT(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset);
void GLAPIENTRY _mesa_GenSemaphoresEXT(GLsizei n, GLuint *semaphores);
void GLAPIENTRY _mesa_DeleteSemaphoresEXT(GLsizei n, const GLuint *semaphores);
GLboolean GLAPIENTRY _mesa_IsSemaphoreEXT(GLuint semaphore);
void GLAPIENTRY _mesa_SemaphoreParameterui64vEXT(GLuint semaphore, GLenum pname, const GLuint64 *params);
void GLAPIENTRY _mesa_GetSemaphoreParameterui64vEXT(GLuint semaphore, GLenum pname, GLuint64 *params);
void GLAPIENTRY _mesa_WaitSemaphoreEXT(GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *srcLayouts);
void GLAPIENTRY _mesa_SignalSemaphoreEXT(GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *dstLayouts);
void GLAPIENTRY _mesa_ImportMemoryFdEXT(GLuint memory, GLuint64 size, GLenum handleType, GLint fd);
void GLAPIENTRY _mesa_ImportSemaphoreFdEXT(GLuint semaphore, GLenum handleType, GLint fd);
void GLAPIENTRY _mesa_ImportMemoryWin32HandleEXT(GLuint memory, GLuint64 size, GLenum handleType, GLvoid *handle);
void GLAPIENTRY _mesa_ImportMemoryWin32NameEXT(GLuint memory, GLuint64 size, GLenum handleType, const GLvoid *name);
void GLAPIENTRY _mesa_ImportSemaphoreWin32HandleEXT(GLuint semaphore, GLenum handleType, GLvoid *handle);
void GLAPIENTRY _mesa_ImportSemaphoreWin32NameEXT(GLuint semaphore, GLenum handleType, const GLvoid *handle);
void GLAPIENTRY _mesa_ViewportSwizzleNV(GLuint index, GLenum swizzlex, GLenum swizzley, GLenum swizzlez, GLenum swizzlew);
void GLAPIENTRY _mesa_ViewportSwizzleNV_no_error(GLuint index, GLenum swizzlex, GLenum swizzley, GLenum swizzlez, GLenum swizzlew);
void GLAPIENTRY _mesa_Vertex2hNV(GLhalfNV x, GLhalfNV y);
void GLAPIENTRY _mesa_Vertex2hvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_Vertex3hNV(GLhalfNV x, GLhalfNV y, GLhalfNV z);
void GLAPIENTRY _mesa_Vertex3hvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_Vertex4hNV(GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w);
void GLAPIENTRY _mesa_Vertex4hvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_Normal3hNV(GLhalfNV nx, GLhalfNV ny, GLhalfNV nz);
void GLAPIENTRY _mesa_Normal3hvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_Color3hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue);
void GLAPIENTRY _mesa_Color3hvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_Color4hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue, GLhalfNV alpha);
void GLAPIENTRY _mesa_Color4hvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_TexCoord1hNV(GLhalfNV s);
void GLAPIENTRY _mesa_TexCoord1hvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_TexCoord2hNV(GLhalfNV s, GLhalfNV t);
void GLAPIENTRY _mesa_TexCoord2hvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_TexCoord3hNV(GLhalfNV s, GLhalfNV t, GLhalfNV r);
void GLAPIENTRY _mesa_TexCoord3hvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_TexCoord4hNV(GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q);
void GLAPIENTRY _mesa_TexCoord4hvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_MultiTexCoord1hNV(GLenum target, GLhalfNV s);
void GLAPIENTRY _mesa_MultiTexCoord1hvNV(GLenum target, const GLhalfNV *v);
void GLAPIENTRY _mesa_MultiTexCoord2hNV(GLenum target, GLhalfNV s, GLhalfNV t);
void GLAPIENTRY _mesa_MultiTexCoord2hvNV(GLenum target, const GLhalfNV *v);
void GLAPIENTRY _mesa_MultiTexCoord3hNV(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r);
void GLAPIENTRY _mesa_MultiTexCoord3hvNV(GLenum target, const GLhalfNV *v);
void GLAPIENTRY _mesa_MultiTexCoord4hNV(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q);
void GLAPIENTRY _mesa_MultiTexCoord4hvNV(GLenum target, const GLhalfNV *v);
void GLAPIENTRY _mesa_VertexAttrib1hNV(GLuint index, GLhalfNV x);
void GLAPIENTRY _mesa_VertexAttrib1hvNV(GLuint index, const GLhalfNV *v);
void GLAPIENTRY _mesa_VertexAttrib2hNV(GLuint index, GLhalfNV x, GLhalfNV y);
void GLAPIENTRY _mesa_VertexAttrib2hvNV(GLuint index, const GLhalfNV *v);
void GLAPIENTRY _mesa_VertexAttrib3hNV(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z);
void GLAPIENTRY _mesa_VertexAttrib3hvNV(GLuint index, const GLhalfNV *v);
void GLAPIENTRY _mesa_VertexAttrib4hNV(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w);
void GLAPIENTRY _mesa_VertexAttrib4hvNV(GLuint index, const GLhalfNV *v);
void GLAPIENTRY _mesa_VertexAttribs1hvNV(GLuint index, GLsizei n, const GLhalfNV *v);
void GLAPIENTRY _mesa_VertexAttribs2hvNV(GLuint index, GLsizei n, const GLhalfNV *v);
void GLAPIENTRY _mesa_VertexAttribs3hvNV(GLuint index, GLsizei n, const GLhalfNV *v);
void GLAPIENTRY _mesa_VertexAttribs4hvNV(GLuint index, GLsizei n, const GLhalfNV *v);
void GLAPIENTRY _mesa_FogCoordhNV(GLhalfNV x);
void GLAPIENTRY _mesa_FogCoordhvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_SecondaryColor3hNV(GLhalfNV red, GLhalfNV green, GLhalfNV blue);
void GLAPIENTRY _mesa_SecondaryColor3hvNV(const GLhalfNV *v);
void GLAPIENTRY _mesa_MemoryBarrierByRegion(GLbitfield barriers);
void GLAPIENTRY _mesa_MemoryBarrierByRegion_no_error(GLbitfield barriers);
void GLAPIENTRY _mesa_AlphaFuncx(GLenum func, GLclampx ref);
void GLAPIENTRY _mesa_ClearColorx(GLclampx red, GLclampx green, GLclampx blue, GLclampx alpha);
void GLAPIENTRY _mesa_ClearDepthx(GLclampx depth);
void GLAPIENTRY _mesa_Color4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha);
void GLAPIENTRY _mesa_DepthRangex(GLclampx zNear, GLclampx zFar);
void GLAPIENTRY _mesa_Fogx(GLenum pname, GLfixed param);
void GLAPIENTRY _mesa_Fogxv(GLenum pname, const GLfixed *params);
void GLAPIENTRY _mesa_Frustumx(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar);
void GLAPIENTRY _mesa_LightModelx(GLenum pname, GLfixed param);
void GLAPIENTRY _mesa_LightModelxv(GLenum pname, const GLfixed *params);
void GLAPIENTRY _mesa_Lightx(GLenum light, GLenum pname, GLfixed param);
void GLAPIENTRY _mesa_Lightxv(GLenum light, GLenum pname, const GLfixed *params);
void GLAPIENTRY _mesa_LineWidthx(GLfixed width);
void GLAPIENTRY _mesa_LoadMatrixx(const GLfixed *m);
void GLAPIENTRY _mesa_Materialx(GLenum face, GLenum pname, GLfixed param);
void GLAPIENTRY _mesa_Materialxv(GLenum face, GLenum pname, const GLfixed *params);
void GLAPIENTRY _mesa_MultMatrixx(const GLfixed *m);
void GLAPIENTRY _mesa_MultiTexCoord4x(GLenum target, GLfixed s, GLfixed t, GLfixed r, GLfixed q);
void GLAPIENTRY _mesa_Normal3x(GLfixed nx, GLfixed ny, GLfixed nz);
void GLAPIENTRY _mesa_Orthox(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar);
void GLAPIENTRY _mesa_PointSizex(GLfixed size);
void GLAPIENTRY _mesa_PolygonOffsetx(GLfixed factor, GLfixed units);
void GLAPIENTRY _mesa_Rotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z);
void GLAPIENTRY _mesa_SampleCoveragex(GLclampx value, GLboolean invert);
void GLAPIENTRY _mesa_Scalex(GLfixed x, GLfixed y, GLfixed z);
void GLAPIENTRY _mesa_TexEnvx(GLenum target, GLenum pname, GLfixed param);
void GLAPIENTRY _mesa_TexEnvxv(GLenum target, GLenum pname, const GLfixed *params);
void GLAPIENTRY _mesa_TexParameterx(GLenum target, GLenum pname, GLfixed param);
void GLAPIENTRY _mesa_Translatex(GLfixed x, GLfixed y, GLfixed z);
void GLAPIENTRY _mesa_ClipPlanex(GLenum plane, const GLfixed *equation);
void GLAPIENTRY _mesa_GetClipPlanex(GLenum plane, GLfixed *equation);
void GLAPIENTRY _mesa_GetFixedv(GLenum pname, GLfixed *params);
void GLAPIENTRY _mesa_GetLightxv(GLenum light, GLenum pname, GLfixed *params);
void GLAPIENTRY _mesa_GetMaterialxv(GLenum face, GLenum pname, GLfixed *params);
void GLAPIENTRY _mesa_GetTexEnvxv(GLenum target, GLenum pname, GLfixed *params);
void GLAPIENTRY _mesa_GetTexParameterxv(GLenum target, GLenum pname, GLfixed *params);
void GLAPIENTRY _mesa_PointParameterx(GLenum pname, GLfixed param);
void GLAPIENTRY _mesa_PointParameterxv(GLenum pname, const GLfixed *params);
void GLAPIENTRY _mesa_TexParameterxv(GLenum target, GLenum pname, const GLfixed *params);
void GLAPIENTRY _mesa_GetTexGenxvOES(GLenum coord, GLenum pname, GLfixed *params);
void GLAPIENTRY _mesa_TexGenxOES(GLenum coord, GLenum pname, GLfixed param);
void GLAPIENTRY _mesa_TexGenxvOES(GLenum coord, GLenum pname, const GLfixed *params);
void GLAPIENTRY _mesa_ClipPlanef(GLenum plane, const GLfloat *equation);
void GLAPIENTRY _mesa_GetClipPlanef(GLenum plane, GLfloat *equation);
void GLAPIENTRY _mesa_Frustumf(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar);
void GLAPIENTRY _mesa_Orthof(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar);
void GLAPIENTRY _mesa_DrawTexiOES(GLint x, GLint y, GLint z, GLint width, GLint height);
void GLAPIENTRY _mesa_DrawTexivOES(const GLint *coords);
void GLAPIENTRY _mesa_DrawTexfOES(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height);
void GLAPIENTRY _mesa_DrawTexfvOES(const GLfloat *coords);
void GLAPIENTRY _mesa_DrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height);
void GLAPIENTRY _mesa_DrawTexsvOES(const GLshort *coords);
void GLAPIENTRY _mesa_DrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height);
void GLAPIENTRY _mesa_DrawTexxvOES(const GLfixed *coords);
void GLAPIENTRY _mesa_PointSizePointerOES(GLenum type, GLsizei stride, const GLvoid *pointer);
void GLAPIENTRY _mesa_PointSizePointerOES_no_error(GLenum type, GLsizei stride, const GLvoid *pointer);
GLbitfield GLAPIENTRY _mesa_QueryMatrixxOES(GLfixed *mantissa, GLint *exponent);
void GLAPIENTRY _mesa_DiscardFramebufferEXT(GLenum target, GLsizei numAttachments, const GLenum *attachments);
void GLAPIENTRY _mesa_FramebufferTexture2DMultisampleEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples);
void GLAPIENTRY _mesa_DepthRangeArrayfvOES(GLuint first, GLsizei count, const GLfloat *v);
void GLAPIENTRY _mesa_DepthRangeIndexedfOES(GLuint index, GLfloat n, GLfloat f);
void GLAPIENTRY _mesa_FramebufferParameteriMESA(GLenum target, GLenum pname, GLint param);
void GLAPIENTRY _mesa_GetFramebufferParameterivMESA(GLenum target, GLenum pname, GLint *params);
void GLAPIENTRY _mesa_TexStorageAttribs2DEXT(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, const GLint *attrib_list);
void GLAPIENTRY _mesa_TexStorageAttribs2DEXT_no_error(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, const GLint *attrib_list);
void GLAPIENTRY _mesa_TexStorageAttribs3DEXT(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, const GLint *attrib_list);
void GLAPIENTRY _mesa_TexStorageAttribs3DEXT_no_error(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, const GLint *attrib_list);

#ifdef __cplusplus
}
#endif

#endif
