/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.config;

import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.pentaho.di.core.annotations.Inject;
import org.pentaho.di.core.config.BasicConfigManager;
import org.pentaho.di.core.exception.KettleConfigException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigesterConfigManager<T>
extends BasicConfigManager<T> {
    @Inject
    private String rulesURL;
    @Inject
    private String configURL;
    @Inject
    private String setNext;

    @Override
    public Collection<T> load() throws KettleConfigException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Digester digester = DigesterLoader.createDigester((URL)loader.getResource(this.rulesURL));
        final LinkedHashSet configObjs = new LinkedHashSet();
        digester.addRule(this.setNext, (Rule)new SetNextRule(""){

            public void end(String nameSpace, String name) throws Exception {
                configObjs.add(this.digester.peek());
            }
        });
        try {
            digester.parse(loader.getResource(this.configURL));
        }
        catch (Exception e) {
            throw new KettleConfigException((Throwable)e);
        }
        return configObjs;
    }
}

