/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.provider.Provider;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.properties.annotations.TypeMetadataWalker;
import org.gradle.internal.reflect.JavaReflectionUtil;

abstract class AbstractTypeMetadataWalker<T, V extends TypeMetadataWalker.TypeMetadataVisitor<T>>
implements TypeMetadataWalker<T, V> {
    private final TypeMetadataStore typeMetadataStore;
    private final Class<? extends Annotation> nestedAnnotation;
    private final Supplier<Map<T, String>> nestedNodeToQualifiedNameMapFactory;

    private AbstractTypeMetadataWalker(TypeMetadataStore typeMetadataStore, Class<? extends Annotation> nestedAnnotation, Supplier<Map<T, String>> nestedNodeToQualifiedNameMapFactory) {
        this.typeMetadataStore = typeMetadataStore;
        this.nestedAnnotation = nestedAnnotation;
        this.nestedNodeToQualifiedNameMapFactory = nestedNodeToQualifiedNameMapFactory;
    }

    @Override
    public void walk(T root, V visitor) {
        Class<?> nodeType = this.resolveType(root);
        TypeMetadata typeMetadata = this.typeMetadataStore.getTypeMetadata(nodeType);
        visitor.visitRoot(typeMetadata, root);
        Map<T, String> nestedNodesOnPath = this.nestedNodeToQualifiedNameMapFactory.get();
        nestedNodesOnPath.put(root, "<root>");
        this.walkChildren(root, typeMetadata, null, visitor, nestedNodesOnPath);
    }

    private void walkNested(T node, String qualifiedName, PropertyMetadata propertyMetadata, V visitor, Map<T, String> nestedNodesWalkedOnPath, boolean isElementOfCollection) {
        Class<?> nodeType = this.resolveType(node);
        if (Provider.class.isAssignableFrom(nodeType)) {
            this.walkNestedProvider(node, qualifiedName, propertyMetadata, visitor, isElementOfCollection, child -> this.walkNested(child, qualifiedName, propertyMetadata, visitor, nestedNodesWalkedOnPath, isElementOfCollection));
        } else {
            TypeMetadata typeMetadata = this.typeMetadataStore.getTypeMetadata(nodeType);
            if (Map.class.isAssignableFrom(nodeType) && !typeMetadata.hasAnnotatedProperties()) {
                this.walkNestedMap(node, qualifiedName, (name, child) -> this.walkNested(child, AbstractTypeMetadataWalker.getQualifiedName(qualifiedName, name), propertyMetadata, visitor, nestedNodesWalkedOnPath, true));
            } else if (Iterable.class.isAssignableFrom(nodeType) && !typeMetadata.hasAnnotatedProperties()) {
                this.walkNestedIterable(node, qualifiedName, (name, child) -> this.walkNested(child, AbstractTypeMetadataWalker.getQualifiedName(qualifiedName, name), propertyMetadata, visitor, nestedNodesWalkedOnPath, true));
            } else {
                this.walkNestedBean(node, typeMetadata, qualifiedName, propertyMetadata, visitor, nestedNodesWalkedOnPath);
            }
        }
    }

    private void walkNestedBean(T node, TypeMetadata typeMetadata, String qualifiedName, PropertyMetadata propertyMetadata, V visitor, Map<T, String> nestedNodesOnPath) {
        String firstOccurrenceQualifiedName = nestedNodesOnPath.putIfAbsent(node, qualifiedName);
        if (firstOccurrenceQualifiedName != null) {
            this.onNestedNodeCycle(firstOccurrenceQualifiedName, qualifiedName);
            return;
        }
        visitor.visitNested(typeMetadata, qualifiedName, propertyMetadata, node);
        this.walkChildren(node, typeMetadata, qualifiedName, visitor, nestedNodesOnPath);
        nestedNodesOnPath.remove(node);
    }

    private void walkChildren(T node, TypeMetadata typeMetadata, @Nullable String parentQualifiedName, V visitor, Map<T, String> nestedNodesOnPath) {
        typeMetadata.getPropertiesMetadata().forEach(propertyMetadata -> {
            if (propertyMetadata.getPropertyType() == this.nestedAnnotation) {
                this.walkNestedChild(node, AbstractTypeMetadataWalker.getQualifiedName(parentQualifiedName, propertyMetadata.getPropertyName()), (PropertyMetadata)propertyMetadata, visitor, child -> this.walkNested((T)child, AbstractTypeMetadataWalker.getQualifiedName(parentQualifiedName, propertyMetadata.getPropertyName()), (PropertyMetadata)propertyMetadata, visitor, nestedNodesOnPath, false));
            } else {
                this.walkLeaf(node, parentQualifiedName, visitor, (PropertyMetadata)propertyMetadata);
            }
        });
    }

    protected abstract void walkLeaf(T var1, @Nullable String var2, V var3, PropertyMetadata var4);

    protected abstract void onNestedNodeCycle(@Nullable String var1, String var2);

    protected abstract void walkNestedProvider(T var1, String var2, PropertyMetadata var3, V var4, boolean var5, Consumer<T> var6);

    protected abstract void walkNestedMap(T var1, String var2, BiConsumer<String, T> var3);

    protected abstract void walkNestedIterable(T var1, String var2, BiConsumer<String, T> var3);

    protected abstract void walkNestedChild(T var1, String var2, PropertyMetadata var3, V var4, Consumer<T> var5);

    @Nullable
    protected abstract T getChild(T var1, PropertyMetadata var2);

    protected abstract Class<?> resolveType(T var1);

    protected TypeMetadata getTypeMetadata(Class<?> type) {
        return this.typeMetadataStore.getTypeMetadata(type);
    }

    private static String getQualifiedName(@Nullable String parentPropertyName, String childPropertyName) {
        return parentPropertyName == null ? childPropertyName : parentPropertyName + "." + childPropertyName;
    }

    static class StaticTypeMetadataWalker
    extends AbstractTypeMetadataWalker<TypeToken<?>, TypeMetadataWalker.StaticMetadataVisitor>
    implements TypeMetadataWalker.StaticMetadataWalker {
        public StaticTypeMetadataWalker(TypeMetadataStore typeMetadataStore, Class<? extends Annotation> nestedAnnotation) {
            super(typeMetadataStore, nestedAnnotation, HashMap::new);
        }

        @Override
        protected Class<?> resolveType(TypeToken<?> type) {
            return type.getRawType();
        }

        @Override
        protected void onNestedNodeCycle(@Nullable String firstOccurrenceQualifiedName, String secondOccurrenceQualifiedName) {
        }

        @Override
        protected void walkNestedProvider(TypeToken<?> node, String qualifiedName, PropertyMetadata propertyMetadata, TypeMetadataWalker.StaticMetadataVisitor visitor, boolean isElementOfCollection, Consumer<TypeToken<?>> handler) {
            handler.accept(JavaReflectionUtil.extractNestedType(node, Provider.class, (int)0));
        }

        @Override
        protected void walkNestedMap(TypeToken<?> node, String qualifiedName, BiConsumer<String, TypeToken<?>> handler) {
            handler.accept("<key>", JavaReflectionUtil.extractNestedType(node, Map.class, (int)1));
        }

        @Override
        protected void walkNestedIterable(TypeToken<?> node, String qualifiedName, BiConsumer<String, TypeToken<?>> handler) {
            TypeToken nestedType = JavaReflectionUtil.extractNestedType(node, Iterable.class, (int)0);
            handler.accept(StaticTypeMetadataWalker.determinePropertyName(nestedType), nestedType);
        }

        @Override
        protected void walkNestedChild(TypeToken<?> parent, String childQualifiedName, PropertyMetadata propertyMetadata, TypeMetadataWalker.StaticMetadataVisitor visitor, Consumer<TypeToken<?>> handler) {
            handler.accept(this.getChild(parent, propertyMetadata));
        }

        @Override
        protected void walkLeaf(TypeToken<?> node, @Nullable String parentQualifiedName, TypeMetadataWalker.StaticMetadataVisitor visitor, PropertyMetadata propertyMetadata) {
        }

        @Override
        protected TypeToken<?> getChild(TypeToken<?> parent, PropertyMetadata property) {
            return property.getDeclaredType();
        }

        private static String determinePropertyName(TypeToken<?> nestedType) {
            return Named.class.isAssignableFrom(nestedType.getRawType()) ? "<name>" : "*";
        }
    }

    static class InstanceTypeMetadataWalker
    extends AbstractTypeMetadataWalker<Object, TypeMetadataWalker.InstanceMetadataVisitor>
    implements TypeMetadataWalker.InstanceMetadataWalker {
        public InstanceTypeMetadataWalker(TypeMetadataStore typeMetadataStore, Class<? extends Annotation> nestedAnnotation) {
            super(typeMetadataStore, nestedAnnotation, IdentityHashMap::new);
        }

        @Override
        protected Class<?> resolveType(Object value) {
            return value.getClass();
        }

        @Override
        protected void onNestedNodeCycle(@Nullable String firstOccurrenceQualifiedName, String secondOccurrenceQualifiedName) {
            throw new IllegalStateException(String.format("Cycles between nested beans are not allowed. Cycle detected between: '%s' and '%s'.", firstOccurrenceQualifiedName, secondOccurrenceQualifiedName));
        }

        @Override
        protected void walkNestedProvider(Object node, String qualifiedName, PropertyMetadata propertyMetadata, TypeMetadataWalker.InstanceMetadataVisitor visitor, boolean isElementOfCollection, Consumer<Object> handler) {
            this.walkNestedChild(() -> ((Provider)node).getOrNull(), qualifiedName, propertyMetadata, visitor, isElementOfCollection, handler);
        }

        @Override
        protected void walkNestedMap(Object node, String qualifiedName, BiConsumer<String, Object> handler) {
            ((Map)node).forEach((key, value) -> {
                Preconditions.checkNotNull((Object)key, (String)"Null keys in nested map '%s' are not allowed.", (Object)qualifiedName);
                String stringKey = key.toString();
                InstanceTypeMetadataWalker.checkNotNullNestedCollectionValue(qualifiedName, stringKey, value);
                handler.accept(stringKey, value);
            });
        }

        @Override
        protected void walkNestedIterable(Object node, String qualifiedName, BiConsumer<String, Object> handler) {
            int counter = 0;
            for (Object o : (Iterable)node) {
                String prefix = o instanceof Named ? ((Named)o).getName() : "";
                String name = prefix + "$" + counter++;
                InstanceTypeMetadataWalker.checkNotNullNestedCollectionValue(qualifiedName, name, o);
                handler.accept(name, o);
            }
        }

        @Override
        protected void walkNestedChild(Object parent, String childQualifiedName, PropertyMetadata propertyMetadata, TypeMetadataWalker.InstanceMetadataVisitor visitor, Consumer<Object> handler) {
            boolean isElementOfCollection = false;
            this.walkNestedChild(() -> this.getChild(parent, propertyMetadata), childQualifiedName, propertyMetadata, visitor, isElementOfCollection, handler);
        }

        private void walkNestedChild(Supplier<Object> unpacker, String qualifiedName, PropertyMetadata propertyMetadata, TypeMetadataWalker.InstanceMetadataVisitor visitor, boolean isElementOfCollection, Consumer<Object> handler) {
            Object value;
            try {
                value = unpacker.get();
            }
            catch (Exception ex) {
                visitor.visitNestedUnpackingError(qualifiedName, ex);
                return;
            }
            if (value != null) {
                handler.accept(value);
            } else {
                if (isElementOfCollection) {
                    throw new IllegalStateException(InstanceTypeMetadataWalker.getNullNestedCollectionValueExceptionMessage(qualifiedName));
                }
                TypeToken<?> getterType = propertyMetadata.getDeclaredType();
                TypeMetadata typeMetadata = this.getTypeMetadata(InstanceTypeMetadataWalker.unpackType(getterType).getRawType());
                visitor.visitNested(typeMetadata, qualifiedName, propertyMetadata, (Object)null);
            }
        }

        @Override
        protected void walkLeaf(Object node, @Nullable String parentQualifiedName, TypeMetadataWalker.InstanceMetadataVisitor visitor, PropertyMetadata propertyMetadata) {
            visitor.visitLeaf(node, AbstractTypeMetadataWalker.getQualifiedName(parentQualifiedName, propertyMetadata.getPropertyName()), propertyMetadata);
        }

        private static TypeToken<?> unpackType(TypeToken<?> type) {
            while (Provider.class.isAssignableFrom(type.getRawType())) {
                type = JavaReflectionUtil.extractNestedType(type, Provider.class, (int)0);
            }
            return type;
        }

        @Override
        @Nullable
        protected Object getChild(Object parent, PropertyMetadata property) {
            return property.getPropertyValue(parent);
        }

        private static void checkNotNullNestedCollectionValue(@Nullable String parentQualifiedName, String name, @Nullable Object value) {
            if (value == null) {
                throw new IllegalStateException(InstanceTypeMetadataWalker.getNullNestedCollectionValueExceptionMessage(AbstractTypeMetadataWalker.getQualifiedName(parentQualifiedName, name)));
            }
        }

        private static String getNullNestedCollectionValueExceptionMessage(String qualifiedName) {
            return String.format("Null value is not allowed for the nested collection property '%s'", qualifiedName);
        }
    }
}

