/*
 * diehard_operm5 test header.
 */

/*
 * function prototype
 */
int diehard_operm5(Test **test, int irun);

static Dtest diehard_operm5_dtest __attribute__((unused)) = {
  "Diehard OPERM5 Test",
  "diehard_operm5",
"\n\
#==================================================================\n\
#          Diehard Overlapping 5-Permutations Test.\n\
# This is the OPERM5 test.  It looks at a sequence of one mill- \n\
# ion 32-bit random integers.  Each set of five consecutive     \n\
# integers can be in one of 120 states, for the 5! possible or- \n\
# derings of five numbers.  Thus the 5th, 6th, 7th,...numbers   \n\
# each provide a state. As many thousands of state transitions  \n\
# are observed,  cumulative counts are made of the number of    \n\
# occurences of each state.  Then the quadratic form in the     \n\
# weak inverse of the 120x120 covariance matrix yields a test   \n\
# equivalent to the likelihood ratio test that the 120 cell     \n\
# counts came from the specified (asymptotically) normal dis-   \n\
# tribution with the specified 120x120 covariance matrix (with  \n\
# rank 99).  This version uses 1,000,000 integers, twice.       \n\
#\n\
# Note that Dieharder runs the test 100 times, not twice, by\n\
# default.\n\
#==================================================================\n",
  100,
  1000000,
  1,
  diehard_operm5,
  0
};

  
  static long double pseudoInv[120][120] __attribute__((unused)) = 
 {
{
    101.702796460,    3.47959864133,    2.04238410188,    1.74181938409,    3.01521299803,    2.28539648409,
    2.27752614391,    12.5879849047,    1.39654183047,    1.61928012390,    4.24056105166,    1.90846053913,
    3.58974770676,    2.43658406577,    2.17703943527,   0.788072126217,    1.44529123062,    1.01893534483,
   -11.7602653513,    2.16993674850,    2.01281383095,    1.70972351290,   -12.5737071842,   -13.8647322686,
    2.22704751677,    1.93731693654,   -8.41395982155,    1.78089271632,    1.72684525309,    3.81509686603,
  -0.610894684855,    7.79473120283,    8.12910672884,    7.96997978451,  -0.195801329414,   0.752358397718,
   0.859606531259,   -2.08846228834,    2.15730956894,    2.86356084676,  -0.548063667065,    1.95882504879,
   -1.16278277850,  -0.208344798672,    1.08285467559,   0.663691969363,   -1.07761585802,    1.30130103982,
    1.63743331504,   0.835336974273,    1.26843494328,   -5.44848887444,   -1.21391220419,   -1.55906670230,
   -2.88743618262,   0.590633792225,   -2.05424388182,    1.68554765668,    2.02872233283,    1.62075751509,
   0.317009408644,  0.0967280348665,    1.32144544549,    1.39656074305,    1.02605720546,    1.88772939286,
  -0.324682637397,   -2.13068687021,   -2.90550450174,    1.25294322978,   0.100981600673,    1.16047660536,
    2.44549621665, -0.0846387143669,   -1.39501835562,   -3.34650475961,   0.283448392274,   -3.02612919136,
   -3.80493410954,   -1.38665779695,   0.121673303444,   0.171732966065,   -2.34887107486,   0.247177449112,
    1.56010340800,   -1.48444614454,    5.44933609520,    8.87802925086,    1.81852923469,    10.1470993263,
  -0.358971552026,   -1.83014139735,   -1.74931105086,  -0.817545630271,    1.02558937862,    8.60717933673,
   -35.4362488569,   -5.36799149000,   -6.65812491595,   -4.26269341359,   -4.19712666694,   -4.77986206737,
   -4.43349551400,   -6.05454160848,   -4.14858224039,   -3.25072542614,   -2.66162830552,   -1.00718051189,
   -2.05132354587,   -1.90101638341,   -5.10130764631,   -1.41314885590,  -0.983369342872,   -1.43661669760,
   -17.4134339546,   -3.96687513396,   -4.09070881500,   -2.90571696531,   -15.7714696397,   -29.6934146419,
},
{
    3.47959864133,    98.3558345997,    1.91572793238,    2.03244291996,    3.27367538387,    3.51750054562,
    10.8670443194,    1.63728269312,    2.46532995184,    2.18522773610,   0.283315126158,    3.32191661492,
    2.11540301866,    1.71359022390,    1.76170682652,    3.87026004778,    4.81301106985,    3.99144669601,
    2.38263262964,   -10.8343835093,   -12.3582958452,   -12.7603680586,   0.908235754809,    1.40680050611,
    3.51283765151,    3.72182254444,    2.82412258514,   -8.39291090002,    5.51065378265,    2.43697755210,
    8.66481634482,  0.0698359663295,   0.840501237418, -0.0789435747566,    7.73624059467,    7.33279444374,
   -1.39535571638,   0.573983294049,   0.110396462681,  -0.491483243017,   0.723831726613,    1.68554765668,
   0.405950073013,   0.827827410776,    1.55270079570,    1.06176307263, -0.0823657666345,   0.613440673968,
   -1.48564295720,   -2.35072651678,   -5.88796619628,   0.116066517666,   0.909198892731,   0.301302209952,
    2.59871803433,   0.112462804622,    2.91664946903,    2.18345616634,   0.243514488529,   0.918782591640,
   -1.79665727600,   -2.29004601420, -0.0762330275188,    1.81968452702,   -2.37331479701,   0.545331558958,
  -0.377040242349,   -1.28003934163,    1.38687323822,    1.40809620370,   0.110396186431,    2.91434752106,
   -1.34997010910,    1.94203511105, -0.0334858524931,  -0.244222984889,   -4.05226447797,   -2.57697065912,
   0.842927830720,   0.448765444898,    2.74121610464,    2.55767805912,   0.516993015810,    2.16874029149,
    4.38149458079,    5.17250072782,   -2.90550450174,   -2.54840826787,    4.44558063180,   -3.45130216438,
   -2.40015513230, -0.0622295296345,   0.926481665246,    1.88241502240,    8.38996332437,   -4.99338303655,
   -2.88446862464,   -36.1948023840,   -5.29037912148,   -6.65812491595,   -4.56409239301,   -4.22796727586,
   -5.02467448805,   -4.48983028873,   -2.15868159775,   -2.11393300786,   -3.86961435551,   -3.27561900621,
   -1.92029423174,   -1.71528642262,   -4.33004449477,   -5.60682842900,   -2.22568304570,   -4.22556084587,
   -1.75773570496,   -18.3976865898,   -17.3220171221,   -16.7877815213,   -12.7359922823,   -4.69893147886,
},
{
    2.04238410188,    1.91572793238,    98.0501238084,    1.54283271895,    1.32988350128,    1.89214896281,
    1.83617274451,   -11.3771881230,   -10.4179101369,   -11.1977046007,    12.0368225525,    3.95863320677,
    2.00594589649,    2.85356476469,    2.75496955568,    2.44544825138,    3.51366877414,    4.39505757541,
   0.592951516896,    3.22581106136,    2.93931202527,    2.37667671700,   0.854745298683,   0.866154454190,
    7.42132958226,    7.85572434880,    6.91329582535,    5.24659988964,    7.68438220043,   -5.55402788282,
   0.839919235494,    2.38836929911,    2.05840148048,    2.13971609673,   -1.32849163946,   -1.13547734156,
   0.314755923607,    8.91907078347,    6.32770429109,    7.13294881956,   0.795755172129,    1.25294322978,
    4.75341046185,    4.62640633331,    3.11848761998,    3.20833846878,    3.72152299620,    2.87816600487,
    1.41674265601,  -0.940801877032,  0.0209809415685,    1.34264207773,   0.831206512909,    1.23620042522,
    2.90077588087,    1.57307864629,    1.51640273628,    1.40809620370,   0.503138444413,  0.0555678467829,
   -2.98199746189,   -2.67167545957,   -2.19163227797,   -2.75719522516,   -3.77733627693,   -2.09613711355,
  -0.877376856169,   0.401277785420,    2.91664946903,    2.66041333492,  -0.644118167803,   0.722311796191,
    4.42099749479,   -1.83309503743,   -1.16880599602,   -1.19922432959,    6.33445073191,    6.73360604526,
   0.248275334921, -0.0946103506733,   -3.11650166621,   -2.30497741046,  -0.818593816318,   -2.56428697012,
   -2.70812576928,   -2.15700853736,   -2.05424388182,   -3.64547457306,   -3.61315415637,   -4.26389011473,
    5.38238026713,   -4.06087251037,   -2.42109281648,   -2.87516480264,   -4.86937681595,   -7.36658175599,
   -2.23364079297,   -4.99880484738,   -36.1948023840,   -5.36799149000,   -2.85350911338,   -2.36940709009,
   -1.25286666352,   -17.0216252500,   -18.0874436684,   -17.9660620096,   -4.80044307096,   -3.91494167754,
   -2.07073322809,   -1.88530104907,   -3.04232718639,   -3.61884557138,   -3.06686059009,   -6.04286677972,
   -14.0912440427,   -5.53141230965,   -3.63980243567,   -4.14106321047,   -3.04768959184,   -5.32764231058,
},
{
    1.74181938409,    2.03244291996,    1.54283271895,    96.4300399384,    1.53038477142,    2.61336859710,
   -12.9037604338,    1.88099997551,    3.11372650764,    2.55730386708,   -12.4658563158,   0.514937591235,
    1.54681324423,    2.94636891811,    3.66237190690,    5.44273872863,    6.16196222431,    5.34531479332,
    2.87699128121,   0.466615290388,    1.02899668126,    1.03203693157,    2.30547304932,    2.52173697735,
    4.32886732400,    5.39916098902,    4.26729074902,    8.42273496448, -0.0679883047309,    8.35094501318,
    3.60249764016,  -0.329815234990,  -0.374619659663,  0.0509280864459,    2.51277142788,   0.692207431452,
    13.6325647973,    6.44221687032,    2.94831173152,   0.934777145256,    13.1815685886,    8.87802925086,
    2.38840824158,    1.99892364104,  -0.288593708110,-0.00969180416599,    2.24103669192,  -0.299951186682,
  -0.794133342961,    2.06849456445,    1.39551041680,    4.83644746149,    2.92211067478,    3.69530622097,
    3.17949645052,  -0.338532291702,   0.795755172129,   -2.54840826787,  0.0824510449375,  -0.222808488642,
   -1.99850697532,   -1.37002058804,   -1.67990502431,   -2.90899564007,   -1.43305365901,   -3.16798642674,
    2.26535029574,    3.19550859524,   0.723831726613,   -3.64547457306,   -1.82528689767,   -3.52437410739,
   -2.52050917818,    3.05921950333,    5.80288007867,    7.29488051492,   -1.30327712967,   0.228970207248,
   0.111484934528,  -0.838740155361,   -3.39699380325,   -4.48756391546,  -0.503684885921,   -3.31540906326,
   -2.36678986350,  -0.546162441077,  -0.548063667065,   -3.12036899949,   -4.09790992519,   -3.76674627657,
   -3.60435018208,    3.95300330661,   -5.59032944961,   -6.87236432478,   -6.40393467745,   -4.23299685560,
   -3.95123677566,   -2.23364079297,   -2.88446862464,   -35.4362488569,   -4.37094940786,   -3.44918321285,
   -15.5611255551,   -2.12754545184,   -3.04136462819,   -4.11294492957,   -17.8481897204,   -21.4030642441,
   -4.08938603508,   -3.93793507938,   -2.70739810248,   -4.34479292116,   -7.18637400837,   -4.27079623153,
   -3.42432463260,   -13.9285718417,   -2.11136224508,   -3.20809872200,   -6.03443377457,   -3.80182453265,
},
{
    3.01521299803,    3.27367538387,    1.32988350128,    1.53038477142,    98.2195915061,    1.77456287105,
    3.06745698764,    2.06125308493,    11.9416522898,    1.77152941632,    4.63861937546,    2.64266037378,
   -10.8751916175,    3.90350490143,    1.39081975589,    1.17416486145,   -12.6814395874,   -12.6457044171,
    3.47037493945,    1.65442854956,    1.96270324942,   0.124039501753,    2.10113876234,    1.70988267819,
    3.95791893946,   -7.23976744124,    4.27652301649,    3.23350409469,    2.76659868630,    4.82579845901,
  -0.831516026082,    1.05528116547,  -0.288433360886,  -0.257197740859,   -1.01550367500,   0.191498213269,
   0.892384226942, -0.0206401687921,   0.559476174582,    2.87309717622,  -0.503684885921,    1.30130103982,
   -1.87300467473,    6.70357901341,    6.85809515971,    7.51502639263,   -1.29869010121,   0.339061376455,
    5.82889224441,    4.48072367247,    2.93182498382,   0.266964585737,    4.66367182442,   0.719583277667,
   -1.77820375188,   0.934294689249,  -0.818593816318,   0.613440673968,  -0.811815197803,   0.429846443576,
    3.18700577505,    2.62950027646,   -1.20360863110,   0.618454666887,    5.30877759488,    2.52869602862,
    3.75027773845,    1.63938994047,   0.516993015810,    2.87816600487,    3.91173751298,    1.30519160208,
   -1.19832194615,   -2.27239000576,   -2.65884432854,   -4.45236155393,   -1.40296912034,   -3.05199614679,
   -4.42205372104,   -3.29214336856,   -2.20848872348,    5.99953633686,    2.94669958734,    6.12522600352,
  -0.607028592293,   -2.53679733505,   -2.34887107486,  -0.299951186682,  -0.561114436965,   -1.46189605730,
   -3.58084102688,   -3.78092960240,   -4.70370169779,    6.35850336621,   -5.29277408478,   -2.93284896764,
   -3.44918321285,   -2.36940709009,   -4.22796727586,   -4.77986206737,   -36.2386704698,   -5.34623743353,
   -5.15925382175,   -2.55234384466,   -4.73280164616,   -1.48524032158,   -3.54614834121,   -1.74755203283,
   -18.3575303507,   -6.22632330604,   -3.66840017366,   -2.77501741267,   -17.3542721770,   -16.7634577374,
   -2.43434134683,  -0.537906001096,   -1.61502794398,   -11.9243045226,   -4.17525572483,   -2.00425841399,
},
{
    2.28539648409,    3.51750054562,    1.89214896281,    2.61336859710,    1.77456287105,    98.0986307305,
    4.13254115806,    3.36886108025,    2.96750226889,    13.3534507787,    6.04967090955,    3.97585019365,
    3.81386715783,   -10.6187303080,   -11.2385279478,   -11.6729786631,   0.827377726153,    1.73634316499,
    1.93512326132,    1.12297208977,    1.10735995817,    3.03302590491,    2.32430877087,    3.04187382428,
   -7.09732086170,    3.85417816513,    4.35351409207,    3.04775298559,    2.76355973272,    4.96993552301,
   -1.72833866992,  -0.159705863318,   -1.49399239261,  -0.852923983700,   0.359573676015,   0.115820235337,
    3.34668012401,    2.28514157604,    2.52120643985,    1.19191624916,    2.24103669192,   0.247177449112,
    7.92839152050,  -0.330263365747,   -1.77477694233,   -1.78976586390,    8.01997590090,    6.12522600352,
    2.35700464670,    4.62879146440,    7.19934538749,    4.27517288855,   -1.03526516990,    3.72198225871,
    2.28500868480,    4.96574729528,    3.72152299620,    2.16874029149,    2.76544260503,    1.88972013476,
    3.33342800563,    4.70409238607,    2.82072520664,   0.702694944772,   0.888583249480,   -1.63606896922,
  -0.822099283250,    1.55050062551, -0.0823657666344,   -2.56428697012,  -0.402406864486,   -2.90479889313,
   -1.32677197557,   -2.03263840131,   -2.88072342083,   -1.56432015213,   -2.96608171915,   -1.65265185841,
    6.43466143584,    5.75150332245,    3.37785124710,   -4.31705493911,   -1.29869010121,   -4.73421493710,
   -2.68666481829,   -1.11357560461,   -1.07761585802,   -3.31540906326,   -2.78206804744,   -3.57155025876,
   -3.30981984540,   -3.78301578534,    6.34108150200,   -4.77212084362,   -5.33485524048,   -3.14490568256,
   -4.37094940786,   -2.85350911338,   -4.56409239301,   -4.19712666694,   -5.22527665799,   -36.2386704698,
   -2.67053226402,  -0.973849166874,   -2.99859433160,   -6.13796778300,   -3.24361929777,   -4.74087329353,
   -6.24502277907,   -18.0301307705,   -16.9543023518,   -18.1647344400,   -4.33829916575,   -3.99370888359,
   -3.52702931314,   -1.97808516555,   -13.1943048089,   -2.90566379430,   -5.49689862569,   -3.31381710689,
},
{
    2.27752614391,    10.8670443194,    1.83617274451,   -12.9037604338,    3.06745698764,    4.13254115806,
    94.1372306530,    3.82132646761,    4.40043954301,    4.11196661189,   -13.6004620130,   -1.09564831427,
    2.12704020822,    3.61354047806,    5.27981451917,    5.43369561992,    5.10925342427,    3.78761175390,
    2.40375639965,    11.0796491579,    13.2137268024,    12.8234289622,    1.64544241710,    3.60711007986,
    5.93887287961,    6.13080095654,    5.64432273403,   -8.33851406616,    23.4873253383,    11.0883737153,
   -14.7625052036,   0.119462679144,   -1.32629124690,   -1.74931022596,   -16.3606587886,   -20.7829473955,
    2.95258478977,    9.54021935880,    4.72477703040,   0.659261570580,    13.6325647973,    10.1470993263,
    4.08962687016,    4.57598222658,   -2.50206994411,   -2.04081972113,    3.34668012401,   -1.46189605730,
    7.30349562037,    6.04429774214,    7.27804666997,    5.84810605862,    2.54581189924,    4.18885217231,
    4.93464750296,    6.24180265424,   0.314755923607,   -3.45130216438,  -0.217621232298,  -0.607862524868,
   -2.66294670741,  -0.986603121024,   -2.81004665660,   -3.35210644563,   -3.45626513000,   -5.37432696832,
   -2.14215935276,  -0.538823633149,   -1.39535571638,   -4.26389011473,   -3.58332670710,   -5.03263931039,
   0.648060105356,   -3.02221399632,   -1.83170587234,   -2.37033491174,  -0.527049340161,    1.27190685484,
    1.86609684761,    2.27346737812,   -4.35783988847,   -4.09579126929,   0.892384226942,   -3.57155025876,
  0.0872816773913,    1.96844187389,   0.859606531259,   -3.76674627657,   -5.83850222330,   -7.61047757684,
   -7.90607148418,   -10.0869608861,   -7.61785716243,   -8.56595466210,   -9.79598600926,   -7.62228100824,
   -3.42432463260,   -14.0912440427,   -1.75773570496,   -17.4134339546,   -3.52702931314,   -2.43434134683,
    4.34231891950,   -2.59637492575,   -4.18361147861,   -4.91534081789,    2.77691764137,   -2.00135462423,
   -8.02880140394,   -6.68837691359,   -4.20846320503,   -5.14678983453,   -8.49276272601,   -6.20630988686,
   -5.10373631855,   -7.88809678529,   -6.50929731674,   -7.84653437912,   -11.8893635232,   -6.79922199279,
},
{
    12.5879849047,    1.63728269312,   -11.3771881230,    1.88099997551,    2.06125308493,    3.36886108025,
    3.82132646761,    95.8253560915,   -11.4937924601,   -12.8169778043,    13.1379198417,    5.44249526303,
   0.660741621798,    1.51214093103,    1.26119834948,    5.96833742143,    4.11048986679,    4.70113281529,
    12.9423641628,    1.95804453141,    4.07022363329,    2.84956457467,    11.4442099056,    12.1325078736,
    11.4517516335,    11.7034791276,   -8.29754156395,    4.86683987463,    7.80962418292,    15.2833215316,
  0.0688474955951,   -14.2515233115,   -18.5389743861,   -19.5588218250,   -1.50027454550,   -2.27303616948,
    6.24180265424,   -5.29735570343,    10.0730498543,    8.54277559021,  -0.338532291702,    1.16047660536,
    6.66691905449,    6.95343835880,    1.20670176701,    1.18570542996,    4.96574729528,    1.30519160208,
    4.42154249574,    4.61452225228,    5.64722424249,    2.18987516681,    2.73971784574,    3.37896290047,
    4.91037153642,    8.60637122639,    1.57307864629,    2.91434752106,   -1.16301986843,   -2.61762276351,
   -5.04394247808,   -4.27782577163,   -1.37163023510,   -2.10738078932,   -5.70466629849,   -4.05435495795,
   -1.50142740200,   -4.57224088644,   0.112462804622,   0.722311796191,   -3.00247208670,  -0.725226738072,
   -1.31988516118,  0.0530762724269,    2.05301896597,   0.651472016818,   -3.49650206722,   -3.04675227459,
    2.34670913657,    2.71151189023,   -3.21707086342,   -3.08366691349,   0.934294689249,   -2.90479889313,
   -1.23652875064,   -1.20420235933,   0.590633792225,   -3.52437410739,   -7.88914111836,   -5.03263931039,
   -8.50314641749,   -8.52814552557,   -7.35459035667,   -5.44641221973,   -6.53319254708,   -8.68936039711,
   -13.9285718417,   -5.53141230965,   -18.3976865898,   -3.96687513396,   -1.97808516555,  -0.537906001096,
   -3.31927402712,    3.97463653510,   0.846182241218,   0.699673230686,   -3.93903347767,   -3.78877759863,
   -4.19782340310,   -3.06099501395,   -6.03427973474,   -5.97302395553,   -4.53722062451,   -8.15841326488,
   -7.88809678529,   -7.36238199152,   -6.72390343177,   -6.30970603601,   -7.42705630041,   -13.5953439229,
},
{
    1.39654183047,    2.46532995184,   -10.4179101369,    3.11372650763,    11.9416522898,    2.96750226889,
    4.40043954301,   -11.4937924601,    96.4518701114,   -12.6839240768,    13.2818405765,    5.80496011766,
    10.3977310850,   0.677327563698,    3.47335810570,    6.85570362359,    13.8527965563,    14.8468941777,
    1.87942139897,    2.17686565290,    3.61855263797,    2.26907424018,    1.31728951722,    2.72936358630,
    6.80378366108,   -12.0089431300,    7.21247353087,    3.94284580098,    6.14401133253,    13.6763017879,
   -1.05510526828,    2.56894077997,    4.01875400135,    2.90487823575,   0.304161354887,  -0.702321383383,
    7.27804666997,    15.5349777304,   -7.84888069700,    9.88998691768,    1.39551041680,    1.88772939286,
    8.51096261755,   -11.2505893766,   -16.9846587415,   -18.3629095634,    7.19934538749,    2.52869602862,
    3.38103514287,    4.05940570669,    7.36241256775,    4.15777877683,  0.0849587942869,    1.06752938523,
    2.52357226846,    5.64722424249,  0.0209809415686,   0.545331558958,   0.514136212441,   -2.30163312917,
   -3.07052267766,   -2.68209384482,   -3.51454627695,   -6.23340209851,   -7.00279693580,   -6.61848412260,
   -2.49753689780,   -1.37410684853,   -5.88796619628,   -2.09613711355,   -4.70767664646,   -4.05435495795,
   -2.42287091649,  -0.380210961430,    1.05158253708,   0.530475704477,   -1.39059221097,  -0.642957914166,
    1.97210592684,    1.61158816726,   -4.11852072757,   -3.12264250823,    2.93182498382,   -1.63606896922,
   0.450688627235,    1.57698579440,    1.26843494328,   -3.16798642674,   -6.83419264548,   -5.37432696832,
   -8.44202922569,   -9.94818435373,   -6.01767315498,   -8.74645850396,   -9.33963865749,   -6.52606891117,
   -2.11136224508,   -3.63980243567,   -17.3220171221,   -4.09070881500,   -13.1943048089,   -1.61502794398,
   -2.27640071874,    3.79095739238,    5.02034622785,  -0.479123945235,   -5.72021533230,   -6.49664214697,
   -5.41431685967,   -3.83821499890,   -3.40654646337,   -3.86241095315,   -7.33354399261,   -6.19424392149,
   -6.50929731674,   -6.72390343177,   -3.20219830206,   -9.62141229527,   -6.57582963161,   -4.70076357543,
},
{
    1.61928012390,    2.18522773610,   -11.1977046007,    2.55730386708,    1.77152941632,    13.3534507787,
    4.11196661189,   -12.8169778043,   -12.6839240768,    95.1410445734,    14.6330225498,    7.04208824378,
  -0.497817484562,    11.9233162716,    13.9006086275,    17.3359761659,    2.91896715975,    7.41429879343,
    2.37060247004,    2.18580016393,    3.00527857918,    3.19368144731,    2.04681763800,    3.14984948426,
   -9.87229649908,    9.42849253750,    9.29575996071,    6.09790724766,    8.95675841254,    16.5612410921,
    1.17284223635,    4.18954888030,    2.73539255755,    2.57472739991,   -3.27086927080,   -1.68292210904,
    5.43369561992,    12.3088134260,    7.54335481944,   -9.39177531702,    5.44273872863,   -1.43661669760,
   -12.2432643529,    7.91720330292,    2.48195738147,    1.55758494558,   -11.6729786631,   -16.7634577374,
    3.51830820868,    8.26954420328,    6.85570362359,    3.23790008991,  -0.580323425396,    1.07416732004,
    2.33851044078,    5.96833742143,    2.44544825138,   -4.22556084587,   -2.27483562655,   -2.45959713642,
   -6.02998849958,   -3.82849120087,   -3.88232908528,   -4.43922102010,   -6.93544144105,   -6.19424392149,
 0.00520850413779,    4.26348616172,    3.87026004778,   -6.04286677972,   -8.51024383753,   -8.15841326488,
   -1.79190636860,  0.0617025313114,   0.716863814499,   0.166041701236,   -3.12338044576,   -1.40380767879,
    3.01638553195,    3.62606894482,   -1.78446843887,   -5.08978296436,    1.17416486145,   -3.99370888359,
  -0.655500619147,   0.625586580876,   0.788072126217,   -4.27079623153,   -7.04349262793,   -6.20630988686,
   -8.09631305473,   -6.79002948435,   -7.15385672093,   -6.84928104137,   -7.93679465698,   -7.22139710446,
   -3.20809872200,   -4.14106321047,   -16.7877815213,   -2.90571696531,   -2.90566379430,   -11.9243045226,
   -4.40884437221,    1.70108151577, -0.0438466036696,    4.06630928290,   -4.24027216807,   -3.15759783481,
   -4.70358055171,   -3.78271517431,   -3.26077886935,   -6.30293519068,   -7.36867393869,   -6.15054479643,
   -7.84653437912,   -6.30970603601,   -9.62141229527,   -4.59832563694,   -7.47507811941,   -5.70081880516,
},
{
    4.24056105166,   0.283315126158,    12.0368225525,   -12.4658563158,    4.63861937546,    6.04967090955,
   -13.6004620130,    13.1379198417,    13.2818405765,    14.6330225498,    95.0549573511,  -0.201028443308,
    4.22568698788,    5.57269052947,    7.31803758939,    8.95675841254,    5.76091246408,    6.18971629783,
    3.57441254429,    1.17390695484,    2.09320522335,    3.30475352149,    3.96775742616,    5.59392466674,
    5.82666009926,    5.42245148490,    5.25351092114,    8.69796976280,    21.1906530124,   -10.6900502580,
    3.17239108681,  -0.453212325349,   -2.80677249714,   -3.78922402605,    5.19487052725,   0.342721870139,
    23.4873253383,   -9.37774635473,   -14.7753124299,   -19.8582350703, -0.0679883047309,    8.60717933673,
    3.43150830196,    3.17903115692,   -2.76899080156,   -3.79629591723,    2.76355973272,   -2.93284896764,
    2.78643342225,    2.67799341696,    6.14401133253,    3.49249165404,   0.219686486452,    1.67444252606,
    5.11985745270,    7.80962418292,    7.68438220043,   -4.99338303655,  -0.288350770806,   -2.75213165922,
   -4.73781547117,   -3.37577633747,   -3.05018339346,   -5.29810362710,   -7.39504638297,   -6.52606891117,
    2.67602940790,    2.38818731746,    5.51065378265,   -7.36658175599,   -13.0398138120,   -8.68936039711,
   0.963561730308,   -3.00379402614,   -1.48303979002,  -0.963704921350,    1.43073220478,    3.00380912726,
    3.35725030544,    3.26675519699,   -2.99515736580,   -3.84237277717,    2.76659868630,   -3.14490568256,
   -1.39758341021,   0.135824431576,    1.72684525309,   -4.23299685560,   -7.04252427141,   -7.62228100824,
   -9.33786975830,   -6.78794619835,   -6.46198437092,   -6.79811016906,   -8.67247228685,   -10.8203866155,
   -6.03443377457,   -3.04768959184,   -12.7359922823,   -15.7714696397,   -5.49689862569,   -4.17525572483,
    3.23042948793,   -3.15950591385,   -5.51170646267,   -6.45874811277,    4.87083197795,   0.470523253304,
   -3.90690736715,   -2.61517726585,   -3.36354084830,   -5.30466293646,   -6.50728434006,   -7.22139710446,
   -11.8893635232,   -7.42705630041,   -6.57582963161,   -7.47507811941,   -7.26558298022,   -9.41793008863,
},
{
    1.90846053913,    3.32191661492,    3.95863320677,   0.514937591235,    2.64266037378,    3.97585019365,
   -1.09564831427,    5.44249526303,    5.80496011766,    7.04208824378,  -0.201028443308,    119.836425318,
    2.61850268380,    3.95757418947,    5.83649997367,    7.04208824378,    2.11615664827,    5.38523171468,
    1.77926900938,    3.10532137185,    4.15892129831,    5.38523171468,    2.33797744968,    4.00304809629,
    5.83649997367,    5.64316448556,    5.36585346694,    7.06585597865,  -0.201028443308,    6.94511364434,
    1.42851903350,-0.00675287102231,   -2.02802672410,   -2.54663857301,    1.38599815357,    1.85902383774,
   -1.09564831427,    7.06585597865,    1.42851903350,    2.31078513921,   0.514937591235,   -29.6934146419,
    3.95757418947,    3.37243472607,   -2.02151439206,   -3.35031062359,    3.97585019365,   -2.00425841399,
 -0.0424397035294,    4.15892129831,    5.80496011766,    5.64316448556,    2.02183256873,    3.37243472607,
    5.36585346694,    5.44249526303,    3.95863320677,   -4.69893147886,-0.00675287102233,   -1.69030572390,
   -3.35179369511,   -2.02151439206,   -2.02802672410,   -4.21925717124,   -5.73626900280,   -4.70076357543,
   -1.72460020986,    3.10532137185,    3.32191661492,   -5.32764231058,   -10.1740482357,   -13.5953439229,
  -0.822761627120,   -1.72460020986, -0.0424397035294,    2.11615664827,   0.170657990262,    2.33797744968,
    2.61850268380,    2.02183256873,   -3.35179369511,   -4.80906526575,    2.64266037378,   -3.31381710689,
  -0.822761627120,    1.77926900938,    1.90846053913,   -3.80182453265,   -6.75964659113,   -6.79922199279,
   -6.75964659112,   -10.1740482357,   -5.73626900280,   -8.15448489157,   -10.7815827017,   -9.41793008863,
   -3.80182453265,   -5.32764231058,   -4.69893147886,   -29.6934146419,   -3.31381710689,   -2.00425841399,
    2.31078513921,   -1.69030572390,   -4.21925717124,   -5.22313360386,    1.85902383774,    1.58839264994,
   -4.80906526575,   -3.35031062359,   -2.54663857301,   -5.22313360386,   -8.15448489157,   -5.70081880516,
   -6.79922199279,   -13.5953439229,   -4.70076357543,   -5.70081880516,   -9.41793008863,   -7.07451952436,
},
{
    3.58974770676,    2.11540301866,    2.00594589649,    1.54681324423,   -10.8751916175,    3.81386715783,
    2.12704020822,   0.660741621798,    10.3977310850,  -0.497817484562,    4.22568698788,    2.61850268380,
    96.2328823514,    5.95579816464,    4.09190734571,    3.01638553195,   -12.4019770743,   -14.7745897265,
    2.26290931654,   0.897125204738,  -0.158319857919,    2.84939790460,    4.01280807894,    1.65867317606,
  -0.175364901065,    11.3982255953,    1.63364398023,    2.99488054707,    3.35725030544,    4.96241427809,
   0.624602508586,   -1.15408470499,   -1.67373580774,    8.11963810962,  -0.873547681475,   -1.05467036139,
    1.86609684761,    3.09071169008,   -3.15515491248,    1.72765665257,   0.111484934528,   0.663691969363,
   -2.62487054875,   -9.04793938552,    9.13690958564,    18.2660662821,    6.43466143584,    7.51502639263,
    7.39312816784,    7.54195229339,    1.97210592684,    2.68655900288,   -11.3999775314,    2.14946668185,
    3.18541284620,    2.34670913657,   0.248275334921,    1.06176307263,   -2.85326303442,    1.60500993770,
   -19.3172377973,   -8.65304489492,   -5.50478634897,  -0.901028953118,   -17.7214813554,   -18.3629095634,
    2.63094122274,    2.37222909638,   0.842927830720,    3.20833846878,    1.35133816440,    1.18570542996,
   0.752523437973,    1.12185793523,  -0.966763684304,  -0.143948880618,  -0.376870686323,   -2.65468288836,
   -1.03267698428,   -1.13586621270,   -2.54666298514,   -5.42499548254,   -4.42205372104,   -1.78976586390,
  -0.981000615935,   -1.66259948970,   -3.80493410954,-0.00969180416603,   -1.78235877809,   -2.04081972113,
   -7.37680265761,   -3.62453739721,   -3.38273805882,   -4.03303910361,   -3.41068706800,   -3.79629591723,
   -3.93793507938,   -1.88530104907,   -1.71528642262,   -1.90101638341,   -18.0301307705,   -6.22632330604,
   -3.29390863627,   -2.98679387144,   -2.74395919415,   -10.9041161162,   -1.73724798100,   -1.28902728442,
    5.54952664487,   -2.69413426189,   -3.64730771509,   -3.18226111466,    2.34564145219,    1.55758494558,
   -6.68837691359,   -3.06099501395,   -3.83821499890,   -3.78271517431,   -2.61517726585,   -3.35031062359,
},
{
    2.43658406577,    1.71359022390,    2.85356476469,    2.94636891811,    3.90350490143,   -10.6187303080,
    3.61354047806,    1.51214093103,   0.677327563698,    11.9233162716,    5.57269052947,    3.95757418947,
    5.95579816464,    92.9081609273,   -10.9696196737,   -12.2432643529,    3.35728059368,    5.69324816715,
    2.89791410635,    2.16723095516,    3.70110750688,   0.783079248832,   0.735988436246,    2.77936969810,
    11.4112320403,  -0.242624434201,    1.22098483369,    3.33357224677,    3.43150830196,    5.08742069869,
  -0.523543280774,   -2.26824927103,    8.86483341561,   -4.56923963793,   0.241912282487,  -0.371207019862,
    4.08962687016,    5.24852905716,  -0.518408162699,  -0.344176823369,    2.38840824158,   0.171732966065,
    3.45654007290,    10.0677163024,    7.58738509851,   -5.42499548254,    7.92839152050,    5.99953633686,
    1.34710462072,    1.92792536871,    8.51096261755,    9.26811669461,    3.60317294936,   -12.0586768221,
    7.33859822326,    6.66691905449,    4.75341046185,    2.55767805912,    1.72187882714,    1.78263563452,
   -5.64241517623,   -18.8945373099,   -21.4912539598,   -21.0330481220,   -2.53196272433,   -3.12264250823,
  -0.308055041427,   0.580982753522,   0.405950073013,   -2.30497741046,   -2.92596621497,   -3.08366691349,
   -1.45370351642,  -0.532432213488,    1.40874140874,   0.407242738726,  -0.675888482944,    1.19185087310,
   -2.62487054875,   -2.07282329380,   -4.22320070153,   -1.17578717837,   -1.87300467473,   -4.31705493911,
   -2.13442715547,   -1.09661117536,   -1.16278277850,   -4.48756391546,   -4.03545319173,   -4.09579126929,
   -7.29749260730,   -3.49052670024,   -4.36964974991,   -3.19563732100,   -3.49946492897,   -3.84237277717,
   -4.08938603508,   -2.07073322809,   -1.92029423174,   -2.05132354587,   -6.24502277907,   -18.3575303507,
   -1.08325212653,  -0.979733462898,   -10.5458301759,   -5.67174203167,   -2.75853109518,   -3.45806031990,
   -3.59775002064,    5.54952664487,    2.98812055676,    1.73375230332,   -4.23601380227,   -5.08978296436,
   -8.02880140394,   -4.19782340310,   -5.41431685967,   -4.70358055171,   -3.90690736715,   -4.80906526575,
},
{
    2.17703943527,    1.76170682652,    2.75496955568,    3.66237190690,    1.39081975589,   -11.2385279478,
    5.27981451917,    1.26119834948,    3.47335810570,    13.9006086275,    7.31803758939,    5.83649997367,
    4.09190734571,   -10.9696196737,    98.6684618307,   -9.87229649908,    2.83654536530,    5.71434286053,
    2.99608668066,    2.00550909998,    4.70811456921,    3.81743460173,    3.05266424708,    4.67733974278,
    24.6607223608,    14.1327613027,    11.2369380302,    4.98178812755,    5.82666009926,    7.18696222212,
   0.313854286943,    6.29032662774,   -6.47364612549,   -6.59806078449,  -0.206560379201,   -1.14299204712,
    5.93887287961,    7.02062231512,    1.83839328834,   -4.19956382234,    4.32886732400,  -0.817545630271,
    11.4112320403,   0.823733923179,   -4.70149806626,   -4.03303910361,   -7.09732086170,    6.35850336621,
    1.45528844758,    2.87287451220,    6.80378366108,   -12.0020462898,    2.25691717471,    6.65935094182,
   -7.46208658743,    11.4517516335,    7.42132958226,    1.88241502240,   -13.1120021898,   -21.5884745239,
   -3.08262042966,    1.03529123844,    4.46226543485,   -3.89444925619,   -11.4856321658,   -8.74645850396,
    1.00101216412,    2.25972447542,    3.51283765151,   -2.87516480264,   -5.38655433290,   -5.44641221973,
   -1.01728261213,   0.625326118133,    2.91476006270,    2.01415320722,   -1.29945312138,  -0.614509431762,
  -0.175364901065,    1.12394241249,   -6.28473382085,   -3.19563732100,    3.95791893946,   -4.77212084362,
   0.768747418436,   0.261943941164,    2.22704751677,   -6.87236432478,   -8.70938048563,   -8.56595466210,
   -9.22655396238,   -5.77589734195,   -7.81212664565,   -7.15322553675,   -6.35861885328,   -6.79811016906,
   -7.18637400837,   -3.06686059009,   -2.22568304570,  -0.983369342872,   -4.33829916575,   -17.3542721770,
  -0.622281335680,   -11.8168960818,   -3.76698308645,   -5.59596919541,   -3.10671340685,   -3.70888639990,
   -4.23601380227,    2.34564145219,    4.33952915306,    1.42580257187,   -4.49896444709,   -6.84928104137,
   -8.49276272601,   -4.53722062451,   -7.33354399261,   -7.36867393869,   -6.50728434006,   -8.15448489157,
},
{
   0.788072126217,    3.87026004778,    2.44544825138,    5.44273872863,    1.17416486145,   -11.6729786631,
    5.43369561992,    5.96833742143,    6.85570362359,    17.3359761659,    8.95675841254,    7.04208824378,
    3.01638553195,   -12.2432643529,   -9.87229649908,    95.1410445734,   0.166041701236,    3.19368144731,
   0.625586580876,    4.26348616172,    8.26954420328,    7.41429879343,   -1.40380767879,    3.14984948426,
    13.9006086275,    3.23790008991,    2.33851044078,    12.3088134260,    14.6330225498,    16.5612410921,
    7.54335481944,   -2.27483562655,   -3.88232908528,   -3.26077886935,   -3.27086927080,   -4.24027216807,
    4.11196661190,    6.09790724766,    1.17284223635,   -4.40884437221,    2.55730386708,   -2.90571696531,
    11.9233162716,    1.07416732004,   -3.82849120087,   -3.78271517431,    13.3534507787,   -11.9243045226,
   0.716863814499,    3.00527857918,   -12.6839240768,    9.42849253750,    3.62606894482,    7.91720330292,
    9.29575996071,   -12.8169778043,   -11.1977046007,   -16.7877815213,    4.18954888030,    1.70108151577,
   -1.78446843887,    2.48195738147,    2.73539255755, -0.0438466036697,   -7.15385672093,   -9.62141229527,
  0.0617025313115,    2.18580016393,    2.18522773610,   -4.14106321047,   -6.79002948435,   -6.30970603601,
  -0.655500619147, 0.00520850413776,    3.51830820868,    2.91896715975,   -3.12338044576,    2.04681763800,
  -0.497817484562,  -0.580323425396,   -6.02998849958,   -4.70358055171,    1.77152941632,   -2.90566379430,
   -1.79190636860,    2.37060247004,    1.61928012390,   -3.20809872200,   -8.09631305473,   -7.84653437912,
   -7.04349262793,   -8.51024383753,   -6.93544144105,   -7.36867393869,   -7.93679465698,   -7.47507811941,
   -4.27079623153,   -6.04286677972,   -4.22556084587,   -1.43661669760,   -3.99370888359,   -16.7634577374,
   -9.39177531702,   -2.45959713642,   -4.43922102010,   -6.30293519068,   -1.68292210904,   -3.15759783481,
   -5.08978296436,    1.55758494558,    2.57472739991,    4.06630928290,   -6.84928104137,   -4.59832563694,
   -6.20630988686,   -8.15841326488,   -6.19424392149,   -6.15054479643,   -7.22139710446,   -5.70081880516,
},
{
    1.44529123062,    4.81301106985,    3.51366877414,    6.16196222431,   -12.6814395874,   0.827377726153,
    5.10925342427,    4.11048986679,    13.8527965563,    2.91896715975,    5.76091246408,    2.11615664827,
   -12.4019770743,    3.35728059368,    2.83654536530,   0.166041701236,    92.1365355516,   -16.1553457842,
 -0.0310057129430,    1.83082030725,    3.58769338251,    4.24731476814,    2.13648776433,    1.02050137931,
    2.01415320722,    11.6325047244,    1.97189302591,    1.29179650177,  -0.963704921350,    3.32517390895,
   -1.52362951526,  -0.774776264366,   -1.49196964868,   -1.95176042081,   -2.05718013166,    8.61627206225,
   -2.37033491174,    2.77259210961,   -3.83870245603,    12.0459018356,    7.29488051492,    7.96997978451,
   0.407242738726,    10.3804109113,   -10.0418795477,    8.11963810962,   -1.56432015213,  -0.257197740859,
   -16.2402478326,    3.73619642794,   0.530475704477,    4.26622830396,    7.17934350437,    3.35790524138,
    4.36501661673,   0.651472016818,   -1.19922432959, -0.0789435747566,   -1.87628143369,    2.47431235715,
   -1.14582454271,   -4.50485903284,   -7.05793411218,   0.193453132463,    5.68294330736,    2.90487823575,
   -15.1465558918,    4.41797286516,  -0.244222984889,    2.13971609673,   -16.0949204373,   -19.5588218250,
   -2.02931849394,   -1.83079589154,  0.0169954512305,    1.20436215199,   0.337099110791,   -1.21452928814,
  -0.143948880618,   -2.34515277457,  -0.172708307440,   -4.56923963793,   -4.45236155393,  -0.852923983700,
  -0.737208484589,   -1.95883804573,   -3.34650475961,  0.0509280864458,   -1.05123128530,   -1.74931022596,
   -2.51407232447,   -5.79854447676,   -4.40445015800,   -6.59806078449,   -3.82010252008,   -3.78922402605,
   -2.70739810248,   -3.04232718639,   -4.33004449477,   -5.10130764631,   -16.9543023518,   -3.66840017366,
   -2.05981445593,   -2.77795348368,   -3.90795863113,   -2.12699636533,  -0.612057989473,   -10.8310446324,
    2.98812055676,   -3.64730771509,   -1.53071571540,   -2.45376070600,    4.33952915306,    2.57472739991,
   -4.20846320503,   -6.03427973474,   -3.40654646337,   -3.26077886935,   -3.36354084830,   -2.54663857301,
},
{
    1.01893534483,    3.99144669601,    4.39505757541,    5.34531479332,   -12.6457044171,    1.73634316499,
    3.78761175390,    4.70113281529,    14.8468941777,    7.41429879343,    6.18971629783,    5.38523171468,
   -14.7745897265,    5.69324816715,    5.71434286053,    3.19368144731,   -16.1553457842,    93.0369089747,
   -1.91776405385,    2.47930316206,    2.99133463145,    6.87948754021,    1.51405062145,    3.53162357437,
    3.81743460173,    12.5784802369,    2.44550709798,    3.07354155736,    3.30475352149,    3.53402648425,
  -0.486534657962,   -1.00719159757,   -4.21039938474,   -2.12699636533,    9.16556607048,   -2.81745826544,
    12.8234289622,    13.2970436677,    8.03071032466,   -5.30094184162,    1.03203693157,   -3.25072542614,
   0.783079248832,    9.16691233076,    5.60836397767,   -10.9041161162,    3.03302590491,   -1.48524032158,
    3.26782880655,   -14.3750955712,    2.26907424018,    4.82287665170,    4.85576722241,    4.67724015175,
    5.49448637986,    2.84956457467,    2.37667671700,   -2.11393300786,   0.149580620670,   -1.76475194051,
  -0.768481463569,  -0.624657997254,  0.0380088357487,   -5.14903647973,   -3.35219702054,  -0.479123945235,
    1.83679897869,   -14.9716998052,   -12.7603680586,   -17.9660620096,   -1.80161412778,   0.699673230686,
   -4.10591299042,   -1.08861127329,   0.864511276649,    4.24731476814,  -0.156236616844,    2.71948844032,
    2.84939790460,   0.493403977792,   -3.96373655670,   -5.67174203167,   0.124039501753,   -6.13796778300,
   -1.74888357212,    2.22998910694,    1.70972351290,   -4.11294492957,   -4.67353237935,   -4.91534081789,
   -7.68846714904,   -7.13738360177,   -5.52024849453,   -5.59596919541,   -6.26867919373,   -6.45874811277,
   -4.34479292116,   -3.61884557138,   -5.60682842900,   -1.41314885590,   -18.1647344400,   -2.77501741267,
  -0.850722933852,   -3.41769576679,   -6.71315349486,   -3.03529803528,   -10.3530654949,   -1.81557029447,
    1.73375230332,   -3.18226111466,   -2.45376070600,   -3.32889805364,    1.42580257187,    4.06630928290,
   -5.14678983453,   -5.97302395553,   -3.86241095315,   -6.30293519068,   -5.30466293646,   -5.22313360386,
},
{
   -11.7602653513,    2.38263262964,   0.592951516896,    2.87699128121,    3.47037493945,    1.93512326132,
    2.40375639965,    12.9423641628,    1.87942139897,    2.37060247004,    3.57441254429,    1.77926900938,
    2.26290931654,    2.89791410635,    2.99608668066,   0.625586580876, -0.0310057129431,   -1.91776405385,
    92.4347819176,    1.87872915877,    1.28248388672,    2.22998910694,   -14.6463852485,   -14.8400567409,
   0.261943941164, 0.00817510064863,    11.7288926780,    1.20036859623,   0.135824431576,    1.92241176595,
   -1.92153663320,   -10.4459740465,    9.35576439192,    12.0459018356,    2.61461575929,    2.22376399657,
    1.96844187389,  -0.685276785438,    4.38226922329,    3.56684831254,  -0.546162441077,    2.86356084676,
   -1.09661117536,   -1.38754417573,   -1.11372675128,    1.72765665257,   -1.11357560461,    2.87309717622,
   0.419196010992,   -1.91084817595,    1.57698579440,  -0.233985776625,   -1.77000131659,  -0.771434475411,
   -6.40891589527,   -1.20420235933,   -2.15700853736,  -0.491483243017,   0.265231994911,   0.829071607073,
 -0.0647828994834, -0.0139864204816,  -0.995124191103,  -0.230362026411, -0.0859737999384,    9.88998691768,
   -1.15480161496,   -4.73130890527,    5.17250072782,    7.13294881956,   -1.36735936182,    8.54277559021,
   -14.7303964383,  -0.379801943548,   -2.04207166717,   -1.95883804573,    5.26249155547,    4.02652212184,
   -1.66259948970,   -2.00355051992,   -1.30237338382,  -0.344176823369,   -2.53679733505,    1.19191624916,
    2.67912768460,   0.960378711611,   -1.48444614454,   0.934777145256,    3.14499930424,   0.659261570580,
   -17.6100253304,   -3.07743593625,   -2.18365247431,   -4.19956382234,   -18.8896883403,   -19.8582350703,
   -15.5611255551,   -1.25286666352,   -5.02467448805,   -4.43349551400,   -2.67053226402,   -5.15925382175,
   -2.98718992499,   -4.10554906252,   -4.87087529660,   -5.30094184162,   -4.53452165872,   -1.69920580331,
   -1.08325212653,   -3.29390863627,   -2.05981445593,  -0.850722933852,  -0.622281335680,   -9.39177531702,
    4.34231891950,   -3.31927402712,   -2.27640071874,   -4.40884437221,    3.23042948793,    2.31078513921,
},
{
    2.16993674850,   -10.8343835093,    3.22581106136,   0.466615290388,    1.65442854956,    1.12297208977,
    11.0796491579,    1.95804453141,    2.17686565290,    2.18580016393,    1.17390695484,    3.10532137185,
   0.897125204738,    2.16723095516,    2.00550909998,    4.26348616172,    1.83082030725,    2.47930316206,
    1.87872915877,    93.6426102094,   -15.7905603561,   -14.9716998052,    2.94467407897,    1.68664098403,
    2.25972447542,    2.60278409476,    2.46454329810,    11.4762396034,    2.38818731746,   0.606401472974,
   -10.7280805275,  -0.188438998761,  -0.156025669468,    2.47431235715,    11.0676035914,    12.1289294635,
  -0.538823633149,    2.71510318704,  -0.267792101053,   0.829071607073,    3.19550859524,    1.62075751509,
   0.580982753522,  -0.295170575584,  -0.201661053047,    1.60500993770,    1.55050062551,   0.429846443576,
   -4.51946838500,   -3.19998558894,   -1.37410684853,    1.14479443151,   0.292564966958,    1.04860798325,
    1.48147473050,   -4.57224088644,   0.401277785420,   0.918782591640,   0.651265875292, -0.0582642072911,
   -2.18819474404,   -2.48488946318,  -0.876450614864,   -1.46089485254,    7.59505512494,   -2.30163312917,
    7.71072711834,    9.06274797268,   -1.28003934163,  0.0555678467829,    7.67248056184,   -2.61762276351,
   -1.65035733438,   -15.2978841164,    1.47846360711,    4.41797286516,   0.733919099735,  -0.695741099095,
    2.37222909638,   0.279843608035,    1.65480029254,    1.78263563452,    1.63938994047,    1.88972013476,
   -4.01214234100,   -4.73130890527,   -2.13068687021,  -0.222808488642,   -2.67538276240,  -0.607862524868,
   -2.26857129554,   -17.8224916068,   -18.7096452661,   -21.5884745239,   -3.81099339358,   -2.75213165922,
   -2.12754545184,   -17.0216252500,   -4.48983028873,   -6.05454160848,  -0.973849166874,   -2.55234384466,
   -4.10554906252,   -1.91383293954,   -1.53452144760,   -1.76475194051,   -5.85849699332,   -7.69733034196,
  -0.979733462898,   -2.98679387144,   -2.77795348368,   -3.41769576679,   -11.8168960818,   -2.45959713642,
   -2.59637492575,    3.97463653510,    3.79095739238,    1.70108151577,   -3.15950591385,   -1.69030572390,
},
{
    2.01281383095,   -12.3582958452,    2.93931202527,    1.02899668126,    1.96270324942,    1.10735995817,
    13.2137268024,    4.07022363329,    3.61855263797,    3.00527857918,    2.09320522335,    4.15892129831,
  -0.158319857919,    3.70110750688,    4.70811456921,    8.26954420328,    3.58769338251,    2.99133463145,
    1.28248388672,   -15.7905603561,    92.7490309898,   -14.3750955712,    2.89820975974,    3.44568326186,
    2.87287451220,    3.05273950099,    3.49246198396,    11.0614215636,    2.67799341696,    1.19761159601,
    7.75620353226,   0.137554300282,   -1.29586693892,   0.193453132463,   -7.83212364819,    7.93840729882,
    6.04429774214,    5.59187838003,    2.82235210499,  -0.230362026411,    2.06849456445,    1.39656074305,
    1.92792536871,    2.25917246856,   -2.64461858054,  -0.901028953118,    4.62879146440,   0.618454666887,
    11.4159072685,    11.0067261524,    4.05940570669,    2.13910789756,    8.64381642659,    1.41439353302,
    2.69155885333,    4.61452225228,  -0.940801877032,    1.81968452702, -0.0567776177297,   -1.46089485254,
    4.48066186429,   -2.78247617573,   -1.85841628415,   -2.73796049663,   -7.34212250355,   -6.23340209851,
   -3.09523932096,   -3.19998558894,   -2.35072651678,   -2.75719522516,   -3.88179659482,   -2.10738078932,
  -0.701150313907,   0.982437868940,   -15.9480158432,    3.73619642794,   0.586904825889,    2.02175215248,
    7.54195229339,   -12.7497104077,   -18.0169750810,   -21.0330481220,    4.48072367247,   0.702694944772,
   -2.50966202192,   -1.91084817595,   0.835336974273,   -2.90899564007,   -7.65647231212,   -3.35210644563,
   -6.13678692008,   -3.79742931057,    1.21387395923,   -3.89444925619,   -7.03436867550,   -5.29810362710,
   -3.04136462819,   -18.0874436684,   -2.15868159775,   -4.14858224039,   -2.99859433160,   -4.73280164616,
   -4.87087529660,   -1.53452144760,   -2.50996423442,   -5.14903647973,  -0.936251126037,   -5.25391663395,
   -10.5458301759,   -2.74395919415,   -3.90795863113,   -6.71315349486,   -3.76698308645,   -4.43922102010,
   -4.18361147861,   0.846182241218,    5.02034622785, -0.0438466036696,   -5.51170646267,   -4.21925717124,
},
{
    1.70972351290,   -12.7603680586,    2.37667671700,    1.03203693157,   0.124039501753,    3.03302590491,
    12.8234289622,    2.84956457467,    2.26907424018,    3.19368144731,    3.30475352149,    5.38523171468,
    2.84939790460,   0.783079248831,    3.81743460173,    7.41429879343,    4.24731476814,    6.87948754021,
    2.22998910694,   -14.9716998052,   -14.3750955712,    93.0369089747,    2.71948844032,    3.53162357437,
    5.71434286053,    4.82287665170,    5.49448637986,    13.2970436677,    6.18971629783,    3.53402648425,
    8.03071032466,   0.149580620670,  0.0380088357487,   -2.45376070600,    9.16556607048,   -10.3530654949,
    3.78761175390,    3.07354155736,  -0.486534657962,  -0.850722933852,    5.34531479332,   -1.41314885590,
    5.69324816715,    4.67724015175,  -0.624657997254,   -3.18226111466,    1.73634316499,   -2.77501741267,
   0.864511276649,    2.99133463145,    14.8468941777,    12.5784802369,   0.493403977792,    9.16691233076,
    2.44550709798,    4.70113281529,    4.39505757541,   -5.60682842900,   -1.00719159757,   -3.41769576679,
   -3.96373655670,    5.60836397767,   -4.21039938474,   -6.71315349486,   -5.52024849453,   -3.86241095315,
   -1.08861127329,    2.47930316206,    3.99144669601,   -3.61884557138,   -7.13738360177,   -5.97302395553,
   -1.74888357212,    1.83679897869,    3.26782880655,   -16.1553457842,  -0.156236616844,    1.51405062145,
   -14.7745897265,    4.85576722241,  -0.768481463569,    1.73375230332,   -12.6457044171,   -18.1647344400,
   -4.10591299042,   -1.91776405385,    1.01893534483,   -4.34479292116,   -7.68846714904,   -5.14678983453,
   -4.67353237935,   -1.80161412778,   -3.35219702054,    1.42580257187,   -6.26867919373,   -5.30466293646,
   -4.11294492957,   -17.9660620096,   -2.11393300786,   -3.25072542614,   -6.13796778300,   -1.48524032158,
   -5.30094184162,   -1.76475194051,   -5.14903647973,   -3.32889805364,   -2.81745826544,   -1.81557029447,
   -5.67174203167,   -10.9041161162,   -2.12699636533,   -3.03529803528,   -5.59596919541,   -6.30293519068,
   -4.91534081789,   0.699673230686,  -0.479123945235,    4.06630928290,   -6.45874811277,   -5.22313360386,
},
{
   -12.5737071842,   0.908235754809,   0.854745298683,    2.30547304932,    2.10113876234,    2.32430877087,
    1.64544241710,    11.4442099056,    1.31728951722,    2.04681763800,    3.96775742616,    2.33797744968,
    4.01280807894,   0.735988436246,    3.05266424708,   -1.40380767879,    2.13648776433,    1.51405062145,
   -14.6463852485,    2.94467407897,    2.89820975974,    2.71948844032,    92.6578117154,   -15.1998571420,
  -0.614509431762,    1.14597346545,    10.7287014056,    4.03107288934,    3.00380912726,    4.68667942184,
    1.78584284172,    8.66578251209,   -7.06529346522,    8.61627206225,   -1.41387342026,   -1.37831976503,
    1.27190685484,    1.45683591274,  -0.541588753301,    2.22376399657,   0.228970207248,   0.752358397718,
    1.19185087310,    2.97337347268,    2.13889983533,   -1.05467036139,   -1.65265185841,   0.191498213269,
    1.75832614461,    2.02175215248,  -0.642957914166,    2.92767457208,    2.08159759315,   0.194605943195,
   0.646018777457,   -3.04675227459,    6.73360604526,    7.33279444374,   -4.68783610204,    12.1289294635,
   -2.32574635157,   -4.82797426774,   -5.73844782065,    7.93840729882,   0.216651853125,  -0.702321383383,
  -0.102612168783,  -0.695741099095,   -2.57697065912,   -1.13547734156,   -1.19535906150,   -2.27303616948,
    2.66720371507,   0.277616118533,  -0.601676628533,   -1.21452928814,   -17.5987402266,  0.0681813707366,
   -2.65468288836,  -0.520669323459,  -0.627258344381,  -0.371207019862,   -3.05199614679,   0.115820235337,
   -15.3285798195,    4.02652212184,   -3.02612919136,   0.692207431452,   -15.1668725173,   -20.7829473955,
  -0.540637942149,   -2.56168688630,   -4.40138514720,   -1.14299204712,    3.80636994282,   0.342721870139,
   -17.8481897204,   -4.80044307096,   -3.86961435551,   -2.66162830552,   -3.24361929777,   -3.54614834121,
   -4.53452165872,   -5.85849699332,  -0.936251126037,   -2.81745826544,   -1.64566691985,   -1.50296632734,
   -2.75853109518,   -1.73724798100,  -0.612057989473,   -10.3530654949,   -3.10671340685,   -1.68292210904,
    2.77691764137,   -3.93903347767,   -5.72021533230,   -4.24027216807,    4.87083197795,    1.85902383774,
},
{
   -13.8647322686,    1.40680050611,   0.866154454190,    2.52173697735,    1.70988267819,    3.04187382428,
    3.60711007986,    12.1325078736,    2.72936358630,    3.14984948426,    5.59392466674,    4.00304809629,
    1.65867317606,    2.77936969810,    4.67733974278,    3.14984948426,    1.02050137931,    3.53162357437,
   -14.8400567409,    1.68664098403,    3.44568326186,    3.53162357437,   -15.1998571420,    95.4361312537,
    4.67733974278,    1.57770453761,    10.7075152535,    2.92665381643,    5.59392466674,    6.98051591347,
    1.80036779883,    9.02880381129,    9.09063855211,   -10.8310446324,  -0.675358718959,   -1.50296632734,
    3.60711007986,    2.92665381643,    1.80036779883,   -1.69920580331,    2.52173697735,   -1.00718051189,
    2.77936969810,   0.888231594353,  -0.726464919442,   -1.28902728442,    3.04187382428,   -1.74755203283,
    1.72996653042,    3.44568326186,    2.72936358630,    1.57770453761,   0.657839132651,   0.888231594353,
    10.7075152535,    12.1325078736,   0.866154454190,   -3.27561900621,    9.02880381129,   -7.69733034196,
   -2.70772471001,  -0.726464919442,    9.09063855211,   -5.25391663395,   -5.75346587156,   -6.49664214697,
  -0.354029801964,    1.68664098403,    1.40680050611,   -3.91494167754,   -3.49132852619,   -3.78877759863,
    2.17786885862,  -0.354029801964,    1.72996653042,    1.02050137931,   0.220345800761,   -15.1998571420,
    1.65867317606,   0.657839132651,   -2.70772471001,   -3.45806031990,    1.70988267819,   -4.74087329353,
    2.17786885862,   -14.8400567409,   -13.8647322686,   -21.4030642441,   -2.37328471558,   -2.00135462423,
   -2.37328471558,   -3.49132852619,   -5.75346587156,   -3.70888639990,   -1.38620940730,   0.470523253304,
   -21.4030642441,   -3.91494167754,   -3.27561900621,   -1.00718051189,   -4.74087329353,   -1.74755203283,
   -1.69920580331,   -7.69733034196,   -5.25391663395,   -1.81557029447,   -1.50296632734,   -3.19605235187,
   -3.45806031990,   -1.28902728442,   -10.8310446324,   -1.81557029447,   -3.70888639990,   -3.15759783481,
   -2.00135462423,   -3.78877759863,   -6.49664214697,   -3.15759783481,   0.470523253304,    1.58839264994,
},
{
    2.22704751677,    3.51283765151,    7.42132958226,    4.32886732399,    3.95791893946,   -7.09732086170,
    5.93887287961,    11.4517516335,    6.80378366108,   -9.87229649908,    5.82666009926,    5.83649997367,
  -0.175364901065,    11.4112320403,    24.6607223608,    13.9006086275,    2.01415320722,    3.81743460173,
   0.261943941163,    2.25972447542,    2.87287451220,    5.71434286053,  -0.614509431762,    4.67733974278,
    98.6684618307,   -12.0020462898,   -7.46208658743,    7.02062231512,    7.31803758939,    7.18696222212,
    1.83839328834,   -13.1120021898,    4.46226543485,    4.33952915306,  -0.206560379201,   -3.10671340685,
    5.27981451917,    4.98178812755,   0.313854286943,  -0.622281335680,    3.66237190690,  -0.983369342872,
   -10.9696196737,    6.65935094182,    1.03529123844,    2.34564145219,   -11.2385279478,   -17.3542721770,
    2.91476006270,    4.70811456921,    3.47335810570,    14.1327613027,    1.12394241249,   0.823733923179,
    11.2369380302,    1.26119834948,    2.75496955568,   -2.22568304570,    6.29032662774,   -11.8168960818,
   -6.28473382085,   -4.70149806626,   -6.47364612549,   -3.76698308645,   -7.81212664565,   -7.33354399261,
   0.625326118133,    2.00550909998,    1.76170682652,   -3.06686059009,   -5.77589734195,   -4.53722062451,
   0.768747418436,    1.00101216412,    1.45528844758,    2.83654536530,   -1.29945312138,    3.05266424708,
    4.09190734571,    2.25691717471,   -3.08262042966,   -4.23601380227,    1.39081975589,   -4.33829916575,
   -1.01728261213,    2.99608668066,    2.17703943527,   -7.18637400837,   -9.22655396238,   -8.49276272601,
   -8.70938048563,   -5.38655433290,   -11.4856321658,   -4.49896444709,   -6.35861885328,   -6.50728434006,
   -6.87236432478,   -2.87516480264,    1.88241502240,  -0.817545630271,   -4.77212084362,    6.35850336621,
   -4.19956382234,   -21.5884745239,   -3.89444925619,    1.42580257187,   -1.14299204712,   -3.70888639990,
   -3.19563732100,   -4.03303910361,   -6.59806078449,   -5.59596919541,   -7.15322553675,   -7.36867393869,
   -8.56595466210,   -5.44641221973,   -8.74645850396,   -6.84928104137,   -6.79811016906,   -8.15448489157,
},
{
    1.93731693654,    3.72182254444,    7.85572434880,    5.39916098902,   -7.23976744124,    3.85417816513,
    6.13080095654,    11.7034791276,   -12.0089431300,    9.42849253750,    5.42245148490,    5.64316448556,
    11.3982255953,  -0.242624434201,    14.1327613027,    3.23790008991,    11.6325047244,    12.5784802369,
 0.00817510064861,    2.60278409476,    3.05273950099,    4.82287665170,    1.14597346545,    1.57770453761,
   -12.0020462898,    94.7298696159,   -8.61710023958,    5.10529079514,    3.49249165404,    3.32405577632,
   -1.18330443691,   -14.6112811453,    4.92079954057,    5.68294330736,    1.50969080752,   0.216651853125,
    5.84810605862,    5.85134547356,    3.39335561421, -0.0859737999384,    4.83644746149,    1.02605720546,
    9.26811669461,   -12.2102995519,   -18.0786209612,   -17.7214813554,    4.27517288855,    5.30877759488,
    1.12338280046,    2.13910789756,    4.15777877683,    15.1580747943,    1.01326108039,    1.32288537996,
    13.8048763306,    2.18987516681,    1.34264207773,   -2.37331479701,   -9.90097087751,    7.59505512494,
   -2.79810435903,   -4.32478909853,   -4.29947966233,   -7.34212250355,   -8.41736996603,   -7.00279693580,
  -0.332001041841,    1.14479443151,   0.116066517666,   -3.77733627693,   -6.47950333593,   -5.70466629849,
  -0.234511347270,   0.341986528276,    1.12502630644,    4.26622830396,    1.50831284227,    2.92767457208,
    2.68655900288,   0.821853551219,   -5.35965896485,   -2.53196272433,   0.266964585737,   0.888583249480,
   -2.05191827869,  -0.233985776625,   -5.44848887444,   -1.43305365901,   -3.44409149145,   -3.45626513000,
   -8.64938121805,   -7.06730433692,   -6.28804067827,   -11.4856321658,   -7.03341058696,   -7.39504638297,
   -5.59032944961,   -2.42109281648,   0.926481665246,   -1.74931105086,    6.34108150200,   -4.70370169779,
   -2.18365247431,   -18.7096452661,    1.21387395923,   -3.35219702054,   -4.40138514720,   -5.75346587156,
   -4.36964974991,   -3.38273805882,   -4.40445015800,   -5.52024849453,   -7.81212664565,   -6.93544144105,
   -7.61785716243,   -7.35459035667,   -6.01767315498,   -7.15385672093,   -6.46198437092,   -5.73626900280,
},
{
   -8.41395982155,    2.82412258514,    6.91329582535,    4.26729074902,    4.27652301649,    4.35351409207,
    5.64432273403,   -8.29754156395,    7.21247353087,    9.29575996071,    5.25351092114,    5.36585346694,
    1.63364398023,    1.22098483369,    11.2369380302,    2.33851044078,    1.97189302591,    2.44550709798,
    11.7288926780,    2.46454329810,    3.49246198396,    5.49448637986,    10.7287014056,    10.7075152535,
   -7.46208658743,   -8.61710023958,    102.873000337,    6.25670358802,    5.11985745270,    4.90918856470,
  -0.424687356220,   -31.9189739166,   -17.8574115966,   -16.0949204373, -0.0662381676393,   -1.19535906150,
    4.93464750296,    6.53891567913,  -0.272497579815,   -1.36735936182,    3.17949645052,   0.100981600673,
    7.33859822326,    6.06537020449,   0.532469675084,    1.35133816440,    2.28500868480,    3.91173751298,
    2.07207252862,    2.69155885333,    2.52357226846,    13.8048763306,    3.59856635699,    3.10256892136,
   -5.21236288663,    4.91037153642,    2.90077588087,   0.110396186431,    9.55041595013,    7.67248056184,
   -4.39348055773,   -4.94217489682,   -3.21798506775,   -3.88179659482,   -6.47950333593,   -4.70767664646,
   0.515781867353,    1.48147473050,    2.59871803433,  -0.644118167803,   -4.33084423350,   -3.00247208670,
   0.306914586681,   0.598478445137,    2.06949985359,    4.36501661673,  0.0977904398823,   0.646018777457,
    3.18541284620,    1.81135952795,   -3.96916466957,   -2.92596621497,   -1.77820375188,  -0.402406864486,
   -3.73188144194,   -6.40891589527,   -2.88743618262,   -1.82528689767,   -3.84681126387,   -3.58332670710,
   -7.53423166744,   -5.19815138695,   -7.06730433692,   -5.38655433290,   -5.72755448944,   -13.0398138120,
    3.95300330661,   -4.06087251037, -0.0622295296345,   -1.83014139735,   -3.78301578534,   -3.78092960240,
   -3.07743593625,   -17.8224916068,   -3.79742931057,   -1.80161412778,   -2.56168688630,   -3.49132852619,
   -3.49052670024,   -3.62453739721,   -5.79854447676,   -7.13738360177,   -5.77589734195,   -8.51024383753,
   -10.0869608861,   -8.52814552557,   -9.94818435373,   -6.79002948435,   -6.78794619835,   -10.1740482357,
},
{
    1.78089271632,   -8.39291090002,    5.24659988964,    8.42273496448,    3.23350409469,    3.04775298559,
   -8.33851406616,    4.86683987463,    3.94284580098,    6.09790724766,    8.69796976280,    7.06585597865,
    2.99488054707,    3.33357224677,    4.98178812755,    12.3088134260,    1.29179650177,    3.07354155736,
    1.20036859623,    11.4762396034,    11.0614215636,    13.2970436677,    4.03107288934,    2.92665381643,
    7.02062231512,    5.10529079514,    6.25670358802,    102.739840617,   -9.37774635473,   -7.53144107416,
   -32.3095409893,  -0.425236423370,   -3.31243791773,   -1.05123128530,   -14.1007388423,   -15.1668725173,
    9.54021935880,    9.59785708953,    3.84465259820,    3.14499930424,    6.44221687032,    1.81852923469,
    5.24852905716,    3.12219281403,   -3.10406777656,   -1.78235877809,    2.28514157604,  -0.561114436965,
    3.62078617726,    5.59187838003,    15.5349777304,    5.85134547356,    3.46667425859,    3.94431849865,
    6.53891567913,   -5.29735570343,    8.91907078347,    4.44558063180,   0.992142461532,   -2.67538276240,
   -1.96636597240,   -1.59619979390,   -2.20778938257,   -7.65647231212,   -3.44409149145,   -6.83419264548,
   0.688957879569,    2.71510318704,   0.573983294049,   -3.61315415637,   -3.84681126387,   -7.88914111836,
  -0.405485447228,   0.303358116588,   0.501243283029,    2.77259210961,    2.72940983215,    1.45683591274,
    3.09071169008,    1.06590212299,   -5.17763354174,   -4.03545319173, -0.0206401687921,   -2.78206804744,
   -2.97318505675,  -0.685276785438,   -2.08846228834,   -4.09790992519,   -2.60446624975,   -5.83850222330,
   -6.10713465110,   -7.53423166744,   -8.64938121805,   -8.70938048563,   -12.4512214806,   -7.04252427141,
   -3.60435018208,    5.38238026713,   -2.40015513230,  -0.358971552026,   -3.30981984540,   -3.58084102688,
   -17.6100253304,   -2.26857129554,   -6.13678692008,   -4.67353237935,  -0.540637942149,   -2.37328471558,
   -7.29749260730,   -7.37680265761,   -2.51407232447,   -7.68846714904,   -9.22655396238,   -7.04349262793,
   -7.90607148418,   -8.50314641749,   -8.44202922569,   -8.09631305473,   -9.33786975830,   -6.75964659113,
},
{
    1.72684525309,    5.51065378265,    7.68438220043, -0.0679883047309,    2.76659868630,    2.76355973272,
    23.4873253383,    7.80962418292,    6.14401133253,    8.95675841254,    21.1906530124,  -0.201028443308,
    3.35725030544,    3.43150830196,    5.82666009926,    14.6330225498,  -0.963704921350,    3.30475352149,
   0.135824431576,    2.38818731746,    2.67799341696,    6.18971629783,    3.00380912726,    5.59392466674,
    7.31803758939,    3.49249165404,    5.11985745270,   -9.37774635473,    95.0549573511,   -10.6900502580,
   -14.7753124299,  -0.288350770806,   -3.05018339346,   -3.36354084830,    5.19487052725,    4.87083197795,
   -13.6004620130,    8.69796976280,    3.17239108681,    3.23042948793,   -12.4658563158,   -15.7714696397,
    5.57269052947,    1.67444252606,   -3.37577633747,   -2.61517726585,    6.04967090955,   -4.17525572483,
   -1.48303979002,    2.09320522335,    13.2818405765,    5.42245148490,    3.26675519699,    3.17903115692,
    5.25351092114,    13.1379198417,    12.0368225525,   -12.7359922823,  -0.453212325349,   -3.15950591385,
   -2.99515736580,   -2.76899080156,   -2.80677249714,   -5.51170646267,   -6.46198437092,   -6.57582963161,
   -3.00379402614,    1.17390695484,   0.283315126158,   -3.04768959184,   -6.78794619835,   -7.42705630041,
   -1.39758341021,    2.67602940790,    2.78643342225,    5.76091246408,    1.43073220478,    3.96775742616,
    4.22568698788,   0.219686486452,   -4.73781547117,   -3.90690736715,    4.63861937546,   -5.49689862569,
   0.963561730308,    3.57441254429,    4.24056105166,   -6.03443377457,   -9.33786975830,   -11.8893635232,
   -7.04252427141,   -13.0398138120,   -7.39504638297,   -6.50728434006,   -8.67247228685,   -7.26558298022,
   -4.23299685560,   -7.36658175599,   -4.99338303655,    8.60717933673,   -3.14490568256,   -2.93284896764,
   -19.8582350703,   -2.75213165922,   -5.29810362710,   -5.30466293646,   0.342721870139,   0.470523253304,
   -3.84237277717,   -3.79629591723,   -3.78922402605,   -6.45874811277,   -6.79811016906,   -7.47507811941,
   -7.62228100824,   -8.68936039712,   -6.52606891117,   -7.22139710446,   -10.8203866155,   -9.41793008863,
},
{
    3.81509686603,    2.43697755210,   -5.55402788282,    8.35094501318,    4.82579845901,    4.96993552301,
    11.0883737153,    15.2833215316,    13.6763017879,    16.5612410921,   -10.6900502580,    6.94511364434,
    4.96241427809,    5.08742069869,    7.18696222212,    16.5612410921,    3.32517390895,    3.53402648425,
    1.92241176595,   0.606401472974,    1.19761159601,    3.53402648425,    4.68667942184,    6.98051591347,
    7.18696222212,    3.32405577632,    4.90918856470,   -7.53144107416,   -10.6900502580,    98.7645681202,
   -13.2965885945,  -0.928902843985,   -4.44273544243,   -3.82010252008,    8.83892629996,    3.80636994282,
    11.0883737153,   -7.53144107416,   -13.2965885945,   -18.8896883403,    8.35094501318,    1.02558937862,
    5.08742069869,    1.53728882691,   -3.81440143326,   -3.41068706800,    4.96993552301,   -5.29277408478,
   0.691587687635,    1.19761159601,    13.6763017879,    3.32405577632,    1.36958351942,    1.53728882691,
    4.90918856470,    15.2833215316,   -5.55402788282,    8.38996332437,  -0.928902843985,   -3.81099339358,
   -3.78125589665,   -3.81440143326,   -4.44273544243,   -7.03436867550,   -7.03341058696,   -9.33963865749,
    1.15099202692,   0.606401472974,    2.43697755210,   -4.86937681595,   -5.72755448944,   -6.53319254708,
   0.493511139924,    1.15099202692,   0.691587687635,    3.32517390895,    2.78891110681,    4.68667942184,
    4.96241427809,    1.36958351942,   -3.78125589665,   -3.49946492897,    4.82579845901,   -5.33485524048,
   0.493511139924,    1.92241176595,    3.81509686603,   -6.40393467745,   -12.4512214806,   -9.79598600926,
   -12.4512214806,   -5.72755448944,   -7.03341058696,   -6.35861885328,   -7.53425426384,   -8.67247228685,
   -6.40393467745,   -4.86937681595,    8.38996332437,    1.02558937862,   -5.33485524048,   -5.29277408478,
   -18.8896883403,   -3.81099339358,   -7.03436867550,   -6.26867919373,    3.80636994282,   -1.38620940730,
   -3.49946492897,   -3.41068706800,   -3.82010252008,   -6.26867919373,   -6.35861885328,   -7.93679465698,
   -9.79598600926,   -6.53319254708,   -9.33963865749,   -7.93679465698,   -8.67247228685,   -10.7815827017,
},
{
  -0.610894684855,    8.66481634482,   0.839919235494,    3.60249764016,  -0.831516026082,   -1.72833866992,
   -14.7625052036,  0.0688474955951,   -1.05510526828,    1.17284223635,    3.17239108681,    1.42851903350,
   0.624602508586,  -0.523543280774,   0.313854286943,    7.54335481944,   -1.52362951526,  -0.486534657962,
   -1.92153663320,   -10.7280805275,    7.75620353226,    8.03071032466,    1.78584284172,    1.80036779883,
    1.83839328834,   -1.18330443691,  -0.424687356220,   -32.3095409893,   -14.7753124299,   -13.2965885945,
    95.5885613006,  -0.775329098765,   0.401647588297,  -0.737208484589,   -15.0432881193,   -15.3285798195,
    4.72477703040,    3.84465259820,    3.27695081497,    2.67912768460,    2.94831173152,    1.56010340800,
  -0.518408162699, -0.0713480282070,  -0.253091316952,  -0.981000615935,    2.52120643985,  -0.607028592293,
    1.65895067518,    2.82235210499,   -7.84888069700,    3.39335561421,    1.31823289283,    2.39181914006,
  -0.272497579815,    10.0730498543,    6.32770429109,    4.38149458079,   -1.61785491827,   -4.01214234100,
   -1.89452057505,   0.220846817197,  -0.721810888033,   -2.50966202192,   -2.05191827869,   0.450688627235,
   -1.13007910406,  -0.267792101053,   0.110396462681,   -2.70812576928,   -3.73188144194,   -1.23652875064,
  -0.807975698449,    1.68797633181,  -0.673633309049,   -3.83870245603,   -3.50345230039,  -0.541588753301,
   -3.15515491248,  -0.755931664233,   -1.74089982198,   -2.13442715547,   0.559476174582,   -2.68666481829,
    4.68499435657,    4.38226922329,    2.15730956894,   -2.36678986350,   -2.97318505675,  0.0872816773914,
  -0.405485447227,   0.306914586681,  -0.234511347270,   0.768747418436,   0.493511139924,   -1.39758341021,
   -2.52050917818,    4.42099749479,   -1.34997010910,    2.44549621665,   -1.32677197557,   -1.19832194615,
   -14.7303964383,   -1.65035733438,  -0.701150313907,   -1.74888357212,    2.66720371507,    2.17786885862,
   -1.45370351642,   0.752523437973,   -2.02931849394,   -4.10591299042,   -1.01728261213,  -0.655500619147,
   0.648060105356,   -1.31988516118,   -2.42287091649,   -1.79190636860,   0.963561730308,  -0.822761627120,
},
{
    7.79473120283,  0.0698359663296,    2.38836929911,  -0.329815234990,    1.05528116547,  -0.159705863318,
   0.119462679144,   -14.2515233115,    2.56894077997,    4.18954888030,  -0.453212325349,-0.00675287102232,
   -1.15408470499,   -2.26824927103,    6.29032662774,   -2.27483562655,  -0.774776264366,   -1.00719159757,
   -10.4459740465,  -0.188438998761,   0.137554300282,   0.149580620670,    8.66578251209,    9.02880381129,
   -13.1120021898,   -14.6112811453,   -31.9189739166,  -0.425236423370,  -0.288350770806,  -0.928902843985,
  -0.775329098765,    94.2552788108,   -14.8356627079,   -15.1465558918,  -0.480848137140,  -0.102612168783,
  -0.217621232298,   0.992142461532,   -1.61785491827,   -1.15480161496,  0.0824510449375,  -0.324682637397,
    1.72187882714,    2.73461452022,    2.76337481959,    2.63094122274,    2.76544260503,    3.75027773845,
 -0.0870870239659, -0.0567776177297,   0.514136212441,   -9.90097087751,    1.20692085121,    1.84284292672,
    9.55041595013,   -1.16301986843,   0.503138444413,  -0.377040242349,    5.66463862396,    7.71072711834,
   -1.38639355346,   0.208255474631,   -3.32096648140,   -3.09523932096,  -0.332001041841,   -2.49753689780,
-0.00616635518708,   0.651265875292,   0.243514488529,  -0.877376856169,   0.515781867353,   -1.50142740200,
    1.68797633181,  -0.298831675023,   0.652888814807,   -1.87628143369,   -2.42952720868,   -4.68783610204,
   -2.85326303442,  -0.230667962931,   -1.10748966817,  -0.308055041427,  -0.811815197803,  -0.822099283250,
   -1.13007910406,   0.265231994911,    2.02872233283,    2.26535029574,   0.688957879569,   -2.14215935276,
   0.303358116588,   0.598478445137,   0.341986528276,    1.00101216412,    1.15099202692,    2.67602940790,
    3.05921950333,   -1.83309503743,    1.94203511105, -0.0846387143668,   -2.03263840131,   -2.27239000576,
  -0.379801943548,   -15.2978841164,   0.982437868940,    1.83679897869,   0.277616118533,  -0.354029801964,
  -0.532432213488,    1.12185793523,   -1.83079589154,   -1.08861127329,   0.625326118133, 0.00520850413772,
   -3.02221399632,  0.0530762724269,  -0.380210961430,  0.0617025313115,   -3.00379402614,   -1.72460020986,
},
{
    8.12910672884,   0.840501237418,    2.05840148048,  -0.374619659663,  -0.288433360886,   -1.49399239261,
   -1.32629124690,   -18.5389743861,    4.01875400135,    2.73539255755,   -2.80677249714,   -2.02802672410,
   -1.67373580774,    8.86483341561,   -6.47364612549,   -3.88232908528,   -1.49196964868,   -4.21039938474,
    9.35576439192,  -0.156025669468,   -1.29586693892,  0.0380088357487,   -7.06529346522,    9.09063855211,
    4.46226543485,    4.92079954057,   -17.8574115966,   -3.31243791773,   -3.05018339346,   -4.44273544243,
   0.401647588297,   -14.8356627079,    92.7853928095,   -16.2402478326,   0.736566900475,    1.75832614461,
   -2.81004665660,   -2.20778938257,  -0.721810888033,   0.419196010992,   -1.67990502431,    1.63743331504,
   -21.4912539598,   -15.7388762514,   -11.1390670812,    7.39312816784,    2.82072520664,    5.82889224441,
   -1.04954137496,   -1.85841628415,   -3.51454627695,   -4.29947966233,   0.882177110707,   -11.3978370566,
   -3.21798506775,   -1.37163023510,   -2.19163227797,   -1.48564295720,   -3.32096648140,   -4.51946838500,
  -0.642532653427,    8.80731107037,    10.7779649759,    11.4159072685,    1.12338280046,    3.38103514287,
 -0.0870870239659,  -0.876450614864, -0.0762330275188,    1.41674265601,    2.07207252862,    4.42154249574,
  -0.673633309049,   0.652888814807,  -0.400893302745,   -7.05793411218,   -1.43426408258,   -5.73844782065,
   -5.50478634897,   -3.32897663818,    2.41906046605,    1.34710462072,   -1.20360863110,    2.35700464670,
    1.65895067518,  -0.995124191103,    1.32144544549,  -0.794133342961,    3.62078617725,    7.30349562037,
   0.501243283029,    2.06949985359,    1.12502630644,    1.45528844758,   0.691587687635,    2.78643342225,
    5.80288007867,   -1.16880599602, -0.0334858524931,   -1.39501835562,   -2.88072342083,   -2.65884432854,
   -2.04207166717,    1.47846360711,   -15.9480158432,    3.26782880655,  -0.601676628533,    1.72996653042,
    1.40874140874,  -0.966763684304,  0.0169954512305,   0.864511276649,    2.91476006270,    3.51830820868,
   -1.83170587234,    2.05301896597,    1.05158253708,   0.716863814499,   -1.48303979002, -0.0424397035294,
},
{
    7.96997978451, -0.0789435747566,    2.13971609673,  0.0509280864459,  -0.257197740859,  -0.852923983700,
   -1.74931022596,   -19.5588218250,    2.90487823575,    2.57472739991,   -3.78922402605,   -2.54663857301,
    8.11963810962,   -4.56923963793,   -6.59806078449,   -3.26077886935,   -1.95176042081,   -2.12699636533,
    12.0459018356,    2.47431235715,   0.193453132463,   -2.45376070600,    8.61627206225,   -10.8310446324,
    4.33952915306,    5.68294330736,   -16.0949204373,   -1.05123128530,   -3.36354084830,   -3.82010252008,
  -0.737208484589,   -15.1465558918,   -16.2402478326,    92.1365355516,   0.337099110791,    2.13648776433,
   -4.20846320503,   -2.51407232447,   -2.02931849394, -0.0310057129430,   -2.70739810248,    1.44529123062,
    2.98812055676,   -1.14582454271,    7.17934350437,   -12.4019770743,   -16.9543023518,   -12.6814395874,
   -1.49196964868,   -3.90795863113,   -3.40654646337,   -4.40445015800,   -10.0418795477,  -0.172708307440,
   -5.79854447676,   -6.03427973474,   -3.04232718639,    4.81301106985,   -1.83079589154,    1.83082030725,
    10.3804109113,   -2.34515277457,  0.0169954512305,    3.58769338251,    11.6325047244,    13.8527965563,
  -0.774776264366,   -2.77795348368,   -4.33004449477,    3.51366877414,    1.97189302591,    4.11048986679,
   -3.83870245603,   -1.87628143369,   -7.05793411218,   -1.53071571540,   -2.05718013166,  -0.612057989473,
   -3.64730771509,   -4.50485903284,    3.35790524138,    3.35728059368,   -3.66840017366,   0.827377726153,
   -1.52362951526,   -2.05981445593,   -5.10130764631,    6.16196222431,    1.29179650177,    5.10925342427,
    2.77259210961,    4.36501661673,    4.26622830396,    2.83654536530,    3.32517390895,    5.76091246408,
    7.29488051492,   -1.19922432959,  -0.244222984889,   -3.34650475961,   -1.56432015213,   -4.45236155393,
   -1.95883804573,    4.41797286516,    3.73619642794,   -16.1553457842,   -1.21452928814,    1.02050137931,
   0.407242738726,  -0.143948880618,    1.20436215200,    4.24731476814,    2.01415320722,    2.91896715975,
   -2.37033491174,   0.651472016818,   0.530475704477,   0.166041701236,  -0.963704921350,    2.11615664827,
},
{
  -0.195801329414,    7.73624059467,   -1.32849163946,    2.51277142788,   -1.01550367500,   0.359573676015,
   -16.3606587886,   -1.50027454550,   0.304161354887,   -3.27086927080,    5.19487052725,    1.38599815357,
  -0.873547681475,   0.241912282487,  -0.206560379201,   -3.27086927080,   -2.05718013166,    9.16556607048,
    2.61461575929,    11.0676035914,   -7.83212364819,    9.16556607048,   -1.41387342026,  -0.675358718959,
  -0.206560379201,    1.50969080752, -0.0662381676393,   -14.1007388423,    5.19487052725,    8.83892629996,
   -15.0432881193,  -0.480848137140,   0.736566900475,   0.337099110791,    89.5751633170,   -17.5987402266,
   -16.3606587886,   -14.1007388423,   -15.0432881193,    5.26249155547,    2.51277142788,   0.283448392275,
   0.241912282487,  -0.948512871545,    1.76478425866,  -0.376870686323,   0.359573676015,   -1.40296912034,
   -1.43426408258,   -7.83212364819,   0.304161354887,    1.50969080752,   -1.80231008148,  -0.948512871545,
 -0.0662381676393,   -1.50027454550,   -1.32849163946,   -4.05226447797,  -0.480848137140,   0.733919099735,
    1.31873349495,    1.76478425866,   0.736566900475,   0.586904825889,    1.50831284227,   -1.39059221097,
   -2.42952720868,    11.0676035914,    7.73624059467,    6.33445073191,  0.0977904398822,   -3.49650206722,
   -3.50345230039,   -2.42952720868,   -1.43426408258,   -2.05718013166,   -1.50120357998,   -1.41387342026,
  -0.873547681475,   -1.80231008148,    1.31873349495,  -0.675888482944,   -1.01550367500,   -2.96608171915,
   -3.50345230039,    2.61461575929,  -0.195801329414,   -1.30327712967,    2.72940983215,  -0.527049340161,
    2.72940983215,  0.0977904398823,    1.50831284227,   -1.29945312138,    2.78891110681,    1.43073220478,
   -1.30327712967,    6.33445073191,   -4.05226447797,   0.283448392275,   -2.96608171915,   -1.40296912034,
    5.26249155547,   0.733919099735,   0.586904825889,  -0.156236616844,   -17.5987402266,   0.220345800761,
  -0.675888482944,  -0.376870686323,   0.337099110791,  -0.156236616844,   -1.29945312138,   -3.12338044576,
  -0.527049340161,   -3.49650206722,   -1.39059221097,   -3.12338044576,    1.43073220478,   0.170657990262,
},
{
   0.752358397718,    7.33279444374,   -1.13547734156,   0.692207431452,   0.191498213269,   0.115820235337,
   -20.7829473955,   -2.27303616948,  -0.702321383383,   -1.68292210904,   0.342721870139,    1.85902383774,
   -1.05467036139,  -0.371207019862,   -1.14299204712,   -4.24027216807,    8.61627206225,   -2.81745826544,
    2.22376399657,    12.1289294635,    7.93840729882,   -10.3530654949,   -1.37831976503,   -1.50296632734,
   -3.10671340685,   0.216651853125,   -1.19535906150,   -15.1668725173,    4.87083197795,    3.80636994282,
   -15.3285798195,  -0.102612168783,    1.75832614461,    2.13648776433,   -17.5987402266,    92.6578117154,
    2.77691764137,  -0.540637942149,    2.66720371507,   -14.6463852485,   -17.8481897204,   -12.5737071842,
   -2.75853109518,   -2.32574635157,    2.08159759315,    4.01280807894,   -3.24361929777,    2.10113876234,
   -7.06529346522,  -0.936251126037,   -5.72021533230,   -4.40138514720,    2.13889983533,  -0.627258344381,
   -2.56168688630,   -3.93903347767,   -4.80044307096,   0.908235754809,   0.277616118533,    2.94467407897,
    2.97337347268,  -0.520669323459,  -0.601676628533,    2.89820975974,    1.14597346545,    1.31728951722,
    8.66578251209,   -5.85849699332,   -3.86961435551,   0.854745298683,    10.7287014056,    11.4442099056,
  -0.541588753301,   -4.68783610204,   -5.73844782065,  -0.612057989473,   -1.41387342026,   -1.64566691985,
   -1.73724798100,   -4.82797426774,   0.194605943195,   0.735988436246,   -3.54614834121,    2.32430877087,
    1.78584284172,   -4.53452165872,   -2.66162830552,    2.30547304932,    4.03107288934,    1.64544241710,
    1.45683591274,   0.646018777457,    2.92767457208,    3.05266424708,    4.68667942184,    3.96775742616,
   0.228970207248,    6.73360604526,   -2.57697065912,   -3.02612919136,   -1.65265185841,   -3.05199614679,
    4.02652212184,  -0.695741099095,    2.02175215248,    1.51405062145,  0.0681813707365,   -15.1998571420,
    1.19185087310,   -2.65468288836,   -1.21452928814,    2.71948844032,  -0.614509431762,    2.04681763800,
    1.27190685484,   -3.04675227459,  -0.642957914166,   -1.40380767879,    3.00380912726,    2.33797744968,
},
{
   0.859606531259,   -1.39535571638,   0.314755923607,    13.6325647973,   0.892384226942,    3.34668012401,
    2.95258478977,    6.24180265424,    7.27804666997,    5.43369561992,    23.4873253383,   -1.09564831427,
    1.86609684761,    4.08962687016,    5.93887287961,    4.11196661190,   -2.37033491174,    12.8234289622,
    1.96844187389,  -0.538823633149,    6.04429774214,    3.78761175390,    1.27190685484,    3.60711007986,
    5.27981451917,    5.84810605862,    4.93464750296,    9.54021935880,   -13.6004620130,    11.0883737153,
    4.72477703040,  -0.217621232298,   -2.81004665660,   -4.20846320503,   -16.3606587886,    2.77691764137,
    94.1372306530,   -8.33851406616,   -14.7625052036,    4.34231891950,   -12.9037604338,   -17.4134339546,
    3.61354047806,    4.18885217231,  -0.986603121024,   -6.68837691359,    4.13254115806,   -2.43434134683,
   -1.83170587234,    13.2137268024,    4.40043954301,    6.13080095654,    2.27346737812,    4.57598222658,
    5.64432273403,    3.82132646761,    1.83617274451,   -1.75773570496,   0.119462679144,   -2.59637492575,
   -4.35783988847,   -2.50206994411,   -1.32629124690,   -4.18361147861,   -7.61785716243,   -6.50929731674,
   -3.02221399632,    11.0796491579,    10.8670443194,   -14.0912440427,   -10.0869608861,   -7.88809678529,
  0.0872816773913,   -2.14215935276,    7.30349562037,    5.10925342427,  -0.527049340161,    1.64544241710,
    2.12704020822,    2.54581189924,   -2.66294670741,   -8.02880140394,    3.06745698764,   -3.52702931314,
   0.648060105356,    2.40375639965,    2.27752614391,   -3.42432463260,   -7.90607148418,   -5.10373631855,
   -5.83850222330,   -3.58332670710,   -3.45626513000,   -8.49276272601,   -9.79598600926,   -11.8893635232,
   -3.76674627657,   -4.26389011473,   -3.45130216438,    10.1470993263,   -3.57155025876,   -1.46189605730,
   0.659261570580,  -0.607862524868,   -3.35210644563,   -5.14678983453,   -20.7829473955,   -2.00135462423,
   -4.09579126929,   -2.04081972113,   -1.74931022596,   -4.91534081789,   -8.56595466210,   -7.84653437912,
   -7.61047757684,   -5.03263931039,   -5.37432696832,   -6.20630988686,   -7.62228100824,   -6.79922199279,
},
{
   -2.08846228834,   0.573983294049,    8.91907078347,    6.44221687032, -0.0206401687921,    2.28514157604,
    9.54021935880,   -5.29735570343,    15.5349777304,    12.3088134260,   -9.37774635473,    7.06585597865,
    3.09071169008,    5.24852905716,    7.02062231512,    6.09790724766,    2.77259210961,    13.2970436677,
  -0.685276785438,    2.71510318704,    5.59187838003,    3.07354155736,    1.45683591274,    2.92665381643,
    4.98178812755,    5.85134547356,    6.53891567913,    9.59785708953,    8.69796976280,   -7.53144107416,
    3.84465259820,   0.992142461532,   -2.20778938257,   -2.51407232447,   -14.1007388423,  -0.540637942149,
   -8.33851406616,    102.739840617,   -32.3095409893,   -17.6100253304,    8.42273496448,  -0.358971552026,
    3.33357224677,    3.94431849865,   -1.59619979390,   -7.37680265761,    3.04775298559,   -3.58084102688,
   0.501243283029,    11.0614215636,    3.94284580098,    5.10529079514,    1.06590212299,    3.12219281403,
    6.25670358802,    4.86683987463,    5.24659988964,   -2.40015513230,  -0.425236423370,   -2.26857129554,
   -5.17763354174,   -3.10406777656,   -3.31243791773,   -6.13678692008,   -8.64938121805,   -8.44202922569,
   0.303358116589,    11.4762396034,   -8.39291090002,    5.38238026713,   -7.53423166744,   -8.50314641749,
   -2.97318505675,   0.688957879569,    3.62078617726,    1.29179650177,    2.72940983215,    4.03107288934,
    2.99488054707,    3.46667425859,   -1.96636597240,   -7.29749260730,    3.23350409469,   -3.30981984540,
  -0.405485447228,    1.20036859623,    1.78089271632,   -3.60435018208,   -6.10713465110,   -7.90607148418,
   -2.60446624975,   -3.84681126387,   -3.44409149145,   -9.22655396238,   -12.4512214806,   -9.33786975830,
   -4.09790992519,   -3.61315415637,    4.44558063180,    1.81852923469,   -2.78206804744,  -0.561114436965,
    3.14499930424,   -2.67538276240,   -7.65647231212,   -7.68846714904,   -15.1668725173,   -2.37328471558,
   -4.03545319173,   -1.78235877809,   -1.05123128530,   -4.67353237935,   -8.70938048563,   -8.09631305473,
   -5.83850222330,   -7.88914111836,   -6.83419264548,   -7.04349262793,   -7.04252427141,   -6.75964659113,
},
{
    2.15730956894,   0.110396462681,    6.32770429109,    2.94831173152,   0.559476174582,    2.52120643985,
    4.72477703040,    10.0730498543,   -7.84888069700,    7.54335481944,   -14.7753124299,    1.42851903350,
   -3.15515491248,  -0.518408162699,    1.83839328834,    1.17284223635,   -3.83870245603,    8.03071032466,
    4.38226922329,  -0.267792101053,    2.82235210499,  -0.486534657962,  -0.541588753301,    1.80036779883,
   0.313854286943,    3.39335561421,  -0.272497579815,    3.84465259820,    3.17239108681,   -13.2965885945,
    3.27695081497,   -1.61785491827,  -0.721810888033,   -2.02931849394,   -15.0432881193,    2.66720371507,
   -14.7625052036,   -32.3095409893,    95.5885613006,   -14.7303964383,    3.60249764016,    2.44549621665,
  -0.523543280774,    2.39181914006,   0.220846817197,   0.752523437973,   -1.72833866992,   -1.19832194615,
  -0.673633309049,    7.75620353226,   -1.05510526828,   -1.18330443691,  -0.755931664233, -0.0713480282071,
  -0.424687356220,  0.0688474955951,   0.839919235494,   -1.34997010910,  -0.775329098765,   -1.65035733438,
   -1.74089982198,  -0.253091316952,   0.401647588297,  -0.701150313907,  -0.234511347270,   -2.42287091649,
    1.68797633181,   -10.7280805275,    8.66481634482,    4.42099749479,   0.306914586682,   -1.31988516118,
    4.68499435657,   -1.13007910406,    1.65895067518,   -1.52362951526,   -3.50345230039,    1.78584284172,
   0.624602508586,    1.31823289283,   -1.89452057505,   -1.45370351642,  -0.831516026082,   -1.32677197557,
  -0.807975698449,   -1.92153663320,  -0.610894684855,   -2.52050917818,  -0.405485447228,   0.648060105356,
   -2.97318505675,   -3.73188144194,   -2.05191827869,   -1.01728261213,   0.493511139924,   0.963561730308,
   -2.36678986350,   -2.70812576928,    4.38149458079,    1.56010340800,   -2.68666481829,  -0.607028592293,
    2.67912768460,   -4.01214234100,   -2.50966202192,   -4.10591299042,   -15.3285798195,    2.17786885862,
   -2.13442715547,  -0.981000615935,  -0.737208484589,   -1.74888357212,   0.768747418436,   -1.79190636860,
  0.0872816773914,   -1.23652875064,   0.450688627235,  -0.655500619147,   -1.39758341021,  -0.822761627120,
},
{
    2.86356084676,  -0.491483243017,    7.13294881956,   0.934777145256,    2.87309717622,    1.19191624916,
   0.659261570580,    8.54277559021,    9.88998691768,   -9.39177531702,   -19.8582350703,    2.31078513921,
    1.72765665257,  -0.344176823369,   -4.19956382234,   -4.40884437221,    12.0459018356,   -5.30094184162,
    3.56684831254,   0.829071607073,  -0.230362026411,  -0.850722933852,    2.22376399657,   -1.69920580331,
  -0.622281335680, -0.0859737999384,   -1.36735936182,    3.14499930424,    3.23042948793,   -18.8896883403,
    2.67912768460,   -1.15480161496,   0.419196010992, -0.0310057129430,    5.26249155547,   -14.6463852485,
    4.34231891950,   -17.6100253304,   -14.7303964383,    92.4347819176,   -15.5611255551,   -11.7602653513,
   -1.08325212653, -0.0647828994834,   -1.77000131659,    2.26290931654,   -2.67053226402,    3.47037493945,
    9.35576439192,   -4.87087529660,   -2.27640071874,   -2.18365247431,   -1.11372675128,   -1.30237338382,
   -3.07743593625,   -3.31927402712,   -1.25286666352,    2.38263262964,  -0.379801943548,    1.87872915877,
   -1.38754417573,   -2.00355051992,   -2.04207166717,    1.28248388672, 0.00817510064863,    1.87942139897,
   -10.4459740465,   -4.10554906252,   -5.02467448805,   0.592951516896,    11.7288926780,    12.9423641628,
    4.38226922329,   0.265231994911,  -0.995124191103,   -2.05981445593,    2.61461575929,   -4.53452165872,
   -3.29390863627, -0.0139864204816,  -0.771434475411,    2.89791410635,   -5.15925382175,    1.93512326132,
   -1.92153663320,   -2.98718992499,   -4.43349551400,    2.87699128121,    1.20036859623,    2.40375639965,
  -0.685276785438,   -6.40891589527,  -0.233985776625,    2.99608668066,    1.92241176595,    3.57441254429,
  -0.546162441077,   -2.15700853736,    5.17250072782,   -1.48444614454,   -1.11357560461,   -2.53679733505,
   0.960378711611,   -4.73130890527,   -1.91084817595,   -1.91776405385,    4.02652212184,   -14.8400567409,
   -1.09661117536,   -1.66259948970,   -1.95883804573,    2.22998910694,   0.261943941164,    2.37060247004,
    1.96844187389,   -1.20420235933,    1.57698579440,   0.625586580876,   0.135824431576,    1.77926900938,
},
{
  -0.548063667065,   0.723831726613,   0.795755172129,    13.1815685886,  -0.503684885921,    2.24103669192,
    13.6325647973,  -0.338532291702,    1.39551041680,    5.44273872863, -0.0679883047309,   0.514937591235,
   0.111484934528,    2.38840824158,    4.32886732400,    2.55730386708,    7.29488051492,    1.03203693157,
  -0.546162441077,    3.19550859524,    2.06849456445,    5.34531479332,   0.228970207248,    2.52173697735,
    3.66237190690,    4.83644746149,    3.17949645052,    6.44221687032,   -12.4658563158,    8.35094501318,
    2.94831173152,  0.0824510449375,   -1.67990502431,   -2.70739810248,    2.51277142788,   -17.8481897204,
   -12.9037604338,    8.42273496448,    3.60249764016,   -15.5611255551,    96.4300399384,   -35.4362488569,
    2.94636891811,    3.69530622097,   -1.37002058804,   -3.93793507938,    2.61336859710,   -3.44918321285,
    5.80288007867,    1.02899668126,    3.11372650764,    5.39916098902,  -0.838740155361,    1.99892364104,
    4.26729074902,    1.88099997551,    1.54283271895,   -2.88446862464,  -0.329815234990,   -2.12754545184,
   -3.39699380325,  -0.288593708110,  -0.374619659663,   -3.04136462819,   -5.59032944961,   -2.11136224508,
    3.05921950333,   0.466615290388,    2.03244291996,   -2.23364079297,    3.95300330661,   -13.9285718417,
   -2.36678986350,    2.26535029574,  -0.794133342961,    6.16196222431,   -1.30327712967,    2.30547304932,
    1.54681324423,    2.92211067478,   -1.99850697532,   -4.08938603508,    1.53038477142,   -4.37094940786,
   -2.52050917818,    2.87699128121,    1.74181938409,   -3.95123677566,   -3.60435018208,   -3.42432463260,
   -4.09790992519,   -1.82528689767,   -1.43305365901,   -7.18637400837,   -6.40393467745,   -6.03443377457,
   -3.12036899949,   -3.64547457306,   -2.54840826787,    8.87802925086,   -3.31540906326,  -0.299951186682,
   0.934777145256,  -0.222808488642,   -2.90899564007,   -4.34479292116,   0.692207431452,   -21.4030642441,
   -4.48756391546,-0.00969180416605,  0.0509280864458,   -4.11294492957,   -6.87236432478,   -3.20809872200,
   -3.76674627657,   -3.52437410739,   -3.16798642674,   -4.27079623153,   -4.23299685560,   -3.80182453265,
},
{
    1.95882504879,    1.68554765668,    1.25294322978,    8.87802925086,    1.30130103982,   0.247177449112,
    10.1470993263,    1.16047660536,    1.88772939286,   -1.43661669760,    8.60717933673,   -29.6934146419,
   0.663691969363,   0.171732966065,  -0.817545630271,   -2.90571696531,    7.96997978451,   -3.25072542614,
    2.86356084676,    1.62075751509,    1.39656074305,   -1.41314885590,   0.752358397718,   -1.00718051189,
  -0.983369342872,    1.02605720546,   0.100981600673,    1.81852923469,   -15.7714696397,    1.02558937862,
    1.56010340800,  -0.324682637397,    1.63743331504,    1.44529123062,   0.283448392274,   -12.5737071842,
   -17.4134339546,  -0.358971552026,    2.44549621665,   -11.7602653513,   -35.4362488569,    101.702796460,
   -2.05132354587,   0.317009408644,   -1.21391220419,    3.58974770676,   -4.19712666694,    3.01521299803,
    8.12910672884,   -4.14858224039,   -4.09070881500,   -1.74931105086,    1.08285467559,   0.121673303444,
   -1.83014139735,   -3.96687513396,   -5.36799149000,    3.47959864133, -0.0846387143668,    2.16993674850,
  -0.208344798672,   -1.38665779695,   -1.39501835562,    2.01281383095,    1.93731693654,    1.39654183047,
    7.79473120283,   -6.05454160848,   -6.65812491595,    2.04238410188,   -8.41395982155,    12.5879849047,
    2.15730956894,    2.02872233283,    1.32144544549,   -5.10130764631,  -0.195801329414,   -2.66162830552,
   -1.90101638341,  0.0967280348665,   -1.55906670230,    2.43658406577,   -4.77986206737,    2.28539648409,
  -0.610894684855,   -4.43349551400,   -4.26269341359,    1.74181938409,    1.78089271632,    2.27752614391,
   -2.08846228834,   -2.88743618262,   -5.44848887444,    2.17703943527,    3.81509686603,    4.24056105166,
  -0.548063667065,   -2.05424388182,   -2.90550450174,    5.44933609520,   -1.07761585802,   -2.34887107486,
   -1.48444614454,   -2.13068687021,   0.835336974273,    1.01893534483,   -3.02612919136,   -13.8647322686,
   -1.16278277850,   -3.80493410954,   -3.34650475961,    1.70972351290,    2.22704751677,    1.61928012390,
   0.859606531259,   0.590633792225,    1.26843494328,   0.788072126217,    1.72684525309,    1.90846053913,
},
{
   -1.16278277850,   0.405950073013,    4.75341046185,    2.38840824158,   -1.87300467473,    7.92839152050,
    4.08962687016,    6.66691905449,    8.51096261755,   -12.2432643529,    3.43150830196,    3.95757418947,
   -2.62487054875,    3.45654007290,    11.4112320403,    11.9233162716,   0.407242738726,   0.783079248832,
   -1.09661117536,   0.580982753522,    1.92792536871,    5.69324816715,    1.19185087310,    2.77936969810,
   -10.9696196737,    9.26811669461,    7.33859822326,    5.24852905716,    5.57269052947,    5.08742069869,
  -0.518408162699,    1.72187882714,   -21.4912539598,    2.98812055676,   0.241912282487,   -2.75853109518,
    3.61354047806,    3.33357224677,  -0.523543280774,   -1.08325212653,    2.94636891811,   -2.05132354587,
    92.9081609273,   -12.0586768221,   -18.8945373099,    5.54952664487,   -10.6187303080,   -18.3575303507,
    1.40874140874,    3.70110750688,   0.677327563698,  -0.242624434201,   -2.07282329380,    10.0677163024,
    1.22098483369,    1.51214093103,    2.85356476469,   -1.92029423174,   -2.26824927103,  -0.979733462898,
   -4.22320070153,    7.58738509851,    8.86483341561,   -10.5458301759,   -4.36964974991,   -5.41431685967,
  -0.532432213488,    2.16723095516,    1.71359022390,   -2.07073322809,   -3.49052670024,   -4.19782340310,
   -2.13442715547,  -0.308055041427,    1.34710462072,    3.35728059368,  -0.675888482944,   0.735988436246,
    5.95579816464,    3.60317294936,   -5.64241517623,   -3.59775002064,    3.90350490143,   -6.24502277907,
   -1.45370351642,    2.89791410635,    2.43658406577,   -4.08938603508,   -7.29749260730,   -8.02880140394,
   -4.03545319173,   -2.92596621497,   -2.53196272433,   -4.23601380227,   -3.49946492897,   -3.90690736715,
   -4.48756391546,   -2.30497741046,    2.55767805912,   0.171732966065,   -4.31705493911,    5.99953633686,
  -0.344176823369,    1.78263563452,   -21.0330481220,    1.73375230332,  -0.371207019862,   -3.45806031990,
   -1.17578717837,   -5.42499548254,   -4.56923963793,   -5.67174203167,   -3.19563732100,   -4.70358055171,
   -4.09579126929,   -3.08366691349,   -3.12264250823,   -5.08978296436,   -3.84237277717,   -4.80906526575,
},
{
  -0.208344798672,   0.827827410776,    4.62640633331,    1.99892364104,    6.70357901341,  -0.330263365747,
    4.57598222658,    6.95343835880,   -11.2505893766,    7.91720330292,    3.17903115692,    3.37243472607,
   -9.04793938552,    10.0677163024,   0.823733923179,    1.07416732004,    10.3804109113,    9.16691233076,
   -1.38754417573,  -0.295170575584,    2.25917246856,    4.67724015175,    2.97337347268,   0.888231594353,
    6.65935094182,   -12.2102995519,    6.06537020449,    3.12219281403,    1.67444252606,    1.53728882691,
 -0.0713480282071,    2.73461452022,   -15.7388762514,   -1.14582454271,  -0.948512871545,   -2.32574635157,
    4.18885217231,    3.94431849865,    2.39181914006, -0.0647828994834,    3.69530622097,   0.317009408644,
   -12.0586768221,    97.5106165352,   -34.1516756924,   -19.3172377973,    3.72198225871,    3.18700577505,
  -0.642532653427,    1.41439353302,    1.06752938523,    1.32288537996,    1.18069247113,    6.93429729132,
    3.10256892136,    3.37896290047,    1.23620042522,   -1.79665727600,    1.84284292672,   -2.18819474404,
  -0.586681818738,    7.45957428690,   -11.3978370566,    4.48066186429,   -2.79810435903,   -3.07052267766,
   -1.38639355346,    1.04860798325,   0.301302209952,   -2.98199746189,   -4.39348055773,   -5.04394247808,
   -1.74089982198,   -1.10748966817,    2.41906046605,    3.35790524138,    1.31873349495,   0.194605943195,
    2.14946668185,    1.33472273249,   -3.22786966042,   -5.64241517623,   0.719583277667,    3.33342800563,
   -1.89452057505,  -0.771434475411,   -1.55906670230,   -1.99850697532,   -1.96636597240,   -2.66294670741,
   -5.17763354174,   -3.96916466957,   -5.35965896485,   -3.08262042966,   -3.78125589665,   -4.73781547117,
   -3.39699380325,   -3.11650166621,    2.74121610464,   0.121673303444,    3.37785124710,   -2.20848872348,
   -1.30237338382,    1.65480029254,   -18.0169750810,  -0.768481463569,  -0.627258344381,   -2.70772471001,
   -4.22320070153,   -2.54666298514,  -0.172708307440,   -3.96373655670,   -6.28473382085,   -6.02998849958,
   -4.35783988847,   -3.21707086342,   -4.11852072757,   -1.78446843887,   -2.99515736580,   -3.35179369511,
},
{
    1.08285467559,    1.55270079570,    3.11848761998,  -0.288593708110,    6.85809515971,   -1.77477694233,
   -2.50206994411,    1.20670176701,   -16.9846587415,    2.48195738147,   -2.76899080156,   -2.02151439206,
    9.13690958564,    7.58738509851,   -4.70149806626,   -3.82849120087,   -10.0418795477,    5.60836397767,
   -1.11372675128,  -0.201661053047,   -2.64461858054,  -0.624657997254,    2.13889983533,  -0.726464919442,
    1.03529123844,   -18.0786209612,   0.532469675084,   -3.10406777656,   -3.37577633747,   -3.81440143326,
  -0.253091316952,    2.76337481959,   -11.1390670812,    7.17934350437,    1.76478425866,    2.08159759315,
  -0.986603121024,   -1.59619979390,   0.220846817197,   -1.77000131659,   -1.37002058804,   -1.21391220419,
   -18.8945373099,   -34.1516756924,    97.9279254243,   -11.3999775314,    4.70409238607,    4.66367182442,
   0.882177110707,   -2.78247617573,   -2.68209384482,   -4.32478909853,   -1.41292452560,    7.45957428690,
   -4.94217489682,   -4.27782577163,   -2.67167545957,   0.909198892731,   0.208255474631,   0.292564966958,
    1.18069247113,   -11.5051519493,    8.80731107037,    8.64381642659,    1.01326108039,  0.0849587942870,
    1.20692085121,   -2.48488946318,   -2.29004601420,   0.831206512909,    3.59856635699,    2.73971784574,
  -0.755931664233,  -0.230667962931,   -3.32897663818,   -4.50485903284,   -1.80231008148,   -4.82797426774,
   -8.65304489492,   -3.16965487642,    1.33472273249,    3.60317294936,    2.62950027646,   -1.03526516990,
    1.31823289283, -0.0139864204816,  0.0967280348665,    2.92211067478,    3.46667425859,    2.54581189924,
    1.06590212299,    1.81135952795,   0.821853551219,    2.25691717471,    1.36958351942,   0.219686486452,
  -0.838740155361, -0.0946103506733,   0.448765444898,   -1.38665779695,    5.75150332245,   -3.29214336856,
   -2.00355051992,   0.279843608035,   -12.7497104077,    4.85576722241,  -0.520669323459,   0.657839132651,
   -2.07282329380,   -1.13586621270,   -2.34515277457,   0.493403977793,    1.12394241249,  -0.580323425396,
    2.27346737812,    2.71151189023,    1.61158816726,    3.62606894482,    3.26675519699,    2.02183256873,
},
{
   0.663691969363,    1.06176307263,    3.20833846878,-0.00969180416605,    7.51502639263,   -1.78976586390,
   -2.04081972113,    1.18570542996,   -18.3629095634,    1.55758494558,   -3.79629591723,   -3.35031062359,
    18.2660662821,   -5.42499548254,   -4.03303910361,   -3.78271517431,    8.11963810962,   -10.9041161162,
    1.72765665257,    1.60500993770,  -0.901028953118,   -3.18226111466,   -1.05467036139,   -1.28902728442,
    2.34564145219,   -17.7214813554,    1.35133816440,   -1.78235877809,   -2.61517726585,   -3.41068706800,
  -0.981000615935,    2.63094122274,    7.39312816784,   -12.4019770743,  -0.376870686323,    4.01280807894,
   -6.68837691359,   -7.37680265761,   0.752523437973,    2.26290931654,   -3.93793507938,    3.58974770676,
    5.54952664487,   -19.3172377973,   -11.3999775314,    96.2328823514,   -18.0301307705,   -10.8751916175,
   -1.67373580774,   -2.74395919415,   -3.83821499890,   -3.38273805882,    9.13690958564,   -2.54666298514,
   -3.62453739721,   -3.06099501395,   -1.88530104907,    2.11540301866,    1.12185793523,   0.897125204738,
   -9.04793938552,   -1.13586621270,  -0.966763684304,  -0.158319857919,    11.3982255953,    10.3977310850,
   -1.15408470499,   -2.98679387144,   -1.71528642262,    2.00594589649,    1.63364398023,   0.660741621798,
   -3.15515491248,   -2.85326303442,   -5.50478634897,   -3.64730771509,  -0.873547681475,   -1.73724798100,
   -2.69413426189,   -8.65304489492,    2.14946668185,    5.95579816464,   -6.22632330604,    3.81386715783,
   0.624602508586,   -3.29390863627,   -1.90101638341,    1.54681324423,    2.99488054707,    2.12704020822,
    3.09071169008,    3.18541284620,    2.68655900288,    4.09190734571,    4.96241427809,    4.22568698788,
   0.111484934528,   0.248275334921,   0.842927830720,   -3.80493410954,    6.43466143584,   -4.42205372104,
   -1.66259948970,    2.37222909638,    7.54195229339,   -14.7745897265,   -2.65468288836,    1.65867317606,
   -2.62487054875,   -1.03267698428,  -0.143948880618,    2.84939790460,  -0.175364901065,  -0.497817484562,
    1.86609684761,    2.34670913657,    1.97210592684,    3.01638553195,    3.35725030544,    2.61850268380,
},
{
   -1.07761585802, -0.0823657666344,    3.72152299620,    2.24103669192,   -1.29869010121,    8.01997590090,
    3.34668012401,    4.96574729528,    7.19934538749,   -11.6729786631,    2.76355973272,    3.97585019365,
    6.43466143584,    7.92839152050,   -7.09732086170,    13.3534507787,   -1.56432015213,    3.03302590491,
   -1.11357560461,    1.55050062551,    4.62879146440,    1.73634316499,   -1.65265185841,    3.04187382428,
   -11.2385279478,    4.27517288855,    2.28500868480,    2.28514157604,    6.04967090955,    4.96993552301,
    2.52120643985,    2.76544260503,    2.82072520664,   -16.9543023518,   0.359573676015,   -3.24361929777,
    4.13254115806,    3.04775298559,   -1.72833866992,   -2.67053226402,    2.61336859710,   -4.19712666694,
   -10.6187303080,    3.72198225871,    4.70409238607,   -18.0301307705,    98.0986307305,   -36.2386704698,
   -2.88072342083,    1.10735995817,    2.96750226889,    3.85417816513,    5.75150332245,  -0.330263365747,
    4.35351409207,    3.36886108025,    1.89214896281,   -4.56409239301,  -0.159705863318,  -0.973849166874,
    3.37785124710,   -1.77477694233,   -1.49399239261,   -2.99859433160,    6.34108150200,   -13.1943048089,
   -2.03263840131,    1.12297208977,    3.51750054562,   -2.85350911338,   -3.78301578534,   -1.97808516555,
   -2.68666481829,  -0.822099283250,    2.35700464670,   0.827377726153,   -2.96608171915,    2.32430877087,
    3.81386715783,   -1.03526516990,    3.33342800563,   -6.24502277907,    1.77456287105,   -5.22527665799,
   -1.32677197557,    1.93512326132,    2.28539648409,   -4.37094940786,   -3.30981984540,   -3.52702931314,
   -2.78206804744,  -0.402406864486,   0.888583249480,   -4.33829916575,   -5.33485524048,   -5.49689862569,
   -3.31540906326,   -2.56428697012,    2.16874029149,   0.247177449112,   -4.73421493710,    6.12522600352,
    1.19191624916,    1.88972013476,   0.702694944772,   -18.1647344400,   0.115820235337,   -4.74087329353,
   -4.31705493911,   -1.78976586390,  -0.852923983700,   -6.13796778300,   -4.77212084362,   -2.90566379430,
   -3.57155025876,   -2.90479889313,   -1.63606896922,   -3.99370888359,   -3.14490568256,   -3.31381710689,
},
{
    1.30130103982,   0.613440673968,    2.87816600487,  -0.299951186682,   0.339061376455,    6.12522600352,
   -1.46189605730,    1.30519160208,    2.52869602862,   -16.7634577374,   -2.93284896764,   -2.00425841399,
    7.51502639263,    5.99953633686,    6.35850336621,   -11.9243045226,  -0.257197740859,   -1.48524032158,
    2.87309717622,   0.429846443576,   0.618454666887,   -2.77501741267,   0.191498213268,   -1.74755203283,
   -17.3542721770,    5.30877759488,    3.91173751298,  -0.561114436965,   -4.17525572483,   -5.29277408478,
  -0.607028592293,    3.75027773845,    5.82889224441,   -12.6814395874,   -1.40296912034,    2.10113876234,
   -2.43434134683,   -3.58084102688,   -1.19832194615,    3.47037493945,   -3.44918321285,    3.01521299803,
   -18.3575303507,    3.18700577505,    4.66367182442,   -10.8751916175,   -36.2386704698,    98.2195915061,
  -0.288433360886,   -4.73280164616,   -1.61502794398,   -4.70370169779,    6.85809515971,   -2.20848872348,
   -3.78092960240,  -0.537906001096,   -2.36940709009,    3.27367538387,   -2.27239000576,    1.65442854956,
    6.70357901341,   -3.29214336856,   -2.65884432854,    1.96270324942,   -7.23976744124,    11.9416522898,
    1.05528116547,   -2.55234384466,   -4.22796727586,    1.32988350128,    4.27652301649,    2.06125308493,
   0.559476174582,  -0.811815197803,   -1.20360863110,   -3.66840017366,   -1.01550367500,   -3.54614834121,
   -6.22632330604,    2.62950027646,   0.719583277667,    3.90350490143,   -5.34623743353,    1.77456287105,
  -0.831516026082,   -5.15925382175,   -4.77986206737,    1.53038477142,    3.23350409469,    3.06745698764,
 -0.0206401687921,   -1.77820375188,   0.266964585737,    1.39081975589,    4.82579845901,    4.63861937546,
  -0.503684885921,  -0.818593816318,   0.516993015810,   -2.34887107486,   -1.29869010121,    2.94669958734,
   -2.53679733505,    1.63938994047,    4.48072367247,   -12.6457044171,   -3.05199614679,    1.70988267819,
   -1.87300467473,   -4.42205372104,   -4.45236155393,   0.124039501753,    3.95791893946,    1.77152941632,
   0.892384226942,   0.934294689249,    2.93182498382,    1.17416486145,    2.76659868630,    2.64266037378,
},
{
    1.63743331504,   -1.48564295720,    1.41674265601,  -0.794133342961,    5.82889224441,    2.35700464670,
    7.30349562037,    4.42154249574,    3.38103514287,    3.51830820868,    2.78643342225, -0.0424397035294,
    7.39312816784,    1.34710462072,    1.45528844758,   0.716863814499,   -16.2402478326,    3.26782880655,
   0.419196010992,   -4.51946838500,    11.4159072685,   0.864511276649,    1.75832614461,    1.72996653042,
    2.91476006270,    1.12338280046,    2.07207252862,    3.62078617726,   -1.48303979002,   0.691587687635,
    1.65895067518, -0.0870870239659,   -1.04954137496,   -1.49196964868,   -1.43426408258,   -7.06529346522,
   -1.83170587234,   0.501243283029,  -0.673633309049,    9.35576439192,    5.80288007867,    8.12910672884,
    1.40874140874,  -0.642532653427,   0.882177110707,   -1.67373580774,   -2.88072342083,  -0.288433360886,
    92.7853928095,   -15.9480158432,    1.05158253708,    1.12502630644,   -11.1390670812,    2.41906046605,
    2.06949985359,    2.05301896597,   -1.16880599602,   0.840501237418,   0.652888814807,  -0.156025669468,
   -15.7388762514,   -3.32897663818,  -0.400893302745,   -1.29586693892,    4.92079954057,    4.01875400135,
   -14.8356627079,    1.47846360711, -0.0334858524931,    2.05840148048,   -17.8574115966,   -18.5389743861,
  -0.721810888033,   -3.32096648140,    10.7779649759,  0.0169954512305,   0.736566900475,  -0.601676628533,
  -0.966763684304,    8.80731107037,   -11.3978370566,    8.86483341561,   -2.65884432854,   -1.49399239261,
   0.401647588297,   -2.04207166717,   -1.39501835562,  -0.374619659663,   -3.31243791773,   -1.32629124690,
   -2.20778938257,   -3.21798506775,   -4.29947966233,   -6.47364612549,   -4.44273544243,   -2.80677249714,
   -1.67990502431,   -2.19163227797, -0.0762330275188,    1.32144544549,    2.82072520664,   -1.20360863110,
  -0.995124191103,  -0.876450614864,   -1.85841628415,   -4.21039938474,   -5.73844782065,    9.09063855211,
   -21.4912539598,   -5.50478634897,   -7.05793411218,  0.0380088357487,    4.46226543485,    2.73539255755,
   -2.81004665660,   -1.37163023510,   -3.51454627695,   -3.88232908528,   -3.05018339346,   -2.02802672410,
},
{
   0.835336974273,   -2.35072651678,  -0.940801877032,    2.06849456445,    4.48072367247,    4.62879146440,
    6.04429774214,    4.61452225228,    4.05940570669,    8.26954420328,    2.67799341696,    4.15892129831,
    7.54195229339,    1.92792536871,    2.87287451220,    3.00527857918,    3.73619642794,   -14.3750955712,
   -1.91084817595,   -3.19998558894,    11.0067261524,    2.99133463145,    2.02175215248,    3.44568326186,
    4.70811456921,    2.13910789756,    2.69155885333,    5.59187838003,    2.09320522335,    1.19761159601,
    2.82235210499, -0.0567776177297,   -1.85841628415,   -3.90795863113,   -7.83212364819,  -0.936251126037,
    13.2137268024,    11.0614215636,    7.75620353226,   -4.87087529660,    1.02899668126,   -4.14858224039,
    3.70110750688,    1.41439353302,   -2.78247617573,   -2.74395919415,    1.10735995817,   -4.73280164616,
   -15.9480158432,    92.7490309898,    3.61855263797,    3.05273950099,   -12.7497104077,    2.25917246856,
    3.49246198396,    4.07022363329,    2.93931202527,   -2.15868159775,   0.137554300282,   -1.53452144760,
   -18.0169750810,   -2.64461858054,   -1.29586693892,   -2.50996423442,    1.21387395923,    5.02034622785,
   0.982437868940,   -15.7905603561,   -12.3582958452,   -18.0874436684,   -3.79742931057,   0.846182241218,
   -2.50966202192,   -3.09523932096,    11.4159072685,    3.58769338251,   0.586904825889,    2.89820975974,
  -0.158319857919,    8.64381642659,    4.48066186429,   -10.5458301759,    1.96270324942,   -2.99859433160,
  -0.701150313907,    1.28248388672,    2.01281383095,   -3.04136462819,   -6.13678692008,   -4.18361147861,
   -7.65647231212,   -3.88179659482,   -7.34212250355,   -3.76698308645,   -7.03436867550,   -5.51170646267,
   -2.90899564007,   -2.75719522516,    1.81968452702,    1.39656074305,   0.702694944772,   0.618454666887,
  -0.230362026411,   -1.46089485254,   -2.73796049663,   -6.71315349486,    7.93840729882,   -5.25391663395,
   -21.0330481220,  -0.901028953118,   0.193453132463,   -5.14903647973,   -3.89444925619, -0.0438466036696,
   -3.35210644563,   -2.10738078932,   -6.23340209851,   -4.43922102010,   -5.29810362710,   -4.21925717124,
},
{
    1.26843494328,   -5.88796619628,  0.0209809415685,    1.39551041680,    2.93182498382,    7.19934538749,
    7.27804666997,    5.64722424249,    7.36241256775,    6.85570362359,    6.14401133253,    5.80496011766,
    1.97210592684,    8.51096261755,    6.80378366108,   -12.6839240768,   0.530475704478,    2.26907424018,
    1.57698579440,   -1.37410684853,    4.05940570669,    14.8468941777,  -0.642957914166,    2.72936358630,
    3.47335810570,    4.15777877683,    2.52357226846,    15.5349777304,    13.2818405765,    13.6763017879,
   -7.84888069700,   0.514136212441,   -3.51454627695,   -3.40654646337,   0.304161354887,   -5.72021533230,
    4.40043954301,    3.94284580098,   -1.05510526828,   -2.27640071874,    3.11372650763,   -4.09070881500,
   0.677327563698,    1.06752938523,   -2.68209384482,   -3.83821499890,    2.96750226889,   -1.61502794398,
    1.05158253708,    3.61855263797,    96.4518701114,   -12.0089431300,    1.61158816726,   -11.2505893766,
    7.21247353087,   -11.4937924601,   -10.4179101369,   -17.3220171221,    2.56894077997,    3.79095739238,
   -4.11852072757,   -16.9846587415,    4.01875400135,    5.02034622785,   -6.01767315498,   -3.20219830206,
  -0.380210961430,    2.17686565290,    2.46532995184,   -3.63980243567,   -9.94818435373,   -6.72390343177,
   0.450688627235,   -2.49753689780,    3.38103514287,    13.8527965563,   -1.39059221097,    1.31728951722,
    10.3977310850,  0.0849587942869,   -3.07052267766,   -5.41431685967,    11.9416522898,   -13.1943048089,
   -2.42287091649,    1.87942139897,    1.39654183047,   -2.11136224508,   -8.44202922569,   -6.50929731674,
   -6.83419264548,   -4.70767664646,   -7.00279693580,   -7.33354399261,   -9.33963865749,   -6.57582963161,
   -3.16798642674,   -2.09613711355,   0.545331558958,    1.88772939286,   -1.63606896922,    2.52869602862,
    9.88998691768,   -2.30163312917,   -6.23340209851,   -3.86241095315,  -0.702321383383,   -6.49664214697,
   -3.12264250823,   -18.3629095634,    2.90487823575,  -0.479123945235,   -8.74645850396,   -9.62141229527,
   -5.37432696832,   -4.05435495795,   -6.61848412260,   -6.19424392149,   -6.52606891117,   -4.70076357543,
},
{
   -5.44848887444,   0.116066517666,    1.34264207773,    4.83644746149,   0.266964585737,    4.27517288855,
    5.84810605862,    2.18987516681,    4.15777877683,    3.23790008991,    3.49249165404,    5.64316448556,
    2.68655900288,    9.26811669461,   -12.0020462898,    9.42849253750,    4.26622830396,    4.82287665170,
  -0.233985776625,    1.14479443151,    2.13910789756,    12.5784802369,    2.92767457208,    1.57770453761,
    14.1327613027,    15.1580747943,    13.8048763306,    5.85134547356,    5.42245148490,    3.32405577632,
    3.39335561421,   -9.90097087751,   -4.29947966233,   -4.40445015800,    1.50969080752,   -4.40138514720,
    6.13080095654,    5.10529079514,   -1.18330443691,   -2.18365247431,    5.39916098902,   -1.74931105086,
  -0.242624434201,    1.32288537996,   -4.32478909853,   -3.38273805882,    3.85417816513,   -4.70370169779,
    1.12502630644,    3.05273950099,   -12.0089431300,    94.7298696159,   0.821853551219,   -12.2102995519,
   -8.61710023958,    11.7034791276,    7.85572434880,   0.926481665246,   -14.6112811453,   -18.7096452661,
   -5.35965896485,   -18.0786209612,    4.92079954057,    1.21387395923,   -6.28804067827,   -6.01767315498,
   0.341986528276,    2.60278409476,    3.72182254444,   -2.42109281648,   -7.06730433692,   -7.35459035667,
   -2.05191827869,  -0.332001041841,    1.12338280046,    11.6325047244,    1.50831284227,    1.14597346545,
    11.3982255953,    1.01326108039,   -2.79810435903,   -4.36964974991,   -7.23976744124,    6.34108150200,
  -0.234511347270, 0.00817510064861,    1.93731693654,   -5.59032944961,   -8.64938121805,   -7.61785716243,
   -3.44409149145,   -6.47950333593,   -8.41736996603,   -7.81212664565,   -7.03341058696,   -6.46198437092,
   -1.43305365901,   -3.77733627693,   -2.37331479701,    1.02605720546,   0.888583249480,    5.30877759488,
 -0.0859737999384,    7.59505512494,   -7.34212250355,   -5.52024849453,   0.216651853125,   -5.75346587156,
   -2.53196272433,   -17.7214813554,    5.68294330736,   -3.35219702054,   -11.4856321658,   -7.15385672093,
   -3.45626513000,   -5.70466629849,   -7.00279693580,   -6.93544144105,   -7.39504638297,   -5.73626900280,
},
{
   -1.21391220419,   0.909198892731,   0.831206512909,    2.92211067478,    4.66367182442,   -1.03526516990,
    2.54581189924,    2.73971784574,  0.0849587942870,  -0.580323425396,   0.219686486452,    2.02183256873,
   -11.3999775314,    3.60317294936,    2.25691717471,    3.62606894482,    7.17934350437,    4.85576722241,
   -1.77000131659,   0.292564966958,    8.64381642659,   0.493403977793,    2.08159759315,   0.657839132651,
    1.12394241249,    1.01326108039,    3.59856635699,    3.46667425859,    3.26675519699,    1.36958351942,
    1.31823289283,    1.20692085121,   0.882177110707,   -10.0418795477,   -1.80231008148,    2.13889983533,
    2.27346737812,    1.06590212299,  -0.755931664233,   -1.11372675128,  -0.838740155361,    1.08285467559,
   -2.07282329380,    1.18069247113,   -1.41292452560,    9.13690958564,    5.75150332245,    6.85809515971,
   -11.1390670812,   -12.7497104077,    1.61158816726,   0.821853551219,    97.9279254243,    1.33472273249,
    1.81135952795,    2.71151189023, -0.0946103506732,    1.55270079570,  -0.230667962931,  -0.201661053047,
   -34.1516756924,   -3.16965487642,   -3.32897663818,   -2.64461858054,   -18.0786209612,   -16.9846587415,
    2.76337481959,   0.279843608035,   0.448765444898,    3.11848761998,   0.532469675084,    1.20670176701,
   0.220846817197,   0.208255474631,    8.80731107037,   -2.34515277457,    1.76478425866,  -0.520669323459,
   -1.13586621270,   -11.5051519493,    7.45957428690,    7.58738509851,   -3.29214336856,   -1.77477694233,
  -0.253091316952,   -2.00355051992,   -1.38665779695,  -0.288593708110,   -3.10406777656,   -2.50206994411,
   -1.59619979390,   -4.94217489682,   -4.32478909853,   -4.70149806626,   -3.81440143326,   -2.76899080156,
   -1.37002058804,   -2.67167545957,   -2.29004601420,  0.0967280348665,    4.70409238607,    2.62950027646,
 -0.0139864204816,   -2.48488946318,   -2.78247617573,    5.60836397767,   -4.82797426774,  -0.726464919442,
   -18.8945373099,   -8.65304489492,   -4.50485903284,  -0.624657997254,    1.03529123844,    2.48195738147,
  -0.986603121024,   -4.27782577163,   -2.68209384482,   -3.82849120087,   -3.37577633747,   -2.02151439206,
},
{
   -1.55906670230,   0.301302209952,    1.23620042522,    3.69530622097,   0.719583277667,    3.72198225871,
    4.18885217231,    3.37896290047,    1.06752938523,    1.07416732004,    1.67444252606,    3.37243472607,
    2.14946668185,   -12.0586768221,    6.65935094182,    7.91720330292,    3.35790524138,    4.67724015175,
  -0.771434475411,    1.04860798325,    1.41439353302,    9.16691233076,   0.194605943195,   0.888231594353,
   0.823733923179,    1.32288537996,    3.10256892136,    3.94431849865,    3.17903115692,    1.53728882691,
    2.39181914006,    1.84284292672,   -11.3978370566,  -0.172708307440,  -0.948512871545,  -0.627258344381,
    4.57598222658,    3.12219281403, -0.0713480282071,   -1.30237338382,    1.99892364104,   0.121673303444,
    10.0677163024,    6.93429729132,    7.45957428690,   -2.54666298514,  -0.330263365747,   -2.20848872348,
    2.41906046605,    2.25917246856,   -11.2505893766,   -12.2102995519,    1.33472273249,    97.5106165352,
    6.06537020449,    6.95343835880,    4.62640633331,    2.74121610464,    2.73461452022,    1.65480029254,
   -3.22786966042,   -34.1516756924,   -15.7388762514,   -18.0169750810,   -5.35965896485,   -4.11852072757,
   -1.10748966817,  -0.295170575584,   0.827827410776,   -3.11650166621,   -3.96916466957,   -3.21707086342,
   -1.89452057505,   -1.38639355346,  -0.642532653427,    10.3804109113,    1.31873349495,    2.97337347268,
   -9.04793938552,    1.18069247113,  -0.586681818738,   -4.22320070153,    6.70357901341,    3.37785124710,
   -1.74089982198,   -1.38754417573,  -0.208344798672,   -3.39699380325,   -5.17763354174,   -4.35783988847,
   -1.96636597240,   -4.39348055773,   -2.79810435903,   -6.28473382085,   -3.78125589665,   -2.99515736580,
   -1.99850697532,   -2.98199746189,   -1.79665727600,   0.317009408644,    3.33342800563,    3.18700577505,
 -0.0647828994834,   -2.18819474404,    4.48066186429,   -3.96373655670,   -2.32574635157,   -2.70772471001,
   -5.64241517623,   -19.3172377973,   -1.14582454271,  -0.768481463569,   -3.08262042966,   -1.78446843887,
   -2.66294670741,   -5.04394247808,   -3.07052267766,   -6.02998849958,   -4.73781547117,   -3.35179369511,
},
{
   -2.88743618262,    2.59871803433,    2.90077588087,    3.17949645052,   -1.77820375188,    2.28500868480,
    4.93464750296,    4.91037153642,    2.52357226846,    2.33851044078,    5.11985745270,    5.36585346694,
    3.18541284620,    7.33859822326,   -7.46208658743,    9.29575996071,    4.36501661673,    5.49448637986,
   -6.40891589527,    1.48147473050,    2.69155885333,    2.44550709798,   0.646018777457,    10.7075152535,
    11.2369380302,    13.8048763306,   -5.21236288663,    6.53891567913,    5.25351092114,    4.90918856470,
  -0.272497579815,    9.55041595013,   -3.21798506775,   -5.79854447676, -0.0662381676393,   -2.56168688630,
    5.64432273403,    6.25670358802,  -0.424687356220,   -3.07743593625,    4.26729074902,   -1.83014139735,
    1.22098483369,    3.10256892136,   -4.94217489682,   -3.62453739721,    4.35351409207,   -3.78092960240,
    2.06949985359,    3.49246198396,    7.21247353087,   -8.61710023958,    1.81135952795,    6.06537020449,
    102.873000337,   -8.29754156395,    6.91329582535, -0.0622295296345,   -31.9189739166,   -17.8224916068,
   -3.96916466957,   0.532469675084,   -17.8574115966,   -3.79742931057,   -7.06730433692,   -9.94818435373,
   0.598478445137,    2.46454329810,    2.82412258514,   -4.06087251037,   -5.19815138695,   -8.52814552557,
   -3.73188144194,   0.515781867353,    2.07207252862,    1.97189302591,  0.0977904398822,    10.7287014056,
    1.63364398023,    3.59856635699,   -4.39348055773,   -3.49052670024,    4.27652301649,   -3.78301578534,
   0.306914586682,    11.7288926780,   -8.41395982155,    3.95300330661,   -7.53423166744,   -10.0869608861,
   -3.84681126387,   -4.33084423350,   -6.47950333593,   -5.77589734195,   -5.72755448944,   -6.78794619835,
   -1.82528689767,  -0.644118167803,   0.110396186431,   0.100981600673,  -0.402406864486,    3.91173751298,
   -1.36735936182,    7.67248056184,   -3.88179659482,   -7.13738360177,   -1.19535906150,   -3.49132852619,
   -2.92596621497,    1.35133816440,   -16.0949204373,   -1.80161412778,   -5.38655433290,   -6.79002948435,
   -3.58332670710,   -3.00247208670,   -4.70767664646,   -8.51024383753,   -13.0398138120,   -10.1740482357,
},
{
   0.590633792225,   0.112462804622,    1.57307864629,  -0.338532291702,   0.934294689249,    4.96574729528,
    6.24180265424,    8.60637122639,    5.64722424249,    5.96833742143,    7.80962418292,    5.44249526303,
    2.34670913657,    6.66691905449,    11.4517516335,   -12.8169778043,   0.651472016818,    2.84956457467,
   -1.20420235933,   -4.57224088644,    4.61452225228,    4.70113281529,   -3.04675227459,    12.1325078736,
    1.26119834948,    2.18987516681,    4.91037153642,   -5.29735570343,    13.1379198417,    15.2833215316,
    10.0730498543,   -1.16301986843,   -1.37163023510,   -6.03427973474,   -1.50027454550,   -3.93903347767,
    3.82132646761,    4.86683987463,  0.0688474955952,   -3.31927402712,    1.88099997551,   -3.96687513396,
    1.51214093103,    3.37896290047,   -4.27782577163,   -3.06099501395,    3.36886108025,  -0.537906001096,
    2.05301896597,    4.07022363329,   -11.4937924601,    11.7034791276,    2.71151189023,    6.95343835880,
   -8.29754156395,    95.8253560915,   -11.3771881230,   -18.3976865898,   -14.2515233115,    3.97463653510,
   -3.21707086342,    1.20670176701,   -18.5389743861,   0.846182241218,   -7.35459035667,   -6.72390343177,
  0.0530762724270,    1.95804453141,    1.63728269312,   -5.53141230965,   -8.52814552557,   -7.36238199152,
   -1.23652875064,   -1.50142740200,    4.42154249574,    4.11048986679,   -3.49650206722,    11.4442099056,
   0.660741621798,    2.73971784574,   -5.04394247808,   -4.19782340310,    2.06125308493,   -1.97808516555,
   -1.31988516118,    12.9423641628,    12.5879849047,   -13.9285718417,   -8.50314641749,   -7.88809678529,
   -7.88914111836,   -3.00247208670,   -5.70466629849,   -4.53722062451,   -6.53319254708,   -7.42705630041,
   -3.52437410739,   0.722311796191,    2.91434752106,    1.16047660536,   -2.90479889313,    1.30519160208,
    8.54277559021,   -2.61762276351,   -2.10738078932,   -5.97302395553,   -2.27303616948,   -3.78877759863,
   -3.08366691349,    1.18570542996,   -19.5588218250,   0.699673230686,   -5.44641221973,   -6.30970603601,
   -5.03263931039,  -0.725226738072,   -4.05435495795,   -8.15841326488,   -8.68936039711,   -13.5953439229,
},
{
   -2.05424388182,    2.91664946903,    1.51640273628,   0.795755172129,  -0.818593816318,    3.72152299620,
   0.314755923607,    1.57307864629,  0.0209809415685,    2.44544825138,    7.68438220043,    3.95863320677,
   0.248275334921,    4.75341046185,    7.42132958226,   -11.1977046007,   -1.19922432959,    2.37667671700,
   -2.15700853736,   0.401277785420,  -0.940801877032,    4.39505757541,    6.73360604526,   0.866154454190,
    2.75496955568,    1.34264207773,    2.90077588087,    8.91907078347,    12.0368225525,   -5.55402788282,
    6.32770429109,   0.503138444413,   -2.19163227797,   -3.04232718639,   -1.32849163946,   -4.80044307096,
    1.83617274451,    5.24659988964,   0.839919235494,   -1.25286666352,    1.54283271895,   -5.36799149000,
    2.85356476469,    1.23620042522,   -2.67167545957,   -1.88530104907,    1.89214896281,   -2.36940709009,
   -1.16880599602,    2.93931202527,   -10.4179101369,    7.85572434880, -0.0946103506733,    4.62640633331,
    6.91329582535,   -11.3771881230,    98.0501238084,   -36.1948023840,    2.38836929911,   -17.0216252500,
   -3.11650166621,    3.11848761998,    2.05840148048,   -18.0874436684,   -2.42109281648,   -3.63980243567,
   -1.83309503743,    3.22581106136,    1.91572793238,   -4.99880484738,   -4.06087251037,   -5.53141230965,
   -2.70812576928,  -0.877376856169,    1.41674265601,    3.51366877414,    6.33445073191,   0.854745298683,
    2.00594589649,   0.831206512909,   -2.98199746189,   -2.07073322809,    1.32988350128,   -2.85350911338,
    4.42099749479,   0.592951516896,    2.04238410188,   -2.23364079297,    5.38238026713,   -14.0912440427,
   -3.61315415637,  -0.644118167803,   -3.77733627693,   -3.06686059009,   -4.86937681595,   -3.04768959184,
   -3.64547457306,    2.66041333492,    1.40809620370,    1.25294322978,   -2.56428697012,    2.87816600487,
    7.13294881956,  0.0555678467830,   -2.75719522516,   -3.61884557138,   -1.13547734156,   -3.91494167754,
   -2.30497741046,    3.20833846878,    2.13971609673,   -17.9660620096,   -2.87516480264,   -4.14106321047,
   -4.26389011473,   0.722311796191,   -2.09613711355,   -6.04286677972,   -7.36658175599,   -5.32764231058,
},
{
    1.68554765668,    2.18345616634,    1.40809620370,   -2.54840826787,   0.613440673968,    2.16874029149,
   -3.45130216438,    2.91434752106,   0.545331558958,   -4.22556084587,   -4.99338303655,   -4.69893147886,
    1.06176307263,    2.55767805912,    1.88241502240,   -16.7877815213, -0.0789435747566,   -2.11393300786,
  -0.491483243017,   0.918782591640,    1.81968452702,   -5.60682842900,    7.33279444374,   -3.27561900621,
   -2.22568304570,   -2.37331479701,   0.110396186431,    4.44558063180,   -12.7359922823,    8.38996332437,
    4.38149458079,  -0.377040242349,   -1.48564295720,    4.81301106985,   -4.05226447797,   0.908235754809,
   -1.75773570496,   -2.40015513230,   -1.34997010910,    2.38263262964,   -2.88446862464,    3.47959864133,
   -1.92029423174,   -1.79665727600,   0.909198892731,    2.11540301866,   -4.56409239301,    3.27367538387,
   0.840501237418,   -2.15868159775,   -17.3220171221,   0.926481665246,    1.55270079570,    2.74121610464,
 -0.0622295296345,   -18.3976865898,   -36.1948023840,    98.3558345997,    1.94203511105,   -10.8343835093,
   0.827827410776,   0.448765444898, -0.0334858524931,   -12.3582958452,    3.72182254444,    2.46532995184,
  0.0698359663296,   -4.48983028873,   -5.29037912148,    1.91572793238,    2.82412258514,    1.63728269312,
   0.110396462682,   0.243514488529, -0.0762330275188,   -4.33004449477,    7.73624059467,   -3.86961435551,
   -1.71528642262,   -2.29004601420,   0.301302209952,    1.71359022390,   -4.22796727586,    3.51750054562,
    8.66481634482,   -5.02467448805,   -6.65812491595,    2.03244291996,   -8.39291090002,    10.8670443194,
   0.573983294049,    2.59871803433,   0.116066517666,    1.76170682652,    2.43697755210,   0.283315126158,
   0.723831726613,    2.91664946903,    1.38687323822,   -2.90550450174, -0.0823657666344,   0.516993015810,
    5.17250072782,   -1.28003934163,   -2.35072651678,    3.99144669601,   -2.57697065912,    1.40680050611,
   0.405950073014,   0.842927830720,  -0.244222984889,   -12.7603680586,    3.51283765151,    2.18522773610,
   -1.39535571638,   0.112462804622,   -5.88796619628,    3.87026004778,    5.51065378265,    3.32191661492,
},
{
    2.02872233283,   0.243514488529,   0.503138444413,  0.0824510449375,  -0.811815197803,    2.76544260503,
  -0.217621232298,   -1.16301986843,   0.514136212441,   -2.27483562655,  -0.288350770806,-0.00675287102233,
   -2.85326303442,    1.72187882714,   -13.1120021898,    4.18954888030,   -1.87628143369,   0.149580620670,
   0.265231994911,   0.651265875292, -0.0567776177298,   -1.00719159757,   -4.68783610204,    9.02880381129,
    6.29032662774,   -9.90097087751,    9.55041595013,   0.992142461532,  -0.453212325349,  -0.928902843985,
   -1.61785491827,    5.66463862396,   -3.32096648140,   -1.83079589154,  -0.480848137140,   0.277616118533,
   0.119462679144,  -0.425236423370,  -0.775329098765,  -0.379801943548,  -0.329815234990, -0.0846387143669,
   -2.26824927103,    1.84284292672,   0.208255474631,    1.12185793523,  -0.159705863318,   -2.27239000576,
   0.652888814807,   0.137554300282,    2.56894077997,   -14.6112811453,  -0.230667962931,    2.73461452022,
   -31.9189739166,   -14.2515233115,    2.38836929911,    1.94203511105,    94.2552788108,   -15.2978841164,
   -1.10748966817,    2.76337481959,   -14.8356627079,   0.982437868940,   0.341986528276,  -0.380210961430,
  -0.298831675023,  -0.188438998761,  0.0698359663295,   -1.83309503743,   0.598478445137,  0.0530762724269,
   -1.13007910406,-0.00616635518711, -0.0870870239659,  -0.774776264366,   -2.42952720868,    8.66578251209,
   -1.15408470499,    1.20692085121,   -1.38639355346,  -0.532432213488,    1.05528116547,   -2.03263840131,
    1.68797633181,   -10.4459740465,    7.79473120283,    3.05921950333,   0.303358116589,   -3.02221399632,
   0.688957879569,   0.515781867353,  -0.332001041841,   0.625326118133,    1.15099202692,   -3.00379402614,
    2.26535029574,  -0.877376856169,  -0.377040242349,  -0.324682637397,  -0.822099283250,    3.75027773845,
   -1.15480161496,    7.71072711834,   -3.09523932096,   -1.08861127329,  -0.102612168783,  -0.354029801964,
  -0.308055041427,    2.63094122274,   -15.1465558918,    1.83679897869,    1.00101216412,  0.0617025313115,
   -2.14215935276,   -1.50142740200,   -2.49753689780, 0.00520850413778,    2.67602940790,   -1.72460020986,
},
{
    1.62075751509,   0.918782591640,  0.0555678467829,  -0.222808488642,   0.429846443576,    1.88972013476,
  -0.607862524868,   -2.61762276351,   -2.30163312917,   -2.45959713642,   -2.75213165922,   -1.69030572390,
    1.60500993770,    1.78263563452,   -21.5884745239,    1.70108151577,    2.47431235715,   -1.76475194051,
   0.829071607073, -0.0582642072911,   -1.46089485254,   -3.41769576679,    12.1289294635,   -7.69733034196,
   -11.8168960818,    7.59505512494,    7.67248056184,   -2.67538276240,   -3.15950591385,   -3.81099339358,
   -4.01214234100,    7.71072711834,   -4.51946838500,    1.83082030725,   0.733919099735,    2.94467407897,
   -2.59637492575,   -2.26857129554,   -1.65035733438,    1.87872915877,   -2.12754545184,    2.16993674850,
  -0.979733462898,   -2.18819474404,   0.292564966958,   0.897125204738,  -0.973849166874,    1.65442854956,
  -0.156025669468,   -1.53452144760,    3.79095739238,   -18.7096452661,  -0.201661053047,    1.65480029254,
   -17.8224916068,    3.97463653510,   -17.0216252500,   -10.8343835093,   -15.2978841164,    93.6426102094,
  -0.295170575584,   0.279843608035,    1.47846360711,   -15.7905603561,    2.60278409476,    2.17686565290,
  -0.188438998761,   -1.91383293954,   -4.48983028873,    3.22581106136,    2.46454329810,    1.95804453141,
  -0.267792101053,   0.651265875292,  -0.876450614864,   -2.77795348368,    11.0676035914,   -5.85849699332,
   -2.98679387144,   -2.48488946318,    1.04860798325,    2.16723095516,   -2.55234384466,    1.12297208977,
   -10.7280805275,   -4.10554906252,   -6.05454160848,   0.466615290388,    11.4762396034,    11.0796491579,
    2.71510318704,    1.48147473050,    1.14479443151,    2.00550909998,   0.606401472974,    1.17390695484,
    3.19550859524,   0.401277785420,   -1.28003934163,   -2.13068687021,    1.55050062551,    1.63938994047,
   -4.73130890527,    9.06274797268,   -3.19998558894,    2.47930316206,  -0.695741099095,    1.68664098403,
   0.580982753522,    2.37222909638,    4.41797286516,   -14.9716998052,    2.25972447542,    2.18580016393,
  -0.538823633149,   -4.57224088644,   -1.37410684853,    4.26348616172,    2.38818731746,    3.10532137185,
},
{
   0.317009408644,   -1.79665727600,   -2.98199746189,   -1.99850697532,    3.18700577505,    3.33342800563,
   -2.66294670741,   -5.04394247808,   -3.07052267766,   -6.02998849958,   -4.73781547117,   -3.35179369511,
   -19.3172377973,   -5.64241517623,   -3.08262042966,   -1.78446843887,   -1.14582454271,  -0.768481463569,
 -0.0647828994834,   -2.18819474404,    4.48066186429,   -3.96373655670,   -2.32574635157,   -2.70772471001,
   -6.28473382085,   -2.79810435903,   -4.39348055773,   -1.96636597240,   -2.99515736580,   -3.78125589665,
   -1.89452057505,   -1.38639355346,  -0.642532653427,    10.3804109113,    1.31873349495,    2.97337347268,
   -4.35783988847,   -5.17763354174,   -1.74089982198,   -1.38754417573,   -3.39699380325,  -0.208344798672,
   -4.22320070153,  -0.586681818738,    1.18069247113,   -9.04793938552,    3.37785124710,    6.70357901341,
   -15.7388762514,   -18.0169750810,   -4.11852072757,   -5.35965896485,   -34.1516756924,   -3.22786966042,
   -3.96916466957,   -3.21707086342,   -3.11650166621,   0.827827410776,   -1.10748966817,  -0.295170575584,
    97.5106165352,    1.33472273249,    2.41906046605,    2.25917246856,   -12.2102995519,   -11.2505893766,
    2.73461452022,    1.65480029254,    2.74121610464,    4.62640633331,    6.06537020449,    6.95343835880,
    2.39181914006,    1.84284292672,   -11.3978370566,  -0.172708307440,  -0.948512871545,  -0.627258344381,
   -2.54666298514,    7.45957428690,    6.93429729132,    10.0677163024,   -2.20848872348,  -0.330263365747,
 -0.0713480282071,   -1.30237338382,   0.121673303444,    1.99892364104,    3.12219281403,    4.57598222658,
    3.94431849865,    3.10256892136,    1.32288537996,   0.823733923179,    1.53728882691,    3.17903115692,
    3.69530622097,    1.23620042522,   0.301302209952,   -1.55906670230,    3.72198225871,   0.719583277667,
  -0.771434475411,    1.04860798325,    1.41439353302,    9.16691233076,   0.194605943195,   0.888231594353,
   -12.0586768221,    2.14946668185,    3.35790524138,    4.67724015175,    6.65935094182,    7.91720330292,
    4.18885217231,    3.37896290047,    1.06752938523,    1.07416732004,    1.67444252606,    3.37243472607,
},
{
  0.0967280348665,   -2.29004601420,   -2.67167545957,   -1.37002058804,    2.62950027646,    4.70409238607,
  -0.986603121024,   -4.27782577163,   -2.68209384482,   -3.82849120087,   -3.37577633747,   -2.02151439206,
   -8.65304489492,   -18.8945373099,    1.03529123844,    2.48195738147,   -4.50485903284,  -0.624657997254,
 -0.0139864204816,   -2.48488946318,   -2.78247617573,    5.60836397767,   -4.82797426774,  -0.726464919442,
   -4.70149806626,   -4.32478909853,   -4.94217489682,   -1.59619979390,   -2.76899080156,   -3.81440143326,
   0.220846817197,   0.208255474631,    8.80731107037,   -2.34515277457,    1.76478425866,  -0.520669323459,
   -2.50206994411,   -3.10406777656,  -0.253091316952,   -2.00355051992,  -0.288593708110,   -1.38665779695,
    7.58738509851,    7.45957428690,   -11.5051519493,   -1.13586621270,   -1.77477694233,   -3.29214336856,
   -3.32897663818,   -2.64461858054,   -16.9846587415,   -18.0786209612,   -3.16965487642,   -34.1516756924,
   0.532469675084,    1.20670176701,    3.11848761998,   0.448765444898,    2.76337481959,   0.279843608035,
    1.33472273249,    97.9279254243,   -11.1390670812,   -12.7497104077,   0.821853551219,    1.61158816726,
  -0.230667962931,  -0.201661053047,    1.55270079570, -0.0946103506733,    1.81135952795,    2.71151189023,
    1.31823289283,    1.20692085121,   0.882177110707,   -10.0418795477,   -1.80231008148,    2.13889983533,
    9.13690958564,   -1.41292452560,    1.18069247113,   -2.07282329380,    6.85809515971,    5.75150332245,
  -0.755931664233,   -1.11372675128,    1.08285467559,  -0.838740155361,    1.06590212299,    2.27346737812,
    3.46667425859,    3.59856635699,    1.01326108039,    1.12394241249,    1.36958351942,    3.26675519699,
    2.92211067478,   0.831206512909,   0.909198892731,   -1.21391220419,   -1.03526516990,    4.66367182442,
   -1.77000131659,   0.292564966958,    8.64381642659,   0.493403977792,    2.08159759315,   0.657839132651,
    3.60317294936,   -11.3999775314,    7.17934350437,    4.85576722241,    2.25691717471,    3.62606894482,
    2.54581189924,    2.73971784574,  0.0849587942870,  -0.580323425396,   0.219686486452,    2.02183256873,
},
{
    1.32144544549, -0.0762330275188,   -2.19163227797,   -1.67990502431,   -1.20360863110,    2.82072520664,
   -2.81004665660,   -1.37163023510,   -3.51454627695,   -3.88232908528,   -3.05018339346,   -2.02802672410,
   -5.50478634897,   -21.4912539598,    4.46226543485,    2.73539255755,   -7.05793411218,  0.0380088357487,
  -0.995124191103,  -0.876450614864,   -1.85841628415,   -4.21039938474,   -5.73844782065,    9.09063855211,
   -6.47364612549,   -4.29947966233,   -3.21798506775,   -2.20778938257,   -2.80677249714,   -4.44273544243,
  -0.721810888033,   -3.32096648140,    10.7779649759,  0.0169954512305,   0.736566900475,  -0.601676628533,
   -1.32629124690,   -3.31243791773,   0.401647588297,   -2.04207166717,  -0.374619659663,   -1.39501835562,
    8.86483341561,   -11.3978370566,    8.80731107037,  -0.966763684304,   -1.49399239261,   -2.65884432854,
  -0.400893302745,   -1.29586693892,    4.01875400135,    4.92079954057,   -3.32897663818,   -15.7388762514,
   -17.8574115966,   -18.5389743861,    2.05840148048, -0.0334858524931,   -14.8356627079,    1.47846360711,
    2.41906046605,   -11.1390670812,    92.7853928095,   -15.9480158432,    1.12502630644,    1.05158253708,
   0.652888814807,  -0.156025669468,   0.840501237418,   -1.16880599602,    2.06949985359,    2.05301896597,
    1.65895067518, -0.0870870239659,   -1.04954137496,   -1.49196964868,   -1.43426408258,   -7.06529346522,
   -1.67373580774,   0.882177110707,  -0.642532653427,    1.40874140874,  -0.288433360886,   -2.88072342083,
  -0.673633309049,    9.35576439192,    8.12910672884,    5.80288007867,   0.501243283029,   -1.83170587234,
    3.62078617726,    2.07207252862,    1.12338280046,    2.91476006270,   0.691587687635,   -1.48303979002,
  -0.794133342961,    1.41674265601,   -1.48564295720,    1.63743331504,    2.35700464670,    5.82889224441,
   0.419196010992,   -4.51946838500,    11.4159072685,   0.864511276649,    1.75832614461,    1.72996653042,
    1.34710462072,    7.39312816784,   -16.2402478326,    3.26782880655,    1.45528844758,   0.716863814499,
    7.30349562037,    4.42154249574,    3.38103514287,    3.51830820868,    2.78643342225, -0.0424397035294,
},
{
    1.39656074305,    1.81968452702,   -2.75719522516,   -2.90899564007,   0.618454666887,   0.702694944772,
   -3.35210644563,   -2.10738078932,   -6.23340209851,   -4.43922102010,   -5.29810362710,   -4.21925717124,
  -0.901028953118,   -21.0330481220,   -3.89444925619, -0.0438466036696,   0.193453132463,   -5.14903647973,
  -0.230362026411,   -1.46089485254,   -2.73796049663,   -6.71315349486,    7.93840729882,   -5.25391663395,
   -3.76698308645,   -7.34212250355,   -3.88179659482,   -7.65647231212,   -5.51170646267,   -7.03436867550,
   -2.50966202192,   -3.09523932096,    11.4159072685,    3.58769338251,   0.586904825889,    2.89820975974,
   -4.18361147861,   -6.13678692008,  -0.701150313907,    1.28248388672,   -3.04136462819,    2.01281383095,
   -10.5458301759,    4.48066186429,    8.64381642659,  -0.158319857919,   -2.99859433160,    1.96270324942,
   -1.29586693892,   -2.50996423442,    5.02034622785,    1.21387395923,   -2.64461858054,   -18.0169750810,
   -3.79742931057,   0.846182241218,   -18.0874436684,   -12.3582958452,   0.982437868940,   -15.7905603561,
    2.25917246856,   -12.7497104077,   -15.9480158432,    92.7490309898,    3.05273950099,    3.61855263797,
   0.137554300282,   -1.53452144760,   -2.15868159775,    2.93931202527,    3.49246198396,    4.07022363329,
    2.82235210499, -0.0567776177297,   -1.85841628415,   -3.90795863113,   -7.83212364819,  -0.936251126036,
   -2.74395919415,   -2.78247617573,    1.41439353302,    3.70110750688,   -4.73280164616,    1.10735995817,
    7.75620353226,   -4.87087529660,   -4.14858224039,    1.02899668126,    11.0614215636,    13.2137268024,
    5.59187838003,    2.69155885333,    2.13910789756,    4.70811456921,    1.19761159601,    2.09320522335,
    2.06849456445,  -0.940801877032,   -2.35072651678,   0.835336974273,    4.62879146440,    4.48072367247,
   -1.91084817595,   -3.19998558894,    11.0067261524,    2.99133463145,    2.02175215248,    3.44568326186,
    1.92792536871,    7.54195229339,    3.73619642794,   -14.3750955712,    2.87287451220,    3.00527857918,
    6.04429774214,    4.61452225228,    4.05940570669,    8.26954420328,    2.67799341696,    4.15892129831,
},
{
    1.02605720546,   -2.37331479701,   -3.77733627693,   -1.43305365901,    5.30877759488,   0.888583249480,
   -3.45626513000,   -5.70466629849,   -7.00279693580,   -6.93544144105,   -7.39504638297,   -5.73626900280,
   -17.7214813554,   -2.53196272433,   -11.4856321658,   -7.15385672093,    5.68294330736,   -3.35219702054,
 -0.0859737999385,    7.59505512494,   -7.34212250355,   -5.52024849453,   0.216651853125,   -5.75346587156,
   -7.81212664565,   -8.41736996603,   -6.47950333593,   -3.44409149145,   -6.46198437092,   -7.03341058696,
   -2.05191827869,  -0.332001041841,    1.12338280046,    11.6325047244,    1.50831284227,    1.14597346545,
   -7.61785716243,   -8.64938121805,  -0.234511347270, 0.00817510064862,   -5.59032944961,    1.93731693654,
   -4.36964974991,   -2.79810435903,    1.01326108039,    11.3982255953,    6.34108150200,   -7.23976744124,
    4.92079954057,    1.21387395923,   -6.01767315498,   -6.28804067827,   -18.0786209612,   -5.35965896485,
   -7.06730433692,   -7.35459035667,   -2.42109281648,    3.72182254444,   0.341986528276,    2.60278409476,
   -12.2102995519,   0.821853551219,    1.12502630644,    3.05273950099,    94.7298696159,   -12.0089431300,
   -14.6112811453,   -18.7096452661,   0.926481665246,    7.85572434880,   -8.61710023958,    11.7034791276,
    3.39335561421,   -9.90097087751,   -4.29947966233,   -4.40445015800,    1.50969080752,   -4.40138514720,
   -3.38273805882,   -4.32478909853,    1.32288537996,  -0.242624434201,   -4.70370169779,    3.85417816513,
   -1.18330443691,   -2.18365247431,   -1.74931105086,    5.39916098902,    5.10529079514,    6.13080095654,
    5.85134547356,    13.8048763306,    15.1580747943,    14.1327613027,    3.32405577632,    5.42245148490,
    4.83644746149,    1.34264207773,   0.116066517666,   -5.44848887444,    4.27517288855,   0.266964585737,
  -0.233985776625,    1.14479443151,    2.13910789756,    12.5784802369,    2.92767457208,    1.57770453761,
    9.26811669461,    2.68655900288,    4.26622830396,    4.82287665170,   -12.0020462898,    9.42849253750,
    5.84810605862,    2.18987516681,    4.15777877683,    3.23790008991,    3.49249165404,    5.64316448556,
},
{
    1.88772939286,   0.545331558958,   -2.09613711355,   -3.16798642674,    2.52869602862,   -1.63606896922,
   -5.37432696832,   -4.05435495795,   -6.61848412260,   -6.19424392149,   -6.52606891117,   -4.70076357543,
   -18.3629095634,   -3.12264250823,   -8.74645850396,   -9.62141229527,    2.90487823575,  -0.479123945235,
    9.88998691768,   -2.30163312917,   -6.23340209851,   -3.86241095315,  -0.702321383383,   -6.49664214697,
   -7.33354399261,   -7.00279693580,   -4.70767664646,   -6.83419264548,   -6.57582963161,   -9.33963865749,
   0.450688627235,   -2.49753689780,    3.38103514287,    13.8527965563,   -1.39059221097,    1.31728951722,
   -6.50929731674,   -8.44202922569,   -2.42287091649,    1.87942139897,   -2.11136224508,    1.39654183047,
   -5.41431685967,   -3.07052267766,  0.0849587942870,    10.3977310850,   -13.1943048089,    11.9416522898,
    4.01875400135,    5.02034622785,   -3.20219830206,   -6.01767315498,   -16.9846587415,   -4.11852072757,
   -9.94818435373,   -6.72390343177,   -3.63980243567,    2.46532995184,  -0.380210961430,    2.17686565290,
   -11.2505893766,    1.61158816726,    1.05158253708,    3.61855263797,   -12.0089431300,    96.4518701114,
    2.56894077997,    3.79095739238,   -17.3220171221,   -10.4179101369,    7.21247353087,   -11.4937924601,
   -7.84888069700,   0.514136212441,   -3.51454627695,   -3.40654646337,   0.304161354887,   -5.72021533230,
   -3.83821499890,   -2.68209384482,    1.06752938523,   0.677327563698,   -1.61502794398,    2.96750226889,
   -1.05510526828,   -2.27640071874,   -4.09070881500,    3.11372650763,    3.94284580098,    4.40043954301,
    15.5349777304,    2.52357226846,    4.15777877683,    3.47335810570,    13.6763017879,    13.2818405765,
    1.39551041680,  0.0209809415685,   -5.88796619628,    1.26843494328,    7.19934538749,    2.93182498382,
    1.57698579440,   -1.37410684853,    4.05940570669,    14.8468941777,  -0.642957914166,    2.72936358630,
    8.51096261755,    1.97210592684,   0.530475704477,    2.26907424018,    6.80378366108,   -12.6839240768,
    7.27804666997,    5.64722424249,    7.36241256775,    6.85570362359,    6.14401133253,    5.80496011766,
},
{
  -0.324682637397,  -0.377040242349,  -0.877376856169,    2.26535029574,    3.75027773845,  -0.822099283250,
   -2.14215935276,   -1.50142740200,   -2.49753689780, 0.00520850413778,    2.67602940790,   -1.72460020986,
    2.63094122274,  -0.308055041427,    1.00101216412,  0.0617025313115,   -15.1465558918,    1.83679897869,
   -1.15480161496,    7.71072711834,   -3.09523932096,   -1.08861127329,  -0.102612168783,  -0.354029801964,
   0.625326118133,  -0.332001041841,   0.515781867353,   0.688957879569,   -3.00379402614,    1.15099202692,
   -1.13007910406,-0.00616635518705, -0.0870870239659,  -0.774776264366,   -2.42952720868,    8.66578251209,
   -3.02221399632,   0.303358116588,    1.68797633181,   -10.4459740465,    3.05921950333,    7.79473120283,
  -0.532432213488,   -1.38639355346,    1.20692085120,   -1.15408470499,   -2.03263840131,    1.05528116547,
   -14.8356627079,   0.982437868940,  -0.380210961430,   0.341986528276,    2.76337481959,   -1.10748966817,
   0.598478445137,  0.0530762724270,   -1.83309503743,  0.0698359663296,  -0.298831675023,  -0.188438998761,
    2.73461452022,  -0.230667962931,   0.652888814807,   0.137554300282,   -14.6112811453,    2.56894077997,
    94.2552788108,   -15.2978841164,    1.94203511105,    2.38836929911,   -31.9189739166,   -14.2515233115,
   -1.61785491827,    5.66463862396,   -3.32096648140,   -1.83079589154,  -0.480848137140,   0.277616118533,
    1.12185793523,   0.208255474631,    1.84284292672,   -2.26824927103,   -2.27239000576,  -0.159705863318,
  -0.775329098765,  -0.379801943548, -0.0846387143668,  -0.329815234990,  -0.425236423370,   0.119462679144,
   0.992142461532,    9.55041595013,   -9.90097087751,    6.29032662774,  -0.928902843985,  -0.453212325349,
  0.0824510449375,   0.503138444413,   0.243514488529,    2.02872233283,    2.76544260503,  -0.811815197803,
   0.265231994911,   0.651265875292, -0.0567776177297,   -1.00719159757,   -4.68783610204,    9.02880381129,
    1.72187882714,   -2.85326303442,   -1.87628143369,   0.149580620670,   -13.1120021898,    4.18954888030,
  -0.217621232298,   -1.16301986843,   0.514136212441,   -2.27483562655,  -0.288350770806,-0.00675287102232,
},
{
   -2.13068687021,   -1.28003934163,   0.401277785420,    3.19550859524,    1.63938994047,    1.55050062551,
  -0.538823633149,   -4.57224088644,   -1.37410684853,    4.26348616172,    2.38818731746,    3.10532137185,
    2.37222909638,   0.580982753522,    2.25972447542,    2.18580016393,    4.41797286516,   -14.9716998052,
   -4.73130890527,    9.06274797268,   -3.19998558894,    2.47930316206,  -0.695741099095,    1.68664098403,
    2.00550909998,    1.14479443151,    1.48147473050,    2.71510318704,    1.17390695484,   0.606401472974,
  -0.267792101053,   0.651265875292,  -0.876450614864,   -2.77795348368,    11.0676035914,   -5.85849699332,
    11.0796491579,    11.4762396034,   -10.7280805275,   -4.10554906252,   0.466615290388,   -6.05454160848,
    2.16723095516,    1.04860798325,   -2.48488946318,   -2.98679387144,    1.12297208977,   -2.55234384466,
    1.47846360711,   -15.7905603561,    2.17686565290,    2.60278409476,   0.279843608035,  -0.295170575584,
    2.46454329810,    1.95804453141,    3.22581106136,   -4.48983028873,  -0.188438998761,   -1.91383293954,
    1.65480029254,  -0.201661053047,  -0.156025669468,   -1.53452144760,   -18.7096452661,    3.79095739238,
   -15.2978841164,    93.6426102094,   -10.8343835093,   -17.0216252500,   -17.8224916068,    3.97463653510,
   -4.01214234100,    7.71072711834,   -4.51946838500,    1.83082030725,   0.733919099735,    2.94467407897,
   0.897125204738,   0.292564966958,   -2.18819474404,  -0.979733462898,    1.65442854956,  -0.973849166874,
   -1.65035733438,    1.87872915877,    2.16993674850,   -2.12754545184,   -2.26857129554,   -2.59637492575,
   -2.67538276240,    7.67248056184,    7.59505512494,   -11.8168960818,   -3.81099339358,   -3.15950591385,
  -0.222808488642,  0.0555678467829,   0.918782591640,    1.62075751509,    1.88972013476,   0.429846443576,
   0.829071607073, -0.0582642072911,   -1.46089485254,   -3.41769576679,    12.1289294635,   -7.69733034196,
    1.78263563452,    1.60500993770,    2.47431235715,   -1.76475194051,   -21.5884745239,    1.70108151577,
  -0.607862524868,   -2.61762276351,   -2.30163312917,   -2.45959713642,   -2.75213165922,   -1.69030572390,
},
{
   -2.90550450174,    1.38687323822,    2.91664946903,   0.723831726613,   0.516993015810, -0.0823657666345,
   -1.39535571638,   0.112462804622,   -5.88796619628,    3.87026004778,    5.51065378265,    3.32191661492,
   0.842927830720,   0.405950073014,    3.51283765151,    2.18522773610,  -0.244222984889,   -12.7603680586,
    5.17250072782,   -1.28003934163,   -2.35072651678,    3.99144669601,   -2.57697065912,    1.40680050611,
    1.76170682652,   0.116066517666,    2.59871803433,   0.573983294049,   0.283315126158,    2.43697755210,
   0.110396462681,   0.243514488529, -0.0762330275188,   -4.33004449477,    7.73624059467,   -3.86961435551,
    10.8670443194,   -8.39291090002,    8.66481634482,   -5.02467448805,    2.03244291996,   -6.65812491595,
    1.71359022390,   0.301302209952,   -2.29004601420,   -1.71528642262,    3.51750054562,   -4.22796727586,
 -0.0334858524931,   -12.3582958452,    2.46532995184,    3.72182254444,   0.448765444898,   0.827827410776,
    2.82412258514,    1.63728269312,    1.91572793238,   -5.29037912148,  0.0698359663296,   -4.48983028873,
    2.74121610464,    1.55270079570,   0.840501237418,   -2.15868159775,   0.926481665246,   -17.3220171221,
    1.94203511105,   -10.8343835093,    98.3558345997,   -36.1948023840, -0.0622295296345,   -18.3976865898,
    4.38149458079,  -0.377040242349,   -1.48564295720,    4.81301106985,   -4.05226447797,   0.908235754809,
    2.11540301866,   0.909198892731,   -1.79665727600,   -1.92029423174,    3.27367538387,   -4.56409239301,
   -1.34997010910,    2.38263262964,    3.47959864133,   -2.88446862464,   -2.40015513230,   -1.75773570496,
    4.44558063180,   0.110396186431,   -2.37331479701,   -2.22568304570,    8.38996332437,   -12.7359922823,
   -2.54840826787,    1.40809620370,    2.18345616634,    1.68554765668,    2.16874029149,   0.613440673968,
  -0.491483243017,   0.918782591640,    1.81968452702,   -5.60682842900,    7.33279444374,   -3.27561900621,
    2.55767805912,    1.06176307263, -0.0789435747566,   -2.11393300786,    1.88241502240,   -16.7877815213,
   -3.45130216438,    2.91434752106,   0.545331558958,   -4.22556084587,   -4.99338303655,   -4.69893147886,
},
{
    1.25294322978,    1.40809620370,    2.66041333492,   -3.64547457306,    2.87816600487,   -2.56428697012,
   -4.26389011473,   0.722311796191,   -2.09613711355,   -6.04286677972,   -7.36658175599,   -5.32764231058,
    3.20833846878,   -2.30497741046,   -2.87516480264,   -4.14106321047,    2.13971609673,   -17.9660620096,
    7.13294881956,  0.0555678467829,   -2.75719522516,   -3.61884557138,   -1.13547734156,   -3.91494167754,
   -3.06686059009,   -3.77733627693,  -0.644118167803,   -3.61315415637,   -3.04768959184,   -4.86937681595,
   -2.70812576928,  -0.877376856169,    1.41674265601,    3.51366877414,    6.33445073191,   0.854745298683,
   -14.0912440427,    5.38238026713,    4.42099749479,   0.592951516896,   -2.23364079297,    2.04238410188,
   -2.07073322809,   -2.98199746189,   0.831206512909,    2.00594589649,   -2.85350911338,    1.32988350128,
    2.05840148048,   -18.0874436684,   -3.63980243567,   -2.42109281648,    3.11848761998,   -3.11650166621,
   -4.06087251037,   -5.53141230965,   -4.99880484738,    1.91572793238,   -1.83309503743,    3.22581106136,
    4.62640633331, -0.0946103506733,   -1.16880599602,    2.93931202527,    7.85572434880,   -10.4179101369,
    2.38836929911,   -17.0216252500,   -36.1948023840,    98.0501238084,    6.91329582535,   -11.3771881230,
    6.32770429109,   0.503138444413,   -2.19163227797,   -3.04232718639,   -1.32849163946,   -4.80044307096,
   -1.88530104907,   -2.67167545957,    1.23620042522,    2.85356476469,   -2.36940709009,    1.89214896281,
   0.839919235494,   -1.25286666352,   -5.36799149000,    1.54283271895,    5.24659988964,    1.83617274451,
    8.91907078347,    2.90077588087,    1.34264207773,    2.75496955568,   -5.55402788282,    12.0368225525,
   0.795755172129,    1.51640273628,    2.91664946903,   -2.05424388182,    3.72152299620,  -0.818593816318,
   -2.15700853736,   0.401277785420,  -0.940801877032,    4.39505757541,    6.73360604526,   0.866154454190,
    4.75341046185,   0.248275334921,   -1.19922432959,    2.37667671700,    7.42132958226,   -11.1977046007,
   0.314755923607,    1.57307864629,  0.0209809415685,    2.44544825138,    7.68438220043,    3.95863320677,
},
{
   0.100981600673,   0.110396186431,  -0.644118167803,   -1.82528689767,    3.91173751298,  -0.402406864486,
   -3.58332670710,   -3.00247208670,   -4.70767664646,   -8.51024383753,   -13.0398138120,   -10.1740482357,
    1.35133816440,   -2.92596621497,   -5.38655433290,   -6.79002948435,   -16.0949204373,   -1.80161412778,
   -1.36735936182,    7.67248056184,   -3.88179659482,   -7.13738360177,   -1.19535906150,   -3.49132852619,
   -5.77589734195,   -6.47950333593,   -4.33084423350,   -3.84681126387,   -6.78794619835,   -5.72755448944,
   -3.73188144194,   0.515781867353,    2.07207252862,    1.97189302591,  0.0977904398822,    10.7287014056,
   -10.0869608861,   -7.53423166744,   0.306914586681,    11.7288926780,    3.95300330661,   -8.41395982155,
   -3.49052670024,   -4.39348055773,    3.59856635699,    1.63364398023,   -3.78301578534,    4.27652301649,
   -17.8574115966,   -3.79742931057,   -9.94818435373,   -7.06730433692,   0.532469675084,   -3.96916466957,
   -5.19815138695,   -8.52814552557,   -4.06087251037,    2.82412258514,   0.598478445137,    2.46454329810,
    6.06537020449,    1.81135952795,    2.06949985359,    3.49246198396,   -8.61710023958,    7.21247353087,
   -31.9189739166,   -17.8224916068, -0.0622295296344,    6.91329582535,    102.873000337,   -8.29754156395,
  -0.272497579815,    9.55041595013,   -3.21798506775,   -5.79854447676, -0.0662381676393,   -2.56168688630,
   -3.62453739721,   -4.94217489682,    3.10256892136,    1.22098483369,   -3.78092960240,    4.35351409207,
  -0.424687356220,   -3.07743593625,   -1.83014139735,    4.26729074902,    6.25670358802,    5.64432273403,
    6.53891567913,   -5.21236288663,    13.8048763306,    11.2369380302,    4.90918856470,    5.25351092114,
    3.17949645052,    2.90077588087,    2.59871803433,   -2.88743618262,    2.28500868480,   -1.77820375188,
   -6.40891589527,    1.48147473050,    2.69155885333,    2.44550709798,   0.646018777457,    10.7075152535,
    7.33859822326,    3.18541284620,    4.36501661673,    5.49448637986,   -7.46208658743,    9.29575996071,
    4.93464750296,    4.91037153642,    2.52357226846,    2.33851044078,    5.11985745270,    5.36585346694,
},
{
    1.16047660536,    2.91434752106,   0.722311796191,   -3.52437410739,    1.30519160208,   -2.90479889313,
   -5.03263931039,  -0.725226738072,   -4.05435495795,   -8.15841326488,   -8.68936039711,   -13.5953439229,
    1.18570542996,   -3.08366691349,   -5.44641221973,   -6.30970603601,   -19.5588218250,   0.699673230686,
    8.54277559021,   -2.61762276351,   -2.10738078932,   -5.97302395553,   -2.27303616948,   -3.78877759863,
   -4.53722062451,   -5.70466629849,   -3.00247208670,   -7.88914111836,   -7.42705630041,   -6.53319254708,
   -1.23652875064,   -1.50142740200,    4.42154249574,    4.11048986679,   -3.49650206722,    11.4442099056,
   -7.88809678529,   -8.50314641749,   -1.31988516118,    12.9423641628,   -13.9285718417,    12.5879849047,
   -4.19782340310,   -5.04394247808,    2.73971784574,   0.660741621798,   -1.97808516555,    2.06125308493,
   -18.5389743861,   0.846182241218,   -6.72390343177,   -7.35459035667,    1.20670176701,   -3.21707086342,
   -8.52814552557,   -7.36238199152,   -5.53141230965,    1.63728269312,  0.0530762724270,    1.95804453141,
    6.95343835880,    2.71151189023,    2.05301896597,    4.07022363329,    11.7034791276,   -11.4937924601,
   -14.2515233115,    3.97463653510,   -18.3976865898,   -11.3771881230,   -8.29754156395,    95.8253560915,
    10.0730498543,   -1.16301986843,   -1.37163023510,   -6.03427973474,   -1.50027454550,   -3.93903347767,
   -3.06099501395,   -4.27782577163,    3.37896290047,    1.51214093103,  -0.537906001096,    3.36886108025,
  0.0688474955951,   -3.31927402712,   -3.96687513396,    1.88099997551,    4.86683987463,    3.82132646761,
   -5.29735570343,    4.91037153642,    2.18987516681,    1.26119834948,    15.2833215316,    13.1379198417,
  -0.338532291702,    1.57307864629,   0.112462804622,   0.590633792225,    4.96574729528,   0.934294689249,
   -1.20420235933,   -4.57224088644,    4.61452225228,    4.70113281529,   -3.04675227459,    12.1325078736,
    6.66691905449,    2.34670913657,   0.651472016817,    2.84956457467,    11.4517516335,   -12.8169778043,
    6.24180265424,    8.60637122639,    5.64722424249,    5.96833742143,    7.80962418292,    5.44249526303,
},
{
    2.44549621665,   -1.34997010910,    4.42099749479,   -2.52050917818,   -1.19832194615,   -1.32677197557,
   0.648060105356,   -1.31988516118,   -2.42287091649,   -1.79190636860,   0.963561730308,  -0.822761627120,
   0.752523437973,   -1.45370351642,   -1.01728261213,  -0.655500619147,   -2.02931849394,   -4.10591299042,
   -14.7303964383,   -1.65035733438,  -0.701150313907,   -1.74888357212,    2.66720371507,    2.17786885862,
   0.768747418436,  -0.234511347270,   0.306914586681,  -0.405485447227,   -1.39758341021,   0.493511139924,
  -0.807975698449,    1.68797633181,  -0.673633309049,   -3.83870245603,   -3.50345230039,  -0.541588753301,
  0.0872816773914,   -2.97318505675,    4.68499435657,    4.38226922329,   -2.36678986350,    2.15730956894,
   -2.13442715547,   -1.74089982198,  -0.755931664233,   -3.15515491248,   -2.68666481829,   0.559476174582,
  -0.721810888033,   -2.50966202192,   0.450688627235,   -2.05191827869,   0.220846817197,   -1.89452057505,
   -3.73188144194,   -1.23652875064,   -2.70812576928,   0.110396462682,   -1.13007910406,  -0.267792101053,
    2.39181914006,    1.31823289283,    1.65895067518,    2.82235210499,    3.39335561421,   -7.84888069700,
   -1.61785491827,   -4.01214234100,    4.38149458079,    6.32770429109,  -0.272497579815,    10.0730498543,
    95.5885613006,  -0.775329098765,   0.401647588297,  -0.737208484589,   -15.0432881193,   -15.3285798195,
  -0.981000615935,  -0.253091316952, -0.0713480282071,  -0.518408162699,  -0.607028592293,    2.52120643985,
    3.27695081497,    2.67912768460,    1.56010340800,    2.94831173152,    3.84465259820,    4.72477703040,
   -32.3095409893,  -0.424687356220,   -1.18330443691,    1.83839328834,   -13.2965885945,   -14.7753124299,
    3.60249764016,   0.839919235494,    8.66481634482,  -0.610894684855,   -1.72833866992,  -0.831516026082,
   -1.92153663320,   -10.7280805275,    7.75620353226,    8.03071032466,    1.78584284172,    1.80036779883,
  -0.523543280774,   0.624602508586,   -1.52362951526,  -0.486534657962,   0.313854286943,    7.54335481944,
   -14.7625052036,  0.0688474955951,   -1.05510526828,    1.17284223635,    3.17239108681,    1.42851903350,
},
{
 -0.0846387143669,    1.94203511105,   -1.83309503743,    3.05921950333,   -2.27239000576,   -2.03263840131,
   -3.02221399632,  0.0530762724270,  -0.380210961430,  0.0617025313115,   -3.00379402614,   -1.72460020986,
    1.12185793523,  -0.532432213488,   0.625326118133, 0.00520850413776,   -1.83079589154,   -1.08861127329,
  -0.379801943548,   -15.2978841164,   0.982437868940,    1.83679897869,   0.277616118533,  -0.354029801964,
    1.00101216412,   0.341986528276,   0.598478445137,   0.303358116589,    2.67602940790,    1.15099202692,
    1.68797633181,  -0.298831675023,   0.652888814807,   -1.87628143369,   -2.42952720868,   -4.68783610204,
   -2.14215935276,   0.688957879569,   -1.13007910406,   0.265231994911,    2.26535029574,    2.02872233283,
  -0.308055041427,   -1.10748966817,  -0.230667962931,   -2.85326303442,  -0.822099283250,  -0.811815197803,
   -3.32096648140,   -3.09523932096,   -2.49753689780,  -0.332001041841,   0.208255474631,   -1.38639355346,
   0.515781867353,   -1.50142740200,  -0.877376856169,   0.243514488529,-0.00616635518708,   0.651265875292,
    1.84284292672,    1.20692085120, -0.0870870239659, -0.0567776177297,   -9.90097087751,   0.514136212441,
    5.66463862396,    7.71072711834,  -0.377040242349,   0.503138444413,    9.55041595013,   -1.16301986843,
  -0.775329098765,    94.2552788108,   -14.8356627079,   -15.1465558918,  -0.480848137140,  -0.102612168783,
    2.63094122274,    2.76337481959,    2.73461452022,    1.72187882714,    3.75027773845,    2.76544260503,
   -1.61785491827,   -1.15480161496,  -0.324682637397,  0.0824510449375,   0.992142461532,  -0.217621232298,
  -0.425236423370,   -31.9189739166,   -14.6112811453,   -13.1120021898,  -0.928902843985,  -0.288350770806,
  -0.329815234990,    2.38836929911,  0.0698359663296,    7.79473120283,  -0.159705863318,    1.05528116547,
   -10.4459740465,  -0.188438998761,   0.137554300282,   0.149580620670,    8.66578251209,    9.02880381129,
   -2.26824927103,   -1.15408470499,  -0.774776264366,   -1.00719159757,    6.29032662774,   -2.27483562655,
   0.119462679144,   -14.2515233115,    2.56894077997,    4.18954888030,  -0.453212325349,-0.00675287102231,
},
{
   -1.39501835562, -0.0334858524930,   -1.16880599602,    5.80288007867,   -2.65884432854,   -2.88072342083,
   -1.83170587234,    2.05301896597,    1.05158253708,   0.716863814499,   -1.48303979002, -0.0424397035294,
  -0.966763684304,    1.40874140874,    2.91476006270,    3.51830820868,  0.0169954512305,   0.864511276649,
   -2.04207166717,    1.47846360711,   -15.9480158432,    3.26782880655,  -0.601676628533,    1.72996653042,
    1.45528844758,    1.12502630644,    2.06949985359,   0.501243283029,    2.78643342225,   0.691587687635,
  -0.673633309049,   0.652888814807,  -0.400893302745,   -7.05793411218,   -1.43426408258,   -5.73844782065,
    7.30349562037,    3.62078617726,    1.65895067518,  -0.995124191103,  -0.794133342961,    1.32144544549,
    1.34710462072,    2.41906046605,   -3.32897663818,   -5.50478634897,    2.35700464670,   -1.20360863110,
    10.7779649759,    11.4159072685,    3.38103514287,    1.12338280046,    8.80731107037,  -0.642532653427,
    2.07207252862,    4.42154249574,    1.41674265601, -0.0762330275188, -0.0870870239659,  -0.876450614864,
   -11.3978370566,   0.882177110707,   -1.04954137496,   -1.85841628415,   -4.29947966233,   -3.51454627695,
   -3.32096648140,   -4.51946838500,   -1.48564295720,   -2.19163227797,   -3.21798506775,   -1.37163023510,
   0.401647588297,   -14.8356627079,    92.7853928095,   -16.2402478326,   0.736566900475,    1.75832614461,
    7.39312816784,   -11.1390670812,   -15.7388762514,   -21.4912539598,    5.82889224441,    2.82072520664,
  -0.721810888033,   0.419196010992,    1.63743331504,   -1.67990502431,   -2.20778938257,   -2.81004665660,
   -3.31243791773,   -17.8574115966,    4.92079954057,    4.46226543485,   -4.44273544243,   -3.05018339346,
  -0.374619659663,    2.05840148048,   0.840501237418,    8.12910672884,   -1.49399239261,  -0.288433360886,
    9.35576439192,  -0.156025669468,   -1.29586693892,  0.0380088357487,   -7.06529346522,    9.09063855211,
    8.86483341561,   -1.67373580774,   -1.49196964868,   -4.21039938474,   -6.47364612549,   -3.88232908528,
   -1.32629124690,   -18.5389743861,    4.01875400135,    2.73539255755,   -2.80677249714,   -2.02802672410,
},
{
   -3.34650475961,  -0.244222984889,   -1.19922432959,    7.29488051492,   -4.45236155393,   -1.56432015213,
   -2.37033491174,   0.651472016817,   0.530475704478,   0.166041701236,  -0.963704921350,    2.11615664827,
  -0.143948880618,   0.407242738726,    2.01415320722,    2.91896715975,    1.20436215199,    4.24731476814,
   -1.95883804573,    4.41797286516,    3.73619642794,   -16.1553457842,   -1.21452928814,    1.02050137931,
    2.83654536530,    4.26622830396,    4.36501661673,    2.77259210961,    5.76091246408,    3.32517390895,
   -3.83870245603,   -1.87628143369,   -7.05793411218,   -1.53071571540,   -2.05718013166,  -0.612057989473,
    5.10925342427,    1.29179650177,   -1.52362951526,   -2.05981445593,    6.16196222431,   -5.10130764631,
    3.35728059368,    3.35790524138,   -4.50485903284,   -3.64730771509,   0.827377726153,   -3.66840017366,
  0.0169954512305,    3.58769338251,    13.8527965563,    11.6325047244,   -2.34515277457,    10.3804109113,
    1.97189302591,    4.11048986679,    3.51366877414,   -4.33004449477,  -0.774776264366,   -2.77795348368,
  -0.172708307440,   -10.0418795477,   -1.49196964868,   -3.90795863113,   -4.40445015800,   -3.40654646337,
   -1.83079589154,    1.83082030725,    4.81301106985,   -3.04232718639,   -5.79854447676,   -6.03427973474,
  -0.737208484589,   -15.1465558918,   -16.2402478326,    92.1365355516,   0.337099110791,    2.13648776433,
   -12.4019770743,    7.17934350437,   -1.14582454271,    2.98812055676,   -12.6814395874,   -16.9543023518,
   -2.02931849394, -0.0310057129430,    1.44529123062,   -2.70739810248,   -2.51407232447,   -4.20846320503,
   -1.05123128530,   -16.0949204373,    5.68294330736,    4.33952915306,   -3.82010252008,   -3.36354084830,
  0.0509280864459,    2.13971609673, -0.0789435747566,    7.96997978451,  -0.852923983700,  -0.257197740859,
    12.0459018356,    2.47431235715,   0.193453132463,   -2.45376070600,    8.61627206225,   -10.8310446324,
   -4.56923963793,    8.11963810962,   -1.95176042081,   -2.12699636533,   -6.59806078449,   -3.26077886935,
   -1.74931022596,   -19.5588218250,    2.90487823575,    2.57472739991,   -3.78922402605,   -2.54663857301,
},
{
   0.283448392274,   -4.05226447797,    6.33445073191,   -1.30327712967,   -1.40296912034,   -2.96608171915,
  -0.527049340161,   -3.49650206722,   -1.39059221097,   -3.12338044576,    1.43073220478,   0.170657990262,
  -0.376870686323,  -0.675888482944,   -1.29945312138,   -3.12338044576,   0.337099110791,  -0.156236616844,
    5.26249155547,   0.733919099735,   0.586904825889,  -0.156236616844,   -17.5987402266,   0.220345800761,
   -1.29945312138,    1.50831284227,  0.0977904398822,    2.72940983215,    1.43073220478,    2.78891110681,
   -3.50345230039,   -2.42952720868,   -1.43426408258,   -2.05718013166,   -1.50120357998,   -1.41387342026,
  -0.527049340161,    2.72940983215,   -3.50345230039,    2.61461575929,   -1.30327712967,  -0.195801329414,
  -0.675888482944,    1.31873349495,   -1.80231008148,  -0.873547681475,   -2.96608171915,   -1.01550367500,
   0.736566900475,   0.586904825889,   -1.39059221097,    1.50831284227,    1.76478425866,    1.31873349495,
  0.0977904398822,   -3.49650206722,    6.33445073191,    7.73624059467,   -2.42952720868,    11.0676035914,
  -0.948512871545,   -1.80231008148,   -1.43426408258,   -7.83212364819,    1.50969080752,   0.304161354887,
  -0.480848137140,   0.733919099735,   -4.05226447797,   -1.32849163946, -0.0662381676393,   -1.50027454550,
   -15.0432881193,  -0.480848137140,   0.736566900475,   0.337099110791,    89.5751633170,   -17.5987402266,
  -0.376870686323,    1.76478425866,  -0.948512871545,   0.241912282487,   -1.40296912034,   0.359573676015,
   -15.0432881193,    5.26249155547,   0.283448392275,    2.51277142788,   -14.1007388423,   -16.3606587886,
   -14.1007388423, -0.0662381676393,    1.50969080752,  -0.206560379201,    8.83892629996,    5.19487052725,
    2.51277142788,   -1.32849163946,    7.73624059467,  -0.195801329414,   0.359573676015,   -1.01550367500,
    2.61461575929,    11.0676035914,   -7.83212364819,    9.16556607048,   -1.41387342026,  -0.675358718959,
   0.241912282487,  -0.873547681475,   -2.05718013166,    9.16556607048,  -0.206560379201,   -3.27086927080,
   -16.3606587886,   -1.50027454550,   0.304161354887,   -3.27086927080,    5.19487052725,    1.38599815357,
},
{
   -3.02612919136,   -2.57697065912,    6.73360604526,   0.228970207248,   -3.05199614679,   -1.65265185841,
    1.27190685484,   -3.04675227459,  -0.642957914166,   -1.40380767879,    3.00380912726,    2.33797744968,
   -2.65468288836,    1.19185087310,  -0.614509431762,    2.04681763800,   -1.21452928814,    2.71948844032,
    4.02652212184,  -0.695741099095,    2.02175215248,    1.51405062145,  0.0681813707366,   -15.1998571420,
    3.05266424708,    2.92767457208,   0.646018777457,    1.45683591274,    3.96775742616,    4.68667942184,
  -0.541588753301,   -4.68783610204,   -5.73844782065,  -0.612057989473,   -1.41387342026,   -1.64566691985,
    1.64544241710,    4.03107288934,    1.78584284172,   -4.53452165872,    2.30547304932,   -2.66162830552,
   0.735988436246,   0.194605943195,   -4.82797426774,   -1.73724798100,    2.32430877087,   -3.54614834121,
  -0.601676628533,    2.89820975974,    1.31728951722,    1.14597346545,  -0.520669323459,    2.97337347268,
    10.7287014056,    11.4442099056,   0.854745298683,   -3.86961435551,    8.66578251209,   -5.85849699332,
  -0.627258344381,    2.13889983533,   -7.06529346522,  -0.936251126036,   -4.40138514720,   -5.72021533230,
   0.277616118533,    2.94467407897,   0.908235754809,   -4.80044307096,   -2.56168688630,   -3.93903347767,
   -15.3285798195,  -0.102612168783,    1.75832614461,    2.13648776433,   -17.5987402266,    92.6578117154,
    4.01280807894,    2.08159759315,   -2.32574635157,   -2.75853109518,    2.10113876234,   -3.24361929777,
    2.66720371507,   -14.6463852485,   -12.5737071842,   -17.8481897204,  -0.540637942149,    2.77691764137,
   -15.1668725173,   -1.19535906150,   0.216651853125,   -3.10671340685,    3.80636994282,    4.87083197795,
   0.692207431452,   -1.13547734156,    7.33279444374,   0.752358397718,   0.115820235337,   0.191498213268,
    2.22376399657,    12.1289294635,    7.93840729882,   -10.3530654949,   -1.37831976503,   -1.50296632734,
  -0.371207019862,   -1.05467036139,    8.61627206225,   -2.81745826544,   -1.14299204712,   -4.24027216807,
   -20.7829473955,   -2.27303616948,  -0.702321383383,   -1.68292210904,   0.342721870139,    1.85902383774,
},
{
   -3.80493410954,   0.842927830720,   0.248275334921,   0.111484934528,   -4.42205372104,    6.43466143584,
    1.86609684761,    2.34670913657,    1.97210592684,    3.01638553195,    3.35725030544,    2.61850268380,
   -1.03267698428,   -2.62487054875,  -0.175364901065,  -0.497817484562,  -0.143948880618,    2.84939790460,
   -1.66259948970,    2.37222909638,    7.54195229339,   -14.7745897265,   -2.65468288836,    1.65867317606,
    4.09190734571,    2.68655900288,    3.18541284620,    3.09071169008,    4.22568698788,    4.96241427809,
   -3.15515491248,   -2.85326303442,   -5.50478634897,   -3.64730771509,  -0.873547681475,   -1.73724798100,
    2.12704020822,    2.99488054707,   0.624602508586,   -3.29390863627,    1.54681324423,   -1.90101638341,
    5.95579816464,    2.14946668185,   -8.65304489492,   -2.69413426189,    3.81386715783,   -6.22632330604,
  -0.966763684304,  -0.158319857919,    10.3977310850,    11.3982255953,   -1.13586621270,   -9.04793938552,
    1.63364398023,   0.660741621798,    2.00594589649,   -1.71528642262,   -1.15408470499,   -2.98679387144,
   -2.54666298514,    9.13690958564,   -1.67373580774,   -2.74395919415,   -3.38273805882,   -3.83821499890,
    1.12185793523,   0.897125204738,    2.11540301866,   -1.88530104907,   -3.62453739721,   -3.06099501395,
  -0.981000615935,    2.63094122274,    7.39312816784,   -12.4019770743,  -0.376870686323,    4.01280807894,
    96.2328823514,   -11.3999775314,   -19.3172377973,    5.54952664487,   -10.8751916175,   -18.0301307705,
   0.752523437973,    2.26290931654,    3.58974770676,   -3.93793507938,   -7.37680265761,   -6.68837691359,
   -1.78235877809,    1.35133816440,   -17.7214813554,    2.34564145219,   -3.41068706800,   -2.61517726585,
-0.00969180416604,    3.20833846878,    1.06176307263,   0.663691969363,   -1.78976586390,    7.51502639263,
    1.72765665257,    1.60500993770,  -0.901028953118,   -3.18226111466,   -1.05467036139,   -1.28902728442,
   -5.42499548254,    18.2660662821,    8.11963810962,   -10.9041161162,   -4.03303910361,   -3.78271517431,
   -2.04081972113,    1.18570542996,   -18.3629095634,    1.55758494558,   -3.79629591723,   -3.35031062359,
},
{
   -1.38665779695,   0.448765444898, -0.0946103506733,  -0.838740155361,   -3.29214336856,    5.75150332245,
    2.27346737812,    2.71151189023,    1.61158816726,    3.62606894482,    3.26675519699,    2.02183256873,
   -1.13586621270,   -2.07282329380,    1.12394241249,  -0.580323425396,   -2.34515277457,   0.493403977792,
   -2.00355051992,   0.279843608035,   -12.7497104077,    4.85576722241,  -0.520669323459,   0.657839132651,
    2.25691717471,   0.821853551219,    1.81135952795,    1.06590212299,   0.219686486452,    1.36958351942,
  -0.755931664233,  -0.230667962931,   -3.32897663818,   -4.50485903284,   -1.80231008148,   -4.82797426774,
    2.54581189924,    3.46667425859,    1.31823289283, -0.0139864204816,    2.92211067478,  0.0967280348665,
    3.60317294936,    1.33472273249,   -3.16965487642,   -8.65304489492,   -1.03526516990,    2.62950027646,
    8.80731107037,    8.64381642659,  0.0849587942869,    1.01326108039,   -11.5051519493,    1.18069247113,
    3.59856635699,    2.73971784574,   0.831206512909,   -2.29004601420,    1.20692085121,   -2.48488946318,
    7.45957428690,   -1.41292452560,   0.882177110707,   -2.78247617573,   -4.32478909853,   -2.68209384482,
   0.208255474631,   0.292564966958,   0.909198892731,   -2.67167545957,   -4.94217489682,   -4.27782577163,
  -0.253091316952,    2.76337481959,   -11.1390670812,    7.17934350437,    1.76478425866,    2.08159759315,
   -11.3999775314,    97.9279254243,   -34.1516756924,   -18.8945373099,    4.66367182442,    4.70409238607,
   0.220846817197,   -1.77000131659,   -1.21391220419,   -1.37002058804,   -1.59619979390,  -0.986603121024,
   -3.10406777656,   0.532469675084,   -18.0786209612,    1.03529123844,   -3.81440143326,   -3.37577633747,
  -0.288593708110,    3.11848761998,    1.55270079570,    1.08285467559,   -1.77477694233,    6.85809515971,
   -1.11372675128,  -0.201661053047,   -2.64461858054,  -0.624657997254,    2.13889983533,  -0.726464919442,
    7.58738509851,    9.13690958564,   -10.0418795477,    5.60836397767,   -4.70149806626,   -3.82849120087,
   -2.50206994411,    1.20670176701,   -16.9846587415,    2.48195738147,   -2.76899080156,   -2.02151439206,
},
{
   0.121673303444,    2.74121610464,   -3.11650166621,   -3.39699380325,   -2.20848872348,    3.37785124710,
   -4.35783988847,   -3.21707086342,   -4.11852072757,   -1.78446843887,   -2.99515736580,   -3.35179369511,
   -2.54666298514,   -4.22320070153,   -6.28473382085,   -6.02998849958,  -0.172708307440,   -3.96373655670,
   -1.30237338382,    1.65480029254,   -18.0169750810,  -0.768481463569,  -0.627258344381,   -2.70772471001,
   -3.08262042966,   -5.35965896485,   -3.96916466957,   -5.17763354174,   -4.73781547117,   -3.78125589665,
   -1.74089982198,   -1.10748966817,    2.41906046605,    3.35790524138,    1.31873349495,   0.194605943195,
   -2.66294670741,   -1.96636597240,   -1.89452057505,  -0.771434475411,   -1.99850697532,   -1.55906670230,
   -5.64241517623,   -3.22786966042,    1.33472273249,    2.14946668185,    3.33342800563,   0.719583277667,
   -11.3978370566,    4.48066186429,   -3.07052267766,   -2.79810435903,    7.45957428690,  -0.586681818738,
   -4.39348055773,   -5.04394247808,   -2.98199746189,   0.301302209952,   -1.38639355346,    1.04860798325,
    6.93429729132,    1.18069247113,  -0.642532653427,    1.41439353302,    1.32288537996,    1.06752938523,
    1.84284292672,   -2.18819474404,   -1.79665727600,    1.23620042522,    3.10256892136,    3.37896290047,
 -0.0713480282071,    2.73461452022,   -15.7388762514,   -1.14582454271,  -0.948512871545,   -2.32574635157,
   -19.3172377973,   -34.1516756924,    97.5106165352,   -12.0586768221,    3.18700577505,    3.72198225871,
    2.39181914006, -0.0647828994834,   0.317009408644,    3.69530622097,    3.94431849865,    4.18885217231,
    3.12219281403,    6.06537020449,   -12.2102995519,    6.65935094182,    1.53728882691,    1.67444252606,
    1.99892364104,    4.62640633331,   0.827827410776,  -0.208344798672,  -0.330263365747,    6.70357901341,
   -1.38754417573,  -0.295170575584,    2.25917246856,    4.67724015175,    2.97337347268,   0.888231594353,
    10.0677163024,   -9.04793938552,    10.3804109113,    9.16691233076,   0.823733923179,    1.07416732004,
    4.57598222658,    6.95343835880,   -11.2505893766,    7.91720330292,    3.17903115692,    3.37243472607,
},
{
   0.171732966065,    2.55767805912,   -2.30497741046,   -4.48756391546,    5.99953633686,   -4.31705493911,
   -4.09579126929,   -3.08366691349,   -3.12264250823,   -5.08978296436,   -3.84237277717,   -4.80906526575,
   -5.42499548254,   -1.17578717837,   -3.19563732100,   -4.70358055171,   -4.56923963793,   -5.67174203167,
  -0.344176823369,    1.78263563452,   -21.0330481220,    1.73375230332,  -0.371207019862,   -3.45806031990,
   -4.23601380227,   -2.53196272433,   -2.92596621497,   -4.03545319173,   -3.90690736715,   -3.49946492897,
   -2.13442715547,  -0.308055041427,    1.34710462072,    3.35728059368,  -0.675888482944,   0.735988436246,
   -8.02880140394,   -7.29749260730,   -1.45370351642,    2.89791410635,   -4.08938603508,    2.43658406577,
   -3.59775002064,   -5.64241517623,    3.60317294936,    5.95579816464,   -6.24502277907,    3.90350490143,
    8.86483341561,   -10.5458301759,   -5.41431685967,   -4.36964974991,    7.58738509851,   -4.22320070153,
   -3.49052670024,   -4.19782340310,   -2.07073322809,    1.71359022390,  -0.532432213488,    2.16723095516,
    10.0677163024,   -2.07282329380,    1.40874140874,    3.70110750688,  -0.242624434201,   0.677327563698,
   -2.26824927103,  -0.979733462898,   -1.92029423174,    2.85356476469,    1.22098483369,    1.51214093103,
  -0.518408162699,    1.72187882714,   -21.4912539598,    2.98812055676,   0.241912282487,   -2.75853109518,
    5.54952664487,   -18.8945373099,   -12.0586768221,    92.9081609273,   -18.3575303507,   -10.6187303080,
  -0.523543280774,   -1.08325212653,   -2.05132354587,    2.94636891811,    3.33357224677,    3.61354047806,
    5.24852905716,    7.33859822326,    9.26811669461,   -10.9696196737,    5.08742069869,    5.57269052947,
    2.38840824158,    4.75341046185,   0.405950073014,   -1.16278277850,    7.92839152050,   -1.87300467473,
   -1.09661117537,   0.580982753522,    1.92792536871,    5.69324816715,    1.19185087310,    2.77936969810,
    3.45654007290,   -2.62487054875,   0.407242738726,   0.783079248832,    11.4112320403,    11.9233162716,
    4.08962687016,    6.66691905449,    8.51096261755,   -12.2432643529,    3.43150830196,    3.95757418947,
},
{
   -2.34887107486,   0.516993015810,  -0.818593816318,  -0.503684885921,    2.94669958734,   -1.29869010121,
   0.892384226942,   0.934294689249,    2.93182498382,    1.17416486145,    2.76659868630,    2.64266037378,
   -4.42205372104,   -1.87300467473,    3.95791893946,    1.77152941632,   -4.45236155393,   0.124039501753,
   -2.53679733505,    1.63938994047,    4.48072367247,   -12.6457044171,   -3.05199614679,    1.70988267819,
    1.39081975589,   0.266964585737,   -1.77820375188, -0.0206401687921,    4.63861937546,    4.82579845901,
   0.559476174582,  -0.811815197803,   -1.20360863110,   -3.66840017366,   -1.01550367500,   -3.54614834121,
    3.06745698764,    3.23350409469,  -0.831516026082,   -5.15925382175,    1.53038477142,   -4.77986206737,
    3.90350490143,   0.719583277667,    2.62950027646,   -6.22632330604,    1.77456287105,   -5.34623743353,
   -2.65884432854,    1.96270324942,    11.9416522898,   -7.23976744124,   -3.29214336856,    6.70357901341,
    4.27652301649,    2.06125308493,    1.32988350128,   -4.22796727586,    1.05528116547,   -2.55234384466,
   -2.20848872348,    6.85809515971,  -0.288433360886,   -4.73280164616,   -4.70370169779,   -1.61502794398,
   -2.27239000576,    1.65442854956,    3.27367538387,   -2.36940709009,   -3.78092960240,  -0.537906001096,
  -0.607028592293,    3.75027773845,    5.82889224441,   -12.6814395874,   -1.40296912034,    2.10113876234,
   -10.8751916175,    4.66367182442,    3.18700577505,   -18.3575303507,    98.2195915061,   -36.2386704698,
   -1.19832194615,    3.47037493945,    3.01521299803,   -3.44918321285,   -3.58084102688,   -2.43434134683,
  -0.561114436965,    3.91173751298,    5.30877759488,   -17.3542721770,   -5.29277408478,   -4.17525572483,
  -0.299951186682,    2.87816600487,   0.613440673968,    1.30130103982,    6.12522600352,   0.339061376455,
    2.87309717622,   0.429846443576,   0.618454666887,   -2.77501741267,   0.191498213269,   -1.74755203283,
    5.99953633686,    7.51502639263,  -0.257197740859,   -1.48524032158,    6.35850336621,   -11.9243045226,
   -1.46189605730,    1.30519160208,    2.52869602862,   -16.7634577374,   -2.93284896764,   -2.00425841399,
},
{
   0.247177449112,    2.16874029149,   -2.56428697012,   -3.31540906326,    6.12522600352,   -4.73421493710,
   -3.57155025876,   -2.90479889313,   -1.63606896922,   -3.99370888359,   -3.14490568256,   -3.31381710689,
   -1.78976586390,   -4.31705493911,   -4.77212084362,   -2.90566379430,  -0.852923983700,   -6.13796778300,
    1.19191624916,    1.88972013476,   0.702694944772,   -18.1647344400,   0.115820235337,   -4.74087329353,
   -4.33829916575,   0.888583249480,  -0.402406864486,   -2.78206804744,   -5.49689862569,   -5.33485524048,
   -2.68666481829,  -0.822099283250,    2.35700464670,   0.827377726153,   -2.96608171915,    2.32430877087,
   -3.52702931314,   -3.30981984540,   -1.32677197557,    1.93512326132,   -4.37094940786,    2.28539648409,
   -6.24502277907,    3.33342800563,   -1.03526516990,    3.81386715783,   -5.22527665799,    1.77456287105,
   -1.49399239261,   -2.99859433160,   -13.1943048089,    6.34108150200,   -1.77477694233,    3.37785124710,
   -3.78301578534,   -1.97808516555,   -2.85350911338,    3.51750054562,   -2.03263840131,    1.12297208977,
  -0.330263365747,    5.75150332245,   -2.88072342083,    1.10735995817,    3.85417816513,    2.96750226889,
  -0.159705863318,  -0.973849166874,   -4.56409239301,    1.89214896281,    4.35351409207,    3.36886108025,
    2.52120643985,    2.76544260503,    2.82072520664,   -16.9543023518,   0.359573676015,   -3.24361929777,
   -18.0301307705,    4.70409238607,    3.72198225871,   -10.6187303080,   -36.2386704698,    98.0986307305,
   -1.72833866992,   -2.67053226402,   -4.19712666694,    2.61336859710,    3.04775298559,    4.13254115806,
    2.28514157604,    2.28500868480,    4.27517288855,   -11.2385279478,    4.96993552301,    6.04967090955,
    2.24103669192,    3.72152299620, -0.0823657666345,   -1.07761585802,    8.01997590090,   -1.29869010121,
   -1.11357560461,    1.55050062551,    4.62879146440,    1.73634316499,   -1.65265185841,    3.04187382428,
    7.92839152050,    6.43466143584,   -1.56432015213,    3.03302590491,   -7.09732086170,    13.3534507787,
    3.34668012401,    4.96574729528,    7.19934538749,   -11.6729786631,    2.76355973272,    3.97585019365,
},
{
    1.56010340800,    4.38149458079,   -2.70812576928,   -2.36678986350,  -0.607028592293,   -2.68666481829,
  0.0872816773913,   -1.23652875064,   0.450688627235,  -0.655500619147,   -1.39758341021,  -0.822761627120,
  -0.981000615935,   -2.13442715547,   0.768747418436,   -1.79190636860,  -0.737208484589,   -1.74888357212,
    2.67912768460,   -4.01214234100,   -2.50966202192,   -4.10591299042,   -15.3285798195,    2.17786885862,
   -1.01728261213,   -2.05191827869,   -3.73188144194,   -2.97318505675,   0.963561730308,   0.493511139924,
    4.68499435657,   -1.13007910406,    1.65895067518,   -1.52362951526,   -3.50345230039,    1.78584284172,
   0.648060105356,  -0.405485447228,  -0.807975698449,   -1.92153663320,   -2.52050917818,  -0.610894684855,
   -1.45370351642,   -1.89452057505,    1.31823289283,   0.624602508586,   -1.32677197557,  -0.831516026082,
   0.401647588297,  -0.701150313907,   -2.42287091649,  -0.234511347270,  -0.253091316952,   -1.74089982198,
   0.306914586681,   -1.31988516118,    4.42099749479,    8.66481634482,    1.68797633181,   -10.7280805275,
 -0.0713480282071,  -0.755931664233,  -0.673633309049,    7.75620353226,   -1.18330443691,   -1.05510526828,
  -0.775329098765,   -1.65035733438,   -1.34997010910,   0.839919235494,  -0.424687356220,  0.0688474955952,
    3.27695081497,   -1.61785491827,  -0.721810888033,   -2.02931849394,   -15.0432881193,    2.66720371507,
   0.752523437973,   0.220846817197,    2.39181914006,  -0.523543280774,   -1.19832194615,   -1.72833866992,
    95.5885613006,   -14.7303964383,    2.44549621665,    3.60249764016,   -32.3095409893,   -14.7625052036,
    3.84465259820,  -0.272497579815,    3.39335561421,   0.313854286943,   -13.2965885945,    3.17239108681,
    2.94831173152,    6.32770429109,   0.110396462681,    2.15730956894,    2.52120643985,   0.559476174582,
    4.38226922329,  -0.267792101053,    2.82235210499,  -0.486534657962,  -0.541588753301,    1.80036779883,
  -0.518408162699,   -3.15515491248,   -3.83870245603,    8.03071032466,    1.83839328834,    1.17284223635,
    4.72477703040,    10.0730498543,   -7.84888069700,    7.54335481944,   -14.7753124299,    1.42851903350,
},
{
   -1.48444614454,    5.17250072782,   -2.15700853736,  -0.546162441077,   -2.53679733505,   -1.11357560461,
    1.96844187389,   -1.20420235933,    1.57698579440,   0.625586580876,   0.135824431576,    1.77926900938,
   -1.66259948970,   -1.09661117536,   0.261943941164,    2.37060247004,   -1.95883804573,    2.22998910694,
   0.960378711611,   -4.73130890527,   -1.91084817595,   -1.91776405385,    4.02652212184,   -14.8400567409,
    2.99608668066,  -0.233985776625,   -6.40891589527,  -0.685276785438,    3.57441254429,    1.92241176595,
    4.38226922329,   0.265231994911,  -0.995124191103,   -2.05981445593,    2.61461575929,   -4.53452165872,
    2.40375639965,    1.20036859623,   -1.92153663320,   -2.98718992499,    2.87699128121,   -4.43349551400,
    2.89791410635,  -0.771434475411, -0.0139864204816,   -3.29390863627,    1.93512326132,   -5.15925382175,
   -2.04207166717,    1.28248388672,    1.87942139897, 0.00817510064860,   -2.00355051992,   -1.38754417573,
    11.7288926780,    12.9423641628,   0.592951516896,   -5.02467448805,   -10.4459740465,   -4.10554906252,
   -1.30237338382,   -1.11372675128,    9.35576439192,   -4.87087529660,   -2.18365247431,   -2.27640071874,
  -0.379801943548,    1.87872915877,    2.38263262964,   -1.25286666352,   -3.07743593625,   -3.31927402712,
    2.67912768460,   -1.15480161496,   0.419196010992, -0.0310057129430,    5.26249155547,   -14.6463852485,
    2.26290931654,   -1.77000131659, -0.0647828994834,   -1.08325212653,    3.47037493945,   -2.67053226402,
   -14.7303964383,    92.4347819176,   -11.7602653513,   -15.5611255551,   -17.6100253304,    4.34231891950,
    3.14499930424,   -1.36735936182, -0.0859737999384,  -0.622281335680,   -18.8896883403,    3.23042948793,
   0.934777145256,    7.13294881956,  -0.491483243017,    2.86356084676,    1.19191624916,    2.87309717622,
    3.56684831254,   0.829071607073,  -0.230362026411,  -0.850722933852,    2.22376399657,   -1.69920580331,
  -0.344176823369,    1.72765665257,    12.0459018356,   -5.30094184162,   -4.19956382234,   -4.40884437221,
   0.659261570580,    8.54277559021,    9.88998691768,   -9.39177531702,   -19.8582350703,    2.31078513921,
},
{
    5.44933609520,   -2.90550450174,   -2.05424388182,  -0.548063667065,   -2.34887107486,   -1.07761585802,
   0.859606531259,   0.590633792225,    1.26843494328,   0.788072126217,    1.72684525309,    1.90846053913,
   -3.80493410954,   -1.16278277850,    2.22704751677,    1.61928012390,   -3.34650475961,    1.70972351290,
   -1.48444614454,   -2.13068687021,   0.835336974273,    1.01893534483,   -3.02612919136,   -13.8647322686,
    2.17703943527,   -5.44848887444,   -2.88743618262,   -2.08846228834,    4.24056105166,    3.81509686603,
    2.15730956894,    2.02872233283,    1.32144544549,   -5.10130764631,  -0.195801329414,   -2.66162830552,
    2.27752614391,    1.78089271632,  -0.610894684855,   -4.43349551400,    1.74181938409,   -4.26269341359,
    2.43658406577,   -1.55906670230,  0.0967280348665,   -1.90101638341,    2.28539648409,   -4.77986206737,
   -1.39501835562,    2.01281383095,    1.39654183047,    1.93731693654,   -1.38665779695,  -0.208344798672,
   -8.41395982155,    12.5879849047,    2.04238410188,   -6.65812491595,    7.79473120283,   -6.05454160848,
   0.121673303444,    1.08285467559,    8.12910672884,   -4.14858224039,   -1.74931105086,   -4.09070881500,
 -0.0846387143668,    2.16993674850,    3.47959864133,   -5.36799149000,   -1.83014139735,   -3.96687513396,
    1.56010340800,  -0.324682637397,    1.63743331504,    1.44529123062,   0.283448392274,   -12.5737071842,
    3.58974770676,   -1.21391220419,   0.317009408644,   -2.05132354587,    3.01521299803,   -4.19712666694,
    2.44549621665,   -11.7602653513,    101.702796460,   -35.4362488569,  -0.358971552026,   -17.4134339546,
    1.81852923469,   0.100981600673,    1.02605720546,  -0.983369342872,    1.02558937862,   -15.7714696397,
    8.87802925086,    1.25294322978,    1.68554765668,    1.95882504879,   0.247177449112,    1.30130103982,
    2.86356084676,    1.62075751509,    1.39656074305,   -1.41314885590,   0.752358397718,   -1.00718051189,
   0.171732966065,   0.663691969363,    7.96997978451,   -3.25072542614,  -0.817545630271,   -2.90571696531,
    10.1470993263,    1.16047660536,    1.88772939286,   -1.43661669760,    8.60717933673,   -29.6934146419,
},
{
    8.87802925086,   -2.54840826787,   -3.64547457306,   -3.12036899949,  -0.299951186682,   -3.31540906326,
   -3.76674627657,   -3.52437410739,   -3.16798642674,   -4.27079623153,   -4.23299685560,   -3.80182453265,
-0.00969180416601,   -4.48756391546,   -6.87236432478,   -3.20809872200,  0.0509280864458,   -4.11294492957,
   0.934777145256,  -0.222808488642,   -2.90899564007,   -4.34479292116,   0.692207431452,   -21.4030642441,
   -7.18637400837,   -1.43305365901,   -1.82528689767,   -4.09790992519,   -6.03443377457,   -6.40393467745,
   -2.36678986350,    2.26535029574,  -0.794133342961,    6.16196222431,   -1.30327712967,    2.30547304932,
   -3.42432463260,   -3.60435018208,   -2.52050917818,    2.87699128121,   -3.95123677566,    1.74181938409,
   -4.08938603508,   -1.99850697532,    2.92211067478,    1.54681324423,   -4.37094940786,    1.53038477142,
  -0.374619659663,   -3.04136462819,   -2.11136224508,   -5.59032944961,  -0.288593708110,   -3.39699380325,
    3.95300330661,   -13.9285718417,   -2.23364079297,    2.03244291996,    3.05921950333,   0.466615290388,
    1.99892364104,  -0.838740155361,    5.80288007867,    1.02899668126,    5.39916098902,    3.11372650763,
  -0.329815234990,   -2.12754545184,   -2.88446862464,    1.54283271895,    4.26729074902,    1.88099997551,
    2.94831173152,  0.0824510449375,   -1.67990502431,   -2.70739810248,    2.51277142788,   -17.8481897204,
   -3.93793507938,   -1.37002058804,    3.69530622097,    2.94636891811,   -3.44918321285,    2.61336859710,
    3.60249764016,   -15.5611255551,   -35.4362488569,    96.4300399384,    8.42273496448,   -12.9037604338,
    6.44221687032,    3.17949645052,    4.83644746149,    3.66237190690,    8.35094501318,   -12.4658563158,
    13.1815685886,   0.795755172129,   0.723831726613,  -0.548063667065,    2.24103669192,  -0.503684885921,
  -0.546162441077,    3.19550859524,    2.06849456445,    5.34531479332,   0.228970207248,    2.52173697735,
    2.38840824158,   0.111484934528,    7.29488051492,    1.03203693157,    4.32886732400,    2.55730386708,
    13.6325647973,  -0.338532291702,    1.39551041680,    5.44273872863, -0.0679883047310,   0.514937591235,
},
{
    1.81852923469,    4.44558063180,   -3.61315415637,   -4.09790992519,  -0.561114436965,   -2.78206804744,
   -5.83850222330,   -7.88914111836,   -6.83419264548,   -7.04349262793,   -7.04252427141,   -6.75964659113,
   -1.78235877809,   -4.03545319173,   -8.70938048563,   -8.09631305473,   -1.05123128530,   -4.67353237935,
    3.14499930424,   -2.67538276240,   -7.65647231212,   -7.68846714904,   -15.1668725173,   -2.37328471558,
   -9.22655396238,   -3.44409149145,   -3.84681126387,   -2.60446624975,   -9.33786975830,   -12.4512214806,
   -2.97318505675,   0.688957879569,    3.62078617726,    1.29179650177,    2.72940983215,    4.03107288934,
   -7.90607148418,   -6.10713465110,  -0.405485447228,    1.20036859623,   -3.60435018208,    1.78089271632,
   -7.29749260730,   -1.96636597240,    3.46667425859,    2.99488054707,   -3.30981984540,    3.23350409469,
   -3.31243791773,   -6.13678692008,   -8.44202922569,   -8.64938121805,   -3.10406777656,   -5.17763354174,
   -7.53423166744,   -8.50314641749,    5.38238026713,   -8.39291090002,   0.303358116588,    11.4762396034,
    3.12219281403,    1.06590212299,   0.501243283029,    11.0614215636,    5.10529079514,    3.94284580098,
  -0.425236423370,   -2.26857129554,   -2.40015513230,    5.24659988964,    6.25670358802,    4.86683987463,
    3.84465259820,   0.992142461532,   -2.20778938257,   -2.51407232447,   -14.1007388423,  -0.540637942149,
   -7.37680265761,   -1.59619979390,    3.94431849865,    3.33357224677,   -3.58084102688,    3.04775298559,
   -32.3095409893,   -17.6100253304,  -0.358971552026,    8.42273496448,    102.739840617,   -8.33851406616,
    9.59785708953,    6.53891567913,    5.85134547356,    4.98178812755,   -7.53144107416,    8.69796976280,
    6.44221687032,    8.91907078347,   0.573983294049,   -2.08846228834,    2.28514157604, -0.0206401687921,
  -0.685276785438,    2.71510318704,    5.59187838003,    3.07354155736,    1.45683591274,    2.92665381643,
    5.24852905716,    3.09071169008,    2.77259210961,    13.2970436677,    7.02062231512,    6.09790724766,
    9.54021935880,   -5.29735570343,    15.5349777304,    12.3088134260,   -9.37774635473,    7.06585597865,
},
{
    10.1470993263,   -3.45130216438,   -4.26389011473,   -3.76674627657,   -1.46189605730,   -3.57155025876,
   -7.61047757684,   -5.03263931039,   -5.37432696832,   -6.20630988686,   -7.62228100824,   -6.79922199279,
   -2.04081972113,   -4.09579126929,   -8.56595466210,   -7.84653437912,   -1.74931022596,   -4.91534081789,
   0.659261570580,  -0.607862524868,   -3.35210644563,   -5.14678983453,   -20.7829473955,   -2.00135462423,
   -8.49276272601,   -3.45626513000,   -3.58332670710,   -5.83850222330,   -11.8893635232,   -9.79598600926,
  0.0872816773914,   -2.14215935276,    7.30349562037,    5.10925342427,  -0.527049340161,    1.64544241710,
   -5.10373631855,   -7.90607148418,   0.648060105356,    2.40375639965,   -3.42432463260,    2.27752614391,
   -8.02880140394,   -2.66294670741,    2.54581189924,    2.12704020822,   -3.52702931314,    3.06745698764,
   -1.32629124690,   -4.18361147861,   -6.50929731674,   -7.61785716243,   -2.50206994411,   -4.35783988847,
   -10.0869608861,   -7.88809678529,   -14.0912440427,    10.8670443194,   -3.02221399632,    11.0796491579,
    4.57598222658,    2.27346737812,   -1.83170587234,    13.2137268024,    6.13080095654,    4.40043954301,
   0.119462679144,   -2.59637492575,   -1.75773570496,    1.83617274451,    5.64432273403,    3.82132646761,
    4.72477703040,  -0.217621232298,   -2.81004665660,   -4.20846320503,   -16.3606587886,    2.77691764137,
   -6.68837691359,  -0.986603121024,    4.18885217231,    3.61354047806,   -2.43434134683,    4.13254115806,
   -14.7625052036,    4.34231891950,   -17.4134339546,   -12.9037604338,   -8.33851406616,    94.1372306530,
    9.54021935880,    4.93464750296,    5.84810605862,    5.27981451917,    11.0883737153,   -13.6004620130,
    13.6325647973,   0.314755923607,   -1.39535571638,   0.859606531259,    3.34668012401,   0.892384226942,
    1.96844187389,  -0.538823633149,    6.04429774214,    3.78761175390,    1.27190685484,    3.60711007986,
    4.08962687016,    1.86609684761,   -2.37033491174,    12.8234289622,    5.93887287961,    4.11196661190,
    2.95258478977,    6.24180265424,    7.27804666997,    5.43369561992,    23.4873253383,   -1.09564831427,
},
{
  -0.358971552026,   -2.40015513230,    5.38238026713,   -3.60435018208,   -3.58084102688,   -3.30981984540,
   -7.90607148418,   -8.50314641749,   -8.44202922569,   -8.09631305473,   -9.33786975830,   -6.75964659113,
   -7.37680265761,   -7.29749260730,   -9.22655396238,   -7.04349262793,   -2.51407232447,   -7.68846714904,
   -17.6100253304,   -2.26857129554,   -6.13678692008,   -4.67353237935,  -0.540637942149,   -2.37328471558,
   -8.70938048563,   -8.64938121805,   -7.53423166744,   -6.10713465110,   -7.04252427141,   -12.4512214806,
  -0.405485447227,   0.303358116589,   0.501243283029,    2.77259210961,    2.72940983215,    1.45683591274,
   -5.83850222330,   -2.60446624975,   -2.97318505675,  -0.685276785438,   -4.09790992519,   -2.08846228834,
   -4.03545319173,   -5.17763354174,    1.06590212299,    3.09071169008,   -2.78206804744, -0.0206401687921,
   -2.20778938257,   -7.65647231212,   -6.83419264548,   -3.44409149145,   -1.59619979390,   -1.96636597240,
   -3.84681126387,   -7.88914111836,   -3.61315415637,   0.573983294049,   0.688957879569,    2.71510318704,
    3.94431849865,    3.46667425859,    3.62078617725,    5.59187838003,    5.85134547356,    15.5349777304,
   0.992142461532,   -2.67538276240,    4.44558063180,    8.91907078347,    6.53891567913,   -5.29735570343,
   -32.3095409893,  -0.425236423370,   -3.31243791773,   -1.05123128530,   -14.1007388423,   -15.1668725173,
   -1.78235877809,   -3.10406777656,    3.12219281403,    5.24852905716,  -0.561114436965,    2.28514157604,
    3.84465259820,    3.14499930424,    1.81852923469,    6.44221687032,    9.59785708953,    9.54021935880,
    102.739840617,    6.25670358802,    5.10529079514,    7.02062231512,   -7.53144107416,   -9.37774635473,
    8.42273496448,    5.24659988964,   -8.39291090002,    1.78089271632,    3.04775298559,    3.23350409469,
    1.20036859623,    11.4762396034,    11.0614215636,    13.2970436677,    4.03107288934,    2.92665381643,
    3.33357224677,    2.99488054707,    1.29179650177,    3.07354155736,    4.98178812755,    12.3088134260,
   -8.33851406616,    4.86683987463,    3.94284580098,    6.09790724766,    8.69796976280,    7.06585597865,
},
{
   -1.83014139735, -0.0622295296345,   -4.06087251037,    3.95300330661,   -3.78092960240,   -3.78301578534,
   -10.0869608861,   -8.52814552557,   -9.94818435373,   -6.79002948435,   -6.78794619835,   -10.1740482357,
   -3.62453739721,   -3.49052670024,   -5.77589734195,   -8.51024383753,   -5.79854447676,   -7.13738360177,
   -3.07743593625,   -17.8224916068,   -3.79742931057,   -1.80161412778,   -2.56168688630,   -3.49132852619,
   -5.38655433290,   -7.06730433692,   -5.19815138695,   -7.53423166744,   -13.0398138120,   -5.72755448944,
   0.306914586681,   0.598478445137,    2.06949985359,    4.36501661673,  0.0977904398823,   0.646018777457,
   -3.58332670710,   -3.84681126387,   -3.73188144194,   -6.40891589527,   -1.82528689767,   -2.88743618262,
   -2.92596621497,   -3.96916466957,    1.81135952795,    3.18541284620,  -0.402406864486,   -1.77820375188,
   -3.21798506775,   -3.88179659482,   -4.70767664646,   -6.47950333593,   -4.94217489682,   -4.39348055773,
   -4.33084423350,   -3.00247208670,  -0.644118167803,    2.59871803433,   0.515781867353,    1.48147473050,
    3.10256892136,    3.59856635699,    2.07207252862,    2.69155885333,    13.8048763306,    2.52357226846,
    9.55041595013,    7.67248056184,   0.110396186431,    2.90077588087,   -5.21236288663,    4.91037153642,
  -0.424687356220,   -31.9189739166,   -17.8574115966,   -16.0949204373, -0.0662381676392,   -1.19535906150,
    1.35133816440,   0.532469675084,    6.06537020449,    7.33859822326,    3.91173751298,    2.28500868480,
  -0.272497579815,   -1.36735936182,   0.100981600673,    3.17949645052,    6.53891567913,    4.93464750296,
    6.25670358802,    102.873000337,   -8.61710023958,   -7.46208658743,    4.90918856470,    5.11985745270,
    4.26729074902,    6.91329582535,    2.82412258514,   -8.41395982155,    4.35351409207,    4.27652301649,
    11.7288926780,    2.46454329810,    3.49246198396,    5.49448637986,    10.7287014056,    10.7075152535,
    1.22098483369,    1.63364398023,    1.97189302591,    2.44550709798,    11.2369380302,    2.33851044078,
    5.64432273403,   -8.29754156395,    7.21247353087,    9.29575996071,    5.25351092114,    5.36585346694,
},
{
   -1.74931105086,   0.926481665246,   -2.42109281648,   -5.59032944961,   -4.70370169779,    6.34108150200,
   -7.61785716243,   -7.35459035667,   -6.01767315498,   -7.15385672093,   -6.46198437092,   -5.73626900280,
   -3.38273805882,   -4.36964974991,   -7.81212664565,   -6.93544144105,   -4.40445015800,   -5.52024849453,
   -2.18365247431,   -18.7096452661,    1.21387395923,   -3.35219702054,   -4.40138514720,   -5.75346587156,
   -11.4856321658,   -6.28804067827,   -7.06730433692,   -8.64938121805,   -7.39504638297,   -7.03341058696,
  -0.234511347270,   0.341986528276,    1.12502630644,    4.26622830396,    1.50831284227,    2.92767457208,
   -3.45626513000,   -3.44409149145,   -2.05191827869,  -0.233985776625,   -1.43305365901,   -5.44848887444,
   -2.53196272433,   -5.35965896485,   0.821853551219,    2.68655900288,   0.888583249480,   0.266964585737,
   -4.29947966233,   -7.34212250355,   -7.00279693580,   -8.41736996603,   -4.32478909853,   -2.79810435903,
   -6.47950333593,   -5.70466629849,   -3.77733627693,   0.116066517666,  -0.332001041841,    1.14479443151,
    1.32288537996,    1.01326108039,    1.12338280046,    2.13910789756,    15.1580747943,    4.15777877683,
   -9.90097087751,    7.59505512494,   -2.37331479701,    1.34264207773,    13.8048763306,    2.18987516681,
   -1.18330443691,   -14.6112811453,    4.92079954057,    5.68294330736,    1.50969080752,   0.216651853125,
   -17.7214813554,   -18.0786209612,   -12.2102995519,    9.26811669461,    5.30877759488,    4.27517288855,
    3.39335561421, -0.0859737999384,    1.02605720546,    4.83644746149,    5.85134547356,    5.84810605862,
    5.10529079514,   -8.61710023958,    94.7298696159,   -12.0020462898,    3.32405577632,    3.49249165404,
    5.39916098902,    7.85572434880,    3.72182254444,    1.93731693654,    3.85417816513,   -7.23976744124,
 0.00817510064859,    2.60278409476,    3.05273950099,    4.82287665170,    1.14597346545,    1.57770453761,
  -0.242624434201,    11.3982255953,    11.6325047244,    12.5784802369,    14.1327613027,    3.23790008991,
    6.13080095654,    11.7034791276,   -12.0089431300,    9.42849253750,    5.42245148490,    5.64316448556,
},
{
  -0.817545630271,    1.88241502240,   -2.87516480264,   -6.87236432478,    6.35850336621,   -4.77212084362,
   -8.56595466210,   -5.44641221973,   -8.74645850396,   -6.84928104137,   -6.79811016906,   -8.15448489157,
   -4.03303910361,   -3.19563732100,   -7.15322553675,   -7.36867393869,   -6.59806078449,   -5.59596919541,
   -4.19956382234,   -21.5884745239,   -3.89444925619,    1.42580257187,   -1.14299204712,   -3.70888639990,
   -4.49896444709,   -11.4856321658,   -5.38655433290,   -8.70938048563,   -6.50728434006,   -6.35861885328,
   0.768747418436,    1.00101216412,    1.45528844758,    2.83654536530,   -1.29945312138,    3.05266424708,
   -8.49276272601,   -9.22655396238,   -1.01728261213,    2.99608668066,   -7.18637400837,    2.17703943527,
   -4.23601380227,   -3.08262042966,    2.25691717471,    4.09190734571,   -4.33829916575,    1.39081975589,
   -6.47364612549,   -3.76698308645,   -7.33354399261,   -7.81212664565,   -4.70149806626,   -6.28473382085,
   -5.77589734195,   -4.53722062451,   -3.06686059009,    1.76170682652,   0.625326118133,    2.00550909998,
   0.823733923179,    1.12394241249,    2.91476006270,    4.70811456921,    14.1327613027,    3.47335810570,
    6.29032662774,   -11.8168960818,   -2.22568304570,    2.75496955568,    11.2369380302,    1.26119834948,
    1.83839328834,   -13.1120021898,    4.46226543485,    4.33952915306,  -0.206560379201,   -3.10671340685,
    2.34564145219,    1.03529123844,    6.65935094182,   -10.9696196737,   -17.3542721770,   -11.2385279478,
   0.313854286943,  -0.622281335680,  -0.983369342872,    3.66237190690,    4.98178812755,    5.27981451917,
    7.02062231512,   -7.46208658743,   -12.0020462898,    98.6684618307,    7.18696222212,    7.31803758939,
    4.32886732400,    7.42132958226,    3.51283765151,    2.22704751677,   -7.09732086170,    3.95791893946,
   0.261943941164,    2.25972447542,    2.87287451220,    5.71434286053,  -0.614509431762,    4.67733974278,
    11.4112320403,  -0.175364901065,    2.01415320722,    3.81743460173,    24.6607223608,    13.9006086275,
    5.93887287961,    11.4517516335,    6.80378366108,   -9.87229649908,    5.82666009926,    5.83649997367,
},
{
    1.02558937862,    8.38996332437,   -4.86937681595,   -6.40393467745,   -5.29277408478,   -5.33485524048,
   -9.79598600926,   -6.53319254708,   -9.33963865749,   -7.93679465698,   -8.67247228685,   -10.7815827017,
   -3.41068706800,   -3.49946492897,   -6.35861885328,   -7.93679465698,   -3.82010252008,   -6.26867919373,
   -18.8896883403,   -3.81099339358,   -7.03436867550,   -6.26867919373,    3.80636994282,   -1.38620940730,
   -6.35861885328,   -7.03341058696,   -5.72755448944,   -12.4512214806,   -8.67247228685,   -7.53425426384,
   0.493511139924,    1.15099202692,   0.691587687635,    3.32517390895,    2.78891110681,    4.68667942184,
   -9.79598600926,   -12.4512214806,   0.493511139924,    1.92241176595,   -6.40393467745,    3.81509686603,
   -3.49946492897,   -3.78125589665,    1.36958351942,    4.96241427809,   -5.33485524048,    4.82579845901,
   -4.44273544243,   -7.03436867550,   -9.33963865749,   -7.03341058696,   -3.81440143326,   -3.78125589665,
   -5.72755448944,   -6.53319254708,   -4.86937681595,    2.43697755210,    1.15099202692,   0.606401472974,
    1.53728882691,    1.36958351942,   0.691587687635,    1.19761159601,    3.32405577632,    13.6763017879,
  -0.928902843985,   -3.81099339358,    8.38996332437,   -5.55402788282,    4.90918856470,    15.2833215316,
   -13.2965885945,  -0.928902843985,   -4.44273544243,   -3.82010252008,    8.83892629996,    3.80636994282,
   -3.41068706800,   -3.81440143326,    1.53728882691,    5.08742069869,   -5.29277408478,    4.96993552301,
   -13.2965885945,   -18.8896883403,    1.02558937862,    8.35094501318,   -7.53144107416,    11.0883737153,
   -7.53144107416,    4.90918856470,    3.32405577632,    7.18696222212,    98.7645681202,   -10.6900502580,
    8.35094501318,   -5.55402788282,    2.43697755210,    3.81509686603,    4.96993552301,    4.82579845901,
    1.92241176595,   0.606401472974,    1.19761159601,    3.53402648425,    4.68667942184,    6.98051591347,
    5.08742069869,    4.96241427809,    3.32517390895,    3.53402648425,    7.18696222212,    16.5612410921,
    11.0883737153,    15.2833215316,    13.6763017879,    16.5612410921,   -10.6900502580,    6.94511364434,
},
{
    8.60717933673,   -4.99338303655,   -7.36658175599,   -4.23299685560,   -2.93284896764,   -3.14490568256,
   -7.62228100824,   -8.68936039711,   -6.52606891117,   -7.22139710446,   -10.8203866155,   -9.41793008863,
   -3.79629591723,   -3.84237277717,   -6.79811016906,   -7.47507811941,   -3.78922402605,   -6.45874811277,
   -19.8582350703,   -2.75213165922,   -5.29810362710,   -5.30466293646,   0.342721870139,   0.470523253304,
   -6.50728434006,   -7.39504638297,   -13.0398138120,   -7.04252427141,   -7.26558298022,   -8.67247228685,
   -1.39758341021,    2.67602940790,    2.78643342225,    5.76091246408,    1.43073220478,    3.96775742616,
   -11.8893635232,   -9.33786975830,   0.963561730308,    3.57441254429,   -6.03443377457,    4.24056105166,
   -3.90690736715,   -4.73781547117,   0.219686486452,    4.22568698788,   -5.49689862569,    4.63861937546,
   -2.80677249714,   -5.51170646267,   -6.57582963161,   -6.46198437092,   -2.76899080156,   -2.99515736580,
   -6.78794619835,   -7.42705630041,   -3.04768959184,   0.283315126158,   -3.00379402614,    1.17390695484,
    3.17903115692,    3.26675519699,   -1.48303979002,    2.09320522335,    5.42245148490,    13.2818405765,
  -0.453212325349,   -3.15950591385,   -12.7359922823,    12.0368225525,    5.25351092114,    13.1379198417,
   -14.7753124299,  -0.288350770806,   -3.05018339346,   -3.36354084830,    5.19487052725,    4.87083197795,
   -2.61517726585,   -3.37577633747,    1.67444252606,    5.57269052947,   -4.17525572483,    6.04967090955,
    3.17239108681,    3.23042948793,   -15.7714696397,   -12.4658563158,    8.69796976280,   -13.6004620130,
   -9.37774635473,    5.11985745270,    3.49249165404,    7.31803758939,   -10.6900502580,    95.0549573511,
 -0.0679883047309,    7.68438220043,    5.51065378265,    1.72684525309,    2.76355973272,    2.76659868630,
   0.135824431576,    2.38818731746,    2.67799341696,    6.18971629783,    3.00380912726,    5.59392466674,
    3.43150830196,    3.35725030544,  -0.963704921350,    3.30475352149,    5.82666009926,    14.6330225498,
    23.4873253383,    7.80962418292,    6.14401133253,    8.95675841254,    21.1906530124,  -0.201028443308,
},
{
   -35.4362488569,   -2.88446862464,   -2.23364079297,   -3.95123677566,   -3.44918321285,   -4.37094940786,
   -3.42432463260,   -13.9285718417,   -2.11136224508,   -3.20809872200,   -6.03443377457,   -3.80182453265,
   -3.93793507938,   -4.08938603508,   -7.18637400837,   -4.27079623153,   -2.70739810248,   -4.34479292116,
   -15.5611255551,   -2.12754545184,   -3.04136462819,   -4.11294492957,   -17.8481897204,   -21.4030642441,
   -6.87236432478,   -5.59032944961,    3.95300330661,   -3.60435018208,   -4.23299685560,   -6.40393467745,
   -2.52050917818,    3.05921950333,    5.80288007867,    7.29488051492,   -1.30327712967,   0.228970207248,
   -3.76674627657,   -4.09790992519,   -2.36678986350,  -0.546162441077,   -3.12036899949,  -0.548063667065,
   -4.48756391546,   -3.39699380325,  -0.838740155361,   0.111484934528,   -3.31540906326,  -0.503684885921,
   -1.67990502431,   -2.90899564007,   -3.16798642674,   -1.43305365901,   -1.37002058804,   -1.99850697532,
   -1.82528689767,   -3.52437410739,   -3.64547457306,   0.723831726613,    2.26535029574,    3.19550859524,
    3.69530622097,    2.92211067478,  -0.794133342961,    2.06849456445,    4.83644746149,    1.39551041680,
  0.0824510449375,  -0.222808488642,   -2.54840826787,   0.795755172129,    3.17949645052,  -0.338532291702,
    3.60249764016,  -0.329815234990,  -0.374619659663,  0.0509280864458,    2.51277142788,   0.692207431452,
-0.00969180416604,  -0.288593708110,    1.99892364104,    2.38840824158,  -0.299951186682,    2.24103669192,
    2.94831173152,   0.934777145256,    8.87802925086,    13.1815685886,    6.44221687032,    13.6325647973,
    8.42273496448,    4.26729074902,    5.39916098902,    4.32886732400,    8.35094501318, -0.0679883047309,
    96.4300399384,    1.54283271895,    2.03244291996,    1.74181938409,    2.61336859710,    1.53038477142,
    2.87699128121,   0.466615290388,    1.02899668126,    1.03203693157,    2.30547304932,    2.52173697735,
    2.94636891811,    1.54681324423,    6.16196222431,    5.34531479332,    3.66237190690,    5.44273872863,
   -12.9037604338,    1.88099997551,    3.11372650764,    2.55730386708,   -12.4658563158,   0.514937591235,
},
{
   -5.36799149000,   -36.1948023840,   -4.99880484738,   -2.23364079297,   -2.36940709009,   -2.85350911338,
   -14.0912440427,   -5.53141230965,   -3.63980243567,   -4.14106321047,   -3.04768959184,   -5.32764231058,
   -1.88530104907,   -2.07073322809,   -3.06686059009,   -6.04286677972,   -3.04232718639,   -3.61884557138,
   -1.25286666352,   -17.0216252500,   -18.0874436684,   -17.9660620096,   -4.80044307096,   -3.91494167754,
   -2.87516480264,   -2.42109281648,   -4.06087251037,    5.38238026713,   -7.36658175599,   -4.86937681595,
    4.42099749479,   -1.83309503743,   -1.16880599602,   -1.19922432959,    6.33445073191,    6.73360604526,
   -4.26389011473,   -3.61315415637,   -2.70812576928,   -2.15700853736,   -3.64547457306,   -2.05424388182,
   -2.30497741046,   -3.11650166621, -0.0946103506733,   0.248275334921,   -2.56428697012,  -0.818593816318,
   -2.19163227797,   -2.75719522516,   -2.09613711355,   -3.77733627693,   -2.67167545957,   -2.98199746189,
  -0.644118167803,   0.722311796191,    2.66041333492,    2.91664946903,  -0.877376856169,   0.401277785420,
    1.23620042522,   0.831206512909,    1.41674265601,  -0.940801877032,    1.34264207773,  0.0209809415686,
   0.503138444413,  0.0555678467829,    1.40809620370,    1.51640273628,    2.90077588087,    1.57307864629,
   0.839919235494,    2.38836929911,    2.05840148048,    2.13971609673,   -1.32849163946,   -1.13547734156,
    3.20833846878,    3.11848761998,    4.62640633331,    4.75341046185,    2.87816600487,    3.72152299620,
    6.32770429109,    7.13294881956,    1.25294322978,   0.795755172129,    8.91907078347,   0.314755923607,
    5.24659988964,    6.91329582535,    7.85572434880,    7.42132958226,   -5.55402788282,    7.68438220043,
    1.54283271895,    98.0501238084,    1.91572793238,    2.04238410188,    1.89214896281,    1.32988350128,
   0.592951516896,    3.22581106136,    2.93931202527,    2.37667671700,   0.854745298683,   0.866154454190,
    2.85356476469,    2.00594589649,    3.51366877414,    4.39505757541,    2.75496955568,    2.44544825138,
    1.83617274451,   -11.3771881230,   -10.4179101369,   -11.1977046007,    12.0368225525,    3.95863320677,
},
{
   -6.65812491595,   -5.29037912148,   -36.1948023840,   -2.88446862464,   -4.22796727586,   -4.56409239301,
   -1.75773570496,   -18.3976865898,   -17.3220171221,   -16.7877815213,   -12.7359922823,   -4.69893147886,
   -1.71528642262,   -1.92029423174,   -2.22568304570,   -4.22556084587,   -4.33004449477,   -5.60682842900,
   -5.02467448805,   -4.48983028873,   -2.15868159775,   -2.11393300786,   -3.86961435551,   -3.27561900621,
    1.88241502240,   0.926481665246, -0.0622295296345,   -2.40015513230,   -4.99338303655,    8.38996332437,
   -1.34997010910,    1.94203511105, -0.0334858524931,  -0.244222984889,   -4.05226447797,   -2.57697065912,
   -3.45130216438,    4.44558063180,    4.38149458079,    5.17250072782,   -2.54840826787,   -2.90550450174,
    2.55767805912,    2.74121610464,   0.448765444898,   0.842927830720,    2.16874029149,   0.516993015810,
 -0.0762330275188,    1.81968452702,   0.545331558958,   -2.37331479701,   -2.29004601420,   -1.79665727600,
   0.110396186431,    2.91434752106,    1.40809620370,    1.38687323822,  -0.377040242349,   -1.28003934163,
   0.301302209952,   0.909198892731,   -1.48564295720,   -2.35072651678,   0.116066517666,   -5.88796619628,
   0.243514488529,   0.918782591640,    2.18345616634,    2.91664946903,    2.59871803433,   0.112462804622,
    8.66481634482,  0.0698359663296,   0.840501237418, -0.0789435747566,    7.73624059467,    7.33279444374,
    1.06176307263,    1.55270079570,   0.827827410776,   0.405950073013,   0.613440673968, -0.0823657666345,
   0.110396462681,  -0.491483243017,    1.68554765668,   0.723831726613,   0.573983294049,   -1.39535571638,
   -8.39291090002,    2.82412258514,    3.72182254444,    3.51283765151,    2.43697755210,    5.51065378265,
    2.03244291996,    1.91572793238,    98.3558345997,    3.47959864133,    3.51750054562,    3.27367538387,
    2.38263262964,   -10.8343835093,   -12.3582958452,   -12.7603680586,   0.908235754809,    1.40680050611,
    1.71359022390,    2.11540301866,    4.81301106985,    3.99144669601,    1.76170682652,    3.87026004778,
    10.8670443194,    1.63728269312,    2.46532995184,    2.18522773610,   0.283315126158,    3.32191661492,
},
{
   -4.26269341359,   -6.65812491595,   -5.36799149000,   -35.4362488569,   -4.77986206737,   -4.19712666694,
   -17.4134339546,   -3.96687513396,   -4.09070881500,   -2.90571696531,   -15.7714696397,   -29.6934146419,
   -1.90101638341,   -2.05132354587,  -0.983369342872,   -1.43661669760,   -5.10130764631,   -1.41314885590,
   -4.43349551400,   -6.05454160848,   -4.14858224039,   -3.25072542614,   -2.66162830552,   -1.00718051189,
  -0.817545630271,   -1.74931105086,   -1.83014139735,  -0.358971552026,    8.60717933673,    1.02558937862,
    2.44549621665, -0.0846387143668,   -1.39501835562,   -3.34650475961,   0.283448392274,   -3.02612919136,
    10.1470993263,    1.81852923469,    1.56010340800,   -1.48444614454,    8.87802925086,    5.44933609520,
   0.171732966065,   0.121673303444,   -1.38665779695,   -3.80493410954,   0.247177449112,   -2.34887107486,
    1.32144544549,    1.39656074305,    1.88772939286,    1.02605720546,  0.0967280348665,   0.317009408644,
   0.100981600673,    1.16047660536,    1.25294322978,   -2.90550450174,  -0.324682637397,   -2.13068687021,
   -1.55906670230,   -1.21391220419,    1.63743331504,   0.835336974273,   -5.44848887444,    1.26843494328,
    2.02872233283,    1.62075751509,    1.68554765668,   -2.05424388182,   -2.88743618262,   0.590633792225,
  -0.610894684855,    7.79473120283,    8.12910672884,    7.96997978451,  -0.195801329414,   0.752358397718,
   0.663691969363,    1.08285467559,  -0.208344798672,   -1.16278277850,    1.30130103982,   -1.07761585802,
    2.15730956894,    2.86356084676,    1.95882504879,  -0.548063667065,   -2.08846228834,   0.859606531259,
    1.78089271632,   -8.41395982155,    1.93731693654,    2.22704751677,    3.81509686603,    1.72684525309,
    1.74181938409,    2.04238410188,    3.47959864133,    101.702796460,    2.28539648409,    3.01521299803,
   -11.7602653513,    2.16993674850,    2.01281383095,    1.70972351290,   -12.5737071842,   -13.8647322686,
    2.43658406577,    3.58974770676,    1.44529123062,    1.01893534483,    2.17703943527,   0.788072126217,
    2.27752614391,    12.5879849047,    1.39654183047,    1.61928012390,    4.24056105166,    1.90846053913,
},
{
   -4.19712666694,   -4.56409239301,   -2.85350911338,   -4.37094940786,   -36.2386704698,   -5.22527665799,
   -3.52702931314,   -1.97808516555,   -13.1943048089,   -2.90566379430,   -5.49689862569,   -3.31381710689,
   -18.0301307705,   -6.24502277907,   -4.33829916575,   -3.99370888359,   -16.9543023518,   -18.1647344400,
   -2.67053226402,  -0.973849166874,   -2.99859433160,   -6.13796778300,   -3.24361929777,   -4.74087329353,
   -4.77212084362,    6.34108150200,   -3.78301578534,   -3.30981984540,   -3.14490568256,   -5.33485524048,
   -1.32677197557,   -2.03263840131,   -2.88072342083,   -1.56432015213,   -2.96608171915,   -1.65265185841,
   -3.57155025876,   -2.78206804744,   -2.68666481829,   -1.11357560461,   -3.31540906326,   -1.07761585802,
   -4.31705493911,    3.37785124710,    5.75150332245,    6.43466143584,   -4.73421493710,   -1.29869010121,
    2.82072520664,   0.702694944772,   -1.63606896922,   0.888583249480,    4.70409238607,    3.33342800563,
  -0.402406864486,   -2.90479889313,   -2.56428697012, -0.0823657666345,  -0.822099283250,    1.55050062551,
    3.72198225871,   -1.03526516990,    2.35700464670,    4.62879146440,    4.27517288855,    7.19934538749,
    2.76544260503,    1.88972013476,    2.16874029149,    3.72152299620,    2.28500868480,    4.96574729528,
   -1.72833866992,  -0.159705863318,   -1.49399239261,  -0.852923983700,   0.359573676015,   0.115820235337,
   -1.78976586390,   -1.77477694233,  -0.330263365747,    7.92839152050,    6.12522600352,    8.01997590090,
    2.52120643985,    1.19191624916,   0.247177449112,    2.24103669192,    2.28514157604,    3.34668012401,
    3.04775298559,    4.35351409207,    3.85417816513,   -7.09732086170,    4.96993552301,    2.76355973272,
    2.61336859710,    1.89214896281,    3.51750054562,    2.28539648409,    98.0986307305,    1.77456287105,
    1.93512326132,    1.12297208977,    1.10735995817,    3.03302590491,    2.32430877086,    3.04187382428,
   -10.6187303080,    3.81386715783,   0.827377726153,    1.73634316499,   -11.2385279478,   -11.6729786631,
    4.13254115806,    3.36886108025,    2.96750226889,    13.3534507787,    6.04967090955,    3.97585019365,
},
{
   -4.77986206737,   -4.22796727586,   -2.36940709009,   -3.44918321285,   -5.34623743353,   -36.2386704698,
   -2.43434134683,  -0.537906001096,   -1.61502794398,   -11.9243045226,   -4.17525572483,   -2.00425841399,
   -6.22632330604,   -18.3575303507,   -17.3542721770,   -16.7634577374,   -3.66840017366,   -2.77501741267,
   -5.15925382175,   -2.55234384466,   -4.73280164616,   -1.48524032158,   -3.54614834121,   -1.74755203283,
    6.35850336621,   -4.70370169779,   -3.78092960240,   -3.58084102688,   -2.93284896764,   -5.29277408478,
   -1.19832194615,   -2.27239000576,   -2.65884432854,   -4.45236155393,   -1.40296912034,   -3.05199614679,
   -1.46189605730,  -0.561114436965,  -0.607028592293,   -2.53679733505,  -0.299951186682,   -2.34887107486,
    5.99953633686,   -2.20848872348,   -3.29214336856,   -4.42205372104,    6.12522600352,    2.94669958734,
   -1.20360863110,   0.618454666887,    2.52869602862,    5.30877759488,    2.62950027646,    3.18700577505,
    3.91173751298,    1.30519160208,    2.87816600487,   0.516993015810,    3.75027773845,    1.63938994047,
   0.719583277667,    4.66367182442,    5.82889224441,    4.48072367247,   0.266964585737,    2.93182498382,
  -0.811815197803,   0.429846443576,   0.613440673968,  -0.818593816318,   -1.77820375188,   0.934294689249,
  -0.831516026082,    1.05528116547,  -0.288433360886,  -0.257197740859,   -1.01550367500,   0.191498213268,
    7.51502639263,    6.85809515971,    6.70357901341,   -1.87300467473,   0.339061376455,   -1.29869010121,
   0.559476174582,    2.87309717622,    1.30130103982,  -0.503684885921, -0.0206401687921,   0.892384226942,
    3.23350409469,    4.27652301649,   -7.23976744124,    3.95791893946,    4.82579845901,    2.76659868630,
    1.53038477142,    1.32988350128,    3.27367538387,    3.01521299803,    1.77456287105,    98.2195915061,
    3.47037493945,    1.65442854956,    1.96270324942,   0.124039501753,    2.10113876234,    1.70988267819,
    3.90350490143,   -10.8751916175,   -12.6814395874,   -12.6457044171,    1.39081975589,    1.17416486145,
    3.06745698764,    2.06125308493,    11.9416522898,    1.77152941632,    4.63861937546,    2.64266037378,
},
{
   -4.43349551400,   -5.02467448805,   -1.25286666352,   -15.5611255551,   -5.15925382175,   -2.67053226402,
    4.34231891950,   -3.31927402712,   -2.27640071874,   -4.40884437221,    3.23042948793,    2.31078513921,
   -3.29390863627,   -1.08325212653,  -0.622281335680,   -9.39177531702,   -2.05981445593,  -0.850722933852,
   -2.98718992499,   -4.10554906252,   -4.87087529660,   -5.30094184162,   -4.53452165872,   -1.69920580331,
   -4.19956382234,   -2.18365247431,   -3.07743593625,   -17.6100253304,   -19.8582350703,   -18.8896883403,
   -14.7303964383,  -0.379801943548,   -2.04207166717,   -1.95883804573,    5.26249155547,    4.02652212184,
   0.659261570580,    3.14499930424,    2.67912768460,   0.960378711611,   0.934777145256,   -1.48444614454,
  -0.344176823369,   -1.30237338382,   -2.00355051992,   -1.66259948970,    1.19191624916,   -2.53679733505,
  -0.995124191103,  -0.230362026411,    9.88998691768, -0.0859737999385, -0.0139864204816, -0.0647828994834,
   -1.36735936182,    8.54277559021,    7.13294881956,    5.17250072782,   -1.15480161496,   -4.73130890527,
  -0.771434475411,   -1.77000131659,   0.419196010992,   -1.91084817595,  -0.233985776625,    1.57698579440,
   0.265231994911,   0.829071607073,  -0.491483243017,   -2.15700853736,   -6.40891589527,   -1.20420235933,
   -1.92153663320,   -10.4459740465,    9.35576439192,    12.0459018356,    2.61461575929,    2.22376399657,
    1.72765665257,   -1.11372675128,   -1.38754417573,   -1.09661117537,    2.87309717622,   -1.11357560461,
    4.38226922329,    3.56684831254,    2.86356084676,  -0.546162441077,  -0.685276785438,    1.96844187389,
    1.20036859623,    11.7288926780, 0.00817510064860,   0.261943941164,    1.92241176595,   0.135824431576,
    2.87699128121,   0.592951516896,    2.38263262964,   -11.7602653513,    1.93512326132,    3.47037493945,
    92.4347819176,    1.87872915877,    1.28248388672,    2.22998910694,   -14.6463852485,   -14.8400567409,
    2.89791410635,    2.26290931654, -0.0310057129430,   -1.91776405385,    2.99608668066,   0.625586580876,
    2.40375639965,    12.9423641628,    1.87942139897,    2.37060247004,    3.57441254429,    1.77926900938,
},
{
   -6.05454160848,   -4.48983028873,   -17.0216252500,   -2.12754545184,   -2.55234384466,  -0.973849166874,
   -2.59637492575,    3.97463653510,    3.79095739238,    1.70108151577,   -3.15950591385,   -1.69030572390,
   -2.98679387144,  -0.979733462898,   -11.8168960818,   -2.45959713642,   -2.77795348368,   -3.41769576679,
   -4.10554906252,   -1.91383293954,   -1.53452144760,   -1.76475194051,   -5.85849699332,   -7.69733034196,
   -21.5884745239,   -18.7096452661,   -17.8224916068,   -2.26857129554,   -2.75213165922,   -3.81099339358,
   -1.65035733438,   -15.2978841164,    1.47846360711,    4.41797286516,   0.733919099735,  -0.695741099095,
  -0.607862524868,   -2.67538276240,   -4.01214234100,   -4.73130890527,  -0.222808488642,   -2.13068687021,
    1.78263563452,    1.65480029254,   0.279843608035,    2.37222909638,    1.88972013476,    1.63938994047,
  -0.876450614864,   -1.46089485254,   -2.30163312917,    7.59505512494,   -2.48488946318,   -2.18819474404,
    7.67248056184,   -2.61762276351,  0.0555678467829,   -1.28003934163,    7.71072711834,    9.06274797268,
    1.04860798325,   0.292564966958,   -4.51946838500,   -3.19998558894,    1.14479443151,   -1.37410684853,
   0.651265875292, -0.0582642072911,   0.918782591640,   0.401277785420,    1.48147473050,   -4.57224088644,
   -10.7280805275,  -0.188438998761,  -0.156025669468,    2.47431235715,    11.0676035914,    12.1289294635,
    1.60500993770,  -0.201661053047,  -0.295170575584,   0.580982753522,   0.429846443576,    1.55050062551,
  -0.267792101053,   0.829071607073,    1.62075751509,    3.19550859524,    2.71510318704,  -0.538823633149,
    11.4762396034,    2.46454329810,    2.60278409476,    2.25972447542,   0.606401472974,    2.38818731746,
   0.466615290388,    3.22581106136,   -10.8343835093,    2.16993674850,    1.12297208977,    1.65442854956,
    1.87872915877,    93.6426102094,   -15.7905603561,   -14.9716998052,    2.94467407897,    1.68664098403,
    2.16723095516,   0.897125204738,    1.83082030725,    2.47930316206,    2.00550909998,    4.26348616172,
    11.0796491579,    1.95804453141,    2.17686565290,    2.18580016393,    1.17390695484,    3.10532137185,
},
{
   -4.14858224039,   -2.15868159775,   -18.0874436684,   -3.04136462819,   -4.73280164616,   -2.99859433160,
   -4.18361147861,   0.846182241218,    5.02034622785, -0.0438466036696,   -5.51170646267,   -4.21925717124,
   -2.74395919415,   -10.5458301759,   -3.76698308645,   -4.43922102010,   -3.90795863113,   -6.71315349486,
   -4.87087529660,   -1.53452144760,   -2.50996423442,   -5.14903647973,  -0.936251126036,   -5.25391663395,
   -3.89444925619,    1.21387395923,   -3.79742931057,   -6.13678692008,   -5.29810362710,   -7.03436867550,
  -0.701150313907,   0.982437868940,   -15.9480158432,    3.73619642795,   0.586904825889,    2.02175215248,
   -3.35210644563,   -7.65647231212,   -2.50966202192,   -1.91084817595,   -2.90899564007,   0.835336974273,
   -21.0330481220,   -18.0169750810,   -12.7497104077,    7.54195229339,   0.702694944772,    4.48072367247,
   -1.85841628415,   -2.73796049663,   -6.23340209851,   -7.34212250355,   -2.78247617573,    4.48066186429,
   -3.88179659482,   -2.10738078932,   -2.75719522516,   -2.35072651678,   -3.09523932096,   -3.19998558894,
    1.41439353302,    8.64381642659,    11.4159072685,    11.0067261524,    2.13910789756,    4.05940570669,
 -0.0567776177298,   -1.46089485254,    1.81968452702,  -0.940801877032,    2.69155885333,    4.61452225228,
    7.75620353226,   0.137554300282,   -1.29586693892,   0.193453132463,   -7.83212364819,    7.93840729882,
  -0.901028953118,   -2.64461858054,    2.25917246856,    1.92792536871,   0.618454666887,    4.62879146440,
    2.82235210499,  -0.230362026411,    1.39656074305,    2.06849456445,    5.59187838003,    6.04429774214,
    11.0614215636,    3.49246198396,    3.05273950099,    2.87287451220,    1.19761159601,    2.67799341696,
    1.02899668126,    2.93931202527,   -12.3582958452,    2.01281383095,    1.10735995817,    1.96270324942,
    1.28248388672,   -15.7905603561,    92.7490309898,   -14.3750955712,    2.89820975974,    3.44568326186,
    3.70110750688,  -0.158319857919,    3.58769338251,    2.99133463145,    4.70811456921,    8.26954420328,
    13.2137268024,    4.07022363329,    3.61855263797,    3.00527857918,    2.09320522335,    4.15892129831,
},
{
   -3.25072542614,   -2.11393300786,   -17.9660620096,   -4.11294492957,   -1.48524032158,   -6.13796778300,
   -4.91534081789,   0.699673230686,  -0.479123945235,    4.06630928290,   -6.45874811277,   -5.22313360386,
   -10.9041161162,   -5.67174203167,   -5.59596919541,   -6.30293519068,   -2.12699636533,   -3.03529803528,
   -5.30094184162,   -1.76475194051,   -5.14903647973,   -3.32889805364,   -2.81745826544,   -1.81557029447,
    1.42580257187,   -3.35219702054,   -1.80161412778,   -4.67353237935,   -5.30466293646,   -6.26867919373,
   -1.74888357212,    1.83679897869,    3.26782880655,   -16.1553457842,  -0.156236616844,    1.51405062145,
   -5.14678983453,   -7.68846714904,   -4.10591299042,   -1.91776405385,   -4.34479292116,    1.01893534483,
    1.73375230332,  -0.768481463569,    4.85576722241,   -14.7745897265,   -18.1647344400,   -12.6457044171,
   -4.21039938474,   -6.71315349486,   -3.86241095315,   -5.52024849453,    5.60836397767,   -3.96373655670,
   -7.13738360177,   -5.97302395553,   -3.61884557138,    3.99144669601,   -1.08861127329,    2.47930316206,
    9.16691233076,   0.493403977792,   0.864511276649,    2.99133463145,    12.5784802369,    14.8468941777,
   -1.00719159757,   -3.41769576679,   -5.60682842900,    4.39505757541,    2.44550709798,    4.70113281529,
    8.03071032466,   0.149580620670,  0.0380088357487,   -2.45376070600,    9.16556607048,   -10.3530654949,
   -3.18226111466,  -0.624657997254,    4.67724015175,    5.69324816715,   -2.77501741267,    1.73634316499,
  -0.486534657962,  -0.850722933852,   -1.41314885590,    5.34531479332,    3.07354155736,    3.78761175390,
    13.2970436677,    5.49448637986,    4.82287665170,    5.71434286053,    3.53402648425,    6.18971629783,
    1.03203693157,    2.37667671700,   -12.7603680586,    1.70972351290,    3.03302590491,   0.124039501753,
    2.22998910694,   -14.9716998052,   -14.3750955712,    93.0369089747,    2.71948844032,    3.53162357437,
   0.783079248832,    2.84939790460,    4.24731476814,    6.87948754021,    3.81743460173,    7.41429879343,
    12.8234289622,    2.84956457467,    2.26907424018,    3.19368144731,    3.30475352149,    5.38523171468,
},
{
   -2.66162830552,   -3.86961435551,   -4.80044307096,   -17.8481897204,   -3.54614834121,   -3.24361929777,
    2.77691764137,   -3.93903347767,   -5.72021533230,   -4.24027216807,    4.87083197795,    1.85902383774,
   -1.73724798100,   -2.75853109518,   -3.10671340685,   -1.68292210904,  -0.612057989473,   -10.3530654949,
   -4.53452165872,   -5.85849699332,  -0.936251126037,   -2.81745826544,   -1.64566691985,   -1.50296632734,
   -1.14299204712,   -4.40138514720,   -2.56168688630,  -0.540637942149,   0.342721870139,    3.80636994282,
    2.66720371507,   0.277616118533,  -0.601676628533,   -1.21452928814,   -17.5987402266,  0.0681813707366,
   -20.7829473955,   -15.1668725173,   -15.3285798195,    4.02652212184,   0.692207431452,   -3.02612919136,
  -0.371207019862,  -0.627258344381,  -0.520669323459,   -2.65468288836,   0.115820235337,   -3.05199614679,
   -5.73844782065,    7.93840729882,  -0.702321383383,   0.216651853125,   -4.82797426774,   -2.32574635157,
   -1.19535906150,   -2.27303616948,   -1.13547734156,   -2.57697065912,  -0.102612168783,  -0.695741099095,
   0.194605943195,    2.08159759315,    1.75832614461,    2.02175215248,    2.92767457208,  -0.642957914166,
   -4.68783610204,    12.1289294635,    7.33279444374,    6.73360604526,   0.646018777457,   -3.04675227459,
    1.78584284172,    8.66578251209,   -7.06529346522,    8.61627206225,   -1.41387342026,   -1.37831976503,
   -1.05467036139,    2.13889983533,    2.97337347268,    1.19185087310,   0.191498213268,   -1.65265185841,
  -0.541588753301,    2.22376399657,   0.752358397718,   0.228970207248,    1.45683591274,    1.27190685484,
    4.03107288934,    10.7287014056,    1.14597346545,  -0.614509431762,    4.68667942184,    3.00380912726,
    2.30547304932,   0.854745298683,   0.908235754809,   -12.5737071842,    2.32430877087,    2.10113876234,
   -14.6463852485,    2.94467407897,    2.89820975974,    2.71948844032,    92.6578117154,   -15.1998571420,
   0.735988436246,    4.01280807894,    2.13648776433,    1.51405062145,    3.05266424708,   -1.40380767879,
    1.64544241710,    11.4442099056,    1.31728951722,    2.04681763800,    3.96775742616,    2.33797744968,
},
{
   -1.00718051189,   -3.27561900621,   -3.91494167754,   -21.4030642441,   -1.74755203283,   -4.74087329353,
   -2.00135462423,   -3.78877759863,   -6.49664214697,   -3.15759783481,   0.470523253304,    1.58839264994,
   -1.28902728442,   -3.45806031990,   -3.70888639990,   -3.15759783481,   -10.8310446324,   -1.81557029447,
   -1.69920580331,   -7.69733034196,   -5.25391663395,   -1.81557029447,   -1.50296632734,   -3.19605235187,
   -3.70888639990,   -5.75346587156,   -3.49132852619,   -2.37328471558,   0.470523253304,   -1.38620940730,
    2.17786885862,  -0.354029801964,    1.72996653042,    1.02050137931,   0.220345800761,   -15.1998571420,
   -2.00135462423,   -2.37328471558,    2.17786885862,   -14.8400567409,   -21.4030642441,   -13.8647322686,
   -3.45806031990,   -2.70772471001,   0.657839132651,    1.65867317606,   -4.74087329353,    1.70988267819,
    9.09063855211,   -5.25391663395,   -6.49664214697,   -5.75346587156,  -0.726464919442,   -2.70772471001,
   -3.49132852619,   -3.78877759863,   -3.91494167754,    1.40680050611,  -0.354029801964,    1.68664098403,
   0.888231594353,   0.657839132651,    1.72996653042,    3.44568326186,    1.57770453761,    2.72936358630,
    9.02880381129,   -7.69733034196,   -3.27561900621,   0.866154454190,    10.7075152535,    12.1325078736,
    1.80036779883,    9.02880381129,    9.09063855211,   -10.8310446324,  -0.675358718959,   -1.50296632734,
   -1.28902728442,  -0.726464919442,   0.888231594353,    2.77936969810,   -1.74755203283,    3.04187382428,
    1.80036779883,   -1.69920580331,   -1.00718051189,    2.52173697735,    2.92665381643,    3.60711007986,
    2.92665381643,    10.7075152535,    1.57770453761,    4.67733974278,    6.98051591347,    5.59392466674,
    2.52173697735,   0.866154454190,    1.40680050611,   -13.8647322686,    3.04187382428,    1.70988267819,
   -14.8400567409,    1.68664098403,    3.44568326186,    3.53162357437,   -15.1998571420,    95.4361312537,
    2.77936969810,    1.65867317606,    1.02050137931,    3.53162357437,    4.67733974278,    3.14984948426,
    3.60711007986,    12.1325078736,    2.72936358630,    3.14984948426,    5.59392466674,    4.00304809629,
},
{
   -2.05132354587,   -1.92029423174,   -2.07073322809,   -4.08938603508,   -18.3575303507,   -6.24502277907,
   -8.02880140394,   -4.19782340310,   -5.41431685967,   -4.70358055171,   -3.90690736715,   -4.80906526575,
    5.54952664487,   -3.59775002064,   -4.23601380227,   -5.08978296436,    2.98812055676,    1.73375230332,
   -1.08325212653,  -0.979733462898,   -10.5458301759,   -5.67174203167,   -2.75853109518,   -3.45806031990,
   -3.19563732100,   -4.36964974991,   -3.49052670024,   -7.29749260730,   -3.84237277717,   -3.49946492897,
   -1.45370351642,  -0.532432213488,    1.40874140874,   0.407242738726,  -0.675888482944,    1.19185087310,
   -4.09579126929,   -4.03545319173,   -2.13442715547,   -1.09661117536,   -4.48756391546,   -1.16278277850,
   -1.17578717837,   -4.22320070153,   -2.07282329380,   -2.62487054875,   -4.31705493911,   -1.87300467473,
   -21.4912539598,   -21.0330481220,   -3.12264250823,   -2.53196272433,   -18.8945373099,   -5.64241517623,
   -2.92596621497,   -3.08366691349,   -2.30497741046,   0.405950073014,  -0.308055041427,   0.580982753522,
   -12.0586768221,    3.60317294936,    1.34710462072,    1.92792536871,    9.26811669461,    8.51096261755,
    1.72187882714,    1.78263563452,    2.55767805912,    4.75341046185,    7.33859822326,    6.66691905449,
  -0.523543280774,   -2.26824927103,    8.86483341561,   -4.56923963793,   0.241912282487,  -0.371207019862,
   -5.42499548254,    7.58738509851,    10.0677163024,    3.45654007290,    5.99953633686,    7.92839152050,
  -0.518408162699,  -0.344176823369,   0.171732966065,    2.38840824158,    5.24852905716,    4.08962687016,
    3.33357224677,    1.22098483369,  -0.242624434201,    11.4112320403,    5.08742069869,    3.43150830196,
    2.94636891811,    2.85356476469,    1.71359022390,    2.43658406577,   -10.6187303080,    3.90350490143,
    2.89791410635,    2.16723095516,    3.70110750688,   0.783079248832,   0.735988436246,    2.77936969810,
    92.9081609273,    5.95579816464,    3.35728059368,    5.69324816715,   -10.9696196737,   -12.2432643529,
    3.61354047806,    1.51214093103,   0.677327563698,    11.9233162716,    5.57269052947,    3.95757418947,
},
{
   -1.90101638341,   -1.71528642262,   -1.88530104907,   -3.93793507938,   -6.22632330604,   -18.0301307705,
   -6.68837691359,   -3.06099501395,   -3.83821499890,   -3.78271517431,   -2.61517726585,   -3.35031062359,
   -2.69413426189,    5.54952664487,    2.34564145219,    1.55758494558,   -3.64730771509,   -3.18226111466,
   -3.29390863627,   -2.98679387144,   -2.74395919415,   -10.9041161162,   -1.73724798100,   -1.28902728442,
   -4.03303910361,   -3.38273805882,   -3.62453739721,   -7.37680265761,   -3.79629591723,   -3.41068706800,
   0.752523437973,    1.12185793523,  -0.966763684304,  -0.143948880618,  -0.376870686323,   -2.65468288836,
   -2.04081972113,   -1.78235877809,  -0.981000615935,   -1.66259948970,-0.00969180416607,   -3.80493410954,
   -5.42499548254,   -2.54666298514,   -1.13586621270,   -1.03267698428,   -1.78976586390,   -4.42205372104,
   -5.50478634897,  -0.901028953118,   -18.3629095634,   -17.7214813554,   -8.65304489492,   -19.3172377973,
    1.35133816440,    1.18570542996,    3.20833846878,   0.842927830720,    2.63094122274,    2.37222909638,
    2.14946668185,   -11.3999775314,    7.39312816784,    7.54195229339,    2.68655900288,    1.97210592684,
   -2.85326303442,    1.60500993770,    1.06176307263,   0.248275334921,    3.18541284620,    2.34670913657,
   0.624602508586,   -1.15408470499,   -1.67373580774,    8.11963810962,  -0.873547681475,   -1.05467036139,
    18.2660662821,    9.13690958564,   -9.04793938552,   -2.62487054875,    7.51502639263,    6.43466143584,
   -3.15515491248,    1.72765665257,   0.663691969363,   0.111484934528,    3.09071169008,    1.86609684761,
    2.99488054707,    1.63364398023,    11.3982255953,  -0.175364901065,    4.96241427809,    3.35725030544,
    1.54681324423,    2.00594589649,    2.11540301866,    3.58974770676,    3.81386715783,   -10.8751916175,
    2.26290931654,   0.897125204738,  -0.158319857919,    2.84939790460,    4.01280807894,    1.65867317606,
    5.95579816464,    96.2328823514,   -12.4019770743,   -14.7745897265,    4.09190734571,    3.01638553195,
    2.12704020822,   0.660741621798,    10.3977310850,  -0.497817484562,    4.22568698788,    2.61850268380,
},
{
   -5.10130764631,   -4.33004449477,   -3.04232718639,   -2.70739810248,   -3.66840017366,   -16.9543023518,
   -4.20846320503,   -6.03427973474,   -3.40654646337,   -3.26077886935,   -3.36354084830,   -2.54663857301,
   -3.64730771509,    2.98812055676,    4.33952915306,    2.57472739991,   -1.53071571540,   -2.45376070600,
   -2.05981445593,   -2.77795348368,   -3.90795863113,   -2.12699636533,  -0.612057989473,   -10.8310446324,
   -6.59806078449,   -4.40445015800,   -5.79854447676,   -2.51407232447,   -3.78922402605,   -3.82010252008,
   -2.02931849394,   -1.83079589154,  0.0169954512305,    1.20436215200,   0.337099110791,   -1.21452928814,
   -1.74931022596,   -1.05123128530,  -0.737208484589,   -1.95883804573,  0.0509280864458,   -3.34650475961,
   -4.56923963793,  -0.172708307440,   -2.34515277457,  -0.143948880618,  -0.852923983700,   -4.45236155393,
   -7.05793411218,   0.193453132463,    2.90487823575,    5.68294330736,   -4.50485903284,   -1.14582454271,
   -16.0949204373,   -19.5588218250,    2.13971609673,  -0.244222984889,   -15.1465558918,    4.41797286516,
    3.35790524138,    7.17934350437,   -16.2402478326,    3.73619642794,    4.26622830396,   0.530475704478,
   -1.87628143369,    2.47431235715, -0.0789435747566,   -1.19922432959,    4.36501661673,   0.651472016818,
   -1.52362951526,  -0.774776264366,   -1.49196964868,   -1.95176042081,   -2.05718013166,    8.61627206225,
    8.11963810962,   -10.0418795477,    10.3804109113,   0.407242738726,  -0.257197740859,   -1.56432015213,
   -3.83870245603,    12.0459018356,    7.96997978451,    7.29488051492,    2.77259210961,   -2.37033491174,
    1.29179650177,    1.97189302591,    11.6325047244,    2.01415320722,    3.32517390895,  -0.963704921350,
    6.16196222431,    3.51366877414,    4.81301106985,    1.44529123062,   0.827377726153,   -12.6814395874,
 -0.0310057129430,    1.83082030725,    3.58769338251,    4.24731476814,    2.13648776433,    1.02050137931,
    3.35728059368,   -12.4019770743,    92.1365355516,   -16.1553457842,    2.83654536530,   0.166041701236,
    5.10925342427,    4.11048986679,    13.8527965563,    2.91896715975,    5.76091246408,    2.11615664827,
},
{
   -1.41314885590,   -5.60682842900,   -3.61884557138,   -4.34479292116,   -2.77501741267,   -18.1647344400,
   -5.14678983453,   -5.97302395553,   -3.86241095315,   -6.30293519068,   -5.30466293646,   -5.22313360386,
   -3.18226111466,    1.73375230332,    1.42580257187,    4.06630928290,   -2.45376070600,   -3.32889805364,
  -0.850722933852,   -3.41769576679,   -6.71315349486,   -3.03529803528,   -10.3530654949,   -1.81557029447,
   -5.59596919541,   -5.52024849453,   -7.13738360177,   -7.68846714904,   -6.45874811277,   -6.26867919373,
   -4.10591299042,   -1.08861127329,   0.864511276649,    4.24731476814,  -0.156236616844,    2.71948844032,
   -4.91534081789,   -4.67353237935,   -1.74888357212,    2.22998910694,   -4.11294492957,    1.70972351290,
   -5.67174203167,   -3.96373655670,   0.493403977792,    2.84939790460,   -6.13796778300,   0.124039501753,
  0.0380088357487,   -5.14903647973,  -0.479123945235,   -3.35219702054,  -0.624657997254,  -0.768481463569,
   -1.80161412778,   0.699673230686,   -17.9660620096,   -12.7603680586,    1.83679897869,   -14.9716998052,
    4.67724015175,    4.85576722241,    3.26782880655,   -14.3750955712,    4.82287665170,    2.26907424018,
   0.149580620670,   -1.76475194051,   -2.11393300786,    2.37667671700,    5.49448637986,    2.84956457467,
  -0.486534657962,   -1.00719159757,   -4.21039938474,   -2.12699636533,    9.16556607048,   -2.81745826544,
   -10.9041161162,    5.60836397767,    9.16691233076,   0.783079248832,   -1.48524032158,    3.03302590491,
    8.03071032466,   -5.30094184162,   -3.25072542614,    1.03203693157,    13.2970436677,    12.8234289622,
    3.07354155736,    2.44550709798,    12.5784802369,    3.81743460173,    3.53402648425,    3.30475352149,
    5.34531479332,    4.39505757541,    3.99144669601,    1.01893534483,    1.73634316499,   -12.6457044171,
   -1.91776405385,    2.47930316206,    2.99133463145,    6.87948754021,    1.51405062145,    3.53162357437,
    5.69324816715,   -14.7745897265,   -16.1553457842,    93.0369089747,    5.71434286053,    3.19368144731,
    3.78761175390,    4.70113281529,    14.8468941777,    7.41429879343,    6.18971629783,    5.38523171468,
},
{
  -0.983369342872,   -2.22568304570,   -3.06686059009,   -7.18637400837,   -17.3542721770,   -4.33829916575,
   -8.49276272601,   -4.53722062451,   -7.33354399261,   -7.36867393869,   -6.50728434006,   -8.15448489157,
    2.34564145219,   -4.23601380227,   -4.49896444709,   -6.84928104137,    4.33952915306,    1.42580257187,
  -0.622281335680,   -11.8168960818,   -3.76698308645,   -5.59596919541,   -3.10671340685,   -3.70888639990,
   -7.15322553675,   -7.81212664565,   -5.77589734195,   -9.22655396238,   -6.79811016906,   -6.35861885328,
   -1.01728261213,   0.625326118133,    2.91476006270,    2.01415320722,   -1.29945312138,  -0.614509431762,
   -8.56595466210,   -8.70938048563,   0.768747418436,   0.261943941163,   -6.87236432478,    2.22704751677,
   -3.19563732100,   -6.28473382085,    1.12394241249,  -0.175364901065,   -4.77212084362,    3.95791893946,
    4.46226543485,   -3.89444925619,   -8.74645850396,   -11.4856321658,    1.03529123844,   -3.08262042966,
   -5.38655433290,   -5.44641221973,   -2.87516480264,    3.51283765151,    1.00101216412,    2.25972447542,
    6.65935094182,    2.25691717471,    1.45528844758,    2.87287451220,   -12.0020462898,    6.80378366108,
   -13.1120021898,   -21.5884745239,    1.88241502240,    7.42132958226,   -7.46208658743,    11.4517516335,
   0.313854286943,    6.29032662774,   -6.47364612549,   -6.59806078449,  -0.206560379201,   -1.14299204712,
   -4.03303910361,   -4.70149806626,   0.823733923179,    11.4112320403,    6.35850336621,   -7.09732086170,
    1.83839328834,   -4.19956382234,  -0.817545630271,    4.32886732399,    7.02062231512,    5.93887287961,
    4.98178812755,    11.2369380302,    14.1327613027,    24.6607223608,    7.18696222212,    5.82666009926,
    3.66237190690,    2.75496955568,    1.76170682652,    2.17703943527,   -11.2385279478,    1.39081975589,
    2.99608668066,    2.00550909998,    4.70811456921,    3.81743460173,    3.05266424708,    4.67733974278,
   -10.9696196737,    4.09190734571,    2.83654536530,    5.71434286053,    98.6684618307,   -9.87229649908,
    5.27981451917,    1.26119834948,    3.47335810570,    13.9006086275,    7.31803758939,    5.83649997367,
},
{
   -1.43661669760,   -4.22556084587,   -6.04286677972,   -4.27079623153,   -16.7634577374,   -3.99370888359,
   -6.20630988686,   -8.15841326488,   -6.19424392149,   -6.15054479643,   -7.22139710446,   -5.70081880516,
    1.55758494558,   -5.08978296436,   -6.84928104137,   -4.59832563694,    2.57472739991,    4.06630928290,
   -9.39177531702,   -2.45959713642,   -4.43922102010,   -6.30293519068,   -1.68292210904,   -3.15759783481,
   -7.36867393869,   -6.93544144105,   -8.51024383753,   -7.04349262793,   -7.47507811941,   -7.93679465698,
  -0.655500619147, 0.00520850413779,    3.51830820868,    2.91896715975,   -3.12338044576,    2.04681763800,
   -7.84653437912,   -8.09631305473,   -1.79190636860,    2.37060247004,   -3.20809872200,    1.61928012390,
   -4.70358055171,   -6.02998849958,  -0.580323425396,  -0.497817484562,   -2.90566379430,    1.77152941632,
    2.73539255755, -0.0438466036696,   -9.62141229527,   -7.15385672093,    2.48195738147,   -1.78446843887,
   -6.79002948435,   -6.30970603601,   -4.14106321047,    2.18522773610,  0.0617025313115,    2.18580016393,
    7.91720330292,    3.62606894482,   0.716863814499,    3.00527857918,    9.42849253750,   -12.6839240768,
    4.18954888030,    1.70108151577,   -16.7877815213,   -11.1977046007,    9.29575996071,   -12.8169778043,
    7.54335481944,   -2.27483562655,   -3.88232908528,   -3.26077886935,   -3.27086927080,   -4.24027216807,
   -3.78271517431,   -3.82849120087,    1.07416732004,    11.9233162716,   -11.9243045226,    13.3534507787,
    1.17284223635,   -4.40884437221,   -2.90571696531,    2.55730386708,    6.09790724766,    4.11196661189,
    12.3088134260,    2.33851044078,    3.23790008991,    13.9006086275,    16.5612410921,    14.6330225498,
    5.44273872863,    2.44544825138,    3.87026004778,   0.788072126217,   -11.6729786631,    1.17416486145,
   0.625586580876,    4.26348616172,    8.26954420328,    7.41429879343,   -1.40380767879,    3.14984948426,
   -12.2432643529,    3.01638553195,   0.166041701236,    3.19368144731,   -9.87229649908,    95.1410445734,
    5.43369561992,    5.96833742143,    6.85570362359,    17.3359761659,    8.95675841254,    7.04208824378,
},
{
   -17.4134339546,   -1.75773570496,   -14.0912440427,   -3.42432463260,   -2.43434134683,   -3.52702931314,
   -5.10373631855,   -7.88809678529,   -6.50929731674,   -7.84653437912,   -11.8893635232,   -6.79922199279,
   -6.68837691359,   -8.02880140394,   -8.49276272601,   -6.20630988686,   -4.20846320503,   -5.14678983453,
    4.34231891950,   -2.59637492575,   -4.18361147861,   -4.91534081789,    2.77691764137,   -2.00135462423,
   -8.56595466210,   -7.61785716243,   -10.0869608861,   -7.90607148418,   -7.62228100824,   -9.79598600926,
   0.648060105356,   -3.02221399632,   -1.83170587234,   -2.37033491174,  -0.527049340161,    1.27190685484,
   -7.61047757684,   -5.83850222330,  0.0872816773914,    1.96844187389,   -3.76674627657,   0.859606531259,
   -4.09579126929,   -4.35783988847,    2.27346737812,    1.86609684761,   -3.57155025876,   0.892384226942,
   -2.81004665660,   -3.35210644563,   -5.37432696832,   -3.45626513000,  -0.986603121024,   -2.66294670741,
   -3.58332670710,   -5.03263931039,   -4.26389011473,   -1.39535571638,   -2.14215935276,  -0.538823633149,
    4.18885217231,    2.54581189924,    7.30349562037,    6.04429774214,    5.84810605862,    7.27804666997,
  -0.217621232298,  -0.607862524868,   -3.45130216438,   0.314755923607,    4.93464750296,    6.24180265424,
   -14.7625052036,   0.119462679144,   -1.32629124690,   -1.74931022596,   -16.3606587886,   -20.7829473955,
   -2.04081972113,   -2.50206994411,    4.57598222658,    4.08962687016,   -1.46189605730,    3.34668012401,
    4.72477703040,   0.659261570580,    10.1470993263,    13.6325647973,    9.54021935880,    2.95258478977,
   -8.33851406616,    5.64432273403,    6.13080095654,    5.93887287961,    11.0883737153,    23.4873253383,
   -12.9037604338,    1.83617274451,    10.8670443194,    2.27752614391,    4.13254115806,    3.06745698764,
    2.40375639965,    11.0796491579,    13.2137268024,    12.8234289622,    1.64544241710,    3.60711007986,
    3.61354047806,    2.12704020822,    5.10925342427,    3.78761175390,    5.27981451917,    5.43369561992,
    94.1372306530,    3.82132646761,    4.40043954301,    4.11196661190,   -13.6004620130,   -1.09564831427,
},
{
   -3.96687513396,   -18.3976865898,   -5.53141230965,   -13.9285718417,  -0.537906001096,   -1.97808516555,
   -7.88809678529,   -7.36238199152,   -6.72390343177,   -6.30970603601,   -7.42705630041,   -13.5953439229,
   -3.06099501395,   -4.19782340310,   -4.53722062451,   -8.15841326488,   -6.03427973474,   -5.97302395553,
   -3.31927402712,    3.97463653510,   0.846182241218,   0.699673230686,   -3.93903347767,   -3.78877759863,
   -5.44641221973,   -7.35459035667,   -8.52814552557,   -8.50314641749,   -8.68936039711,   -6.53319254708,
   -1.31988516118,  0.0530762724269,    2.05301896597,   0.651472016818,   -3.49650206722,   -3.04675227459,
   -5.03263931039,   -7.88914111836,   -1.23652875064,   -1.20420235933,   -3.52437410739,   0.590633792225,
   -3.08366691349,   -3.21707086342,    2.71151189023,    2.34670913657,   -2.90479889313,   0.934294689249,
   -1.37163023510,   -2.10738078932,   -4.05435495795,   -5.70466629849,   -4.27782577163,   -5.04394247808,
   -3.00247208670,  -0.725226738072,   0.722311796191,   0.112462804622,   -1.50142740200,   -4.57224088644,
    3.37896290047,    2.73971784574,    4.42154249574,    4.61452225228,    2.18987516681,    5.64722424249,
   -1.16301986843,   -2.61762276351,    2.91434752106,    1.57307864629,    4.91037153642,    8.60637122639,
  0.0688474955951,   -14.2515233115,   -18.5389743861,   -19.5588218250,   -1.50027454550,   -2.27303616948,
    1.18570542996,    1.20670176701,    6.95343835880,    6.66691905449,    1.30519160208,    4.96574729528,
    10.0730498543,    8.54277559021,    1.16047660536,  -0.338532291702,   -5.29735570343,    6.24180265424,
    4.86683987463,   -8.29754156395,    11.7034791276,    11.4517516335,    15.2833215316,    7.80962418292,
    1.88099997551,   -11.3771881230,    1.63728269312,    12.5879849047,    3.36886108025,    2.06125308493,
    12.9423641628,    1.95804453141,    4.07022363329,    2.84956457467,    11.4442099056,    12.1325078736,
    1.51214093103,   0.660741621798,    4.11048986679,    4.70113281529,    1.26119834948,    5.96833742143,
    3.82132646761,    95.8253560915,   -11.4937924601,   -12.8169778043,    13.1379198417,    5.44249526303,
},
{
   -4.09070881500,   -17.3220171221,   -3.63980243567,   -2.11136224508,   -1.61502794398,   -13.1943048089,
   -6.50929731674,   -6.72390343177,   -3.20219830206,   -9.62141229527,   -6.57582963161,   -4.70076357543,
   -3.83821499890,   -5.41431685967,   -7.33354399261,   -6.19424392149,   -3.40654646337,   -3.86241095315,
   -2.27640071874,    3.79095739238,    5.02034622785,  -0.479123945235,   -5.72021533230,   -6.49664214697,
   -8.74645850396,   -6.01767315498,   -9.94818435373,   -8.44202922569,   -6.52606891117,   -9.33963865749,
   -2.42287091649,  -0.380210961430,    1.05158253708,   0.530475704477,   -1.39059221097,  -0.642957914166,
   -5.37432696832,   -6.83419264548,   0.450688627235,    1.57698579440,   -3.16798642674,    1.26843494328,
   -3.12264250823,   -4.11852072757,    1.61158816726,    1.97210592684,   -1.63606896922,    2.93182498382,
   -3.51454627695,   -6.23340209851,   -6.61848412260,   -7.00279693580,   -2.68209384482,   -3.07052267766,
   -4.70767664646,   -4.05435495795,   -2.09613711355,   -5.88796619628,   -2.49753689780,   -1.37410684853,
    1.06752938523,  0.0849587942870,    3.38103514287,    4.05940570669,    4.15777877683,    7.36241256775,
   0.514136212441,   -2.30163312917,   0.545331558958,  0.0209809415685,    2.52357226846,    5.64722424249,
   -1.05510526828,    2.56894077997,    4.01875400135,    2.90487823575,   0.304161354887,  -0.702321383383,
   -18.3629095634,   -16.9846587415,   -11.2505893766,    8.51096261755,    2.52869602862,    7.19934538749,
   -7.84888069700,    9.88998691768,    1.88772939286,    1.39551041680,    15.5349777304,    7.27804666997,
    3.94284580098,    7.21247353087,   -12.0089431300,    6.80378366108,    13.6763017879,    6.14401133253,
    3.11372650764,   -10.4179101369,    2.46532995184,    1.39654183047,    2.96750226889,    11.9416522898,
    1.87942139897,    2.17686565290,    3.61855263797,    2.26907424018,    1.31728951722,    2.72936358630,
   0.677327563698,    10.3977310850,    13.8527965563,    14.8468941777,    3.47335810570,    6.85570362359,
    4.40043954301,   -11.4937924601,    96.4518701114,   -12.6839240768,    13.2818405765,    5.80496011766,
},
{
   -2.90571696531,   -16.7877815213,   -4.14106321047,   -3.20809872200,   -11.9243045226,   -2.90566379430,
   -7.84653437912,   -6.30970603601,   -9.62141229527,   -4.59832563694,   -7.47507811941,   -5.70081880516,
   -3.78271517431,   -4.70358055171,   -7.36867393869,   -6.15054479643,   -3.26077886935,   -6.30293519068,
   -4.40884437221,    1.70108151577, -0.0438466036696,    4.06630928290,   -4.24027216807,   -3.15759783481,
   -6.84928104137,   -7.15385672093,   -6.79002948435,   -8.09631305473,   -7.22139710446,   -7.93679465698,
   -1.79190636860,  0.0617025313114,   0.716863814499,   0.166041701236,   -3.12338044576,   -1.40380767879,
   -6.20630988686,   -7.04349262793,  -0.655500619147,   0.625586580876,   -4.27079623153,   0.788072126217,
   -5.08978296436,   -1.78446843887,    3.62606894482,    3.01638553195,   -3.99370888359,    1.17416486145,
   -3.88232908528,   -4.43922102010,   -6.19424392149,   -6.93544144105,   -3.82849120087,   -6.02998849958,
   -8.51024383753,   -8.15841326488,   -6.04286677972,    3.87026004778, 0.00520850413777,    4.26348616172,
    1.07416732004,  -0.580323425396,    3.51830820868,    8.26954420328,    3.23790008991,    6.85570362359,
   -2.27483562655,   -2.45959713642,   -4.22556084587,    2.44544825138,    2.33851044078,    5.96833742143,
    1.17284223635,    4.18954888030,    2.73539255755,    2.57472739991,   -3.27086927080,   -1.68292210904,
    1.55758494558,    2.48195738147,    7.91720330292,   -12.2432643529,   -16.7634577374,   -11.6729786631,
    7.54335481944,   -9.39177531702,   -1.43661669760,    5.44273872863,    12.3088134260,    5.43369561992,
    6.09790724766,    9.29575996071,    9.42849253750,   -9.87229649908,    16.5612410921,    8.95675841254,
    2.55730386708,   -11.1977046007,    2.18522773610,    1.61928012390,    13.3534507787,    1.77152941632,
    2.37060247004,    2.18580016393,    3.00527857918,    3.19368144731,    2.04681763800,    3.14984948426,
    11.9233162716,  -0.497817484562,    2.91896715975,    7.41429879343,    13.9006086275,    17.3359761659,
    4.11196661190,   -12.8169778043,   -12.6839240768,    95.1410445734,    14.6330225498,    7.04208824378,
},
{
   -15.7714696397,   -12.7359922823,   -3.04768959184,   -6.03443377457,   -4.17525572483,   -5.49689862569,
   -11.8893635232,   -7.42705630041,   -6.57582963161,   -7.47507811941,   -7.26558298022,   -9.41793008863,
   -2.61517726585,   -3.90690736715,   -6.50728434006,   -7.22139710446,   -3.36354084830,   -5.30466293646,
    3.23042948793,   -3.15950591385,   -5.51170646267,   -6.45874811277,    4.87083197795,   0.470523253304,
   -6.79811016906,   -6.46198437092,   -6.78794619835,   -9.33786975830,   -10.8203866155,   -8.67247228685,
   0.963561730308,   -3.00379402614,   -1.48303979002,  -0.963704921350,    1.43073220478,    3.00380912726,
   -7.62228100824,   -7.04252427141,   -1.39758341021,   0.135824431576,   -4.23299685560,    1.72684525309,
   -3.84237277717,   -2.99515736580,    3.26675519699,    3.35725030544,   -3.14490568256,    2.76659868630,
   -3.05018339346,   -5.29810362710,   -6.52606891117,   -7.39504638297,   -3.37577633747,   -4.73781547117,
   -13.0398138120,   -8.68936039712,   -7.36658175599,    5.51065378265,    2.67602940790,    2.38818731746,
    1.67444252606,   0.219686486452,    2.78643342225,    2.67799341696,    3.49249165404,    6.14401133253,
  -0.288350770806,   -2.75213165922,   -4.99338303655,    7.68438220043,    5.11985745270,    7.80962418292,
    3.17239108681,  -0.453212325349,   -2.80677249714,   -3.78922402605,    5.19487052725,   0.342721870139,
   -3.79629591723,   -2.76899080156,    3.17903115692,    3.43150830196,   -2.93284896764,    2.76355973272,
   -14.7753124299,   -19.8582350703,    8.60717933673, -0.0679883047309,   -9.37774635473,    23.4873253383,
    8.69796976280,    5.25351092114,    5.42245148490,    5.82666009926,   -10.6900502580,    21.1906530124,
   -12.4658563158,    12.0368225525,   0.283315126158,    4.24056105166,    6.04967090955,    4.63861937546,
    3.57441254429,    1.17390695484,    2.09320522335,    3.30475352149,    3.96775742616,    5.59392466674,
    5.57269052947,    4.22568698788,    5.76091246408,    6.18971629783,    7.31803758939,    8.95675841254,
   -13.6004620130,    13.1379198417,    13.2818405765,    14.6330225498,    95.0549573511,  -0.201028443308,
},
{
   -29.6934146419,   -4.69893147886,   -5.32764231058,   -3.80182453265,   -2.00425841399,   -3.31381710689,
   -6.79922199279,   -13.5953439229,   -4.70076357543,   -5.70081880516,   -9.41793008863,   -7.07451952436,
   -3.35031062359,   -4.80906526575,   -8.15448489157,   -5.70081880516,   -2.54663857301,   -5.22313360386,
    2.31078513921,   -1.69030572390,   -4.21925717124,   -5.22313360386,    1.85902383774,    1.58839264994,
   -8.15448489157,   -5.73626900280,   -10.1740482357,   -6.75964659113,   -9.41793008863,   -10.7815827017,
  -0.822761627120,   -1.72460020986, -0.0424397035294,    2.11615664827,   0.170657990262,    2.33797744968,
   -6.79922199279,   -6.75964659112,  -0.822761627120,    1.77926900938,   -3.80182453265,    1.90846053913,
   -4.80906526575,   -3.35179369511,    2.02183256873,    2.61850268380,   -3.31381710689,    2.64266037378,
   -2.02802672410,   -4.21925717124,   -4.70076357543,   -5.73626900280,   -2.02151439206,   -3.35179369511,
   -10.1740482357,   -13.5953439229,   -5.32764231058,    3.32191661492,   -1.72460020986,    3.10532137185,
    3.37243472607,    2.02183256873, -0.0424397035295,    4.15892129831,    5.64316448556,    5.80496011766,
-0.00675287102233,   -1.69030572390,   -4.69893147886,    3.95863320677,    5.36585346694,    5.44249526303,
    1.42851903350,-0.00675287102233,   -2.02802672410,   -2.54663857301,    1.38599815357,    1.85902383774,
   -3.35031062359,   -2.02151439206,    3.37243472607,    3.95757418947,   -2.00425841399,    3.97585019365,
    1.42851903350,    2.31078513921,   -29.6934146419,   0.514937591235,    7.06585597865,   -1.09564831427,
    7.06585597865,    5.36585346694,    5.64316448556,    5.83649997367,    6.94511364434,  -0.201028443308,
   0.514937591235,    3.95863320677,    3.32191661492,    1.90846053913,    3.97585019365,    2.64266037378,
    1.77926900938,    3.10532137185,    4.15892129831,    5.38523171468,    2.33797744968,    4.00304809629,
    3.95757418947,    2.61850268380,    2.11615664827,    5.38523171468,    5.83649997367,    7.04208824378,
   -1.09564831427,    5.44249526303,    5.80496011766,    7.04208824378,  -0.201028443308,    119.836425318,
}
};
			       
