/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaAvroSerializer
extends AbstractKafkaAvroSerializer
implements Serializer<Object> {
    public KafkaAvroSerializer() {
    }

    public KafkaAvroSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
    }

    public KafkaAvroSerializer(SchemaRegistryClient client, Map<String, ?> props) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
        this.configure(this.serializerConfig(props));
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.configure(new KafkaAvroSerializerConfig(configs));
    }

    public byte[] serialize(String topic, Object data) {
        return this.serialize(topic, null, data);
    }

    public byte[] serialize(String topic, Headers headers, Object record) {
        if (record == null) {
            return null;
        }
        AvroSchema schema = new AvroSchema(AvroSchemaUtils.getSchema((Object)record, (boolean)this.useSchemaReflection, (boolean)this.avroReflectionAllowNull, (boolean)this.avroUseLogicalTypeConverters, (boolean)this.removeJavaProperties, (boolean)true));
        return this.serializeImpl(this.getSubjectName(topic, this.isKey, record, (ParsedSchema)schema), topic, headers, record, schema);
    }

    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while closing serializer", e);
        }
    }
}

