/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.catalog.predicate;

import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.registry.catalog.Extension;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ExtensionPredicate
implements Predicate<Extension> {
    private final String q;

    public ExtensionPredicate(String keyword) {
        this.q = Objects.requireNonNull(keyword, "keyword must not be null").trim().toLowerCase();
    }

    public static Predicate<Extension> create(String keyword) {
        return new ExtensionPredicate(keyword);
    }

    public static boolean isPattern(String keyword) {
        for (char c : keyword.toCharArray()) {
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean test(Extension extension) {
        ExtensionProcessor extensionMetadata = ExtensionProcessor.of(extension);
        if (extensionMetadata.isUnlisted()) {
            return false;
        }
        String extensionName = Objects.toString(extension.getName(), "");
        String shortName = Objects.toString(extensionMetadata.getShortName(), "");
        if (this.isExactMatch(extension)) {
            return true;
        }
        if (ExtensionPredicate.matchesShortName(extension, this.q)) {
            return true;
        }
        if (extensionName.toLowerCase().contains(this.q) || extension.getArtifact().getArtifactId().toLowerCase().contains(this.q) || shortName.toLowerCase().contains(this.q)) {
            return true;
        }
        if (extensionMetadata.getExtendedKeywords().contains(this.q)) {
            return true;
        }
        Pattern pattern = ExtensionPredicate.toRegex(this.q);
        return pattern != null && (pattern.matcher(extensionName.toLowerCase()).matches() || pattern.matcher(extension.getArtifact().getArtifactId().toLowerCase()).matches() || pattern.matcher(shortName.toLowerCase()).matches() || ExtensionPredicate.matchLabels(pattern, extensionMetadata.getKeywords()));
    }

    public boolean isExactMatch(Extension extension) {
        String extensionName = Objects.toString(extension.getName(), "");
        return extensionName.equalsIgnoreCase(this.q) || ExtensionPredicate.matchesArtifactId(extension.getArtifact().getArtifactId(), this.q);
    }

    private static boolean matchesShortName(Extension extension, String q) {
        return q.equalsIgnoreCase(ExtensionProcessor.getShortName(extension));
    }

    private static boolean matchesArtifactId(String artifactId, String q) {
        return artifactId.equalsIgnoreCase(q) || artifactId.equalsIgnoreCase("quarkus-" + q);
    }

    private static boolean matchLabels(Pattern pattern, List<String> labels) {
        boolean matches = false;
        for (String label : labels) {
            matches = matches || pattern.matcher(label.toLowerCase()).matches();
        }
        return matches;
    }

    private static Pattern toRegex(String str) {
        try {
            String wildcardToRegex = ExtensionPredicate.wildcardToRegex(str);
            if (wildcardToRegex != null && !wildcardToRegex.isEmpty()) {
                return Pattern.compile(wildcardToRegex, 2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return null;
    }

    private static String wildcardToRegex(String wildcard) {
        if (wildcard == null || wildcard.isEmpty()) {
            return null;
        }
        if (!wildcard.contains("*") && !wildcard.contains("?")) {
            return null;
        }
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append("^.*");
        int is = wildcard.length();
        block6: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block6;
                }
                case '?': {
                    s.append(".");
                    continue block6;
                }
                case '^': {
                    s.append("\\");
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block6;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append(".*$");
        return s.toString();
    }
}

