/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import com.headius.backport9.buffer.Buffers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import jnr.enxio.channels.NativeSelectorProvider;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyIO;
import org.jruby.RubyThread;
import org.jruby.api.Create;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.OpenFile;

public class SelectExecutor {
    private static final RubyThread.Task<SelectExecutor, Integer> SelectTask = new RubyThread.Task<SelectExecutor, Integer>(){

        @Override
        public Integer run(ThreadContext context, SelectExecutor s2) throws InterruptedException {
            int ready = 0;
            try {
                int i2;
                if (s2.mainSelector != null) {
                    if (s2.pendingReadFDs == null) {
                        if (s2.timeout != null && s2.timeout == 0L) {
                            for (i2 = 0; i2 < s2.selectors.size(); ++i2) {
                                Selector selector = s2.selectors.get(i2);
                                ready += selector.selectNow();
                            }
                        } else {
                            ENXIOSelector enxioSelector;
                            int i3;
                            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(s2.enxioSelectors.size());
                            for (i3 = 0; i3 < s2.enxioSelectors.size(); ++i3) {
                                enxioSelector = s2.enxioSelectors.get(i3);
                                futures.add(context.runtime.getExecutor().submit(enxioSelector));
                            }
                            ready += s2.mainSelector.select(s2.timeout == null ? 0L : s2.timeout);
                            for (i3 = 0; i3 < s2.enxioSelectors.size(); ++i3) {
                                enxioSelector = s2.enxioSelectors.get(i3);
                                enxioSelector.selector.wakeup();
                            }
                            for (i3 = 0; i3 < futures.size(); ++i3) {
                                try {
                                    Future f = (Future)futures.get(i3);
                                    f.get();
                                    continue;
                                }
                                catch (InterruptedException f) {
                                    continue;
                                }
                                catch (ExecutionException eex) {
                                    if (!(eex.getCause() instanceof IOException)) continue;
                                    throw (IOException)eex.getCause();
                                }
                            }
                        }
                    } else {
                        for (int i4 = 0; i4 < s2.selectors.size(); ++i4) {
                            Selector selector = s2.selectors.get(i4);
                            ready += selector.selectNow();
                        }
                    }
                }
                for (i2 = 0; i2 < s2.enxioSelectors.size(); ++i2) {
                    ENXIOSelector enxioSelector = s2.enxioSelectors.get(i2);
                    Pipe.SourceChannel source2 = enxioSelector.pipe.source();
                    SelectionKey key2 = source2.keyFor(s2.mainSelector);
                    if (key2 == null || !s2.mainSelector.selectedKeys().contains(key2)) continue;
                    s2.mainSelector.selectedKeys().remove(key2);
                    ByteBuffer buf = ByteBuffer.allocate(1);
                    source2.read(buf);
                }
            }
            catch (IOException ioe) {
                throw context.runtime.newIOErrorFromException(ioe);
            }
            return ready;
        }

        @Override
        public void wakeup(RubyThread thread2, SelectExecutor selectExecutor) {
            thread2.getNativeThread().interrupt();
            for (int i2 = 0; i2 < selectExecutor.selectors.size(); ++i2) {
                Selector selector = selectExecutor.selectors.get(i2);
                selector.wakeup();
            }
        }
    };
    final IRubyObject read;
    final IRubyObject write;
    final IRubyObject except;
    List<SelectionKey> readKeyList;
    List<SelectionKey> writeKeyList;
    List<SelectionKey> errorKeyList;
    List<ChannelFD> unselectableReadFDs;
    List<ChannelFD> unselectableWriteFDs;
    List<ChannelFD> pendingReadFDs;
    Selector mainSelector = null;
    List<Selector> selectors = null;
    List<ENXIOSelector> enxioSelectors = Collections.emptyList();
    Long timeout;
    final Ruby runtime;
    public static final int READ_ACCEPT_OPS = 17;
    public static final int WRITE_CONNECT_OPS = 12;

    public SelectExecutor(IRubyObject read2, IRubyObject write2, IRubyObject except2, Long timeout2) {
        this.read = read2;
        this.write = write2;
        this.except = except2;
        this.timeout = timeout2;
        this.runtime = read2.getRuntime();
    }

    public IRubyObject go(ThreadContext context) {
        try {
            IRubyObject iRubyObject = this.selectCall(context);
            return iRubyObject;
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        finally {
            try {
                this.selectEnd(context);
            }
            catch (IOException iOException) {}
        }
    }

    IRubyObject selectCall(ThreadContext context) throws IOException {
        return this.selectInternal(context);
    }

    IRubyObject selectEnd(ThreadContext context) throws IOException {
        if (this.selectors != null) {
            for (int i2 = 0; i2 < this.selectors.size(); ++i2) {
                Selector selector = this.selectors.get(i2);
                if (selector.provider() == SelectorProvider.provider()) {
                    context.runtime.getSelectorPool().put(selector);
                    continue;
                }
                selector.close();
            }
            for (ENXIOSelector enxioSelector : this.enxioSelectors) {
                enxioSelector.cleanup();
            }
        }
        return context.nil;
    }

    IRubyObject selectInternal(ThreadContext context) throws IOException {
        RubyArray<?> error2;
        RubyIO write_io;
        RubyIO io2;
        Object obj;
        RubyArray<?> writeReady;
        RubyArray<?> readReady;
        int n;
        OpenFile fptr;
        long i2;
        Ruby runtime2 = context.runtime;
        RubyArray readAry = null;
        if (!this.read.isNil()) {
            readAry = this.read.convertToArray();
            for (i2 = 0L; i2 < (long)readAry.size(); ++i2) {
                fptr = TypeConverter.ioGetIO(runtime2, readAry.eltOk(i2)).getOpenFileChecked();
                this.fdSetRead(context, fptr.fd(), readAry.size());
                if (!fptr.READ_DATA_PENDING() && !fptr.READ_CHAR_PENDING()) continue;
                if (this.pendingReadFDs == null) {
                    this.pendingReadFDs = new ArrayList<ChannelFD>(1);
                }
                this.pendingReadFDs.add(fptr.fd());
            }
            if (this.pendingReadFDs != null || this.unselectableReadFDs != null) {
                this.timeout = 0L;
            }
        }
        RubyArray writeAry = null;
        if (!this.write.isNil()) {
            writeAry = this.write.convertToArray();
            for (i2 = 0L; i2 < (long)writeAry.size(); ++i2) {
                RubyIO write_io2 = TypeConverter.ioGetIO(runtime2, writeAry.eltOk(i2)).GetWriteIO();
                fptr = write_io2.getOpenFileChecked();
                this.fdSetWrite(context, fptr.fd(), writeAry.size());
            }
            if (this.unselectableWriteFDs != null) {
                this.timeout = 0L;
            }
        }
        RubyArray exceptAry = null;
        if (!this.except.isNil()) {
            exceptAry = this.except.convertToArray();
            for (i2 = 0L; i2 < (long)exceptAry.size(); ++i2) {
                RubyIO io3 = TypeConverter.ioGetIO(runtime2, exceptAry.eltOk(i2));
                RubyIO write_io3 = io3.GetWriteIO();
                io3.getOpenFileChecked();
                if (io3 == write_io3) continue;
                write_io3.getOpenFileChecked();
            }
        }
        if ((n = this.threadFdSelect(context)) == 0 && this.pendingReadFDs == null && this.unselectableReadFDs == null && this.unselectableWriteFDs == null) {
            return context.nil;
        }
        if (this.readKeyList == null && this.pendingReadFDs == null && this.unselectableReadFDs == null) {
            readReady = Create.newEmptyArray(context);
        } else {
            int len = Math.min(n, this.maxReadReadySize());
            readReady = Create.allocArray(context, len);
            for (i2 = 0L; i2 < (long)readAry.size(); ++i2) {
                Object obj2 = readAry.eltOk(i2);
                RubyIO io4 = TypeConverter.ioGetIO(runtime2, obj2);
                fptr = io4.getOpenFileChecked();
                if (!(this.readKeyList != null && this.fdIsSet(this.readKeyList, fptr.fd(), 17) || this.pendingReadFDs != null && this.pendingReadFDs.contains(fptr.fd())) && (this.unselectableReadFDs == null || !this.unselectableReadFDs.contains(fptr.fd()))) continue;
                readReady.append(context, (IRubyObject)obj2);
            }
        }
        if (this.writeKeyList == null && this.unselectableWriteFDs == null) {
            writeReady = Create.newEmptyArray(context);
        } else {
            int len = Math.min(n, this.maxWriteReadySize());
            writeReady = Create.allocArray(context, len);
            for (i2 = 0L; i2 < (long)writeAry.size(); ++i2) {
                obj = writeAry.eltOk(i2);
                io2 = TypeConverter.ioGetIO(runtime2, obj);
                write_io = io2.GetWriteIO();
                fptr = write_io.getOpenFileChecked();
                if ((this.writeKeyList == null || !this.fdIsSet(this.writeKeyList, fptr.fd(), 12)) && (this.unselectableWriteFDs == null || !this.unselectableWriteFDs.contains(fptr.fd()))) continue;
                writeReady.push(context, (IRubyObject)obj);
            }
        }
        if (this.errorKeyList == null) {
            error2 = Create.newEmptyArray(context);
        } else {
            error2 = Create.allocArray(context, exceptAry.size());
            for (i2 = 0L; i2 < (long)exceptAry.size(); ++i2) {
                obj = exceptAry.eltOk(i2);
                io2 = TypeConverter.ioGetIO(runtime2, obj);
                write_io = io2.GetWriteIO();
                fptr = io2.getOpenFileChecked();
                if (!this.fdIsSet(this.errorKeyList, fptr.fd(), 29) && (io2 == write_io || !this.fdIsSet(this.errorKeyList, write_io.getOpenFileChecked().fd(), 29))) continue;
                error2.push(context, (IRubyObject)obj);
            }
        }
        return Create.newArray(context, readReady, writeReady, error2);
    }

    private int maxReadReadySize() {
        int size2 = 0;
        if (this.readKeyList != null) {
            size2 += this.readKeyList.size();
        }
        if (this.unselectableReadFDs != null) {
            size2 += this.unselectableReadFDs.size();
        }
        return size2;
    }

    private int maxWriteReadySize() {
        int size2 = 0;
        if (this.writeKeyList != null) {
            size2 += this.writeKeyList.size();
        }
        if (this.unselectableWriteFDs != null) {
            size2 += this.unselectableWriteFDs.size();
        }
        return size2;
    }

    private void fdSetRead(ThreadContext context, ChannelFD fd, int maxSize) throws IOException {
        if (fd.chSelect == null) {
            if (this.unselectableReadFDs == null) {
                this.unselectableReadFDs = new ArrayList<ChannelFD>(1);
            }
            this.unselectableReadFDs.add(fd);
            return;
        }
        SelectionKey key2 = this.trySelectRead(context, fd);
        if (key2 == null) {
            return;
        }
        if (this.readKeyList == null) {
            this.readKeyList = new ArrayList<SelectionKey>(1);
        }
        this.readKeyList.add(key2);
    }

    private void fdSetWrite(ThreadContext context, ChannelFD fd, int maxSize) throws IOException {
        if (fd.chSelect == null) {
            if (this.unselectableWriteFDs == null) {
                this.unselectableWriteFDs = new ArrayList<ChannelFD>(1);
            }
            this.unselectableWriteFDs.add(fd);
            return;
        }
        SelectionKey key2 = this.trySelectWrite(context, fd);
        if (key2 == null) {
            return;
        }
        if (this.writeKeyList == null) {
            this.writeKeyList = new ArrayList<SelectionKey>(1);
        }
        this.writeKeyList.add(key2);
    }

    private boolean fdIsSet(List<SelectionKey> fds, ChannelFD fd, int operations) {
        if (fds == null) {
            return false;
        }
        for (SelectionKey key2 : fds) {
            if (!key2.isValid() || (key2.readyOps() & operations) == 0 || !((List)key2.attachment()).contains(fd)) continue;
            return true;
        }
        return false;
    }

    private SelectionKey trySelectRead(ThreadContext context, ChannelFD fd) throws IOException {
        if (fd.chSelect != null) {
            return SelectExecutor.registerSelect(this.getSelector(context, fd.chSelect), fd, fd.chSelect, 17);
        }
        return null;
    }

    private SelectionKey trySelectWrite(ThreadContext context, ChannelFD fd) throws IOException {
        if (fd.chSelect != null) {
            return SelectExecutor.registerSelect(this.getSelector(context, fd.chSelect), fd, fd.chSelect, 12);
        }
        return null;
    }

    private Selector getSelector(ThreadContext context, SelectableChannel channel) throws IOException {
        Selector selector = null;
        if (this.selectors == null) {
            this.selectors = new ArrayList<Selector>(1);
        } else {
            for (int i2 = 0; i2 < this.selectors.size(); ++i2) {
                Selector sel = this.selectors.get(i2);
                if (sel.provider() != channel.provider()) continue;
                selector = sel;
                break;
            }
        }
        if (selector == null) {
            if (channel.provider() instanceof NativeSelectorProvider) {
                selector = channel.provider().openSelector();
                Pipe pipe2 = Pipe.open();
                ENXIOSelector enxioSelector = new ENXIOSelector(selector, pipe2);
                if (this.enxioSelectors.isEmpty()) {
                    this.enxioSelectors = new ArrayList<ENXIOSelector>();
                }
                this.enxioSelectors.add(enxioSelector);
                pipe2.source().configureBlocking(false);
                pipe2.source().register(this.getSelector(context, pipe2.source()), 1, enxioSelector);
            } else {
                selector = context.runtime.getSelectorPool().get();
                if (this.mainSelector == null) {
                    this.mainSelector = selector;
                }
            }
            this.selectors.add(selector);
        }
        return selector;
    }

    private static SelectionKey registerSelect(Selector selector, ChannelFD attachment, SelectableChannel channel, int ops) throws IOException {
        channel.configureBlocking(false);
        int real_ops = channel.validOps() & ops;
        SelectionKey key2 = channel.keyFor(selector);
        if (key2 != null) {
            key2.interestOps(key2.interestOps() | real_ops);
            List attachmentSet = (List)key2.attachment();
            if (!attachmentSet.contains(attachment)) {
                attachmentSet.add(attachment);
            }
            return key2;
        }
        ArrayList<ChannelFD> attachmentSet = new ArrayList<ChannelFD>(1);
        attachmentSet.add(attachment);
        return channel.register(selector, real_ops, attachmentSet);
    }

    private int threadFdSelect(ThreadContext context) {
        if (this.readKeyList == null && this.writeKeyList == null && this.errorKeyList == null) {
            if (this.timeout == null) {
                try {
                    context.getThread().sleep(0L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return 0;
            }
            if (this.timeout == 0L) {
                return 0;
            }
            try {
                context.getThread().sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return 0;
        }
        if (this.readKeyList != null) {
            // empty if block
        }
        if (this.writeKeyList != null) {
            // empty if block
        }
        if (this.errorKeyList != null) {
            // empty if block
        }
        return this.doSelect(context);
    }

    private int doSelect(ThreadContext context) {
        int result2;
        double limit2 = 0.0;
        RubyThread th = context.getThread();
        boolean lerrno = false;
        try {
            result2 = th.executeTaskBlocking(context, this, SelectTask);
        }
        catch (InterruptedException ie) {
            throw context.runtime.newErrnoEINTRError();
        }
        return result2;
    }

    private static final class ENXIOSelector
    implements Callable<Object> {
        private final Selector selector;
        private final Pipe pipe;

        private ENXIOSelector(Selector selector, Pipe pipe2) {
            this.selector = selector;
            this.pipe = pipe2;
        }

        @Override
        public Object call() throws Exception {
            try {
                this.selector.select();
            }
            finally {
                ByteBuffer buf = ByteBuffer.allocate(1);
                buf.put((byte)0);
                Buffers.flipBuffer(buf);
                this.pipe.sink().write(buf);
            }
            return null;
        }

        public void cleanup() throws IOException {
            this.pipe.sink().close();
            this.pipe.source().close();
        }
    }
}

