/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public abstract class NationType
extends FreeColSpecObjectType {
    private SettlementNumber numberOfSettlements = SettlementNumber.AVERAGE;
    private AggressionLevel aggression = AggressionLevel.AVERAGE;
    private List<SettlementType> settlementTypes = null;
    private static final String AGGRESSION_TAG = "aggression";
    private static final String NUMBER_OF_SETTLEMENTS_TAG = "number-of-settlements";
    private static final String SETTLEMENT_TAG = "settlement";

    public NationType(String id, Specification specification) {
        super(id, specification);
    }

    public final List<SettlementType> getSettlementTypes() {
        return this.settlementTypes == null ? Collections.emptyList() : this.settlementTypes;
    }

    public final void setSettlementTypes(List<SettlementType> settlementTypes) {
        if (this.settlementTypes == null) {
            this.settlementTypes = new ArrayList<SettlementType>();
        } else {
            this.settlementTypes.clear();
        }
        this.settlementTypes.addAll(settlementTypes);
    }

    private void addSettlementType(SettlementType settlementType) {
        if (this.settlementTypes == null) {
            this.settlementTypes = new ArrayList<SettlementType>();
        }
        this.settlementTypes.add(settlementType);
    }

    private void addSettlementTypes(List<SettlementType> types) {
        if (this.settlementTypes == null) {
            this.settlementTypes = new ArrayList<SettlementType>();
        }
        this.settlementTypes.addAll(types);
    }

    public SettlementType getCapitalType() {
        return this.getSettlementType(true);
    }

    public SettlementType getSettlementType(boolean isCapital) {
        return CollectionUtils.find(this.getSettlementTypes(), CollectionUtils.matchKey(isCapital, SettlementType::isCapital));
    }

    public SettlementType getSettlementType(String id) {
        return CollectionUtils.find(this.getSettlementTypes(), CollectionUtils.matchKeyEquals(id, FreeColObject::getId));
    }

    public final SettlementNumber getNumberOfSettlements() {
        return this.numberOfSettlements;
    }

    public final AggressionLevel getAggression() {
        return this.aggression;
    }

    public abstract boolean isEuropean();

    public abstract boolean isIndian();

    public abstract boolean isREF();

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        NationType o = this.copyInCast(other, NationType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.numberOfSettlements = o.getNumberOfSettlements();
        this.aggression = o.getAggression();
        this.setSettlementTypes(o.getSettlementTypes());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NUMBER_OF_SETTLEMENTS_TAG, this.numberOfSettlements);
        xw.writeAttribute(AGGRESSION_TAG, this.aggression);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (SettlementType settlementType : this.getSettlementTypes()) {
            settlementType.toXML(xw, SETTLEMENT_TAG);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        NationType parent = xr.getType(spec, "extends", NationType.class, this);
        this.numberOfSettlements = xr.getAttribute(NUMBER_OF_SETTLEMENTS_TAG, SettlementNumber.class, parent.numberOfSettlements);
        this.aggression = xr.getAttribute(AGGRESSION_TAG, AggressionLevel.class, parent.aggression);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec;
        NationType parent;
        if (xr.shouldClearContainers()) {
            this.settlementTypes = null;
        }
        if ((parent = xr.getType(spec = this.getSpecification(), "extends", NationType.class, this)) != this) {
            if (parent.settlementTypes != null) {
                this.addSettlementTypes(parent.settlementTypes);
            }
            this.addFeatures(parent);
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (SETTLEMENT_TAG.equals(tag)) {
            this.addSettlementType(new SettlementType(xr, spec));
        } else {
            super.readChild(xr);
        }
    }

    public static enum AggressionLevel {
        LOW,
        AVERAGE,
        HIGH;


        public String getKey() {
            return "aggressionLevel." + StringUtils.getEnumKey(this);
        }
    }

    public static enum SettlementNumber {
        LOW,
        AVERAGE,
        HIGH;


        public String getKey() {
            return "settlementNumber." + StringUtils.getEnumKey(this);
        }
    }
}

