/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.UnitAction;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;

public class ImprovementAction
extends UnitAction {
    private final TileImprovementType improvement;

    public ImprovementAction(FreeColClient freeColClient, TileImprovementType improvement) {
        super(freeColClient, improvement.getSuffix() + "Action");
        this.improvement = improvement;
        this.addImageIcons(improvement.getSuffix());
    }

    @Override
    protected boolean shouldBeEnabled() {
        if (!super.shouldBeEnabled()) {
            return false;
        }
        Unit selectedUnit = this.getGUI().getActiveUnit();
        Tile tile = selectedUnit.getTile();
        return tile != null && tile.isImprovementTypeAllowed(this.improvement) && this.improvement.isWorkerAllowed(selectedUnit) && selectedUnit.checkSetState(Unit.UnitState.IMPROVING);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Unit unit = this.getGUI().getActiveUnit();
        if (unit == null) {
            return;
        }
        this.igc().changeWorkImprovementType(unit, this.improvement);
    }
}

