/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.snapshot.ChildKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Path
implements Iterable<ChildKey>,
Comparable<Path> {
    private static final Path EMPTY_PATH = new Path("");
    private final ChildKey[] pieces;
    private final int start;
    private final int end;

    public Path(ChildKey ... segments) {
        this.pieces = Arrays.copyOf(segments, segments.length);
        this.start = 0;
        this.end = segments.length;
        for (ChildKey name : segments) {
            assert (name != null) : "Can't construct a path with a null value!";
        }
    }

    public Path(List<String> segments) {
        this.pieces = new ChildKey[segments.size()];
        int i = 0;
        for (String segment : segments) {
            this.pieces[i++] = ChildKey.fromString(segment);
        }
        this.start = 0;
        this.end = segments.size();
    }

    public Path(String pathString) {
        String[] segments = pathString.split("/");
        int count = 0;
        for (String segment : segments) {
            if (segment.length() <= 0) continue;
            ++count;
        }
        this.pieces = new ChildKey[count];
        int j = 0;
        for (String segment : segments) {
            if (segment.length() <= 0) continue;
            this.pieces[j++] = ChildKey.fromString(segment);
        }
        this.start = 0;
        this.end = this.pieces.length;
    }

    private Path(ChildKey[] pieces, int start, int end) {
        this.pieces = pieces;
        this.start = start;
        this.end = end;
    }

    public static Path getRelative(Path from, Path to) {
        ChildKey outerFront = from.getFront();
        ChildKey innerFront = to.getFront();
        if (outerFront == null) {
            return to;
        }
        if (outerFront.equals(innerFront)) {
            return Path.getRelative(from.popFront(), to.popFront());
        }
        throw new DatabaseException("INTERNAL ERROR: " + to + " is not contained in " + from);
    }

    public static Path getEmptyPath() {
        return EMPTY_PATH;
    }

    public Path child(Path path) {
        int newSize = this.size() + path.size();
        ChildKey[] newPieces = new ChildKey[newSize];
        System.arraycopy(this.pieces, this.start, newPieces, 0, this.size());
        System.arraycopy(path.pieces, path.start, newPieces, this.size(), path.size());
        return new Path(newPieces, 0, newSize);
    }

    public Path child(ChildKey child) {
        int size = this.size();
        ChildKey[] newPieces = new ChildKey[size + 1];
        System.arraycopy(this.pieces, this.start, newPieces, 0, size);
        newPieces[size] = child;
        return new Path(newPieces, 0, size + 1);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            builder.append("/");
            builder.append(this.pieces[i].asString());
        }
        return builder.toString();
    }

    public String wireFormat() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            if (i > this.start) {
                builder.append("/");
            }
            builder.append(this.pieces[i].asString());
        }
        return builder.toString();
    }

    public List<String> asList() {
        ArrayList<String> result = new ArrayList<String>(this.size());
        for (ChildKey key : this) {
            result.add(key.asString());
        }
        return result;
    }

    public ChildKey getFront() {
        if (this.isEmpty()) {
            return null;
        }
        return this.pieces[this.start];
    }

    public Path popFront() {
        int newStart = this.start;
        if (!this.isEmpty()) {
            ++newStart;
        }
        return new Path(this.pieces, newStart, this.end);
    }

    public Path getParent() {
        if (this.isEmpty()) {
            return null;
        }
        return new Path(this.pieces, this.start, this.end - 1);
    }

    public ChildKey getBack() {
        if (!this.isEmpty()) {
            return this.pieces[this.end - 1];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.start >= this.end;
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public Iterator<ChildKey> iterator() {
        return new Iterator<ChildKey>(){
            int offset;
            {
                this.offset = Path.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.offset < Path.this.end;
            }

            @Override
            public ChildKey next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements.");
                }
                ChildKey child = Path.this.pieces[this.offset];
                ++this.offset;
                return child;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove component from immutable Path!");
            }
        };
    }

    public boolean contains(Path other) {
        if (this.size() > other.size()) {
            return false;
        }
        int i = this.start;
        int j = other.start;
        while (i < this.end) {
            if (!this.pieces[i].equals(other.pieces[j])) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Path)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Path otherPath = (Path)other;
        if (this.size() != otherPath.size()) {
            return false;
        }
        int i = this.start;
        for (int j = otherPath.start; i < this.end && j < otherPath.end; ++i, ++j) {
            if (this.pieces[i].equals(otherPath.pieces[j])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = this.start; i < this.end; ++i) {
            hashCode = hashCode * 37 + this.pieces[i].hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(Path other) {
        int j;
        int i = this.start;
        for (j = other.start; i < this.end && j < other.end; ++i, ++j) {
            int comp = this.pieces[i].compareTo(other.pieces[j]);
            if (comp == 0) continue;
            return comp;
        }
        if (i == this.end && j == other.end) {
            return 0;
        }
        if (i == this.end) {
            return -1;
        }
        return 1;
    }
}

