/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JROrigin
implements JRCloneable,
Serializable {
    private static final long serialVersionUID = 10200L;
    public static final byte UNKNOWN = 0;
    public static final byte BACKGROUND = 1;
    public static final byte TITLE = 2;
    public static final byte PAGE_HEADER = 3;
    public static final byte COLUMN_HEADER = 4;
    public static final byte GROUP_HEADER = 5;
    public static final byte DETAIL = 6;
    public static final byte GROUP_FOOTER = 7;
    public static final byte COLUMN_FOOTER = 8;
    public static final byte PAGE_FOOTER = 9;
    public static final byte LAST_PAGE_FOOTER = 10;
    public static final byte SUMMARY = 11;
    public static final byte NO_DATA = 12;
    private byte bandType = 0;
    private String groupName = null;
    private String reportName = null;
    private int hashCode = 0;

    public JROrigin(byte bandType) {
        this(null, null, bandType);
    }

    public JROrigin(String reportName, byte bandType) {
        this(reportName, null, bandType);
    }

    public JROrigin(String reportName, String groupName, byte bandType) {
        this.reportName = reportName;
        this.groupName = groupName;
        this.bandType = bandType;
        int hash = 17;
        hash = 31 * hash + (reportName == null ? 0 : reportName.hashCode());
        hash = 31 * hash + (groupName == null ? 0 : groupName.hashCode());
        this.hashCode = hash = 31 * hash + bandType;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public byte getBandType() {
        return this.bandType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JROrigin) {
            JROrigin origin = (JROrigin)obj;
            String groupName2 = origin.getGroupName();
            String reportName2 = origin.getReportName();
            return origin.getBandType() == this.bandType && (this.groupName == null && groupName2 == null || this.groupName.equals(groupName2)) && (this.reportName == null && reportName2 == null || this.reportName.equals(reportName2));
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }
}

