# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("shell32.dll")
prototypes = \
    {
        #
        'SHGetPropertyStoreFromIDList': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="GETPROPERTYSTOREFLAGS"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidl", "flags", "riid", "ppv"]),
        #
        'SHGetPropertyStoreFromParsingName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IBindCtx"), SimTypeInt(signed=False, label="GETPROPERTYSTOREFLAGS"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath", "pbc", "flags", "riid", "ppv"]),
        #
        'SHAddDefaultPropertiesByExt': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IPropertyStore")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszExt", "pPropStore"]),
        #
        'PifMgr_OpenProperties': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pszApp", "pszPIF", "hInf", "flOpt"]),
        #
        'PifMgr_GetProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProps", "pszGroup", "lpProps", "cbProps", "flOpt"]),
        #
        'PifMgr_SetProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProps", "pszGroup", "lpProps", "cbProps", "flOpt"]),
        #
        'PifMgr_CloseProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hProps", "flOpt"]),
        #
        'SHPropStgCreate': SimTypeFunction([SimTypeBottom(label="IPropertySetStorage"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="IPropertyStorage"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psstg", "fmtid", "pclsid", "grfFlags", "grfMode", "dwDisposition", "ppstg", "puCodePage"]),
        #
        'SHPropStgReadMultiple': SimTypeFunction([SimTypeBottom(label="IPropertyStorage"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulKind": SimTypeInt(signed=False, label="PROPSPEC_KIND"), "Anonymous": SimUnion({"propid": SimTypeInt(signed=False, label="UInt32"), "lpwstr": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="PROPSPEC", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"cVal": SimTypeBottom(label="CHAR"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "lVal": SimTypeInt(signed=True, label="Int32"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "hVal": SimTypeBottom(label="LARGE_INTEGER"), "uhVal": SimTypeBottom(label="ULARGE_INTEGER"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "filetime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "puuid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pclipdata": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "bstrblobVal": SimTypeBottom(label="BSTRBLOB"), "blob": SimTypeBottom(label="BLOB"), "pszVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "pStream": SimTypeBottom(label="IStream"), "pStorage": SimTypeBottom(label="IStorage"), "pVersionedStream": SimTypePointer(SimStruct({"guidVersion": SimTypeBottom(label="Guid"), "pStream": SimTypeBottom(label="IStream")}, name="VERSIONEDSTREAM", pack=False, align=None), offset=0), "parray": SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), "cac": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAC", pack=False, align=None), "caub": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAUB", pack=False, align=None), "cai": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CAI", pack=False, align=None), "caui": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="CAUI", pack=False, align=None), "cal": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CAL", pack=False, align=None), "caul": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CAUL", pack=False, align=None), "cah": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)}, name="CAH", pack=False, align=None), "cauh": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="ULARGE_INTEGER"), offset=0)}, name="CAUH", pack=False, align=None), "caflt": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=32), offset=0)}, name="CAFLT", pack=False, align=None), "cadbl": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADBL", pack=False, align=None), "cabool": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CABOOL", pack=False, align=None), "cascode": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CASCODE", pack=False, align=None), "cacy": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CY"), offset=0)}, name="CACY", pack=False, align=None), "cadate": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADATE", pack=False, align=None), "cafiletime": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)}, name="CAFILETIME", pack=False, align=None), "cauuid": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="CACLSID", pack=False, align=None), "caclipdata": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0)}, name="CACLIPDATA", pack=False, align=None), "cabstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CABSTR", pack=False, align=None), "cabstrblob": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="BSTRBLOB"), offset=0)}, name="CABSTRBLOB", pack=False, align=None), "calpstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CALPSTR", pack=False, align=None), "calpwstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CALPWSTR", pack=False, align=None), "capropvar": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="CAPROPVARIANT", pack=False, align=None), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="PROPVARIANT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pps", "uCodePage", "cpspec", "rgpspec", "rgvar"]),
        #
        'SHPropStgWriteMultiple': SimTypeFunction([SimTypeBottom(label="IPropertyStorage"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulKind": SimTypeInt(signed=False, label="PROPSPEC_KIND"), "Anonymous": SimUnion({"propid": SimTypeInt(signed=False, label="UInt32"), "lpwstr": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="PROPSPEC", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"cVal": SimTypeBottom(label="CHAR"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "lVal": SimTypeInt(signed=True, label="Int32"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "hVal": SimTypeBottom(label="LARGE_INTEGER"), "uhVal": SimTypeBottom(label="ULARGE_INTEGER"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "filetime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "puuid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pclipdata": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "bstrblobVal": SimTypeBottom(label="BSTRBLOB"), "blob": SimTypeBottom(label="BLOB"), "pszVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "pStream": SimTypeBottom(label="IStream"), "pStorage": SimTypeBottom(label="IStorage"), "pVersionedStream": SimTypePointer(SimStruct({"guidVersion": SimTypeBottom(label="Guid"), "pStream": SimTypeBottom(label="IStream")}, name="VERSIONEDSTREAM", pack=False, align=None), offset=0), "parray": SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), "cac": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAC", pack=False, align=None), "caub": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAUB", pack=False, align=None), "cai": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CAI", pack=False, align=None), "caui": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="CAUI", pack=False, align=None), "cal": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CAL", pack=False, align=None), "caul": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CAUL", pack=False, align=None), "cah": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)}, name="CAH", pack=False, align=None), "cauh": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="ULARGE_INTEGER"), offset=0)}, name="CAUH", pack=False, align=None), "caflt": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=32), offset=0)}, name="CAFLT", pack=False, align=None), "cadbl": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADBL", pack=False, align=None), "cabool": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CABOOL", pack=False, align=None), "cascode": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CASCODE", pack=False, align=None), "cacy": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CY"), offset=0)}, name="CACY", pack=False, align=None), "cadate": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADATE", pack=False, align=None), "cafiletime": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)}, name="CAFILETIME", pack=False, align=None), "cauuid": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="CACLSID", pack=False, align=None), "caclipdata": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0)}, name="CACLIPDATA", pack=False, align=None), "cabstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CABSTR", pack=False, align=None), "cabstrblob": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="BSTRBLOB"), offset=0)}, name="CABSTRBLOB", pack=False, align=None), "calpstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CALPSTR", pack=False, align=None), "calpwstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CALPWSTR", pack=False, align=None), "capropvar": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="CAPROPVARIANT", pack=False, align=None), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="PROPVARIANT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pps", "puCodePage", "cpspec", "rgpspec", "rgvar", "propidNameFirst"]),
        #
        'SHGetPropertyStoreForWindow': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "riid", "ppv"]),
        #
        'SHSimpleIDListFromPath': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["pszPath"]),
        #
        'SHCreateItemFromIDList': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidl", "riid", "ppv"]),
        #
        'SHCreateItemFromParsingName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IBindCtx"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath", "pbc", "riid", "ppv"]),
        #
        'SHCreateItemWithParent': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeBottom(label="IShellFolder"), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidlParent", "psfParent", "pidl", "riid", "ppvItem"]),
        #
        'SHCreateItemFromRelativeName': SimTypeFunction([SimTypeBottom(label="IShellItem"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IBindCtx"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psiParent", "pszName", "pbc", "riid", "ppv"]),
        #
        'SHCreateItemInKnownFolder': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["kfid", "dwKFFlags", "pszItem", "riid", "ppv"]),
        #
        'SHGetIDListFromObject': SimTypeFunction([SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["punk", "ppidl"]),
        #
        'SHGetItemFromObject': SimTypeFunction([SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["punk", "riid", "ppv"]),
        #
        'SHGetNameFromIDList': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SIGDN"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidl", "sigdnName", "ppszName"]),
        #
        'SHGetItemFromDataObject': SimTypeFunction([SimTypeBottom(label="IDataObject"), SimTypeInt(signed=False, label="DATAOBJ_GET_ITEM_FLAGS"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pdtobj", "dwFlags", "riid", "ppv"]),
        #
        'SHCreateShellItemArray': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeBottom(label="IShellFolder"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="IShellItemArray"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidlParent", "psf", "cidl", "ppidl", "ppsiItemArray"]),
        #
        'SHCreateShellItemArrayFromDataObject': SimTypeFunction([SimTypeBottom(label="IDataObject"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pdo", "riid", "ppv"]),
        #
        'SHCreateShellItemArrayFromIDLists': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="IShellItemArray"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["cidl", "rgpidl", "ppsiItemArray"]),
        #
        'SHCreateShellItemArrayFromShellItem': SimTypeFunction([SimTypeBottom(label="IShellItem"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psi", "riid", "ppv"]),
        #
        'SHCreateAssociationRegistration': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["riid", "ppv"]),
        #
        'SHCreateDefaultExtractIcon': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["riid", "ppv"]),
        #
        'SetCurrentProcessExplicitAppUserModelID': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AppID"]),
        #
        'GetCurrentProcessExplicitAppUserModelID': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AppID"]),
        #
        'SHGetTemporaryPropertyForItem': SimTypeFunction([SimTypeBottom(label="IShellItem"), SimTypePointer(SimStruct({"fmtid": SimTypeBottom(label="Guid"), "pid": SimTypeInt(signed=False, label="UInt32")}, name="PROPERTYKEY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"cVal": SimTypeBottom(label="CHAR"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "lVal": SimTypeInt(signed=True, label="Int32"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "hVal": SimTypeBottom(label="LARGE_INTEGER"), "uhVal": SimTypeBottom(label="ULARGE_INTEGER"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "filetime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "puuid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pclipdata": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "bstrblobVal": SimTypeBottom(label="BSTRBLOB"), "blob": SimTypeBottom(label="BLOB"), "pszVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "pStream": SimTypeBottom(label="IStream"), "pStorage": SimTypeBottom(label="IStorage"), "pVersionedStream": SimTypePointer(SimStruct({"guidVersion": SimTypeBottom(label="Guid"), "pStream": SimTypeBottom(label="IStream")}, name="VERSIONEDSTREAM", pack=False, align=None), offset=0), "parray": SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), "cac": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAC", pack=False, align=None), "caub": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAUB", pack=False, align=None), "cai": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CAI", pack=False, align=None), "caui": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="CAUI", pack=False, align=None), "cal": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CAL", pack=False, align=None), "caul": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CAUL", pack=False, align=None), "cah": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)}, name="CAH", pack=False, align=None), "cauh": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="ULARGE_INTEGER"), offset=0)}, name="CAUH", pack=False, align=None), "caflt": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=32), offset=0)}, name="CAFLT", pack=False, align=None), "cadbl": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADBL", pack=False, align=None), "cabool": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CABOOL", pack=False, align=None), "cascode": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CASCODE", pack=False, align=None), "cacy": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CY"), offset=0)}, name="CACY", pack=False, align=None), "cadate": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADATE", pack=False, align=None), "cafiletime": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)}, name="CAFILETIME", pack=False, align=None), "cauuid": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="CACLSID", pack=False, align=None), "caclipdata": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0)}, name="CACLIPDATA", pack=False, align=None), "cabstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CABSTR", pack=False, align=None), "cabstrblob": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="BSTRBLOB"), offset=0)}, name="CABSTRBLOB", pack=False, align=None), "calpstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CALPSTR", pack=False, align=None), "calpwstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CALPWSTR", pack=False, align=None), "capropvar": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="CAPROPVARIANT", pack=False, align=None), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="PROPVARIANT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psi", "propkey", "ppropvar"]),
        #
        'SHSetTemporaryPropertyForItem': SimTypeFunction([SimTypeBottom(label="IShellItem"), SimTypePointer(SimStruct({"fmtid": SimTypeBottom(label="Guid"), "pid": SimTypeInt(signed=False, label="UInt32")}, name="PROPERTYKEY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"cVal": SimTypeBottom(label="CHAR"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "lVal": SimTypeInt(signed=True, label="Int32"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "hVal": SimTypeBottom(label="LARGE_INTEGER"), "uhVal": SimTypeBottom(label="ULARGE_INTEGER"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "filetime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "puuid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pclipdata": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "bstrblobVal": SimTypeBottom(label="BSTRBLOB"), "blob": SimTypeBottom(label="BLOB"), "pszVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "pStream": SimTypeBottom(label="IStream"), "pStorage": SimTypeBottom(label="IStorage"), "pVersionedStream": SimTypePointer(SimStruct({"guidVersion": SimTypeBottom(label="Guid"), "pStream": SimTypeBottom(label="IStream")}, name="VERSIONEDSTREAM", pack=False, align=None), offset=0), "parray": SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), "cac": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAC", pack=False, align=None), "caub": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CAUB", pack=False, align=None), "cai": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CAI", pack=False, align=None), "caui": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)}, name="CAUI", pack=False, align=None), "cal": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CAL", pack=False, align=None), "caul": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="CAUL", pack=False, align=None), "cah": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="LARGE_INTEGER"), offset=0)}, name="CAH", pack=False, align=None), "cauh": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="ULARGE_INTEGER"), offset=0)}, name="CAUH", pack=False, align=None), "caflt": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=32), offset=0)}, name="CAFLT", pack=False, align=None), "cadbl": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADBL", pack=False, align=None), "cabool": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0)}, name="CABOOL", pack=False, align=None), "cascode": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)}, name="CASCODE", pack=False, align=None), "cacy": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CY"), offset=0)}, name="CACY", pack=False, align=None), "cadate": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeFloat(size=64), offset=0)}, name="CADATE", pack=False, align=None), "cafiletime": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)}, name="CAFILETIME", pack=False, align=None), "cauuid": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="CACLSID", pack=False, align=None), "caclipdata": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="CLIPDATA"), offset=0)}, name="CACLIPDATA", pack=False, align=None), "cabstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CABSTR", pack=False, align=None), "cabstrblob": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="BSTRBLOB"), offset=0)}, name="CABSTRBLOB", pack=False, align=None), "calpstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CALPSTR", pack=False, align=None), "calpwstr": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="CALPWSTR", pack=False, align=None), "capropvar": SimStruct({"cElems": SimTypeInt(signed=False, label="UInt32"), "pElems": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="CAPROPVARIANT", pack=False, align=None), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimTypeBottom(label="SAFEARRAY"), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="PROPVARIANT"), offset=0)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="PROPVARIANT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psi", "propkey", "propvar"]),
        #
        'SHShowManageLibraryUI': SimTypeFunction([SimTypeBottom(label="IShellItem"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="LIBRARYMANAGEDIALOGOPTIONS")], SimTypeInt(signed=True, label="Int32"), arg_names=["psiLibrary", "hwndOwner", "pszTitle", "pszInstruction", "lmdOptions"]),
        #
        'SHResolveLibrary': SimTypeFunction([SimTypeBottom(label="IShellItem")], SimTypeInt(signed=True, label="Int32"), arg_names=["psiLibrary"]),
        #
        'SHAssocEnumHandlers': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="ASSOC_FILTER"), SimTypePointer(SimTypeBottom(label="IEnumAssocHandlers"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszExtra", "afFilter", "ppEnumHandler"]),
        #
        'SHAssocEnumHandlersForProtocolByApplication': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["protocol", "riid", "enumHandlers"]),
        #
        'SHCreateDefaultPropertiesOp': SimTypeFunction([SimTypeBottom(label="IShellItem"), SimTypePointer(SimTypeBottom(label="IFileOperation"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psi", "ppFileOp"]),
        #
        'SHSetDefaultProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeBottom(label="IShellItem"), SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="IFileOperationProgressSink")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "psi", "dwFileOpFlags", "pfops"]),
        #
        'SHGetMalloc': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMalloc"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppMalloc"]),
        #
        'SHAlloc': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cb"]),
        #
        'SHFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]),
        #
        'SHGetIconOverlayIndexA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszIconPath", "iIconIndex"]),
        #
        'SHGetIconOverlayIndexW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszIconPath", "iIconIndex"]),
        #
        'ILClone': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["pidl"]),
        #
        'ILCloneFirst': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["pidl"]),
        #
        'ILCombine': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["pidl1", "pidl2"]),
        #
        'ILFree': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pidl"]),
        #
        'ILGetNext': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["pidl"]),
        #
        'ILGetSize': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pidl"]),
        #
        'ILFindChild': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["pidlParent", "pidlChild"]),
        #
        'ILFindLastID': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["pidl"]),
        #
        'ILRemoveLastID': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidl"]),
        #
        'ILIsEqual': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidl1", "pidl2"]),
        #
        'ILIsParent': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pidl1", "pidl2", "fImmediate"]),
        #
        'ILSaveToStream': SimTypeFunction([SimTypeBottom(label="IStream"), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pstm", "pidl"]),
        #
        'ILLoadFromStreamEx': SimTypeFunction([SimTypeBottom(label="IStream"), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pstm", "pidl"]),
        #
        'ILCreateFromPathA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["pszPath"]),
        #
        'ILCreateFromPathW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["pszPath"]),
        #
        'SHILCreateFromPath': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath", "ppidl", "rgfInOut"]),
        #
        'ILAppendID': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["pidl", "pmkid", "fAppend"]),
        #
        'SHGetPathFromIDListEx': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pidl", "pszPath", "cchPath", "uOpts"]),
        #
        'SHGetPathFromIDListA': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidl", "pszPath"]),
        #
        'SHGetPathFromIDListW': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidl", "pszPath"]),
        #
        'SHCreateDirectory': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszPath"]),
        #
        'SHCreateDirectoryExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszPath", "psa"]),
        #
        'SHCreateDirectoryExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszPath", "psa"]),
        #
        'SHOpenFolderAndSelectItems': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pidlFolder", "cidl", "apidl", "dwFlags"]),
        #
        'SHCreateShellItem': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeBottom(label="IShellFolder"), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="IShellItem"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidlParent", "psfParent", "pidl", "ppsi"]),
        #
        'SHGetSpecialFolderLocation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "csidl", "ppidl"]),
        #
        'SHCloneSpecialIDList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["hwnd", "csidl", "fCreate"]),
        #
        'SHGetSpecialFolderPathA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszPath", "csidl", "fCreate"]),
        #
        'SHGetSpecialFolderPathW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszPath", "csidl", "fCreate"]),
        #
        'SHFlushSFCache': SimTypeFunction([], SimTypeBottom(label="Void")),
        #
        'SHGetFolderPathA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "csidl", "hToken", "dwFlags", "pszPath"]),
        #
        'SHGetFolderPathW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "csidl", "hToken", "dwFlags", "pszPath"]),
        #
        'SHGetFolderLocation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "csidl", "hToken", "dwFlags", "ppidl"]),
        #
        'SHSetFolderPathA': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["csidl", "hToken", "dwFlags", "pszPath"]),
        #
        'SHSetFolderPathW': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["csidl", "hToken", "dwFlags", "pszPath"]),
        #
        'SHGetFolderPathAndSubDirA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "csidl", "hToken", "dwFlags", "pszSubDir", "pszPath"]),
        #
        'SHGetFolderPathAndSubDirW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "csidl", "hToken", "dwFlags", "pszSubDir", "pszPath"]),
        #
        'SHGetKnownFolderIDList': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["rfid", "dwFlags", "hToken", "ppidl"]),
        #
        'SHSetKnownFolderPath': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["rfid", "dwFlags", "hToken", "pszPath"]),
        #
        'SHGetKnownFolderPath': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["rfid", "dwFlags", "hToken", "ppszPath"]),
        #
        'SHGetKnownFolderItem': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="KNOWN_FOLDER_FLAG"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["rfid", "flags", "hToken", "riid", "ppv"]),
        #
        'SHGetSetFolderCustomSettings': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwMask": SimTypeInt(signed=False, label="UInt32"), "pvid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pszWebViewTemplate": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cchWebViewTemplate": SimTypeInt(signed=False, label="UInt32"), "pszWebViewTemplateVersion": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszInfoTip": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cchInfoTip": SimTypeInt(signed=False, label="UInt32"), "pclsid": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pszIconFile": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cchIconFile": SimTypeInt(signed=False, label="UInt32"), "iIconIndex": SimTypeInt(signed=True, label="Int32"), "pszLogo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cchLogo": SimTypeInt(signed=False, label="UInt32")}, name="SHFOLDERCUSTOMSETTINGS", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pfcs", "pszPath", "dwReadWrite"]),
        #
        'SHBrowseForFolderA': SimTypeFunction([SimTypePointer(SimStruct({"hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pidlRoot": SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), "pszDisplayName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ulFlags": SimTypeInt(signed=False, label="UInt32"), "lpfn": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "uMsg", "lParam", "lpData"]), offset=0), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "iImage": SimTypeInt(signed=True, label="Int32")}, name="BROWSEINFOA", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["lpbi"]),
        #
        'SHBrowseForFolderW': SimTypeFunction([SimTypePointer(SimStruct({"hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pidlRoot": SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), "pszDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ulFlags": SimTypeInt(signed=False, label="UInt32"), "lpfn": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "uMsg", "lParam", "lpData"]), offset=0), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "iImage": SimTypeInt(signed=True, label="Int32")}, name="BROWSEINFOW", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), arg_names=["lpbi"]),
        #
        'SHLoadInProc': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["rclsid"]),
        #
        'SHGetDesktopFolder': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IShellFolder"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppshf"]),
        #
        'SHChangeNotify': SimTypeFunction([SimTypeInt(signed=False, label="SHCNE_ID"), SimTypeInt(signed=False, label="SHCNF_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["wEventId", "uFlags", "dwItem1", "dwItem2"]),
        #
        'SHAddToRecentDocs': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["uFlags", "pv"]),
        #
        'SHHandleUpdateImage': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidlExtra"]),
        #
        'SHUpdateImageA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["pszHashItem", "iIndex", "uFlags", "iImageIndex"]),
        #
        'SHUpdateImageW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["pszHashItem", "iIndex", "uFlags", "iImageIndex"]),
        #
        'SHChangeNotifyRegister': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SHCNRF_SOURCE"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"pidl": SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), "fRecursive": SimTypeInt(signed=True, label="Int32")}, name="SHChangeNotifyEntry", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "fSources", "fEvents", "wMsg", "cEntries", "pshcne"]),
        #
        'SHChangeNotifyDeregister': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ulID"]),
        #
        'SHChangeNotification_Lock': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hChange", "dwProcId", "pppidl", "plEvent"]),
        #
        'SHChangeNotification_Unlock': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLock"]),
        #
        'SHGetRealIDL': SimTypeFunction([SimTypeBottom(label="IShellFolder"), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psf", "pidlSimple", "ppidlReal"]),
        #
        'SHGetInstanceExplorer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppunk"]),
        #
        'SHGetDataFromIDListA': SimTypeFunction([SimTypeBottom(label="IShellFolder"), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SHGDFIL_FORMAT"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["psf", "pidl", "nFormat", "pv", "cb"]),
        #
        'SHGetDataFromIDListW': SimTypeFunction([SimTypeBottom(label="IShellFolder"), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SHGDFIL_FORMAT"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["psf", "pidl", "nFormat", "pv", "cb"]),
        #
        'RestartDialog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszPrompt", "dwReturn"]),
        #
        'RestartDialogEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszPrompt", "dwReturn", "dwReasonCode"]),
        #
        'SHCoCreateInstance': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszCLSID", "pclsid", "pUnkOuter", "riid", "ppv"]),
        #
        'SHCreateDataObject': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypeBottom(label="IDataObject"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidlFolder", "cidl", "apidl", "pdtInner", "riid", "ppv"]),
        #
        'CIDLData_CreateFromIDArray': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="IDataObject"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidlFolder", "cidl", "apidl", "ppdtobj"]),
        #
        'SHCreateStdEnumFmtEtc': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cfFormat": SimTypeShort(signed=False, label="UInt16"), "ptd": SimTypePointer(SimStruct({"tdSize": SimTypeInt(signed=False, label="UInt32"), "tdDriverNameOffset": SimTypeShort(signed=False, label="UInt16"), "tdDeviceNameOffset": SimTypeShort(signed=False, label="UInt16"), "tdPortNameOffset": SimTypeShort(signed=False, label="UInt16"), "tdExtDevmodeOffset": SimTypeShort(signed=False, label="UInt16"), "tdData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="DVTARGETDEVICE", pack=False, align=None), offset=0), "dwAspect": SimTypeInt(signed=False, label="UInt32"), "lindex": SimTypeInt(signed=True, label="Int32"), "tymed": SimTypeInt(signed=False, label="UInt32")}, name="FORMATETC", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="IEnumFORMATETC"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["cfmt", "afmt", "ppenumFormatEtc"]),
        #
        'SHDoDragDrop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeBottom(label="IDataObject"), SimTypeBottom(label="IDropSource"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pdata", "pdsrc", "dwEffect", "pdwEffect"]),
        #
        'DAD_SetDragImage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["him", "pptOffset"]),
        #
        'DAD_DragEnterEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndTarget", "ptStart"]),
        #
        'DAD_DragEnterEx2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), SimTypeBottom(label="IDataObject")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndTarget", "ptStart", "pdtObject"]),
        #
        'DAD_ShowDragImage': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["fShow"]),
        #
        'DAD_DragMove': SimTypeFunction([SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None)], SimTypeInt(signed=True, label="Int32"), arg_names=["pt"]),
        #
        'DAD_DragLeave': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'DAD_AutoScroll': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"iNextSample": SimTypeInt(signed=True, label="Int32"), "dwLastScroll": SimTypeInt(signed=False, label="UInt32"), "bFull": SimTypeInt(signed=True, label="Int32"), "pts": SimTypeFixedSizeArray(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), 3), "dwTimes": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 3)}, name="AUTO_SCROLL_DATA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pad", "pptNow"]),
        #
        'ReadCabinetState': SimTypeFunction([SimTypePointer(SimStruct({"cLength": SimTypeShort(signed=False, label="UInt16"), "nVersion": SimTypeShort(signed=False, label="UInt16"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "fMenuEnumFilter": SimTypeInt(signed=False, label="UInt32")}, name="CABINETSTATE", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pcs", "cLength"]),
        #
        'WriteCabinetState': SimTypeFunction([SimTypePointer(SimStruct({"cLength": SimTypeShort(signed=False, label="UInt16"), "nVersion": SimTypeShort(signed=False, label="UInt16"), "_bitfield": SimTypeInt(signed=True, label="Int32"), "fMenuEnumFilter": SimTypeInt(signed=False, label="UInt32")}, name="CABINETSTATE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcs"]),
        #
        'PathMakeUniqueName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszUniqueName", "cchMax", "pszTemplate", "pszLongPlate", "pszDir"]),
        #
        'PathIsExe': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath"]),
        #
        'PathCleanupSpec': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="PCS_RET"), arg_names=["pszDir", "pszSpec"]),
        #
        'PathResolve': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), offset=0), SimTypeInt(signed=False, label="PRF_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath", "dirs", "fFlags"]),
        #
        'GetFileNameFromBrowse': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszFilePath", "cchFilePath", "pszWorkingDir", "pszDefExt", "pszFilters", "pszTitle"]),
        #
        'DriveType': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["iDrive"]),
        #
        'RealDriveType': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["iDrive", "fOKToHitNet"]),
        #
        'IsNetDrive': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["iDrive"]),
        #
        'Shell_MergeMenus': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="MM_FLAGS")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmDst", "hmSrc", "uInsert", "uIDAdjust", "uIDAdjustMax", "uFlags"]),
        #
        'SHObjectProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="SHOP_TYPE"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "shopObjectType", "pszObjectName", "pszPropertyPage"]),
        #
        'SHFormatDrive': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SHFMT_ID"), SimTypeInt(signed=False, label="SHFMT_OPT")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "drive", "fmtID", "options"]),
        #
        'SHDestroyPropSheetExtArray': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hpsxa"]),
        #
        'SHAddFromPropSheetExtArray': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hpsxa", "lpfnAddPage", "lParam"]),
        #
        'SHReplaceFromPropSheetExtArray': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hpsxa", "uPageID", "lpfnReplaceWith", "lParam"]),
        #
        'OpenRegStream': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="IStream"), arg_names=["hkey", "pszSubkey", "pszValue", "grfMode"]),
        #
        'SHFindFiles': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidlFolder", "pidlSaveFile"]),
        #
        'PathGetShortPath': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeBottom(label="Void"), arg_names=["pszLongPath"]),
        #
        'PathYetAnotherMakeUniqueName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszUniqueName", "pszPath", "pszShort", "pszFileSpec"]),
        #
        'Win32DeleteFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath"]),
        #
        'SHRestricted': SimTypeFunction([SimTypeInt(signed=False, label="RESTRICTIONS")], SimTypeInt(signed=False, label="UInt32"), arg_names=["rest"]),
        #
        'SignalFileOpen': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidl"]),
        #
        'AssocGetDetailsOfPropKey': SimTypeFunction([SimTypeBottom(label="IShellFolder"), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"fmtid": SimTypeBottom(label="Guid"), "pid": SimTypeInt(signed=False, label="UInt32")}, name="PROPERTYKEY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"llVal": SimTypeLongLong(signed=True, label="Int64"), "lVal": SimTypeInt(signed=True, label="Int32"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "parray": SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pllVal": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "__OBSOLETE__VARIANT_PBOOL": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="VARIANT"), offset=0), "byref": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cVal": SimTypeBottom(label="CHAR"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "ullVal": SimTypeLongLong(signed=False, label="UInt64"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pullVal": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "Anonymous": SimStruct({"pvRecord": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pRecInfo": SimTypeBottom(label="IRecordInfo")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="VARIANT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psf", "pidl", "pkey", "pv", "pfFoundPropKey"]),
        #
        'SHStartNetConnectionDialogW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszRemoteName", "dwType"]),
        #
        'SHDefExtractIconA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszIconFile", "iIndex", "uFlags", "phiconLarge", "phiconSmall", "nIconSize"]),
        #
        'SHDefExtractIconW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszIconFile", "iIndex", "uFlags", "phiconLarge", "phiconSmall", "nIconSize"]),
        #
        'SHOpenWithDialog': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"pcszFile": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pcszClass": SimTypePointer(SimTypeChar(label="Char"), offset=0), "oaifInFlags": SimTypeInt(signed=False, label="OPEN_AS_INFO_FLAGS")}, name="OPENASINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndParent", "poainfo"]),
        #
        'Shell_GetImageLists': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phiml", "phimlSmall"]),
        #
        'Shell_GetCachedImageIndex': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pwszIconPath", "iIconIndex", "uIconFlags"]),
        #
        'Shell_GetCachedImageIndexA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszIconPath", "iIconIndex", "uIconFlags"]),
        #
        'Shell_GetCachedImageIndexW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszIconPath", "iIconIndex", "uIconFlags"]),
        #
        'SHValidateUNC': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="VALIDATEUNC_OPTION")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndOwner", "pszFile", "fConnect"]),
        #
        'SHSetInstanceExplorer': SimTypeFunction([SimTypeBottom(label="IUnknown")], SimTypeBottom(label="Void"), arg_names=["punk"]),
        #
        'IsUserAnAdmin': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'SHShellFolderView_Message': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwndMain", "uMsg", "lParam"]),
        #
        'SHCreateShellFolderView': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pshf": SimTypeBottom(label="IShellFolder"), "psvOuter": SimTypeBottom(label="IShellView"), "psfvcb": SimTypeBottom(label="IShellFolderViewCB")}, name="SFV_CREATE", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="IShellView"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcsfv", "ppsv"]),
        #
        'CDefFolderMenu_Create2': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypeBottom(label="IShellFolder"), SimTypePointer(SimTypeFunction([SimTypeBottom(label="IShellFolder"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeBottom(label="IDataObject"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psf", "hwnd", "pdtobj", "uMsg", "wParam", "lParam"]), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="IContextMenu"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidlFolder", "hwnd", "cidl", "apidl", "psf", "pfn", "nKeys", "ahkeys", "ppcm"]),
        #
        'SHCreateDefaultContextMenu': SimTypeFunction([SimTypePointer(SimStruct({"hwnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pcmcb": SimTypeBottom(label="IContextMenuCB"), "pidlFolder": SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), "psf": SimTypeBottom(label="IShellFolder"), "cidl": SimTypeInt(signed=False, label="UInt32"), "apidl": SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0), "punkAssociationInfo": SimTypeBottom(label="IUnknown"), "cKeys": SimTypeInt(signed=False, label="UInt32"), "aKeys": SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)}, name="DEFCONTEXTMENU", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pdcm", "riid", "ppv"]),
        #
        'SHFind_InitMenuPopup': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="IContextMenu"), arg_names=["hmenu", "hwndOwner", "idCmdFirst", "idCmdLast"]),
        #
        'SHCreateShellFolderViewEx': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pshf": SimTypeBottom(label="IShellFolder"), "psvOuter": SimTypeBottom(label="IShellView"), "pidl": SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), "lEvents": SimTypeInt(signed=True, label="Int32"), "pfnCallback": SimTypePointer(SimTypeFunction([SimTypeBottom(label="IShellView"), SimTypeBottom(label="IShellFolder"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psvOuter", "psf", "hwndMain", "uMsg", "wParam", "lParam"]), offset=0), "fvm": SimTypeInt(signed=False, label="FOLDERVIEWMODE")}, name="CSFV", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="IShellView"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcsfv", "ppsv"]),
        #
        'SHGetSetSettings': SimTypeFunction([SimTypePointer(SimStruct({"_bitfield1": SimTypeInt(signed=True, label="Int32"), "dwWin95Unused": SimTypeInt(signed=False, label="UInt32"), "uWin95Unused": SimTypeInt(signed=False, label="UInt32"), "lParamSort": SimTypeInt(signed=True, label="Int32"), "iSortDirection": SimTypeInt(signed=True, label="Int32"), "version": SimTypeInt(signed=False, label="UInt32"), "uNotUsed": SimTypeInt(signed=False, label="UInt32"), "_bitfield2": SimTypeInt(signed=True, label="Int32")}, name="SHELLSTATEA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="SSF_MASK"), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["lpss", "dwMask", "bSet"]),
        #
        'SHGetSettings': SimTypeFunction([SimTypePointer(SimStruct({"_bitfield": SimTypeInt(signed=True, label="Int32")}, name="SHELLFLAGSTATE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["psfs", "dwMask"]),
        #
        'SHBindToParent': SimTypeFunction([SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pidl", "riid", "ppv", "ppidlLast"]),
        #
        'SHBindToFolderIDListParent': SimTypeFunction([SimTypeBottom(label="IShellFolder"), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psfRoot", "pidl", "riid", "ppv", "ppidlLast"]),
        #
        'SHBindToFolderIDListParentEx': SimTypeFunction([SimTypeBottom(label="IShellFolder"), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeBottom(label="IBindCtx"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psfRoot", "pidl", "ppbc", "riid", "ppv", "ppidlLast"]),
        #
        'SHBindToObject': SimTypeFunction([SimTypeBottom(label="IShellFolder"), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypeBottom(label="IBindCtx"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psf", "pidl", "pbc", "riid", "ppv"]),
        #
        'SHParseDisplayName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeBottom(label="IBindCtx"), SimTypePointer(SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszName", "pbc", "ppidl", "sfgaoIn", "psfgaoOut"]),
        #
        'SHPathPrepareForWriteA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "punkEnableModless", "pszPath", "dwFlags"]),
        #
        'SHPathPrepareForWriteW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeBottom(label="IUnknown"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "punkEnableModless", "pszPath", "dwFlags"]),
        #
        'SHCreateFileExtractIconW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszFile", "dwFileAttributes", "riid", "ppv"]),
        #
        'SHLimitInputEdit': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeBottom(label="IShellFolder")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndEdit", "psf"]),
        #
        'SHGetAttributesFromDataObject': SimTypeFunction([SimTypeBottom(label="IDataObject"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pdo", "dwAttributeMask", "pdwAttributes", "pcItems"]),
        #
        'SHMapPIDLToSystemImageListIndex': SimTypeFunction([SimTypeBottom(label="IShellFolder"), SimTypePointer(SimStruct({"mkid": SimStruct({"cb": SimTypeShort(signed=False, label="UInt16"), "abID": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHITEMID", pack=False, align=None)}, name="ITEMIDLIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pshf", "pidl", "piIndexSel"]),
        #
        'SHCLSIDFromString': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["psz", "pclsid"]),
        #
        'PickIconDlg': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszIconPath", "cchIconPath", "piIconIndex"]),
        #
        'StgMakeUniqueName': SimTypeFunction([SimTypeBottom(label="IStorage"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pstgParent", "pszFileSpec", "grfMode", "riid", "ppv"]),
        #
        'SHChangeNotifyRegisterThread': SimTypeFunction([SimTypeInt(signed=False, label="SCNRT_STATUS")], SimTypeBottom(label="Void"), arg_names=["status"]),
        #
        'PathQualify': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["psz"]),
        #
        'PathIsSlowA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszFile", "dwAttr"]),
        #
        'PathIsSlowW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszFile", "dwAttr"]),
        #
        'SHCreatePropSheetExtArray': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hKey", "pszSubKey", "max_iface"]),
        #
        'SHOpenPropSheetW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeBottom(label="IDataObject"), SimTypeBottom(label="IShellBrowser"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszCaption", "ahkeys", "ckeys", "pclsidDefault", "pdtobj", "psb", "pStartPage"]),
        #
        'SHMultiFileProperties': SimTypeFunction([SimTypeBottom(label="IDataObject"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pdtobj", "dwFlags"]),
        #
        'SHCreateQueryCancelAutoPlayMoniker': SimTypeFunction([SimTypePointer(SimTypeBottom(label="IMoniker"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppmoniker"]),
        #
        'CommandLineToArgvW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), arg_names=["lpCmdLine", "pNumArgs"]),
        #
        'DragQueryFileA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hDrop", "iFile", "lpszFile", "cch"]),
        #
        'DragQueryFileW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hDrop", "iFile", "lpszFile", "cch"]),
        #
        'DragQueryPoint': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"x": SimTypeInt(signed=True, label="Int32"), "y": SimTypeInt(signed=True, label="Int32")}, name="POINT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hDrop", "ppt"]),
        #
        'DragFinish': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hDrop"]),
        #
        'DragAcceptFiles': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["hWnd", "fAccept"]),
        #
        'ShellExecuteA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwnd", "lpOperation", "lpFile", "lpParameters", "lpDirectory", "nShowCmd"]),
        #
        'ShellExecuteW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hwnd", "lpOperation", "lpFile", "lpParameters", "lpDirectory", "nShowCmd"]),
        #
        'FindExecutableA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpFile", "lpDirectory", "lpResult"]),
        #
        'FindExecutableW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpFile", "lpDirectory", "lpResult"]),
        #
        'ShellAboutA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "szApp", "szOtherStuff", "hIcon"]),
        #
        'ShellAboutW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "szApp", "szOtherStuff", "hIcon"]),
        #
        'DuplicateIcon': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hInst", "hIcon"]),
        #
        'ExtractAssociatedIconA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hInst", "pszIconPath", "piIcon"]),
        #
        'ExtractAssociatedIconW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hInst", "pszIconPath", "piIcon"]),
        #
        'ExtractAssociatedIconExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hInst", "pszIconPath", "piIconIndex", "piIconId"]),
        #
        'ExtractAssociatedIconExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hInst", "pszIconPath", "piIconIndex", "piIconId"]),
        #
        'ExtractIconA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hInst", "pszExeFileName", "nIconIndex"]),
        #
        'ExtractIconW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hInst", "pszExeFileName", "nIconIndex"]),
        #
        'SHAppBarMessage': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "uCallbackMessage": SimTypeInt(signed=False, label="UInt32"), "uEdge": SimTypeInt(signed=False, label="UInt32"), "rc": SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="APPBARDATA", pack=False, align=None), offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["dwMessage", "pData"]),
        #
        'DoEnvironmentSubstA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszSrc", "cchSrc"]),
        #
        'DoEnvironmentSubstW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszSrc", "cchSrc"]),
        #
        'ExtractIconExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszFile", "nIconIndex", "phiconLarge", "phiconSmall", "nIcons"]),
        #
        'ExtractIconExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszFile", "nIconIndex", "phiconLarge", "phiconSmall", "nIcons"]),
        #
        'SHFileOperationA': SimTypeFunction([SimTypePointer(SimStruct({"hwnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "wFunc": SimTypeInt(signed=False, label="UInt32"), "pFrom": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pTo": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "fFlags": SimTypeShort(signed=False, label="UInt16"), "fAnyOperationsAborted": SimTypeInt(signed=True, label="Int32"), "hNameMappings": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lpszProgressTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SHFILEOPSTRUCTA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileOp"]),
        #
        'SHFileOperationW': SimTypeFunction([SimTypePointer(SimStruct({"hwnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "wFunc": SimTypeInt(signed=False, label="UInt32"), "pFrom": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pTo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "fFlags": SimTypeShort(signed=False, label="UInt16"), "fAnyOperationsAborted": SimTypeInt(signed=True, label="Int32"), "hNameMappings": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lpszProgressTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="SHFILEOPSTRUCTW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpFileOp"]),
        #
        'SHFreeNameMappings': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hNameMappings"]),
        #
        'ShellExecuteExA': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "fMask": SimTypeInt(signed=False, label="UInt32"), "hwnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpVerb": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpFile": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpParameters": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpDirectory": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "nShow": SimTypeInt(signed=True, label="Int32"), "hInstApp": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpIDList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lpClass": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hkeyClass": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwHotKey": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"hIcon": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hMonitor": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="<anon>", label="None"), "hProcess": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="SHELLEXECUTEINFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pExecInfo"]),
        #
        'ShellExecuteExW': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "fMask": SimTypeInt(signed=False, label="UInt32"), "hwnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpVerb": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpFile": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpParameters": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpDirectory": SimTypePointer(SimTypeChar(label="Char"), offset=0), "nShow": SimTypeInt(signed=True, label="Int32"), "hInstApp": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpIDList": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "lpClass": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hkeyClass": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwHotKey": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"hIcon": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hMonitor": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="<anon>", label="None"), "hProcess": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="SHELLEXECUTEINFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pExecInfo"]),
        #
        'SHCreateProcessAsUserW': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "fMask": SimTypeInt(signed=False, label="UInt32"), "hwnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszFile": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszParameters": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszCurrentDirectory": SimTypePointer(SimTypeChar(label="Char"), offset=0), "hUserToken": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "lpProcessAttributes": SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), "lpThreadAttributes": SimTypePointer(SimStruct({"nLength": SimTypeInt(signed=False, label="UInt32"), "lpSecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "bInheritHandle": SimTypeInt(signed=True, label="Int32")}, name="SECURITY_ATTRIBUTES", pack=False, align=None), offset=0), "bInheritHandles": SimTypeInt(signed=True, label="Int32"), "dwCreationFlags": SimTypeInt(signed=False, label="UInt32"), "lpStartupInfo": SimTypePointer(SimStruct({"cb": SimTypeInt(signed=False, label="UInt32"), "lpReserved": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpDesktop": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwX": SimTypeInt(signed=False, label="UInt32"), "dwY": SimTypeInt(signed=False, label="UInt32"), "dwXSize": SimTypeInt(signed=False, label="UInt32"), "dwYSize": SimTypeInt(signed=False, label="UInt32"), "dwXCountChars": SimTypeInt(signed=False, label="UInt32"), "dwYCountChars": SimTypeInt(signed=False, label="UInt32"), "dwFillAttribute": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="STARTUPINFOW_FLAGS"), "wShowWindow": SimTypeShort(signed=False, label="UInt16"), "cbReserved2": SimTypeShort(signed=False, label="UInt16"), "lpReserved2": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "hStdInput": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hStdOutput": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hStdError": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="STARTUPINFOW", pack=False, align=None), offset=0), "lpProcessInformation": SimTypePointer(SimStruct({"hProcess": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dwProcessId": SimTypeInt(signed=False, label="UInt32"), "dwThreadId": SimTypeInt(signed=False, label="UInt32")}, name="PROCESS_INFORMATION", pack=False, align=None), offset=0)}, name="SHCREATEPROCESSINFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pscpi"]),
        #
        'SHEvaluateSystemCommandTemplate': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszCmdTemplate", "ppszApplication", "ppszCommandLine", "ppszParameters"]),
        #
        'AssocCreateForClasses': SimTypeFunction([SimTypePointer(SimStruct({"ac": SimTypeInt(signed=False, label="ASSOCCLASS"), "hkClass": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszClass": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ASSOCIATIONELEMENT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["rgClasses", "cClasses", "riid", "ppv"]),
        #
        'SHQueryRecycleBinA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "i64Size": SimTypeLongLong(signed=True, label="Int64"), "i64NumItems": SimTypeLongLong(signed=True, label="Int64")}, name="SHQUERYRBINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszRootPath", "pSHQueryRBInfo"]),
        #
        'SHQueryRecycleBinW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "i64Size": SimTypeLongLong(signed=True, label="Int64"), "i64NumItems": SimTypeLongLong(signed=True, label="Int64")}, name="SHQUERYRBINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszRootPath", "pSHQueryRBInfo"]),
        #
        'SHEmptyRecycleBinA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszRootPath", "dwFlags"]),
        #
        'SHEmptyRecycleBinW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "pszRootPath", "dwFlags"]),
        #
        'SHQueryUserNotificationState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="QUERY_USER_NOTIFICATION_STATE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pquns"]),
        #
        'Shell_NotifyIconA': SimTypeFunction([SimTypeInt(signed=False, label="NOTIFY_ICON_MESSAGE"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "uID": SimTypeInt(signed=False, label="UInt32"), "uFlags": SimTypeInt(signed=False, label="NOTIFY_ICON_DATA_FLAGS"), "uCallbackMessage": SimTypeInt(signed=False, label="UInt32"), "hIcon": SimTypeBottom(label="HICON"), "szTip": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 128), "dwState": SimTypeInt(signed=False, label="UInt32"), "dwStateMask": SimTypeInt(signed=False, label="UInt32"), "szInfo": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 256), "Anonymous": SimUnion({"uTimeout": SimTypeInt(signed=False, label="UInt32"), "uVersion": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "szInfoTitle": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 64), "dwInfoFlags": SimTypeInt(signed=False, label="UInt32"), "guidItem": SimTypeBottom(label="Guid"), "hBalloonIcon": SimTypeBottom(label="HICON")}, name="NOTIFYICONDATAA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwMessage", "lpData"]),
        #
        'Shell_NotifyIconW': SimTypeFunction([SimTypeInt(signed=False, label="NOTIFY_ICON_MESSAGE"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "uID": SimTypeInt(signed=False, label="UInt32"), "uFlags": SimTypeInt(signed=False, label="NOTIFY_ICON_DATA_FLAGS"), "uCallbackMessage": SimTypeInt(signed=False, label="UInt32"), "hIcon": SimTypeBottom(label="HICON"), "szTip": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "dwState": SimTypeInt(signed=False, label="UInt32"), "dwStateMask": SimTypeInt(signed=False, label="UInt32"), "szInfo": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Anonymous": SimUnion({"uTimeout": SimTypeInt(signed=False, label="UInt32"), "uVersion": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "szInfoTitle": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 64), "dwInfoFlags": SimTypeInt(signed=False, label="UInt32"), "guidItem": SimTypeBottom(label="Guid"), "hBalloonIcon": SimTypeBottom(label="HICON")}, name="NOTIFYICONDATAW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwMessage", "lpData"]),
        #
        'Shell_NotifyIconGetRect': SimTypeFunction([SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "uID": SimTypeInt(signed=False, label="UInt32"), "guidItem": SimTypeBottom(label="Guid")}, name="NOTIFYICONIDENTIFIER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"left": SimTypeInt(signed=True, label="Int32"), "top": SimTypeInt(signed=True, label="Int32"), "right": SimTypeInt(signed=True, label="Int32"), "bottom": SimTypeInt(signed=True, label="Int32")}, name="RECT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["identifier", "iconLocation"]),
        #
        'SHGetFileInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="FILE_FLAGS_AND_ATTRIBUTES"), SimTypePointer(SimStruct({"hIcon": SimTypeBottom(label="HICON"), "iIcon": SimTypeInt(signed=True, label="Int32"), "dwAttributes": SimTypeInt(signed=False, label="UInt32"), "szDisplayName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 260), "szTypeName": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 80)}, name="SHFILEINFOA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SHGFI_FLAGS")], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["pszPath", "dwFileAttributes", "psfi", "cbFileInfo", "uFlags"]),
        #
        'SHGetFileInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="FILE_FLAGS_AND_ATTRIBUTES"), SimTypePointer(SimStruct({"hIcon": SimTypeBottom(label="HICON"), "iIcon": SimTypeInt(signed=True, label="Int32"), "dwAttributes": SimTypeInt(signed=False, label="UInt32"), "szDisplayName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "szTypeName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 80)}, name="SHFILEINFOW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SHGFI_FLAGS")], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["pszPath", "dwFileAttributes", "psfi", "cbFileInfo", "uFlags"]),
        #
        'SHGetStockIconInfo': SimTypeFunction([SimTypeInt(signed=False, label="SHSTOCKICONID"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "hIcon": SimTypeBottom(label="HICON"), "iSysImageIndex": SimTypeInt(signed=True, label="Int32"), "iIcon": SimTypeInt(signed=True, label="Int32"), "szPath": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="SHSTOCKICONINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["siid", "uFlags", "psii"]),
        #
        'SHGetDiskFreeSpaceExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszDirectoryName", "pulFreeBytesAvailableToCaller", "pulTotalNumberOfBytes", "pulTotalNumberOfFreeBytes"]),
        #
        'SHGetDiskFreeSpaceExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=False, label="UInt32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszDirectoryName", "pulFreeBytesAvailableToCaller", "pulTotalNumberOfBytes", "pulTotalNumberOfFreeBytes"]),
        #
        'SHGetNewLinkInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszLinkTo", "pszDir", "pszName", "pfMustCopy", "uFlags"]),
        #
        'SHGetNewLinkInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszLinkTo", "pszDir", "pszName", "pfMustCopy", "uFlags"]),
        #
        'SHInvokePrinterCommandA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "uAction", "lpBuf1", "lpBuf2", "fModal"]),
        #
        'SHInvokePrinterCommandW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwnd", "uAction", "lpBuf1", "lpBuf2", "fModal"]),
        #
        'SHLoadNonloadedIconOverlayIdentifiers': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'SHIsFileAvailableOffline': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwszPath", "pdwStatus"]),
        #
        'SHSetLocalizedName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath", "pszResModule", "idsRes"]),
        #
        'SHRemoveLocalizedName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath"]),
        #
        'SHGetLocalizedName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath", "pszResModule", "cch", "pidsRes"]),
        #
        'IsLFNDriveA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath"]),
        #
        'IsLFNDriveW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath"]),
        #
        'SHEnumerateUnreadMailAccountsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKeyUser", "dwIndex", "pszMailAddress", "cchMailAddress"]),
        #
        'SHGetUnreadMailCountW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKeyUser", "pszMailAddress", "pdwCount", "pFileTime", "pszShellExecuteCommand", "cchShellExecuteCommand"]),
        #
        'SHSetUnreadMailCountW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszMailAddress", "dwCount", "pszShellExecuteCommand"]),
        #
        'SHTestTokenMembership': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hToken", "ulRID"]),
        #
        'SHGetImageList': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["iImageList", "riid", "ppvObj"]),
        #
        'InitNetworkAddressControl': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'SHGetDriveMedia': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszDrive", "pdwMediaContent"]),
    }

lib.set_prototypes(prototypes)
