/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.ubi;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.ubi.ProbabilityProportionalToSizeQuerySampler;
import org.opensearch.searchrelevance.ubi.RandomQuerySampler;
import org.opensearch.searchrelevance.ubi.TopNQuerySampler;
import org.opensearch.transport.client.Client;
import reactor.util.annotation.NonNull;

public abstract class QuerySampler {
    private static final Logger LOGGER = LogManager.getLogger(QuerySampler.class);
    private final Client client;
    private final int size;

    protected QuerySampler(int size, @NonNull Client client) {
        this.client = client;
        this.size = size;
    }

    protected Client getClient() {
        return this.client;
    }

    protected int getSize() {
        return this.size;
    }

    public abstract CompletableFuture<Map<String, Integer>> sample();

    public static QuerySampler create(String name, int size, Client client) {
        return switch (name) {
            case "pptss" -> new ProbabilityProportionalToSizeQuerySampler(size, client);
            case "random" -> new RandomQuerySampler(size, client);
            case "topn" -> new TopNQuerySampler(size, client);
            default -> throw new SearchRelevanceException("Unknown sampler type: " + name, RestStatus.BAD_REQUEST);
        };
    }
}

