/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.function.Function;
import org.opensearch.sql.analysis.NestedAnalyzer;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexScan;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexScanAggregationBuilder;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexScanQueryBuilder;
import org.opensearch.sql.opensearch.storage.scan.PushDownQueryBuilder;
import org.opensearch.sql.planner.logical.LogicalAggregation;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalHighlight;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalNested;
import org.opensearch.sql.planner.logical.LogicalPaginate;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.storage.TableScanOperator;
import org.opensearch.sql.storage.read.TableScanBuilder;

public class OpenSearchIndexScanBuilder
extends TableScanBuilder {
    private final Function<OpenSearchRequestBuilder, OpenSearchIndexScan> scanFactory;
    private PushDownQueryBuilder delegate;
    private boolean isLimitPushedDown = false;

    public OpenSearchIndexScanBuilder(OpenSearchRequestBuilder requestBuilder, Function<OpenSearchRequestBuilder, OpenSearchIndexScan> scanFactory) {
        this.delegate = new OpenSearchIndexScanQueryBuilder(requestBuilder);
        this.scanFactory = scanFactory;
    }

    protected OpenSearchIndexScanBuilder(PushDownQueryBuilder translator, Function<OpenSearchRequestBuilder, OpenSearchIndexScan> scanFactory) {
        this.delegate = translator;
        this.scanFactory = scanFactory;
    }

    @Override
    public TableScanOperator build() {
        return this.scanFactory.apply(this.delegate.build());
    }

    @Override
    public boolean pushDownFilter(LogicalFilter filter) {
        if (this.isLimitPushedDown) {
            return false;
        }
        return this.delegate.pushDownFilter(filter);
    }

    @Override
    public boolean pushDownAggregation(LogicalAggregation aggregation) {
        if (this.isLimitPushedDown) {
            return false;
        }
        this.delegate = new OpenSearchIndexScanAggregationBuilder(this.delegate.build(), aggregation);
        return true;
    }

    @Override
    public boolean pushDownPageSize(LogicalPaginate paginate) {
        return this.delegate.pushDownPageSize(paginate);
    }

    @Override
    public boolean pushDownSort(LogicalSort sort) {
        if (!this.sortByFieldsOnly(sort)) {
            return false;
        }
        return this.delegate.pushDownSort(sort);
    }

    @Override
    public boolean pushDownLimit(LogicalLimit limit) {
        this.isLimitPushedDown = true;
        return this.delegate.pushDownLimit(limit);
    }

    @Override
    public boolean pushDownProject(LogicalProject project) {
        return this.delegate.pushDownProject(project);
    }

    @Override
    public boolean pushDownHighlight(LogicalHighlight highlight) {
        return this.delegate.pushDownHighlight(highlight);
    }

    @Override
    public boolean pushDownNested(LogicalNested nested) {
        return this.delegate.pushDownNested(nested);
    }

    private boolean sortByFieldsOnly(LogicalSort sort) {
        return sort.getSortList().stream().map(sortItem -> sortItem.getRight() instanceof ReferenceExpression || NestedAnalyzer.isNestedFunction((Expression)sortItem.getRight()) != false).reduce(true, Boolean::logicalAnd);
    }
}

