/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.SubqueryAlias;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class Join
extends UnresolvedPlan {
    private UnresolvedPlan left;
    private final UnresolvedPlan right;
    private Optional<String> leftAlias;
    private Optional<String> rightAlias;
    private final JoinType joinType;
    private final Optional<UnresolvedExpression> joinCondition;
    private final JoinHint joinHint;

    public Join(UnresolvedPlan right, Optional<String> leftAlias, Optional<String> rightAlias, JoinType joinType, Optional<UnresolvedExpression> joinCondition, JoinHint joinHint) {
        this.right = right;
        this.leftAlias = leftAlias;
        this.rightAlias = rightAlias;
        this.joinType = joinType;
        this.joinCondition = joinCondition;
        this.joinHint = joinHint;
    }

    @Override
    public UnresolvedPlan attach(UnresolvedPlan child) {
        UnresolvedPlan unresolvedPlan;
        SubqueryAlias alias;
        if (this.leftAlias.isPresent()) {
            if (child instanceof SubqueryAlias) {
                alias = (SubqueryAlias)child;
                this.left = new SubqueryAlias(this.leftAlias.get(), alias.getChild().getFirst());
            } else {
                this.left = new SubqueryAlias(this.leftAlias.get(), child);
            }
        } else {
            if (child instanceof SubqueryAlias) {
                alias = (SubqueryAlias)child;
                this.leftAlias = Optional.of(alias.getAlias());
            }
            this.left = child;
        }
        if (this.rightAlias.isEmpty() && (unresolvedPlan = this.right) instanceof SubqueryAlias) {
            alias = (SubqueryAlias)unresolvedPlan;
            this.rightAlias = Optional.of(alias.getAlias());
        }
        return this;
    }

    public List<UnresolvedPlan> getChild() {
        return this.left == null ? ImmutableList.of() : ImmutableList.of((Object)this.left);
    }

    public List<UnresolvedPlan> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitJoin(this, context);
    }

    @Override
    @Generated
    public String toString() {
        return "Join(left=" + String.valueOf(this.getLeft()) + ", right=" + String.valueOf(this.getRight()) + ", leftAlias=" + String.valueOf(this.getLeftAlias()) + ", rightAlias=" + String.valueOf(this.getRightAlias()) + ", joinType=" + String.valueOf((Object)this.getJoinType()) + ", joinCondition=" + String.valueOf(this.getJoinCondition()) + ", joinHint=" + String.valueOf(this.getJoinHint()) + ")";
    }

    @Generated
    public UnresolvedPlan getLeft() {
        return this.left;
    }

    @Generated
    public UnresolvedPlan getRight() {
        return this.right;
    }

    @Generated
    public Optional<String> getLeftAlias() {
        return this.leftAlias;
    }

    @Generated
    public Optional<String> getRightAlias() {
        return this.rightAlias;
    }

    @Generated
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Generated
    public Optional<UnresolvedExpression> getJoinCondition() {
        return this.joinCondition;
    }

    @Generated
    public JoinHint getJoinHint() {
        return this.joinHint;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Join)) {
            return false;
        }
        Join other = (Join)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UnresolvedPlan this$left = this.getLeft();
        UnresolvedPlan other$left = other.getLeft();
        if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
            return false;
        }
        UnresolvedPlan this$right = this.getRight();
        UnresolvedPlan other$right = other.getRight();
        if (this$right == null ? other$right != null : !((Object)this$right).equals(other$right)) {
            return false;
        }
        Optional<String> this$leftAlias = this.getLeftAlias();
        Optional<String> other$leftAlias = other.getLeftAlias();
        if (this$leftAlias == null ? other$leftAlias != null : !((Object)this$leftAlias).equals(other$leftAlias)) {
            return false;
        }
        Optional<String> this$rightAlias = this.getRightAlias();
        Optional<String> other$rightAlias = other.getRightAlias();
        if (this$rightAlias == null ? other$rightAlias != null : !((Object)this$rightAlias).equals(other$rightAlias)) {
            return false;
        }
        JoinType this$joinType = this.getJoinType();
        JoinType other$joinType = other.getJoinType();
        if (this$joinType == null ? other$joinType != null : !((Object)((Object)this$joinType)).equals((Object)other$joinType)) {
            return false;
        }
        Optional<UnresolvedExpression> this$joinCondition = this.getJoinCondition();
        Optional<UnresolvedExpression> other$joinCondition = other.getJoinCondition();
        if (this$joinCondition == null ? other$joinCondition != null : !((Object)this$joinCondition).equals(other$joinCondition)) {
            return false;
        }
        JoinHint this$joinHint = this.getJoinHint();
        JoinHint other$joinHint = other.getJoinHint();
        return !(this$joinHint == null ? other$joinHint != null : !this$joinHint.equals(other$joinHint));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Join;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UnresolvedPlan $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : ((Object)$left).hashCode());
        UnresolvedPlan $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : ((Object)$right).hashCode());
        Optional<String> $leftAlias = this.getLeftAlias();
        result = result * 59 + ($leftAlias == null ? 43 : ((Object)$leftAlias).hashCode());
        Optional<String> $rightAlias = this.getRightAlias();
        result = result * 59 + ($rightAlias == null ? 43 : ((Object)$rightAlias).hashCode());
        JoinType $joinType = this.getJoinType();
        result = result * 59 + ($joinType == null ? 43 : ((Object)((Object)$joinType)).hashCode());
        Optional<UnresolvedExpression> $joinCondition = this.getJoinCondition();
        result = result * 59 + ($joinCondition == null ? 43 : ((Object)$joinCondition).hashCode());
        JoinHint $joinHint = this.getJoinHint();
        result = result * 59 + ($joinHint == null ? 43 : $joinHint.hashCode());
        return result;
    }

    public static enum JoinType {
        INNER,
        LEFT,
        RIGHT,
        SEMI,
        ANTI,
        CROSS,
        FULL;

    }

    public static class JoinHint {
        private final Map<String, String> hints;

        public JoinHint() {
            this.hints = ImmutableMap.of();
        }

        @Generated
        public Map<String, String> getHints() {
            return this.hints;
        }

        @Generated
        public JoinHint(Map<String, String> hints) {
            this.hints = hints;
        }
    }
}

