/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.ImportStatus;
import software.amazon.awssdk.services.dynamodb.model.InputCompressionType;
import software.amazon.awssdk.services.dynamodb.model.InputFormat;
import software.amazon.awssdk.services.dynamodb.model.InputFormatOptions;
import software.amazon.awssdk.services.dynamodb.model.S3BucketSource;
import software.amazon.awssdk.services.dynamodb.model.TableCreationParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportTableDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportTableDescription> {
    private static final SdkField<String> IMPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportArn").getter(ImportTableDescription.getter(ImportTableDescription::importArn)).setter(ImportTableDescription.setter(Builder::importArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportArn").build()}).build();
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportStatus").getter(ImportTableDescription.getter(ImportTableDescription::importStatusAsString)).setter(ImportTableDescription.setter(Builder::importStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportStatus").build()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableArn").getter(ImportTableDescription.getter(ImportTableDescription::tableArn)).setter(ImportTableDescription.setter(Builder::tableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableId").getter(ImportTableDescription.getter(ImportTableDescription::tableId)).setter(ImportTableDescription.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ImportTableDescription.getter(ImportTableDescription::clientToken)).setter(ImportTableDescription.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<S3BucketSource> S3_BUCKET_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3BucketSource").getter(ImportTableDescription.getter(ImportTableDescription::s3BucketSource)).setter(ImportTableDescription.setter(Builder::s3BucketSource)).constructor(S3BucketSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketSource").build()}).build();
    private static final SdkField<Long> ERROR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ErrorCount").getter(ImportTableDescription.getter(ImportTableDescription::errorCount)).setter(ImportTableDescription.setter(Builder::errorCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCount").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogGroupArn").getter(ImportTableDescription.getter(ImportTableDescription::cloudWatchLogGroupArn)).setter(ImportTableDescription.setter(Builder::cloudWatchLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build()}).build();
    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputFormat").getter(ImportTableDescription.getter(ImportTableDescription::inputFormatAsString)).setter(ImportTableDescription.setter(Builder::inputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()}).build();
    private static final SdkField<InputFormatOptions> INPUT_FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputFormatOptions").getter(ImportTableDescription.getter(ImportTableDescription::inputFormatOptions)).setter(ImportTableDescription.setter(Builder::inputFormatOptions)).constructor(InputFormatOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormatOptions").build()}).build();
    private static final SdkField<String> INPUT_COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputCompressionType").getter(ImportTableDescription.getter(ImportTableDescription::inputCompressionTypeAsString)).setter(ImportTableDescription.setter(Builder::inputCompressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputCompressionType").build()}).build();
    private static final SdkField<TableCreationParameters> TABLE_CREATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TableCreationParameters").getter(ImportTableDescription.getter(ImportTableDescription::tableCreationParameters)).setter(ImportTableDescription.setter(Builder::tableCreationParameters)).constructor(TableCreationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableCreationParameters").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ImportTableDescription.getter(ImportTableDescription::startTime)).setter(ImportTableDescription.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ImportTableDescription.getter(ImportTableDescription::endTime)).setter(ImportTableDescription.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Long> PROCESSED_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProcessedSizeBytes").getter(ImportTableDescription.getter(ImportTableDescription::processedSizeBytes)).setter(ImportTableDescription.setter(Builder::processedSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedSizeBytes").build()}).build();
    private static final SdkField<Long> PROCESSED_ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProcessedItemCount").getter(ImportTableDescription.getter(ImportTableDescription::processedItemCount)).setter(ImportTableDescription.setter(Builder::processedItemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedItemCount").build()}).build();
    private static final SdkField<Long> IMPORTED_ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ImportedItemCount").getter(ImportTableDescription.getter(ImportTableDescription::importedItemCount)).setter(ImportTableDescription.setter(Builder::importedItemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedItemCount").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCode").getter(ImportTableDescription.getter(ImportTableDescription::failureCode)).setter(ImportTableDescription.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(ImportTableDescription.getter(ImportTableDescription::failureMessage)).setter(ImportTableDescription.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ARN_FIELD, IMPORT_STATUS_FIELD, TABLE_ARN_FIELD, TABLE_ID_FIELD, CLIENT_TOKEN_FIELD, S3_BUCKET_SOURCE_FIELD, ERROR_COUNT_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, INPUT_FORMAT_FIELD, INPUT_FORMAT_OPTIONS_FIELD, INPUT_COMPRESSION_TYPE_FIELD, TABLE_CREATION_PARAMETERS_FIELD, START_TIME_FIELD, END_TIME_FIELD, PROCESSED_SIZE_BYTES_FIELD, PROCESSED_ITEM_COUNT_FIELD, IMPORTED_ITEM_COUNT_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportTableDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String importArn;
    private final String importStatus;
    private final String tableArn;
    private final String tableId;
    private final String clientToken;
    private final S3BucketSource s3BucketSource;
    private final Long errorCount;
    private final String cloudWatchLogGroupArn;
    private final String inputFormat;
    private final InputFormatOptions inputFormatOptions;
    private final String inputCompressionType;
    private final TableCreationParameters tableCreationParameters;
    private final Instant startTime;
    private final Instant endTime;
    private final Long processedSizeBytes;
    private final Long processedItemCount;
    private final Long importedItemCount;
    private final String failureCode;
    private final String failureMessage;

    private ImportTableDescription(BuilderImpl builder) {
        this.importArn = builder.importArn;
        this.importStatus = builder.importStatus;
        this.tableArn = builder.tableArn;
        this.tableId = builder.tableId;
        this.clientToken = builder.clientToken;
        this.s3BucketSource = builder.s3BucketSource;
        this.errorCount = builder.errorCount;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.inputFormat = builder.inputFormat;
        this.inputFormatOptions = builder.inputFormatOptions;
        this.inputCompressionType = builder.inputCompressionType;
        this.tableCreationParameters = builder.tableCreationParameters;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.processedSizeBytes = builder.processedSizeBytes;
        this.processedItemCount = builder.processedItemCount;
        this.importedItemCount = builder.importedItemCount;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
    }

    public final String importArn() {
        return this.importArn;
    }

    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(this.importStatus);
    }

    public final String importStatusAsString() {
        return this.importStatus;
    }

    public final String tableArn() {
        return this.tableArn;
    }

    public final String tableId() {
        return this.tableId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final S3BucketSource s3BucketSource() {
        return this.s3BucketSource;
    }

    public final Long errorCount() {
        return this.errorCount;
    }

    public final String cloudWatchLogGroupArn() {
        return this.cloudWatchLogGroupArn;
    }

    public final InputFormat inputFormat() {
        return InputFormat.fromValue(this.inputFormat);
    }

    public final String inputFormatAsString() {
        return this.inputFormat;
    }

    public final InputFormatOptions inputFormatOptions() {
        return this.inputFormatOptions;
    }

    public final InputCompressionType inputCompressionType() {
        return InputCompressionType.fromValue(this.inputCompressionType);
    }

    public final String inputCompressionTypeAsString() {
        return this.inputCompressionType;
    }

    public final TableCreationParameters tableCreationParameters() {
        return this.tableCreationParameters;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Long processedSizeBytes() {
        return this.processedSizeBytes;
    }

    public final Long processedItemCount() {
        return this.processedItemCount;
    }

    public final Long importedItemCount() {
        return this.importedItemCount;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableCreationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.processedSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.processedItemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedItemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTableDescription)) {
            return false;
        }
        ImportTableDescription other = (ImportTableDescription)obj;
        return Objects.equals(this.importArn(), other.importArn()) && Objects.equals(this.importStatusAsString(), other.importStatusAsString()) && Objects.equals(this.tableArn(), other.tableArn()) && Objects.equals(this.tableId(), other.tableId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.s3BucketSource(), other.s3BucketSource()) && Objects.equals(this.errorCount(), other.errorCount()) && Objects.equals(this.cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && Objects.equals(this.inputFormatAsString(), other.inputFormatAsString()) && Objects.equals(this.inputFormatOptions(), other.inputFormatOptions()) && Objects.equals(this.inputCompressionTypeAsString(), other.inputCompressionTypeAsString()) && Objects.equals(this.tableCreationParameters(), other.tableCreationParameters()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.processedSizeBytes(), other.processedSizeBytes()) && Objects.equals(this.processedItemCount(), other.processedItemCount()) && Objects.equals(this.importedItemCount(), other.importedItemCount()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.failureMessage(), other.failureMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ImportTableDescription").add("ImportArn", (Object)this.importArn()).add("ImportStatus", (Object)this.importStatusAsString()).add("TableArn", (Object)this.tableArn()).add("TableId", (Object)this.tableId()).add("ClientToken", (Object)this.clientToken()).add("S3BucketSource", (Object)this.s3BucketSource()).add("ErrorCount", (Object)this.errorCount()).add("CloudWatchLogGroupArn", (Object)this.cloudWatchLogGroupArn()).add("InputFormat", (Object)this.inputFormatAsString()).add("InputFormatOptions", (Object)this.inputFormatOptions()).add("InputCompressionType", (Object)this.inputCompressionTypeAsString()).add("TableCreationParameters", (Object)this.tableCreationParameters()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ProcessedSizeBytes", (Object)this.processedSizeBytes()).add("ProcessedItemCount", (Object)this.processedItemCount()).add("ImportedItemCount", (Object)this.importedItemCount()).add("FailureCode", (Object)this.failureCode()).add("FailureMessage", (Object)this.failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportArn": {
                return Optional.ofNullable(clazz.cast(this.importArn()));
            }
            case "ImportStatus": {
                return Optional.ofNullable(clazz.cast(this.importStatusAsString()));
            }
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
            case "TableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "S3BucketSource": {
                return Optional.ofNullable(clazz.cast(this.s3BucketSource()));
            }
            case "ErrorCount": {
                return Optional.ofNullable(clazz.cast(this.errorCount()));
            }
            case "CloudWatchLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupArn()));
            }
            case "InputFormat": {
                return Optional.ofNullable(clazz.cast(this.inputFormatAsString()));
            }
            case "InputFormatOptions": {
                return Optional.ofNullable(clazz.cast(this.inputFormatOptions()));
            }
            case "InputCompressionType": {
                return Optional.ofNullable(clazz.cast(this.inputCompressionTypeAsString()));
            }
            case "TableCreationParameters": {
                return Optional.ofNullable(clazz.cast(this.tableCreationParameters()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ProcessedSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.processedSizeBytes()));
            }
            case "ProcessedItemCount": {
                return Optional.ofNullable(clazz.cast(this.processedItemCount()));
            }
            case "ImportedItemCount": {
                return Optional.ofNullable(clazz.cast(this.importedItemCount()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImportArn", IMPORT_ARN_FIELD);
        map.put("ImportStatus", IMPORT_STATUS_FIELD);
        map.put("TableArn", TABLE_ARN_FIELD);
        map.put("TableId", TABLE_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("S3BucketSource", S3_BUCKET_SOURCE_FIELD);
        map.put("ErrorCount", ERROR_COUNT_FIELD);
        map.put("CloudWatchLogGroupArn", CLOUD_WATCH_LOG_GROUP_ARN_FIELD);
        map.put("InputFormat", INPUT_FORMAT_FIELD);
        map.put("InputFormatOptions", INPUT_FORMAT_OPTIONS_FIELD);
        map.put("InputCompressionType", INPUT_COMPRESSION_TYPE_FIELD);
        map.put("TableCreationParameters", TABLE_CREATION_PARAMETERS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ProcessedSizeBytes", PROCESSED_SIZE_BYTES_FIELD);
        map.put("ProcessedItemCount", PROCESSED_ITEM_COUNT_FIELD);
        map.put("ImportedItemCount", IMPORTED_ITEM_COUNT_FIELD);
        map.put("FailureCode", FAILURE_CODE_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportTableDescription, T> g) {
        return obj -> g.apply((ImportTableDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String importArn;
        private String importStatus;
        private String tableArn;
        private String tableId;
        private String clientToken;
        private S3BucketSource s3BucketSource;
        private Long errorCount;
        private String cloudWatchLogGroupArn;
        private String inputFormat;
        private InputFormatOptions inputFormatOptions;
        private String inputCompressionType;
        private TableCreationParameters tableCreationParameters;
        private Instant startTime;
        private Instant endTime;
        private Long processedSizeBytes;
        private Long processedItemCount;
        private Long importedItemCount;
        private String failureCode;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTableDescription model) {
            this.importArn(model.importArn);
            this.importStatus(model.importStatus);
            this.tableArn(model.tableArn);
            this.tableId(model.tableId);
            this.clientToken(model.clientToken);
            this.s3BucketSource(model.s3BucketSource);
            this.errorCount(model.errorCount);
            this.cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            this.inputFormat(model.inputFormat);
            this.inputFormatOptions(model.inputFormatOptions);
            this.inputCompressionType(model.inputCompressionType);
            this.tableCreationParameters(model.tableCreationParameters);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.processedSizeBytes(model.processedSizeBytes);
            this.processedItemCount(model.processedItemCount);
            this.importedItemCount(model.importedItemCount);
            this.failureCode(model.failureCode);
            this.failureMessage(model.failureMessage);
        }

        public final String getImportArn() {
            return this.importArn;
        }

        public final void setImportArn(String importArn) {
            this.importArn = importArn;
        }

        @Override
        public final Builder importArn(String importArn) {
            this.importArn = importArn;
            return this;
        }

        public final String getImportStatus() {
            return this.importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final String getTableId() {
            return this.tableId;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final S3BucketSource.Builder getS3BucketSource() {
            return this.s3BucketSource != null ? this.s3BucketSource.toBuilder() : null;
        }

        public final void setS3BucketSource(S3BucketSource.BuilderImpl s3BucketSource) {
            this.s3BucketSource = s3BucketSource != null ? s3BucketSource.build() : null;
        }

        @Override
        public final Builder s3BucketSource(S3BucketSource s3BucketSource) {
            this.s3BucketSource = s3BucketSource;
            return this;
        }

        public final Long getErrorCount() {
            return this.errorCount;
        }

        public final void setErrorCount(Long errorCount) {
            this.errorCount = errorCount;
        }

        @Override
        public final Builder errorCount(Long errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final String getInputFormat() {
            return this.inputFormat;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat == null ? null : inputFormat.toString());
            return this;
        }

        public final InputFormatOptions.Builder getInputFormatOptions() {
            return this.inputFormatOptions != null ? this.inputFormatOptions.toBuilder() : null;
        }

        public final void setInputFormatOptions(InputFormatOptions.BuilderImpl inputFormatOptions) {
            this.inputFormatOptions = inputFormatOptions != null ? inputFormatOptions.build() : null;
        }

        @Override
        public final Builder inputFormatOptions(InputFormatOptions inputFormatOptions) {
            this.inputFormatOptions = inputFormatOptions;
            return this;
        }

        public final String getInputCompressionType() {
            return this.inputCompressionType;
        }

        public final void setInputCompressionType(String inputCompressionType) {
            this.inputCompressionType = inputCompressionType;
        }

        @Override
        public final Builder inputCompressionType(String inputCompressionType) {
            this.inputCompressionType = inputCompressionType;
            return this;
        }

        @Override
        public final Builder inputCompressionType(InputCompressionType inputCompressionType) {
            this.inputCompressionType(inputCompressionType == null ? null : inputCompressionType.toString());
            return this;
        }

        public final TableCreationParameters.Builder getTableCreationParameters() {
            return this.tableCreationParameters != null ? this.tableCreationParameters.toBuilder() : null;
        }

        public final void setTableCreationParameters(TableCreationParameters.BuilderImpl tableCreationParameters) {
            this.tableCreationParameters = tableCreationParameters != null ? tableCreationParameters.build() : null;
        }

        @Override
        public final Builder tableCreationParameters(TableCreationParameters tableCreationParameters) {
            this.tableCreationParameters = tableCreationParameters;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Long getProcessedSizeBytes() {
            return this.processedSizeBytes;
        }

        public final void setProcessedSizeBytes(Long processedSizeBytes) {
            this.processedSizeBytes = processedSizeBytes;
        }

        @Override
        public final Builder processedSizeBytes(Long processedSizeBytes) {
            this.processedSizeBytes = processedSizeBytes;
            return this;
        }

        public final Long getProcessedItemCount() {
            return this.processedItemCount;
        }

        public final void setProcessedItemCount(Long processedItemCount) {
            this.processedItemCount = processedItemCount;
        }

        @Override
        public final Builder processedItemCount(Long processedItemCount) {
            this.processedItemCount = processedItemCount;
            return this;
        }

        public final Long getImportedItemCount() {
            return this.importedItemCount;
        }

        public final void setImportedItemCount(Long importedItemCount) {
            this.importedItemCount = importedItemCount;
        }

        @Override
        public final Builder importedItemCount(Long importedItemCount) {
            this.importedItemCount = importedItemCount;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public ImportTableDescription build() {
            return new ImportTableDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportTableDescription> {
        public Builder importArn(String var1);

        public Builder importStatus(String var1);

        public Builder importStatus(ImportStatus var1);

        public Builder tableArn(String var1);

        public Builder tableId(String var1);

        public Builder clientToken(String var1);

        public Builder s3BucketSource(S3BucketSource var1);

        default public Builder s3BucketSource(Consumer<S3BucketSource.Builder> s3BucketSource) {
            return this.s3BucketSource((S3BucketSource)((S3BucketSource.Builder)S3BucketSource.builder().applyMutation(s3BucketSource)).build());
        }

        public Builder errorCount(Long var1);

        public Builder cloudWatchLogGroupArn(String var1);

        public Builder inputFormat(String var1);

        public Builder inputFormat(InputFormat var1);

        public Builder inputFormatOptions(InputFormatOptions var1);

        default public Builder inputFormatOptions(Consumer<InputFormatOptions.Builder> inputFormatOptions) {
            return this.inputFormatOptions((InputFormatOptions)((InputFormatOptions.Builder)InputFormatOptions.builder().applyMutation(inputFormatOptions)).build());
        }

        public Builder inputCompressionType(String var1);

        public Builder inputCompressionType(InputCompressionType var1);

        public Builder tableCreationParameters(TableCreationParameters var1);

        default public Builder tableCreationParameters(Consumer<TableCreationParameters.Builder> tableCreationParameters) {
            return this.tableCreationParameters((TableCreationParameters)((TableCreationParameters.Builder)TableCreationParameters.builder().applyMutation(tableCreationParameters)).build());
        }

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder processedSizeBytes(Long var1);

        public Builder processedItemCount(Long var1);

        public Builder importedItemCount(Long var1);

        public Builder failureCode(String var1);

        public Builder failureMessage(String var1);
    }
}

