/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.sync;

import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.model.MLDeploySetting;

public class MLSyncUpNodeResponse
extends BaseNodeResponse {
    @Generated
    private static final Logger log = LogManager.getLogger(MLSyncUpNodeResponse.class);
    private String modelStatus;
    private String[] deployedModelIds;
    private String[] runningDeployModelIds;
    private String[] runningDeployModelTaskIds;
    private String[] expiredModelIds;

    public MLSyncUpNodeResponse(DiscoveryNode node, String modelStatus, String[] deployedModelIds, String[] runningDeployModelIds, String[] runningDeployModelTaskIds, String[] expiredModelIds) {
        super(node);
        this.modelStatus = modelStatus;
        this.deployedModelIds = deployedModelIds;
        this.runningDeployModelIds = runningDeployModelIds;
        this.runningDeployModelTaskIds = runningDeployModelTaskIds;
        this.expiredModelIds = expiredModelIds;
    }

    public MLSyncUpNodeResponse(StreamInput in) throws IOException {
        super(in);
        Version streamInputVersion = in.getVersion();
        this.modelStatus = in.readOptionalString();
        this.deployedModelIds = in.readOptionalStringArray();
        this.runningDeployModelIds = in.readOptionalStringArray();
        this.runningDeployModelTaskIds = in.readOptionalStringArray();
        if (streamInputVersion.onOrAfter(MLDeploySetting.MINIMAL_SUPPORTED_VERSION_FOR_MODEL_TTL)) {
            this.expiredModelIds = in.readOptionalStringArray();
        }
    }

    public static MLSyncUpNodeResponse readStats(StreamInput in) throws IOException {
        return new MLSyncUpNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        super.writeTo(out);
        out.writeOptionalString(this.modelStatus);
        out.writeOptionalStringArray(this.deployedModelIds);
        out.writeOptionalStringArray(this.runningDeployModelIds);
        out.writeOptionalStringArray(this.runningDeployModelTaskIds);
        if (streamOutputVersion.onOrAfter(MLDeploySetting.MINIMAL_SUPPORTED_VERSION_FOR_MODEL_TTL)) {
            out.writeOptionalStringArray(this.expiredModelIds);
        }
    }

    @Generated
    public String getModelStatus() {
        return this.modelStatus;
    }

    @Generated
    public String[] getDeployedModelIds() {
        return this.deployedModelIds;
    }

    @Generated
    public String[] getRunningDeployModelIds() {
        return this.runningDeployModelIds;
    }

    @Generated
    public String[] getRunningDeployModelTaskIds() {
        return this.runningDeployModelTaskIds;
    }

    @Generated
    public String[] getExpiredModelIds() {
        return this.expiredModelIds;
    }
}

