/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.ExpressionFunctionValues;
import org.apache.lucene.expressions.ExpressionValueSource;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;

final class CachingExpressionValueSource
extends ExpressionValueSource {
    CachingExpressionValueSource(Bindings bindings, Expression expression) {
        super(bindings, expression);
    }

    CachingExpressionValueSource(DoubleValuesSource[] variables, Expression expression, boolean needsScores) {
        super(variables, expression, needsScores);
    }

    public CachingExpressionValueSource(ExpressionValueSource expressionValueSource) {
        super(expressionValueSource.variables, expressionValueSource.expression, expressionValueSource.needsScores);
    }

    @Override
    public DoubleValues getValues(LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        return this.getValuesWithCache(readerContext, scores, new HashMap<String, DoubleValues>());
    }

    private DoubleValues getValuesWithCache(LeafReaderContext readerContext, DoubleValues scores, Map<String, DoubleValues> valuesCache) throws IOException {
        DoubleValues[] externalValues = new DoubleValues[this.expression.variables.length];
        for (int i = 0; i < this.variables.length; ++i) {
            String externalName = this.expression.variables[i];
            DoubleValues values = valuesCache.get(externalName);
            if (values == null) {
                values = this.variables[i] instanceof CachingExpressionValueSource ? ((CachingExpressionValueSource)this.variables[i]).getValuesWithCache(readerContext, scores, valuesCache) : this.variables[i].getValues(readerContext, scores);
                if (values == null) {
                    throw new RuntimeException("Unrecognized variable (" + externalName + ") referenced in expression (" + this.expression.sourceText + ").");
                }
                valuesCache.put(externalName, values);
            }
            externalValues[i] = CachingExpressionValueSource.zeroWhenUnpositioned(values);
        }
        return new ExpressionFunctionValues(this.expression, externalValues);
    }
}

