/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.internal.AesGcmJceKeyCipher;
import com.amazonaws.encryptionsdk.internal.RsaJceKeyCipher;
import com.amazonaws.encryptionsdk.model.KeyBlob;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.ArrayUtils;

public abstract class JceKeyCipher {
    private final Key wrappingKey;
    private final Key unwrappingKey;
    private static final Charset KEY_NAME_ENCODING = StandardCharsets.UTF_8;

    public static JceKeyCipher aesGcm(SecretKey secretKey) {
        return new AesGcmJceKeyCipher(secretKey);
    }

    public static JceKeyCipher rsa(PublicKey wrappingKey, PrivateKey unwrappingKey, String transformation) {
        return new RsaJceKeyCipher(wrappingKey, unwrappingKey, transformation);
    }

    JceKeyCipher(Key wrappingKey, Key unwrappingKey) {
        this.wrappingKey = wrappingKey;
        this.unwrappingKey = unwrappingKey;
    }

    abstract WrappingData buildWrappingCipher(Key var1, Map<String, String> var2) throws GeneralSecurityException;

    abstract Cipher buildUnwrappingCipher(Key var1, byte[] var2, int var3, Map<String, String> var4) throws GeneralSecurityException;

    public EncryptedDataKey encryptKey(byte[] key, String keyName, String keyNamespace, Map<String, String> encryptionContext) {
        byte[] keyNameBytes = keyName.getBytes(KEY_NAME_ENCODING);
        try {
            byte[] provInfo;
            WrappingData wData = this.buildWrappingCipher(this.wrappingKey, encryptionContext);
            Cipher cipher = wData.cipher;
            byte[] encryptedKey = cipher.doFinal(key);
            if (wData.extraInfo.length == 0) {
                provInfo = keyNameBytes;
            } else {
                provInfo = new byte[keyNameBytes.length + wData.extraInfo.length];
                System.arraycopy(keyNameBytes, 0, provInfo, 0, keyNameBytes.length);
                System.arraycopy(wData.extraInfo, 0, provInfo, keyNameBytes.length, wData.extraInfo.length);
            }
            return new KeyBlob(keyNamespace, provInfo, encryptedKey);
        }
        catch (GeneralSecurityException gsex) {
            throw new AwsCryptoException(gsex);
        }
    }

    public byte[] decryptKey(EncryptedDataKey edk, String keyName, Map<String, String> encryptionContext) throws GeneralSecurityException {
        byte[] keyNameBytes = keyName.getBytes(KEY_NAME_ENCODING);
        Cipher cipher = this.buildUnwrappingCipher(this.unwrappingKey, edk.getProviderInformation(), keyNameBytes.length, encryptionContext);
        return cipher.doFinal(edk.getEncryptedDataKey());
    }

    static class WrappingData {
        public final Cipher cipher;
        public final byte[] extraInfo;

        WrappingData(Cipher cipher, byte[] extraInfo) {
            this.cipher = cipher;
            this.extraInfo = extraInfo != null ? extraInfo : ArrayUtils.EMPTY_BYTE_ARRAY;
        }
    }
}

