/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.rulesupport.loader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.module.script.ScriptDependencyTracker;
import org.openhab.core.automation.module.script.rulesupport.internal.loader.BidiSetBag;
import org.openhab.core.service.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractScriptDependencyTracker
implements ScriptDependencyTracker,
WatchService.WatchEventListener {
    private final Logger logger = LoggerFactory.getLogger(AbstractScriptDependencyTracker.class);
    protected final Path libraryPath;
    private final Set<ScriptDependencyTracker.Listener> dependencyChangeListeners = ConcurrentHashMap.newKeySet();
    private final BidiSetBag<String, String> scriptToLibs = new BidiSetBag();
    private final WatchService watchService;

    protected AbstractScriptDependencyTracker(WatchService watchService, String fileDirectory) {
        this.watchService = watchService;
        this.libraryPath = watchService.getWatchPath().resolve(fileDirectory);
        if (!Files.exists(this.libraryPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.libraryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.warn("Failed to create watched directory: {}", (Object)this.libraryPath);
            }
        } else if (!Files.isDirectory(this.libraryPath, new LinkOption[0])) {
            this.logger.warn("Trying to watch directory {}, however it is a file", (Object)this.libraryPath);
        }
        watchService.registerListener((WatchService.WatchEventListener)this, this.libraryPath);
    }

    public void deactivate() {
        this.watchService.unregisterListener((WatchService.WatchEventListener)this);
    }

    public Path getLibraryPath() {
        return this.libraryPath;
    }

    public void processWatchEvent(WatchService.Kind kind, Path path) {
        File file = this.libraryPath.resolve(path).toFile();
        if (!file.isHidden() && (kind == WatchService.Kind.DELETE || file.canRead() && (kind == WatchService.Kind.CREATE || kind == WatchService.Kind.MODIFY))) {
            this.dependencyChanged(file.toString());
        }
    }

    protected void dependencyChanged(String dependency) {
        HashSet<String> scripts = new HashSet<String>(this.scriptToLibs.getKeys(dependency));
        this.logger.debug("Library {} changed; reimporting {} scripts...", (Object)this.libraryPath, (Object)scripts.size());
        for (String scriptUrl : scripts) {
            for (ScriptDependencyTracker.Listener listener : this.dependencyChangeListeners) {
                try {
                    listener.onDependencyChange(scriptUrl);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to notify tracker of dependency change: {}: {}", e.getClass(), (Object)e.getMessage());
                }
            }
        }
    }

    public Consumer<String> getTracker(String scriptId) {
        return dependencyPath -> this.startTracking(scriptId, (String)dependencyPath);
    }

    public void removeTracking(String scriptId) {
        this.scriptToLibs.removeKey(scriptId);
    }

    protected void startTracking(String scriptId, String libPath) {
        this.scriptToLibs.put(scriptId, libPath);
    }

    public void addChangeTracker(ScriptDependencyTracker.Listener listener) {
        this.dependencyChangeListeners.add(listener);
    }

    public void removeChangeTracker(ScriptDependencyTracker.Listener listener) {
        this.dependencyChangeListeners.remove(listener);
    }
}

